//////////////////////////////////////////////////////////////////////////////
//
//                     ((C) TBS 2005 - 2012
//  All rights are reserved. Reproduction in whole or in part is prohibited
//  without the written consent of the copyright owner.
//
//  TBS reserves the right to make changes without notice at any time.
//  TBS makes no warranty, expressed, implied or statutory, including but
//  not limited to any implied warranty of merchantability or fitness for any
//  particular purpose, or that the use will not infringe any third party
//  patent, copyright or trademark. TBS must not be liable for any loss
//  or damage arising from its use.
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// Modification History:
//
//  Date               By                  Description
//  -------          ------          ---------------------------------------------------------
// 10-10-2011    steven@tbsdtv.com       version:1.0.0.0  	TBS SDK created
// 11-12-2011    steven@tbsdtv.com       version:2.0.0.1  	update new inerface
// 05-23-2012    steven@tbsdtv.com       version:2.0.0.2    add DVBC and DVBT/T2 
//															TS file receive method
//////////////////////////////////////////////////////////////////////////////

CComPtr<IGraphBuilder> builder;
CComPtr<IMediaControl> control;
CComPtr<IBaseFilter> CaptureFilter,TunerFilter,TSDump,VideoCaptureFilter;
CComPtr<IBaseFilter> provider;
CComPtr<IBaseFilter> demux, infinite, tif;
HANDLE hIOMutex;

IKsPropertySet *m_pKsCtrl;

IKsPropertySet *ppropsetIRCaptureFilter = NULL;
IBaseFilter *pfltIRcapture;



CComPtr <IPin> m_pTunerPin;                  // the tuner pin on the tuner/demod filter


IFileSinkFilter* DumpFilterCtrl;
CCritSec m_Lock;

CDestFilter	*m_pFilterDest;
CString m_StoreFilePath;
CFile StoreFile;
BOOLEAN StoreFileOpened;



void StopIPProcess()
{
	if(control != NULL )
	{
		control->Stop();
	}
}

void StartIPProcess()
{
	if(control != NULL )
	{
		control->Run();
	}
}
IBaseFilter* LoadFilter(CLSID clsid)
{
	IBaseFilter *filter;

	CoCreateInstance(clsid,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,reinterpret_cast<void**>(&filter));
	return filter;
}

// Finds a filter based on the name
IBaseFilter* FindFilter(CLSID clsid,WCHAR *name)
{
	HRESULT hr;
	CComPtr <IMoniker>      pIMoniker;
	CComPtr <IEnumMoniker>  pIEnumMoniker;
	CComPtr <ICreateDevEnum> m_pICreateDevEnum;
	int nl;

	if(name!=NULL) nl=wcslen(name);
	if(!m_pICreateDevEnum) 
	{
		hr=m_pICreateDevEnum.CoCreateInstance(CLSID_SystemDeviceEnum);
		if(FAILED(hr)) return NULL;
	}

	hr=m_pICreateDevEnum->CreateClassEnumerator(clsid,&pIEnumMoniker,0);
	if(FAILED(hr)||(S_OK!=hr))
		return NULL;

	while(pIEnumMoniker->Next(1,&pIMoniker,0)==S_OK)
	{
		CComPtr <IPropertyBag>  pBag;
		hr=pIMoniker->BindToStorage(NULL,NULL,IID_IPropertyBag,reinterpret_cast<void**>(&pBag));
		if(FAILED(hr)) 
		{
			OutputDebugString("FindFilter(): Cannot BindToStorage");
			return NULL;
		}

		CComVariant varBSTR;
		hr=pBag->Read(L"FriendlyName",&varBSTR,NULL);
		if(FAILED(hr))
		{
			OutputDebugString("FindFilter(): IPropertyBag->Read method failed");
			pIMoniker=NULL;
			continue;
		}

		// bind the filter
		IBaseFilter*   pFilter;
		hr=pIMoniker->BindToObject(NULL,NULL,IID_IBaseFilter,reinterpret_cast<void**>(&pFilter));
		if(FAILED(hr)) 
		{
			pIMoniker=NULL;
			pFilter=NULL;
			continue;
		}

		if((name==NULL)||(memcmp(varBSTR.bstrVal,name,nl)==0)) 
			return pFilter;

		pIMoniker=NULL;
		pFilter=NULL;
	}
	return NULL;
}

IBaseFilter* CreateMPEG2Demultiplexer(void)
{
	return LoadFilter(CLSID_MPEG2Demultiplexer);
}

IBaseFilter* CreateTunerDevice(void)
{
	return FindFilter(KSCATEGORY_BDA_NETWORK_TUNER,TunerName);
}

// Returns IPin pointer of a pin on a filter.
//
IPin* CTBSSDKDlg::FindPinOnFilter(IBaseFilter* pBaseFilter, char* pPinName)
{
	HRESULT hr;
	IEnumPins *pEnumPin = NULL;
	ULONG CountReceived = 0;
	IPin *pPin = NULL, *pThePin = NULL;
	char String[80];
	char* pString;
	PIN_INFO PinInfo;
	int length;

	if (!pBaseFilter || !pPinName)
		return NULL;

	// enumerate of pins on the filter 
	hr = pBaseFilter->EnumPins(&pEnumPin);
	if (hr == S_OK && pEnumPin)
	{
		pEnumPin->Reset();
		while (pEnumPin->Next( 1, &pPin, &CountReceived) == S_OK && pPin)
		{
			memset(String, NULL, sizeof(String));

			hr = pPin->QueryPinInfo(&PinInfo);
			if (hr == S_OK)
			{
				length = wcslen (PinInfo.achName) + 1;
				pString = new char [length];

				// get the pin name 
				WideCharToMultiByte(CP_ACP, 0, PinInfo.achName, -1, pString, length,
					NULL, NULL);

				//strcat (String, pString);
				StringCbCat(String,strlen(String) + strlen(pString)+1,pString);

				// is there a match
				if (strstr(String, pPinName))
					pThePin = pPin;	  // yes
				else
					pPin = NULL;	  // no

				delete pString;

			}
			else
			{
				// need to release this pin
				pPin->Release();
			}


		}	// end if have pin

		// need to release the enumerator
		pEnumPin->Release();
	}

	// return address of pin if found on the filter
	return pThePin;

}

BOOL CheckDeviceReady()
{
	TunerFilter=CreateTunerDevice();
	if(TunerFilter)
	{
		return TRUE;
	}
	return FALSE;
}

IBaseFilter* CreateCaptureDevice(void)
{
	return FindFilter(KSCATEGORY_BDA_RECEIVER_COMPONENT,CaptuerName);
}

IBaseFilter* CreateCaptureIRDevice(void)
{
	return FindFilter(KSCATEGORY_CAPTURE,L"TBS");
}


void ConnectPins(IGraphBuilder *builder,IBaseFilter *out_from,IBaseFilter *in_to,WCHAR *from_name=NULL,WCHAR *to_name=NULL);
void ConnectPins(IGraphBuilder *builder,IBaseFilter *out_from,IBaseFilter *in_to,WCHAR *from_name,WCHAR *to_name)
{
	CComPtr<IEnumPins> pins;
	CComPtr<IPin> out_pin;
	CComPtr<IPin> in_pin;
	CComPtr<IPin> temp;
	PIN_INFO info;
	HRESULT hResult;
	BOOL bConnected;

	if(builder == NULL)
	{
		MessageBox(NULL, "ConnectPins builder == NULL","error",MB_OK);
		return ;
	}

	if(out_from == NULL)
	{
		MessageBox(NULL, "ConnectPins out_from == NULL","error",MB_OK);
		return ;
	}

	if(in_to == NULL)
	{
		MessageBox(NULL, "ConnectPins in_to == NULL","error",MB_OK);
		return ;
	}

	// Find output pin of out_from
	out_from->EnumPins(&pins);
	pins->Reset();
	while(pins->Next(1,&out_pin,NULL)==S_OK) 
	{
		out_pin->ConnectedTo(&temp);
		bConnected=temp.p!=NULL;
		temp.Release();
		if(!bConnected) 
		{
			out_pin->QueryPinInfo(&info);
			if((info.dir==PINDIR_OUTPUT)&&((from_name==NULL)?TRUE:(wcscmp(info.achName,from_name)==0))) break;
		}
		out_pin.Release();
	}
	pins.Release();

	if(!out_pin) 
	{
		AfxMessageBox("CBDAGraph::ConnectPins() - No output pin found on filter\r\n");
		return;
	}

	// Find input pin of in_to
	in_to->EnumPins(&pins);
	pins->Reset();
	while(pins->Next(1,&in_pin,NULL)==S_OK) 
	{
		in_pin->ConnectedTo(&temp);
		bConnected=temp.p!=NULL;
		temp.Release();
		if(!bConnected) 
		{
			in_pin->QueryPinInfo(&info);
			if((info.dir==PINDIR_INPUT)&&((to_name==NULL)?TRUE:(wcscmp(info.achName,to_name)==0))) break;
		}
		in_pin.Release();
	}

	pins.Release();
	if(!in_pin) 
	{
		AfxMessageBox("CBDAGraph::ConnectPins() - No input pin found on filter\r\n");
		return;
	}
	// Join them together
	if((hResult=builder->Connect(out_pin,in_pin))!=S_OK) 
	{
		//AfxMessageBox("CBDAGraph::ConnectPins() - Could not connect pins together. Error was: ");
	}
}

IBaseFilter* CreateInfinitePinTee(void)
{
	return LoadFilter(CLSID_InfTee);
}

IBaseFilter* CreateTransportInformationFilter(void)
{
	return FindFilter(KSCATEGORY_BDA_TRANSPORT_INFORMATION,NULL);
}


#define DVBS_TUNING_SPACE_NAME		L"turbosight dvb-s"

#define DVBC_TUNING_SPACE_NAME		L"turbosight dvb-c"

#define DVBT_TUNING_SPACE_NAME		L"turbosight dvb-t"



IDVBTuningSpace2* CreateDVBSTuningSpace(void)
{
	IDVBSLocator *locator;
	IDVBTuningSpace2 *tuning;

	// Create locator
	CoCreateInstance(CLSID_DVBSLocator,NULL,CLSCTX_INPROC_SERVER,IID_IDVBSLocator,(void**)&locator);

	// Create tuning space
	CoCreateInstance(CLSID_DVBSTuningSpace,NULL,CLSCTX_INPROC_SERVER,IID_IDVBTuningSpace2,(void**)&tuning);
	// Set ITuningSpace variables
	tuning->put__NetworkType(CLSID_DVBSNetworkProvider);
	// Set IDVBTuningSpace variables
	tuning->put_SystemType(DVB_Satellite);
	// Set IDVBTuningSpace2 variables
	//	tuning->put_NetworkID(9018);
	// Set ITuningSpace variables again
	tuning->put_DefaultLocator(locator);
	tuning->put_FrequencyMapping(L"");
	tuning->put_FriendlyName(L"Local DVBS Tuner");
	tuning->put_UniqueName(DVBS_TUNING_SPACE_NAME);
	CComQIPtr<IDVBSTuningSpace> pDVBSTuningSpace(tuning) ;
	if( pDVBSTuningSpace != NULL ) {
		pDVBSTuningSpace->put_HighOscillator (-1); //Sets the high oscillator frequency. 
		pDVBSTuningSpace->put_InputRange (CComBSTR("-1")); //Sets an integer indicating which option or switch contains the requested signal source. 
		pDVBSTuningSpace->put_LNBSwitch (-1); //Sets the LNB switch frequency. 
		pDVBSTuningSpace->put_LowOscillator (-1); //Sets the low oscillator frequency. 
		pDVBSTuningSpace->put_SpectralInversion (BDA_SPECTRAL_INVERSION_NOT_SET);//Sets an integer indicating the spectral inversion. 
	}

	// Done
	return tuning;
}

IDVBTuningSpace2* CreateDVBCTuningSpace(void)
{
	IDVBCLocator *locator;
	IDVBTuningSpace2 *tuning;

	// Create locator
	CoCreateInstance(CLSID_DVBCLocator,NULL,CLSCTX_INPROC_SERVER,IID_IDVBCLocator,(void**)&locator);

	// Create tuning space
	CoCreateInstance(CLSID_DVBTuningSpace,NULL,CLSCTX_INPROC_SERVER,IID_IDVBTuningSpace2,(void**)&tuning);
	// Set ITuningSpace variables
	tuning->put__NetworkType(CLSID_DVBCNetworkProvider);
	// Set IDVBTuningSpace variables
	tuning->put_SystemType(DVB_Cable);
	// Set IDVBTuningSpace2 variables
	//	tuning->put_NetworkID(9018);
	// Set ITuningSpace variables again
	tuning->put_DefaultLocator(locator);
	tuning->put_FrequencyMapping(L"");
	tuning->put_FriendlyName(L"Local DVB-C digital antenna");
	tuning->put_UniqueName(DVBC_TUNING_SPACE_NAME);
	// Done
	return tuning;
}




IDVBTuningSpace2* CreateDVBTTuningSpace(void)
{
	IDVBCLocator *locator;
	IDVBTuningSpace2 *tuning;

	// Create locator
	CoCreateInstance(CLSID_DVBTLocator,NULL,CLSCTX_INPROC_SERVER,IID_IDVBTLocator,(void**)&locator);

	// Create tuning space
	CoCreateInstance(CLSID_DVBTuningSpace,NULL,CLSCTX_INPROC_SERVER,IID_IDVBTuningSpace2,(void**)&tuning);
	// Set ITuningSpace variables
	tuning->put__NetworkType(CLSID_DVBTNetworkProvider);
	// Set IDVBTuningSpace variables
	tuning->put_SystemType(DVB_Terrestrial);
	// Set IDVBTuningSpace2 variables
	//	tuning->put_NetworkID(9018);
	// Set ITuningSpace variables again
	tuning->put_DefaultLocator(locator);
	tuning->put_FrequencyMapping(L"");
	tuning->put_FriendlyName(L"Local DVB-T digital antenna");
	tuning->put_UniqueName(DVBT_TUNING_SPACE_NAME);
	// Done
	return tuning;
}


IDVBTuningSpace2* LoadDVBSTuningSpace(void)
{
	IEnumTuningSpaces *spaces;
	CComPtr<ITuningSpaceContainer> pITuningSpaceContainer;
	HRESULT hr;
	ITuningSpace *space;
	ULONG l;
	BSTR name;
	BOOL bFound;

	hr=pITuningSpaceContainer.CoCreateInstance(CLSID_SystemTuningSpaces);
	if(FAILED(hr)) 
		return NULL;
	// Check if our tuning space is in the container, and add it if not
	pITuningSpaceContainer->get_EnumTuningSpaces(&spaces);
	spaces->Reset();
	bFound=FALSE;
	while((!bFound)&&(spaces->Next(1,&space,&l)==S_OK)) 
	{
		space->get_UniqueName(&name);
		if(wcscmp(name,DVBS_TUNING_SPACE_NAME)==0) 
			bFound=TRUE;
		else 
			space->Release();
		SysFreeString(name);
	}
	spaces->Release();
	if(!bFound) 
	{
		VARIANT v;

		space=CreateDVBSTuningSpace();
		pITuningSpaceContainer->Add(space,&v);
	}
	return (IDVBTuningSpace2*)space;
}

IDVBTuningSpace2* LoadDVBCTuningSpace(void)
{
	IEnumTuningSpaces *spaces;
	CComPtr<ITuningSpaceContainer> pITuningSpaceContainer;
	HRESULT hr;
	ITuningSpace *space;
	ULONG l;
	BSTR name;
	BOOL bFound;

	hr=pITuningSpaceContainer.CoCreateInstance(CLSID_SystemTuningSpaces);
	if(FAILED(hr)) return NULL;
	// Check if our tuning space is in the container, and add it if not
	pITuningSpaceContainer->get_EnumTuningSpaces(&spaces);
	spaces->Reset();
	bFound=FALSE;
	while((!bFound)&&(spaces->Next(1,&space,&l)==S_OK)) {
		space->get_UniqueName(&name);
		if(wcscmp(name,DVBC_TUNING_SPACE_NAME)==0) bFound=TRUE;
		else space->Release();
		SysFreeString(name);
	}
	spaces->Release();
	if(!bFound) {
		VARIANT v;

		space=CreateDVBCTuningSpace();
		pITuningSpaceContainer->Add(space,&v);
	}
	return (IDVBTuningSpace2*)space;
}

IDVBTuningSpace2* LoadDVBTTuningSpace(void)
{
	IEnumTuningSpaces *spaces;
	CComPtr<ITuningSpaceContainer> pITuningSpaceContainer;
	HRESULT hr;
	ITuningSpace *space;
	ULONG l;
	BSTR name;
	BOOL bFound;

	hr=pITuningSpaceContainer.CoCreateInstance(CLSID_SystemTuningSpaces);
	if(FAILED(hr)) 
		return NULL;
	// Check if our tuning space is in the container, and add it if not
	pITuningSpaceContainer->get_EnumTuningSpaces(&spaces);
	spaces->Reset();
	bFound=FALSE;
	while((!bFound)&&(spaces->Next(1,&space,&l)==S_OK)) 
	{
		space->get_UniqueName(&name);
		if(wcscmp(name, DVBT_TUNING_SPACE_NAME)==0) 
			bFound=TRUE;
		else 
			space->Release();
		SysFreeString(name);
	}
	spaces->Release();
	if(!bFound) 
	{
		VARIANT v;

		space=CreateDVBTTuningSpace();
		pITuningSpaceContainer->Add(space,&v);
	}
	return (IDVBTuningSpace2*)space;
}

IBaseFilter* CreateDVBSNetworkProvider(void)
{

	BSTR name;
	CLSID clsid;
	IBaseFilter *provider;

	tuningspace[iDevice]=LoadDVBSTuningSpace();
	tuningspace[iDevice]->get_NetworkType(&name);
	CLSIDFromString(name,&clsid);
	SysFreeString(name);
	CoCreateInstance(clsid,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,reinterpret_cast<void**>(&provider));
	{
		CComPtr<ITuner> tuner;
		CComPtr<ITuneRequest> request;

		tuningspace[iDevice]->CreateTuneRequest(&request);
		provider->QueryInterface(IID_ITuner,(void**)&tuner);
		tuner->put_TuningSpace(tuningspace[iDevice]);
		tuner->put_TuneRequest(request);
		//
	}
	return provider;
}

IBaseFilter* CreateDVBCNetworkProvider(int iDevice)
{

	BSTR name;
	CLSID clsid;
	IBaseFilter *provider;

	tuningspace[iDevice]=LoadDVBCTuningSpace();
	tuningspace[iDevice]->get_NetworkType(&name);
	CLSIDFromString(name,&clsid);
	SysFreeString(name);
	CoCreateInstance(clsid,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,reinterpret_cast<void**>(&provider));
	{
		CComPtr<ITuner> tuner;
		CComPtr<ITuneRequest> request;

		tuningspace[iDevice]->CreateTuneRequest(&request);
		provider->QueryInterface(IID_ITuner,(void**)&tuner);
		tuner->put_TuningSpace(tuningspace[iDevice]);
		tuner->put_TuneRequest(request);
		//
	}
	return provider;
}


IBaseFilter* CreateDVBTNetworkProvider(int iDevice)
{

	BSTR name;
	CLSID clsid;
	IBaseFilter *provider;

	tuningspace[iDevice]=LoadDVBCTuningSpace();
	tuningspace[iDevice]->get_NetworkType(&name);
	CLSIDFromString(name,&clsid);
	SysFreeString(name);
	CoCreateInstance(clsid,NULL,CLSCTX_INPROC_SERVER,IID_IBaseFilter,reinterpret_cast<void**>(&provider));
	{
		CComPtr<ITuner> tuner;
		CComPtr<ITuneRequest> request;

		tuningspace[iDevice]->CreateTuneRequest(&request);
		provider->QueryInterface(IID_ITuner,(void**)&tuner);
		tuner->put_TuningSpace(tuningspace[iDevice]);
		tuner->put_TuneRequest(request);
		//
	}
	return provider;
}

HRESULT create_IR_filter(IBaseFilter **pfilter, wchar_t *ws_cap_filter_name)
{	
	int i = 0;
	*pfilter = NULL;

	TDSEnum *penumCapFilters = enum_create(KSCATEGORY_CAPTURE);
	if(!penumCapFilters) return E_FAIL;

	while (enum_next(penumCapFilters) == S_OK) {
		enum_get_name(penumCapFilters);		
		if (wcscmp(penumCapFilters->szNameW, ws_cap_filter_name) == 0) {
			if (enum_get_filter(penumCapFilters, pfilter) == S_OK) {					
				AddLog(L"BDA IR Filter Name: [%s]", penumCapFilters->szNameW);				
				enum_free(penumCapFilters);								
				return S_OK;
			}
		}
		i++;
	}

	enum_free(penumCapFilters);
	return E_FAIL;
}

HRESULT get_filter_property_set(IBaseFilter *pfilter, IKsPropertySet **pkspropertyset)
{
	return pfilter->QueryInterface(IID_IKsPropertySet, (void **) pkspropertyset);
}


//Only for TBS6920;TBS6921 TBS8920 TBS8921 TBS8922 TBS6980 TBS6981 IR code get method
//Qbox do not need this init
HRESULT TBSIRInit()
{
	HRESULT hr;

	pfltIRcapture = NULL;
	hr = create_IR_filter(&pfltIRcapture, IRFileName);


	if FAILED(hr || !pfltIRcapture) 
		AddLog(L"WARNING: TBS IR capture filter can not be created");


	// get the property sets on the IR capture filte
	ppropsetIRCaptureFilter = NULL;
	if (pfltIRcapture) {
		hr = get_filter_property_set(pfltIRcapture,&ppropsetIRCaptureFilter);	
		if FAILED(hr) 
			AddLog(L"WARNING: No propertyset interface on the IR capture filter");
	}

	return hr;
}


HRESULT TBSSetIROn()
{

	HRESULT hr;
	DWORD TypeSupport=0;
	KSPROPERTY_IRCAPTURE_KEYSTROKES_S  kStore={1,1};
	KSPROPERTY ks;
	ks.Id=KSPROPERTY_IRCAPTURE_KEYSTROKES;
	KSPROPERTY_IRCAPTURE_COMMAND_S tem;	

	if (ppropsetIRCaptureFilter) 
	{
		hr = ppropsetIRCaptureFilter->QuerySupported(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&TypeSupport);
		if (hr==S_OK) 
		{
			if (TypeSupport & KSPROPERTY_SUPPORT_SET) 	
			{

				tem.CommandCode = IRCAPTURE_COMMAND_START;
				hr=ppropsetIRCaptureFilter->Set(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S),
					&tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S));
				if (hr!=S_OK)  {
					AddLog(L"Error: Set IR capture filter error");

				}
			}

		}

	}

	return S_OK;

}

HRESULT TBSSetIROff()
{

	HRESULT hr;
	DWORD TypeSupport=0;
	KSPROPERTY_IRCAPTURE_KEYSTROKES_S  kStore={1,1};
	KSPROPERTY ks;
	ks.Id=KSPROPERTY_IRCAPTURE_KEYSTROKES;
	KSPROPERTY_IRCAPTURE_COMMAND_S tem;	

	if (ppropsetIRCaptureFilter) 
	{
		hr = ppropsetIRCaptureFilter->QuerySupported(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&TypeSupport);
		if (hr==S_OK) 
		{
			if (TypeSupport & KSPROPERTY_SUPPORT_SET) 	
			{

				tem.CommandCode = IRCAPTURE_COMMAND_STOP;
				hr=ppropsetIRCaptureFilter->Set(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_COMMAND,&tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S),
					&tem,sizeof(KSPROPERTY_IRCAPTURE_COMMAND_S));
				if (hr!=S_OK)  {
					AddLog(L"Error: Set IR capture filter error");

				}
			}

		}

	}

	return S_OK;

}




/////////////////////////////////////////////////////////////////////////////
// CTBSSDKDlg dialog

CTBSSDKDlg::CTBSSDKDlg(CWnd* pParent /*=NULL*/)
: CDialog(CTBSSDKDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CTBSSDKDlg)

	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CTBSSDKDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTBSSDKDlg)

	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTBSSDKDlg, CDialog)
	//{{AFX_MSG_MAP(CTBSSDKDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()

	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTBSSDKDlg message handlers

BOOL CTBSSDKDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class

	//  [8/13/2010 liuy]
	//˳ʱ Stopֹͣ߳
	StopBSDriveThread();

	if(control != NULL)
	{
		control->Stop();
	}

	if(m_pKsCtrl)
	{
		WaitForSingleObject( hIOMutex, INFINITE );
		m_pKsCtrl->Release();
		m_pKsCtrl = NULL;	
		ReleaseMutex(hIOMutex);
	}
	if(CaptureFilter != NULL)
	{
		builder->RemoveFilter(CaptureFilter);		
	}
	if(TSDump != NULL)
	{
		builder->RemoveFilter(TSDump);
	}
	if(provider != NULL)
	{
		builder->RemoveFilter(provider);
	}

	if(m_pFilterDest)
		builder->RemoveFilter(m_pFilterDest);

	if(control != NULL)
	{
		control.Release();
		control = NULL;
	}
	if(CaptureFilter != NULL)
	{
		CaptureFilter.Release();
		CaptureFilter = NULL;
	}
	if(TSDump != NULL)
	{
		TSDump.Release();
		TSDump = NULL;
	}
	if(demux != NULL)
	{
		demux.Release();
		demux = NULL;
	}
	if(infinite != NULL)
	{
		infinite.Release();
		infinite = NULL;
	}
	if(tif != NULL)
	{
		tif.Release();
		tif = NULL;
	}
	if(provider != NULL)
	{
		provider.Release();
		provider = NULL;
	}	

	if(TunerFilter)
	{
		builder->RemoveFilter(TunerFilter);
		TunerFilter.Release();
	}

	if(m_pFilterDest)
	{
		delete m_pFilterDest->m_pPin;
		delete m_pFilterDest;
		m_pFilterDest=NULL;
	}	

	if(builder != NULL)
	{
		builder.Release();
		builder = NULL;
	}	
	CoUninitialize();
	return CDialog::DestroyWindow();
}

BOOL CTBSSDKDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	////////////////////////////////////////////////////////////////////////////

	m_pTunerDevice = NULL;
	tuningspace = NULL;
	builder = NULL;
	provider = NULL;
	CaptureFilter = NULL;
	TSDump = NULL;
	control = NULL;
	demux = NULL;
	tif = NULL;
	infinite = NULL;

	int ll_init=0;
	HRESULT hr = S_OK;
	unsigned long BytesRead=0;
	DWORD type_support=0 ;

	CoCreateInstance(CLSID_FilterGraph,NULL,CLSCTX_INPROC_SERVER,IID_IGraphBuilder,(void**)&builder);

	builder->QueryInterface(IID_IMediaControl,(void**)&control);


	//For DVBS/S2
	if(DVBS)
	{
		// Create filters
		provider=CreateDVBSNetworkProvider();

		if(provider)
		{
			builder->AddFilter(provider, L"Network DVBS Provider");
		}
		else
		{
			OutputDebugString("CreateDVBSNetworkProvider Failed");

			return FALSE;
		}

	}

	//For DVB-T/T2
	if(DVB-T/T2)
	{

		provider=CreateDVBTNetworkProvider(iDevice);

		if(provider)
		{
			builder->AddFilter(provider, L"Network DVBT Provider");
		}
		else
		{
			OutputDebugString("CreateDVBTNetworkProvider Failed");

			return FALSE;
		}	

	}

	//For DVB-C
	if(DVB-C)
	{
		// Create filters
		provider=CreateDVBCNetworkProvider(iDevice);

		if(provider)
		{
			builder->AddFilter(provider, L"Network DVBC Provider");
		}
		else
		{
			OutputDebugString("CreateDVBCNetworkProvider Failed");

			return FALSE;
		}		
	}


	if(provider)
	{
		builder->AddFilter(provider, L"Network DVBS Provider");
	}
	else
	{
		MessageBox("CreateDVBSNetworkProvider Failed","error",MB_OK);
		return FALSE;
	}


	if(!TunerFilter)	//TunerFilter has been created in CheckDeviceReady() !!!
	{
		TunerFilter=CreateTunerDevice();
	}

	if(TunerFilter)
	{
		builder->AddFilter(TunerFilter,TunerName);
	}
	else
	{
		Sleep(3000);

		TunerFilter=CreateTunerDevice();

		if(TunerFilter)
		{
			builder->AddFilter(TunerFilter,TunerName);
		}
		else
		{
			MessageBox("CreateTunerDevice Failed","error",MB_OK);
			return FALSE;
		}
	}

	//CaptureDevice
	CaptureFilter=CreateCaptureDevice();
	if(CaptureFilter)
	{
		builder->AddFilter(CaptureFilter,CaptuerName);
	}
	else
	{
		Sleep(3000);

		CaptureFilter=CreateCaptureDevice();
		if(CaptureFilter)
		{
			builder->AddFilter(CaptureFilter,CaptuerName);
		}
		else
		{
			MessageBox("CreateCaptureDevice Failed","error",MB_OK);
			return FALSE;
		}
	}

	demux=CreateMPEG2Demultiplexer();
	if(demux)
	{
		builder->AddFilter(demux,L"MPEG2 Demultiplexer");
	}
	else
	{
		MessageBox("CreateMPEG2Demultiplexer Failed","error",MB_OK);
		return FALSE;
	}


	//
	infinite=CreateInfinitePinTee();
	if(infinite)
	{
		builder->AddFilter(infinite,L"Infinite pin tee splitter");
	}
	else
	{
		MessageBox("CreateInfinitePinTee Failed","error",MB_OK);
		return FALSE;
	}

	tif=CreateTransportInformationFilter();
	if(tif)
	{
		builder->AddFilter(tif, L"transport information filter");
	}
	else
	{
		MessageBox("Createtransport Failed","error",MB_OK);
		return FALSE;
	}

	m_pFilterDest= new CDestFilter(0, &m_Lock, &hr);
	m_pFilterDest->AddRef();
	hr=builder->AddFilter(m_pFilterDest,L"Dest Filter");



	m_pTunerDevice = TunerFilter;
	VideoCaptureFilter = CreateCaptureIRDevice();

	ConnectPins(builder,provider,TunerFilter);
	ConnectPins(builder,TunerFilter,CaptureFilter);
	ConnectPins(builder, CaptureFilter, infinite);
	ConnectPins(builder,infinite, demux);
	//This is to get the TS file
	ConnectPins(builder,infinite, m_pFilterDest);

	ConnectPins(builder,demux, tif);

	//---------Notice---------------------
	/***********************************/
	//PCI/PCIE and USB use difference init,this should be separated so they can use the different interface
	/***********************************/

	//first use USB as default init 
	{
		m_pKsCtrl = NULL;
		if(!ll_init && m_pTunerDevice != NULL)
		{
			hr = m_pTunerDevice->QueryInterface(__uuidof( m_pKsCtrl ),
				reinterpret_cast< void** >( &m_pKsCtrl ) );
			if (FAILED(hr))    
			{
				ll_init = 1;
				MessageBox("m_pTunerDevice USB QueryInterface Failed","error",MB_OK);
				m_pKsCtrl = NULL;
				return FALSE;			
			}
		}

		//check is usb init right
		if(!IsUsbDevice())
		{
			//It is PCI/PCI-E device , use PCI/PCI-E init
			MessageBox("It is PCI/PCI-E deivce ","notice",MB_OK);

			m_pKsCtrl = NULL;
			m_pTunerPin=NULL;
			m_pTunerPin = FindPinOnFilter(m_pTunerDevice, "Input0");
			if(!ll_init && m_pTunerPin != NULL)
			{
				hr = m_pTunerPin->QueryInterface(IID_IKsPropertySet,
					reinterpret_cast<void**>(&m_pKsCtrl));
				if (FAILED(hr))
				{
					ll_init = 1;
					MessageBox("m_pTunerDevice PCI/PCI-E QueryInterface Failed","error",MB_OK);
					m_pKsCtrl = NULL;
					return FALSE;	
				}
			}

		}	
		else
		{
			//It is USB Device
			MessageBox("It is USB device ","notice",MB_OK);
		}

	}

	/***********************************/	
	///////////////////////////////////////////////////////////

	return TRUE;  // return TRUE  unless you set the focus to a control
}

bool CTBSSDKDlg::IsUsbDevice()
{
	DWORD TypeSupport=0;
	HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPERTYSET_QBOXControl, 
		KSPROPERTY_CTRL_IR, 
		&TypeSupport);

	if FAILED(hr)	
		return false;
	else
		return true;	
}

char* CTBSSDKDlg::CreateDVBTuneRequest(IDVBTuneRequest**   pTuneRequest2)
{
	HRESULT hr = S_OK;


	if (tuningspace==NULL)
		return "CreateTuneRequest: Can't create tune request.\n";
	CComPtr <ITuneRequest> pNewTuneRequest;

	//  Create an instance of the DVB tuning space

	///////////////  - satelite -
	CComQIPtr <IDVBSTuningSpace> pDVBSTuningSpace (tuningspace);

	if (!pDVBSTuningSpace)
		return   TEXT("Cannot QI for an IDVBSTuningSpace\n");

	if(1){
		hr=pDVBSTuningSpace->put__NetworkType(CLSID_DVBSNetworkProvider);
		hr=pDVBSTuningSpace->put_LNBSwitch(LNBSwithvalue*1000);				
		hr=pDVBSTuningSpace->put_HighOscillator(ulLNBLOFHighBand*1000);
		hr=pDVBSTuningSpace->put_LowOscillator(ulLNBLOFLowBand*1000);
	};


	//  Create an empty tune request.
	hr = pDVBSTuningSpace->CreateTuneRequest(&pNewTuneRequest);


	if (FAILED (hr))
		return "CreateTuneRequest: Can't create tune request.\n";

	//query for an IDVBChannelTuneRequest interface pointer
	CComQIPtr <IDVBTuneRequest> pDVBTuneRequest (pNewTuneRequest);
	if (!pDVBTuneRequest)
		return TEXT("CreateDVBTuneRequest: Can't QI for IChannelTuneRequest.\n");


	///////////////  - satelite -
	CComPtr <IDVBSLocator>		pDVBSLocator;	

	hr = pDVBSLocator.CoCreateInstance (CLSID_DVBSLocator);
	if (FAILED( hr)) return "Cannot create the DVBS locator failed\n";

	if(1){
		pDVBSLocator->put_OuterFEC(BDA_FEC_VITERBI);
		pDVBSLocator->put_OuterFECRate(BDA_BCC_RATE_3_4);

		hr=pDVBSLocator->put_CarrierFrequency(ChannelFrequency*1000);
		hr=pDVBSLocator->put_SignalPolarisation(Polarity?BDA_POLARISATION_LINEAR_V:BDA_POLARISATION_LINEAR_H);
		hr=pDVBSLocator->put_SymbolRate(SymbolRate);
	};	

	hr = pDVBTuneRequest->put_Locator (pDVBSLocator);


	if (FAILED (hr))  return TEXT("Cannot put the locator\n");


	hr = pNewTuneRequest.QueryInterface (pTuneRequest2);

	return FAILED (hr) ? "Error on create pTuneRequest2":0;
}

void CQboxMacApp::TBSLock()
{
	CComPtr <IDVBTuneRequest>  pTuneRequest;
	if(FAILED (CreateDVBTuneRequest(&pTuneRequest)))
	{
		AfxMessageBox("CreateDVBTuneRequest is invalid!");
	}

	CComQIPtr<ITuner> pTuner(provider);
	hr=pTuner->put_TuneRequest(pTuneRequest);//put the request to lock

}

//Diseqc interface
void CTBSSDKDlg::TBSSendDiseqc(BYTE *cmd,int cmdlen)
{
	if(!IsUsbDevice())
	{
		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPSETID_BdaTunerExtensionProperties, 
			KSPROPERTY_BDA_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");		
		}

		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));

		TBSAccessCmd.access_mode = TBSACCESS_DISEQC;

		CopyMemory(TBSAccessCmd.uc_diseqc_send_message, cmd, cmdlen);
		TBSAccessCmd.uc_diseqc_send_message_length = cmdlen;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPSETID_BdaTunerExtensionProperties,
				KSPROPERTY_BDA_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));

		}
	}


	if(IsUsbDevice())
	{
		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPERTYSET_QBOXControl, 
			KSPROPERTY_CTRL_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");		
		}


		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));

		TBSAccessCmd.access_mode = TBSACCESS_DISEQC;

		CopyMemory(TBSAccessCmd.uc_diseqc_send_message, cmd, cmdlen);
		TBSAccessCmd.uc_diseqc_send_message_length = cmdlen;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPERTYSET_QBOXControl,
				KSPROPERTY_CTRL_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));

		}
	}

}

//LNBPower interface
void CTBSSDKDlg::TBSSetLNBPower(TBSLNBPowerMode tbslnbpower)
{
	if(!IsUsbDevice())
	{

		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPSETID_BdaTunerExtensionProperties, 
			KSPROPERTY_BDA_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");		
		}

		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));	

		TBSAccessCmd.access_mode = TBSACCESS_LNBPOWER;
		TBSAccessCmd.LNBPower_mode = tbslnbpower;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPSETID_BdaTunerExtensionProperties,
				KSPROPERTY_BDA_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));
		}

	}

	if(IsUsbDevice())
	{

		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPERTYSET_QBOXControl, 
			KSPROPERTY_CTRL_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");		
		}

		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));	

		TBSAccessCmd.access_mode = TBSACCESS_LNBPOWER;
		TBSAccessCmd.LNBPower_mode = tbslnbpower;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPERTYSET_QBOXControl,
				KSPROPERTY_CTRL_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));
		}

	}
}

//22k interface
void CTBSSDKDlg::TBSSet22K(TBS22KMode tbs22k)
{
	if(!IsUsbDevice())
	{
		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPSETID_BdaTunerExtensionProperties, 
			KSPROPERTY_BDA_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");			
			return E_FAIL;
		}


		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));	

		TBSAccessCmd.access_mode = TBSACCESS_22K;
		TBSAccessCmd.tbs22k_mode = tbs22k;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPSETID_BdaTunerExtensionProperties,
				KSPROPERTY_BDA_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));
		}

	}

	if(IsUsbDevice())
	{

		DWORD TypeSupport=0;
		HRESULT hr = m_pKsCtrl->QuerySupported(KSPROPERTYSET_QBOXControl, 
			KSPROPERTY_CTRL_TBSACCESS, 
			&TypeSupport);

		if FAILED(hr)
		{
			MessageBox("ERROR: Interface not supported!");			
			return E_FAIL;
		}
		TBS_ACCESS_STRUCT TBSAccessCmd;
		ZeroMemory(&TBSAccessCmd, sizeof(TBSAccessCmd));	

		TBSAccessCmd.access_mode = TBSACCESS_22K;
		TBSAccessCmd.tbs22k_mode = tbs22k;

		if(m_pKsCtrl)
		{
			hr = m_pKsCtrl->Set(KSPROPERTYSET_QBOXControl,
				KSPROPERTY_CTRL_TBSACCESS,
				NULL,
				0,
				&TBSAccessCmd,
				sizeof( TBS_ACCESS_STRUCT ));
		}

	}	
}

//Only for TBS6920;TBS6921 TBS8920 TBS8921 TBS8922 TBS6980 TBS6981 IR code get method
void CTBSSDKDlg::TBSGetIRCode()
{

	if(IsUsbDevice())
	{

		HRESULT hr;
		QBOXIRCMD temp_cmd;
		ULONG BytesRead;
		BYTE ir_code;
		int i;

		WaitForSingleObject( hIOMutex, INFINITE );

		hr = m_pKsCtrl->Get(KSPROPERTYSET_QBOXControl,
			KSPROPERTY_CTRL_IR,
			&temp_cmd,
			sizeof( QBOXIRCMD ),
			&temp_cmd,
			sizeof( QBOXIRCMD ),
			&BytesRead );

		ReleaseMutex( hIOMutex);

		if FAILED(hr)
			MessageBox("Failed to get the ir code");


		//IRcode
		ir_code = temp_cmd.ir_code[0];

		//you can process the IRcode here

	}


	if(!IsUsbDevice())
	{
		//First use IR init just need once
		TBSIRInit();
		TBSSetIROn();
		//end init later do not need call this two method
		//and when you release the device do not forget  call TBSSetIROff() method

		KSPROPERTY_IRCAPTURE_KEYSTROKES_S  kStore={1,1};
		KSPROPERTY ks;
		ks.Id=KSPROPERTY_IRCAPTURE_KEYSTROKES;
		DWORD type_support=0 ;
		ULONG pcbReturned;
		BYTE ir_code;
		int i;

		if (!ppropsetIRCaptureFilter)
			return 0;

		CoInitialize(NULL);


		WaitForSingleObject( hIOMutex, INFINITE );

		hr=ppropsetIRCaptureFilter->Get(KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE,KSPROPERTY_IRCAPTURE_KEYSTROKES,&ks,sizeof(ks),
			&kStore,sizeof(kStore),&pcbReturned);
		ReleaseMutex( hIOMutex);

		if FAILED(hr)
			MessageBox("Failed to get the ir code");

		//IR code	
		ir_code = (BYTE)kStore.dwCommand;

		CoUninitialize();

	}


}


//For TS receive
//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
// {90D647A7-DFBB-48f9-861F-33F3660C03FD}
DEFINE_GUID(CLSID_DestFilter, 
			0x90d647a7, 0xdfbb, 0x48f9, 0x86, 0x1f, 0x33, 0xf3, 0x66, 0xc, 0x3, 0xfd);

CDestFilter::CDestFilter(LPUNKNOWN pUnk,
						 CCritSec *pLock,
						 HRESULT *phr) :
CBaseFilter(NAME("CDestFilter"), pUnk, pLock,CLSID_DestFilter)

{
	m_pPin = new CDumpInputPin(this,GetOwner(),this,pLock,phr);

}

//
// GetPin
//
CBasePin * CDestFilter::GetPin(int n)
{
	if (n == 0) {
		return (CBasePin *)m_pPin;
	} else {
		return NULL;
	}
}


//
// GetPinCount
//
int CDestFilter::GetPinCount()
{
	return 1;
}

STDMETHODIMP CDestFilter::NonDelegatingQueryInterface(REFIID riid, void ** ppv){
	CheckPointer(ppv,E_POINTER);

	// Do we have this interface

	if (riid == IID_IBaseFilter || riid == IID_IMediaFilter || riid == IID_IPersist) {
		return CBaseFilter::NonDelegatingQueryInterface(riid, ppv);
	};

	return CUnknown::NonDelegatingQueryInterface(riid, ppv);

};

///////////////////////////////////////////////////////////////////////////////////////////////////////
//
//  Definition of CDumpInputPin
//

CDumpInputPin::CDumpInputPin(CDestFilter *pDump,
							 LPUNKNOWN pUnk,
							 CBaseFilter *pFilter,
							 CCritSec *pLock,
							 HRESULT *phr) :

CBaseInputPin(NAME("CDestInputPin"),
			  pFilter,                   // Filter
			  pLock,                     // Locking
			  phr,                       // Return code
			  L"Input"),                 // Pin name
			  m_pReceiveLock(pLock),
			  m_pFilter(pDump)

{
	m_tmpBufferLen=0;
	m_bOpened=false;
}


//
// CheckMediaType
//
// Check if the pin can support this specific proposed type and format
//
HRESULT CDumpInputPin::CheckMediaType(const CMediaType *type)
{
	return S_OK;
}


HRESULT
CDumpInputPin::GetMediaType(
							int iPosition,
							CMediaType *pMediaType)
{

	if(iPosition < 0)
	{
		return E_INVALIDARG;
	}
	if(iPosition > 0)
	{
		return VFW_S_NO_MORE_ITEMS;
	}

	AM_MEDIA_TYPE type;
	ZeroMemory(&type,sizeof(type));
	type.bFixedSizeSamples=1;
	type.lSampleSize=188;
	type.majortype=MEDIATYPE_Stream;
	type.subtype=MEDIASUBTYPE_NULL;

	pMediaType->Set(type);

	return S_OK;
}



//
// BreakConnect
//
// Break a connection
//
HRESULT CDumpInputPin::BreakConnect()
{
	return CBaseInputPin::BreakConnect();
}


//
// ReceiveCanBlock
//
// We don't hold up source threads on Receive
//
STDMETHODIMP CDumpInputPin::ReceiveCanBlock()
{
	return S_FALSE;
}


//
// Receive
//
// Do something with this media sample
//
STDMETHODIMP CDumpInputPin::Receive(IMediaSample *pSample)
{
	if(!m_bOpened) return S_OK;

	CAutoLock lock(m_pReceiveLock);
	PBYTE pbData;

	HRESULT hr = pSample->GetPointer(&pbData);
	if (FAILED(hr)) 
	{
		return hr;
	}

	int size=pSample->GetActualDataLength();
	StoreFile.Write(pbData,size);


	return  S_OK;
}




//
// EndOfStream
//
STDMETHODIMP CDumpInputPin::EndOfStream(void)
{
	CAutoLock lock(m_pReceiveLock);
	return CBaseInputPin::EndOfStream();

} // EndOfStream


//
// NewSegment
//
// Called when we are seeked
//
STDMETHODIMP CDumpInputPin::NewSegment(REFERENCE_TIME tStart,
									   REFERENCE_TIME tStop,
									   double dRate)
{
	return S_OK;

} // NewSegment


void StartRecord()
{
	if(control)
	{

		CAutoLock lock(&m_Lock);

		if(StoreFileOpened)
		{
			StoreFileOpened=FALSE;
			StoreFile.Close();
		}

		//This is will start record
		if(m_pFilterDest)
			m_pFilterDest->m_pPin->RefreshConnect();

		StoreFile.Open(m_StoreFilePath,CFile::modeCreate|CFile::modeWrite);
		StoreFileOpened=TRUE;


		control->Run(); 
	}
}

void StopRecord()
{
	if(control)
	{
		control->Stop();
		if(StoreFileOpened)
		{
			StoreFile.Close();
			StoreFileOpened=FALSE;
		}
	}
}


