//////////////////////////////////////////////////////////////////////////////
//
//                     (C) TBS 2005 - 2012
//  All rights are reserved. Reproduction in whole or in part is prohibited
//  without the written consent of the copyright owner.
//
//  TBS reserves the right to make changes without notice at any time.
//  TBS makes no warranty, expressed, implied or statutory, including but
//  not limited to any implied warranty of merchantability or fitness for any
//  particular purpose, or that the use will not infringe any third party
//  patent, copyright or trademark. TBS must not be liable for any loss
//  or damage arising from its use.
//
//////////////////////////////////////////////////////////////////////////////

//////////////////////////////////////////////////////////////////////////////
//
// Modification History:
//
//  Date               By                  Description
//  -------          ------          ---------------------------------------------------------
// 10-10-2011    steven@tbsdtv.com       version:1.0.0.0  	TBS SDK created
// 12-22-2011    steven@tbsdtv.com       version:2.0.0.1  	update new inerface
// 05-23-2012    steven@tbsdtv.com       version:2.0.0.2    add DVBC and DVBT/T2 
//															TS file receive method
//////////////////////////////////////////////////////////////////////////////


/////////////////////////////////////////////////////////////////////////////
// CQboxMacDlg dialog


const GUID KSPROPSETID_BdaTunerExtensionProperties =
{0xfaa8f3e5, 0x31d4, 0x4e41, {0x88, 0xef, 0xd9, 0xeb, 0x71, 0x6f, 0x6e, 0xc9}};


DEFINE_GUIDSTRUCT( "C6EFE5EB-855A-4f1b-B7AA-87B5E1DC4113", KSPROPERTYSET_QBOXControl );
#define KSPROPERTYSET_QBOXControl DEFINE_GUIDNAMED( KSPROPERTYSET_QBOXControl )


//for IR
const GUID KSPROPSETID_VIDCAP_CUSTOM_IRCAPTURE = 
{0xB51C4994,0x0054,0x4749,{0x82,0x43,0x02,0x9A,0x66,0x86,0x36,0x36}};
typedef struct 
{   
	DWORD             dwAddress;
	DWORD             dwCommand;  
} KSPROPERTY_IRCAPTURE_KEYSTROKES_S, *PKSPROPERTY_IRCAPTURE_KEYSTROKES_S;


typedef enum
{
	KSPROPERTY_IRCAPTURE_KEYSTROKES         = 0,
	KSPROPERTY_IRCAPTURE_COMMAND            = 1

}KSPROPERTY_IRCAPTURE_PROPS;
#define IRCAPTURE_COMMAND_START        1
#define IRCAPTURE_COMMAND_STOP         2
#define IRCAPTURE_COMMAND_FLUSH        3
typedef struct 
{    
	CHAR             CommandCode;    

} KSPROPERTY_IRCAPTURE_COMMAND_S, *PKSPROPERTY_IRCAPTURE_COMMAND_S;


//END

//PCI/E
typedef enum {
	KSPROPERTY_BDA_RESERVED   = 0,
	KSPROPERTY_BDA_BLIND_SCAN = 11,	
	KSPROPERTY_BDA_TBSACCESS  = 21	
} KSPROPERTY_BDA_TUNER_EXTENSION;


//USB
typedef enum
{
	KSPROPERTY_CTRL_RESERVED   = 0,
	KSPROPERTY_CTRL_IR		   = 1,
	KSPROPERTY_CTRL_BLIND_SCAN = 9,
	KSPROPERTY_CTRL_TBSACCESS  = 18
} KSPROPERTY_UTICA;



typedef enum _tbsaccessmode{
	TBSACCESS_LNBPOWER=0x00,
	TBSACCESS_DISEQC  =0x01,
	TBSACCESS_22K     =0x02
}TBSAccessMode;

typedef enum _tbslnbpowermode{
	LNBPOWER_OFF  =0x00,
	LNBPOWER_ON   =0x03,// this sets automatically to last H/V state  and keeps changing after tune requests
	LNBPOWER_13V  =0x02,
	LNBPOWER_18V  =0x01,
}TBSLNBPowerMode;

typedef enum _tbs22kmode{
	TBSBURST_OFF         =0x00,
	TBSBURST_ON          =0x01, 
	TBSBURST_UNMODULATED =0x02, //tone burst unmodulated ,satellite A
	TBSBURST_MODULATED   =0x03 ////tone burst modulated, satellite B
}TBS22KMode;

typedef struct _tbs_access
{

	TBSAccessMode	   access_mode;

	TBS22KMode		   tbs22k_mode;

	DWORD			   uc_reservedtemp;

	TBSLNBPowerMode    LNBPower_mode;

	UCHAR			   uc_diseqc_send_message[128];
	DWORD			   uc_diseqc_send_message_length;

	UCHAR			   uc_diseqc_receive_message[128];
	DWORD			   uc_diseqc_receive_message_length;

	UCHAR			   uc_reserved[256];//reserved for future use 

}TBS_ACCESS_STRUCT;



typedef struct {

	unsigned char uc_reserved_1[32];

	unsigned char ir_code[12];

	unsigned char uc_reserved_2[244];
} QBOXIRCMD;



class CQboxMacDlg : public CDialog
{
	// Construction
public:
	CQboxMacDlg(CWnd* pParent = NULL);	// standard constructor

	// Dialog Data
	//{{AFX_DATA(CQboxMacDlg)
	enum { IDD = IDD_QBOXMAC_DIALOG };

	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CQboxMacDlg)
public:
	virtual BOOL DestroyWindow();
protected:
	virtual void DoDataExchange(CDataExchange* pDX);	// DDX/DDV support
	virtual LRESULT DefWindowProc(UINT message, WPARAM wParam, LPARAM lParam);
	//}}AFX_VIRTUAL

	// Implementation

protected:
	CComPtr <IBaseFilter> m_pTunerDevice;
	IDVBTuningSpace2 * tuningspace;


public:

	IPin* FindPinOnFilter(IBaseFilter* pBaseFilter, char* pPinName);

	char* CreateDVBTuneRequest(IDVBTuneRequest**   pTuneRequest2);


protected:
	HICON m_hIcon;

	// Generated message map functions
	//{{AFX_MSG(CQboxMacDlg)
	virtual BOOL OnInitDialog();

	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()

public:

	bool IsUsbDevice();


	void TBSSendDiseqc(BYTE *cmd,int cmdlen);
	void TBSSetLNBPower(TBSLNBPowerMode tbslnbpower);
	void TBSSet22K(TBS22KMode tbs22k);

	//for USB
	void TBSQBOXGetIRCode();

	//for PCI/PCI-E
	void TBSIRInit();
	void TBSSetIROn();
	void TBSGetIRCode();


};


class CDumpInputPin;
class CDestFilter : public CBaseFilter
{

public:
	DWORD			m_Pid;
	CComPtr <IMPEG2PIDMap>		m_pMpeg2PidMap;

	CDumpInputPin	*m_pPin;

	// Constructor
	CDestFilter(LPUNKNOWN pUnk,
		CCritSec *pLock,
		HRESULT *phr);

	// Pin enumeration
	CBasePin * GetPin(int n);
	int GetPinCount();
	STDMETHODIMP NonDelegatingQueryInterface(REFIID riid, void ** ppv);
};

//////////////////////////////////////////////////////////////////////////////////////

class CDumpInputPin : public CBaseInputPin
{
	CDestFilter    * const m_pFilter;           // Main renderer object
	CCritSec * const m_pReceiveLock;    // Sample critical section

public:

	void		RefreshConnect(){
		m_tmpBufferLen=0;
		m_bOpened=true;
	}

	bool		m_bOpened;

	byte		m_tmpBuffer[188];
	int			m_tmpBufferLen;

	CDumpInputPin(CDestFilter *pDump,
		LPUNKNOWN pUnk,
		CBaseFilter *pFilter,
		CCritSec *pLock,                  
		HRESULT *phr);

	// Do something with this media sample
	STDMETHODIMP Receive(IMediaSample *pSample);
	STDMETHODIMP EndOfStream(void);
	STDMETHODIMP ReceiveCanBlock();
	//HRESULT WriteStringInfo(IMediaSample *pSample);

	// Check if the pin can support this specific proposed type and format
	HRESULT CheckMediaType(const CMediaType *);
	HRESULT GetMediaType( int iPosition,  CMediaType *pMediaType);

	// Break connection
	HRESULT BreakConnect();

	// Track NewSegment
	STDMETHODIMP NewSegment(REFERENCE_TIME tStart,
		REFERENCE_TIME tStop,
		double dRate);
};



//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_QBOXMACDLG_H__0B67971A_BEDF_4BD5_B2F0_89CAEAA560C2__INCLUDED_)
