#ifndef MN88436_PRIV_H
#define MN88436_PRIV_H

#include <media/dvb_frontend.h>
#include "mn88436.h"
#include <linux/regmap.h>

typedef enum{
	DMD_E_ATSC,
	DMD_E_QAMB_64QAM,
	DMD_E_QAMB_256QAM,

}DMD_SYSTEM_t;

struct mn88436_dev {
	struct i2c_client *client[2];
	struct regmap *regmap[2];
	struct dvb_frontend fe;
	u16 i2c_write_max;

	unsigned int ts_mode;
	
	DMD_SYSTEM_t mode;

};

#define AGC_MIN 801   //-90dBm
#define AGC_MAX 3338  //0dBm
#define AGC_RANGE (AGC_MAX - AGC_MIN)


#define DMD_INFORMATION_MAX	512
#define DMD_INFO_VALUE_MAX	32

#define DMD_MAX_DEVICE	4
#define DMD_REG_BANK    2

#define DMD_NOT_SUPPORT		0
#define DMD_SYSTEM_MAX		15
#define DMD_TCB_DATA_MAX	256
#define DMD_REGISTER_MAX	2048
#define DMD_I2C_MAXSIZE	127



//For Main
#define DMD_MAIN_IBMOD		0x0
#define DMD_MAIN_CPOSET1		0x1
#define DMD_MAIN_CPOSET2		0x2
#define DMD_MAIN_HIZSET		0x3
#define DMD_MAIN_INVSET		0x4
#define DMD_MAIN_GPSET1		0x5
#define DMD_MAIN_GPSET2		0x6
#define DMD_MAIN_GPSET3		0x7
#define DMD_MAIN_MDADATL		0x8
#define DMD_MAIN_MDADATU		0x9
#define DMD_MAIN_IQDSET		0xA
#define DMD_MAIN_FOFFSET1U		0xB
#define DMD_MAIN_FOFFSET1L		0xC
#define DMD_MAIN_SRATEIN1		0xD
#define DMD_MAIN_SRATEIN2		0xE
#define DMD_MAIN_SRATEIN3		0xF
#define DMD_MAIN_RSTSET1		0x10
#define DMD_MAIN_RSTSET2		0x11
#define DMD_MAIN_FOFFSET2U		0x12
#define DMD_MAIN_FOFFSET2L		0x13
#define DMD_MAIN_I2CSET		0x14
#define DMD_MAIN_TCBSET		0x15
#define DMD_MAIN_TCBRT		0x16
#define DMD_MAIN_TCBADR		0x17
#define DMD_MAIN_TCBDT0		0x18
#define DMD_MAIN_TCBDT1		0x19
#define DMD_MAIN_TCBDT2		0x1A
#define DMD_MAIN_TCBDT3		0x1B
#define DMD_MAIN_TCBDT4		0x1C
#define DMD_MAIN_TCBDT5		0x1D
#define DMD_MAIN_TCBDT6		0x1E
#define DMD_MAIN_TCBDT7		0x1F
#define DMD_MAIN_TCBCOM		0x20
#define DMD_MAIN_VAGCREF		0x21
#define DMD_MAIN_QAGCREF		0x22
#define DMD_MAIN_AGCCO1		0x23
#define DMD_MAIN_AGCSET1		0x24
#define DMD_MAIN_VAGCDLY1L		0x25
#define DMD_MAIN_VQAGCDLY1U		0x26
#define DMD_MAIN_QAGCDLY1L		0x27
#define DMD_MAIN_ERRCNTTHU		0x28
#define DMD_MAIN_ERRCNTTHL		0x29
#define DMD_MAIN_ALCSET1		0x2A
#define DMD_MAIN_ALCSET2		0x2B
#define DMD_MAIN_ALCSET3		0x2C
#define DMD_MAIN_CLIPVUL		0x2D
#define DMD_MAIN_CLIPVL		0x2E
#define DMD_MAIN_PIRETH2U		0x2F
#define DMD_MAIN_PIRETH2L		0x30
#define DMD_MAIN_PIRETH3U		0x31
#define DMD_MAIN_PIRETH3L		0x32
#define DMD_MAIN_PAFCSGSET1		0x33
#define DMD_MAIN_PAFCSGSET2		0x34
#define DMD_MAIN_PAFCLPFSET1		0x35
#define DMD_MAIN_PAFCLPFSETA2		0x36
#define DMD_MAIN_PAFCLPFSETA3		0x37
#define DMD_MAIN_PAFCLPFSETA4		0x38
#define DMD_MAIN_PAFCLPFSETB2		0x39
#define DMD_MAIN_PAFCLPFSETB3		0x3A
#define DMD_MAIN_PAFCLPFSETB4		0x3B
#define DMD_MAIN_AFCSET1		0x3C
#define DMD_MAIN_AFCCO		0x3D
#define DMD_MAIN_AFCADD		0x3E
#define DMD_MAIN_APCSET1		0x3F
#define DMD_MAIN_APCSET2		0x40
#define DMD_MAIN_APCSET4		0x41
#define DMD_MAIN_APCSET5		0x42
#define DMD_MAIN_APCCO1		0x43
#define DMD_MAIN_APCCO2		0x44
#define DMD_MAIN_APCCO3		0x45
#define DMD_MAIN_APCCO4		0x46
#define DMD_MAIN_VCKRSET1		0x47
#define DMD_MAIN_VCKRSET2		0x48
#define DMD_MAIN_VCKRCOUL		0x49
#define DMD_MAIN_VCKRCOL		0x4A
#define DMD_MAIN_VFCKSET1		0x4B
#define DMD_MAIN_VFCKSET2		0x4C
#define DMD_MAIN_VFCKBWUL		0x4D
#define DMD_MAIN_VFCKBWLK		0x4E
#define DMD_MAIN_VFCKATUL		0x4F
#define DMD_MAIN_VFCKATLK		0x50
#define DMD_MAIN_VTCKSET1		0x51
#define DMD_MAIN_VTCKSET2		0x52
#define DMD_MAIN_VDAGCREF		0x53
#define DMD_MAIN_QDAGCREF		0x54
#define DMD_MAIN_GMIN		0x55
#define DMD_MAIN_DAGCCO		0x56
#define DMD_MAIN_CKRCO1		0x57
#define DMD_MAIN_CKRCO2		0x58
#define DMD_MAIN_CKRSET1		0x59
#define DMD_MAIN_CKRSET2		0x5A
#define DMD_MAIN_PNTSET		0x5B
#define DMD_MAIN_PNTCO		0x5C
#define DMD_MAIN_NRFMODE		0x5D
#define DMD_MAIN_FDATSC		0x5E
#define DMD_MAIN_FLTBW1		0x5F
#define DMD_MAIN_NRFRSEL		0x60
#define DMD_MAIN_SYNCSET1		0x61
#define DMD_MAIN_SYNCSET2		0x62
#define DMD_MAIN_SYNCSET6		0x63
#define DMD_MAIN_QDETREF		0x64
#define DMD_MAIN_QDETSET1		0x65
#define DMD_MAIN_QDETSET2		0x66
#define DMD_MAIN_EQSET		0x67
#define DMD_MAIN_VEQSET1		0x68
#define DMD_MAIN_VEQSET2		0x69
#define DMD_MAIN_VEQSET3		0x6A
#define DMD_MAIN_VEQSET4		0x6B
#define DMD_MAIN_VEQSET5		0x6C
#define DMD_MAIN_VEQSET6		0x6D
#define DMD_MAIN_VEQSET7		0x6E
#define DMD_MAIN_VEQSET8		0x6F
#define DMD_MAIN_VEQSET9		0x70
#define DMD_MAIN_AGCMON		0x71
#define DMD_MAIN_CKRFEMON		0x72
#define DMD_MAIN_DAGCMON		0x73
#define DMD_MAIN_QEQSET		0x74
#define DMD_MAIN_PAFCPILOT		0x75
#define DMD_MAIN_VCKRSYM		0x76
#define DMD_MAIN_APCMON		0x77
#define DMD_MAIN_PNTMON		0x78
#define DMD_MAIN_VEQSET10		0x79
#define DMD_MAIN_VEQSET11		0x7A
#define DMD_MAIN_VEQSET12		0x7B
#define DMD_MAIN_VEQSET13		0x7C
#define DMD_MAIN_VEQSET14		0x7D
#define DMD_MAIN_VEQSET15		0x7E
#define DMD_MAIN_VEQSET16		0x7F
#define DMD_MAIN_VEQSET17		0x80
#define DMD_MAIN_VEQSET18		0x81
#define DMD_MAIN_VEQSET19		0x82
#define DMD_MAIN_VEQSET20		0x83
#define DMD_MAIN_VEQSET21		0x84
#define DMD_MAIN_VEQSET22		0x85
#define DMD_MAIN_PLOCKTH1		0x86
#define DMD_MAIN_PLOCKTH2		0x87
#define DMD_MAIN_PLOCKTH3		0x88
#define DMD_MAIN_CRCDIVASET1		0x89
#define DMD_MAIN_CRCDIVASET2		0x8A
#define DMD_MAIN_CRCDIVASET3		0x8B
#define DMD_MAIN_CRCDIVBSET1		0x8C
#define DMD_MAIN_CRCDIVBSET2		0x8D
#define DMD_MAIN_CRCDIVBSET3		0x8E
#define DMD_MAIN_CRCDIVSMV		0x8F
#define DMD_MAIN_CRCDIVTIM		0x90
#define DMD_MAIN_PNDETSET1		0x91
#define DMD_MAIN_PNDETSET2		0x92
#define DMD_MAIN_PREIDETSET1		0x93
#define DMD_MAIN_PREQDETSET1		0x94
#define DMD_MAIN_PNDETSET3		0x95
#define DMD_MAIN_PNDETSET4		0x96
#define DMD_MAIN_PNSMSET1		0x97
#define DMD_MAIN_PNSMSET2		0x98
#define DMD_MAIN_PNSMSET3		0x99
#define DMD_MAIN_PNSMSET4		0x9A
#define DMD_MAIN_PNSMSET5		0x9B
#define DMD_MAIN_PNSMSET6		0x9C
#define DMD_MAIN_PNSMSET7		0x9D
#define DMD_MAIN_PNSMSET8		0x9E
#define DMD_MAIN_PNSMSET9		0x9F
#define DMD_MAIN_PNSMSET10		0xA0
#define DMD_MAIN_PNSMSET11		0xA1
#define DMD_MAIN_PNSMSET12		0xA2
#define DMD_MAIN_PNSMSET13		0xA3
#define DMD_MAIN_PNREGSET1		0xA4
#define DMD_MAIN_PNREGSET2		0xA5
#define DMD_MAIN_PNREGSET3		0xA6
#define DMD_MAIN_PNREGSET4		0xA7
#define DMD_MAIN_PNREGSET5		0xA8
#define DMD_MAIN_PNREGSET6		0xA9
#define DMD_MAIN_FREQSET		0xAA
#define DMD_MAIN_FREQU		0xAB
#define DMD_MAIN_FREQL		0xAC
#define DMD_MAIN_PNREGSET10		0xAD
#define DMD_MAIN_PNREGSET11		0xAE
#define DMD_MAIN_PNREGSET12		0xAF
#define DMD_MAIN_PNREGSET13		0xB0
#define DMD_MAIN_PNREGSET14		0xB1
#define DMD_MAIN_PNREGSET15		0xB2
#define DMD_MAIN_PNREGSET16		0xB3
#define DMD_MAIN_PNREGSET17		0xB4
#define DMD_MAIN_PNREGSET18		0xB5
#define DMD_MAIN_PNREGSET19		0xB6
#define DMD_MAIN_PNREGSET20		0xB7
#define DMD_MAIN_PNREGSET21		0xB8
#define DMD_MAIN_NTCWTH1		0xB9
#define DMD_MAIN_IBTGSET		0xBA
#define DMD_MAIN_AFCMON		0xBB
#define DMD_MAIN_CKRMON		0xBC
#define DMD_MAIN_NRFRDAT		0xBD
#define DMD_MAIN_MEANFERR		0xBE
#define DMD_MAIN_MEANMAGERR		0xBF
#define DMD_MAIN_PAFCSGGATE		0xC0
#define DMD_MAIN_AFCMONB		0xC1
#define DMD_MAIN_PLOCKMONAU		0xC2
#define DMD_MAIN_PLOCKMONAL		0xC3
#define DMD_MAIN_STSMON1		0xC4
#define DMD_MAIN_STSMON2		0xC5
#define DMD_MAIN_SYNCRD2		0xC6
#define DMD_MAIN_SYNCRD3		0xC7
#define DMD_MAIN_PLOCKMONBU		0xC8
#define DMD_MAIN_PLOCKMONBL		0xC9
#define DMD_MAIN_PNDETU		0xCA
#define DMD_MAIN_PNDETL		0xCB
#define DMD_MAIN_PIBETAU		0xCC
#define DMD_MAIN_PIBETAL		0xCD
#define DMD_MAIN_EQMNSET		0xCE
#define DMD_MAIN_EQERR1		0xCF
#define DMD_MAIN_EQERR2		0xD0
#define DMD_MAIN_RFAGCMON1P		0xD1
#define DMD_MAIN_RFAGCMON2P		0xD2
#define DMD_MAIN_IFAGCMON1P		0xD3
#define DMD_MAIN_IFAGCMON2P		0xD4
#define DMD_MAIN_PLOCKSTATE		0xD5
#define DMD_MAIN_PIBETAQU		0xD6
#define DMD_MAIN_PIBETAQL		0xD7
#define DMD_MAIN_PNDETSTATE		0xD8
#define DMD_MAIN_CNSETP		0xD9
#define DMD_MAIN_CNFLGP		0xDA
#define DMD_MAIN_CNMON1P		0xDB
#define DMD_MAIN_CNMON2P		0xDC
#define DMD_MAIN_CNMON3P		0xDD
#define DMD_MAIN_CNMON4P		0xDE
#define DMD_MAIN_FECSET		0xDF
#define DMD_MAIN_BERDSETP		0xE0
#define DMD_MAIN_BERTSET1P		0xE1
#define DMD_MAIN_BERTSET2P		0xE2
#define DMD_MAIN_BERFLGP		0xE3
#define DMD_MAIN_BERMON1P		0xE4
#define DMD_MAIN_BERMON2P		0xE5
#define DMD_MAIN_BERMON3P		0xE6
#define DMD_MAIN_NTCWTH2		0xE7
#define DMD_MAIN_PWDSET1		0xE8
#define DMD_MAIN_PWDSET2		0xE9
#define DMD_MAIN_PSEQOP1		0xEA
#define DMD_MAIN_PSEQOP2		0xEB
#define DMD_MAIN_PSEQOP3		0xEC
#define DMD_MAIN_PSEQOP4		0xED
#define DMD_MAIN_PSEQOP5		0xEE
#define DMD_MAIN_PSEQOP6		0xEF
#define DMD_MAIN_PSEQSET		0xF0
#define DMD_MAIN_PSEQPRG		0xF1
#define DMD_MAIN_PSEQSEL		0xF2
#define DMD_MAIN_PSEQDBG		0xF3
#define DMD_MAIN_PSEQOP7		0xF4
#define DMD_MAIN_PSEQOP8		0xF5
#define DMD_MAIN_PSEQOP9		0xF6
#define DMD_MAIN_PSEQOP10		0xF7
#define DMD_MAIN_PSEQADRU		0xF8
#define DMD_MAIN_PSEQADRL		0xF9
#define DMD_MAIN_PSEQDT		0xFA
#define DMD_MAIN_TESTSET3		0xFB
#define DMD_MAIN_CLKGSET		0xFC
#define DMD_MAIN_TPLLSET1		0xFD
#define DMD_MAIN_TPLLSET2		0xFE
#define DMD_MAIN_RDCHK		0xFF


//For USR
#define DMD_USR_INTDEFR		0x9
#define DMD_USR_INTDEFF		0xA
#define DMD_USR_INTSET		0xB
#define DMD_USR_INTCNT		0xC
#define DMD_USR_INTCND		0xD
#define DMD_USR_I2CSET		0x14
#define DMD_USR_CNSET		0x5A
#define DMD_USR_CNFLG		0x5B
#define DMD_USR_CNMON1		0x5C
#define DMD_USR_CNMON2		0x5D
#define DMD_USR_CNMON3		0x5E
#define DMD_USR_CNMON4		0x5F
#define DMD_USR_BERTSET1		0x60
#define DMD_USR_BERTSET2		0x61
#define DMD_USR_BERPSET1		0x62
#define DMD_USR_BERPSET2		0x63
#define DMD_USR_BERFLG		0x64
#define DMD_USR_BERMON1		0x65
#define DMD_USR_BERMON2		0x66
#define DMD_USR_BERMON3		0x67
#define DMD_USR_RFAGCMON1		0x68
#define DMD_USR_RFAGCMON2		0x69
#define DMD_USR_IFAGCMON1		0x6A
#define DMD_USR_IFAGCMON2		0x6B
#define DMD_USR_IMON		0x74
#define DMD_USR_QMON		0x79
#define DMD_USR_SDCC		0x80
#define DMD_USR_VSAGCREFU		0x81
#define DMD_USR_VSAGCREFL		0x82
#define DMD_USR_QSAGCREFU		0x83
#define DMD_USR_QSAGCREFL		0x84
#define DMD_USR_SAGCCO		0x85
#define DMD_USR_SAGCSET		0x86
#define DMD_USR_VPWMSET1		0x87
#define DMD_USR_VPWMDAT1		0x88
#define DMD_USR_QPWMSET1		0x89
#define DMD_USR_QPWMDAT1		0x8A
#define DMD_USR_QFECSET1		0x8B
#define DMD_USR_QFECSET4		0x8C
#define DMD_USR_QFECSET5		0x8D
#define DMD_USR_TSCSETV1		0x8E
#define DMD_USR_TSCSETQ1		0x8F
#define DMD_USR_TSCSET2		0x90
#define DMD_USR_TSCSET4		0x91
#define DMD_USR_FAD064U		0x92
#define DMD_USR_FAD064M		0x93
#define DMD_USR_FAD064L		0x94
#define DMD_USR_FAD256U		0x95
#define DMD_USR_FAD256M		0x96
#define DMD_USR_FAD256L		0x97
#define DMD_USR_FAD188U		0x98
#define DMD_USR_FAD188M		0x99
#define DMD_USR_FAD188L		0x9A
#define DMD_USR_FAD208U		0x9B
#define DMD_USR_FAD208M		0x9C
#define DMD_USR_FAD208L		0x9D
#define DMD_USR_TESTSET1		0x9E
#define DMD_USR_TESTSET2		0x9F
#define DMD_USR_AD10SET1		0xA0
#define DMD_USR_AD10SET2		0xA1
#define DMD_USR_AD10SET3		0xA2
#define DMD_USR_AD10SET4		0xA3
#define DMD_USR_RDCHK		0xFF

#endif
