/* 
* This file is part of STiD135 OXFORD LLA 
* 
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
* 
* License terms: BSD 3-clause "New" or "Revised" License. 
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
* 
*/ 
#ifndef _AFE_CTRL_REG_INIT_H
#define _AFE_CTRL_REG_INIT_H

/* -------------------------------------------------------------------------
 * File name  : afe_ctrl_reg_init.h
 * File type  : C header file
 * -------------------------------------------------------------------------
 * Description:  Register map constants
 * Generated by spirit2regtest v2.24_alpha3
 * -------------------------------------------------------------------------
 */


/* Register map constants */

/* AFE_OSC */
#define RSTID135_AFE_AFE_OSC                                         0x00000000
#define RSTID135_AFE_AFE_OSC__DEFAULT                                0x0       
#define FSTID135_AFE_AFE_OSC_OSC_PWD__MASK                           0x01      
#define FSTID135_AFE_AFE_OSC_OSC_EXT_PWD__MASK                       0x02      
#define FSTID135_AFE_AFE_OSC_DIG1_CLK_ENA__MASK                      0x04      
#define FSTID135_AFE_AFE_OSC_DIG2_CLK_ENA__MASK                      0x08      
#define FSTID135_AFE_AFE_OSC_CLK_DCDC_ENA__MASK                      0x10      
#define FSTID135_AFE_AFE_OSC_CLK_DCDC_DIV__MASK                      0x20      

/* AFE_PLL_CTRL */
#define RSTID135_AFE_AFE_PLL_CTRL                                    0x00000001
#define RSTID135_AFE_AFE_PLL_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_PLL_CTRL_PLL_ENA__MASK                      0x01      
#define FSTID135_AFE_AFE_PLL_CTRL_PLL_REFDIV_N__MASK                 0x02      
#define FSTID135_AFE_AFE_PLL_CTRL_PLL_ICP__MASK                      0x1C      
#define FSTID135_AFE_AFE_PLL_CTRL_PLL_START_FAST__MASK               0x20      
#define FSTID135_AFE_AFE_PLL_CTRL_PLL_RST_N__MASK                    0x80      

/* AFE_PLL_INT */
#define RSTID135_AFE_AFE_PLL_INT                                     0x00000002
#define RSTID135_AFE_AFE_PLL_INT__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_PLL_INT_PLL_INT__MASK                       0xFF      

/* AFE_PLL_FRAC1 */
#define RSTID135_AFE_AFE_PLL_FRAC1                                   0x00000003
#define RSTID135_AFE_AFE_PLL_FRAC1__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_PLL_FRAC1_PLL_FRAC_1__MASK                  0x7F      
#define FSTID135_AFE_AFE_PLL_FRAC1_PLL_SDON__MASK                    0x80      

/* AFE_PLL_FRAC2 */
#define RSTID135_AFE_AFE_PLL_FRAC2                                   0x00000004
#define RSTID135_AFE_AFE_PLL_FRAC2__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_PLL_FRAC2_PLL_FRAC_0__MASK                  0xFF      

/* AFE_PLL_TST1 */
#define RSTID135_AFE_AFE_PLL_TST1                                    0x00000005
#define RSTID135_AFE_AFE_PLL_TST1__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_PLL_TST1_PLL_CPDNS__MASK                    0x01      
#define FSTID135_AFE_AFE_PLL_TST1_PLL_CPA__MASK                      0x02      
#define FSTID135_AFE_AFE_PLL_TST1_PLL_TCP__MASK                      0x0C      
#define FSTID135_AFE_AFE_PLL_TST1_PLL_TSTBUF_BYPASS__MASK            0x10      

/* AFE_PLL_TST2 */
#define RSTID135_AFE_AFE_PLL_TST2                                    0x00000006
#define RSTID135_AFE_AFE_PLL_TST2__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_PLL_TST2_PLL_TSELA__MASK                    0x0F      
#define FSTID135_AFE_AFE_PLL_TST2_PLL_TSELD__MASK                    0xF0      

/* AFE_VCO_CAL1 */
#define RSTID135_AFE_AFE_VCO_CAL1                                    0x00000007
#define RSTID135_AFE_AFE_VCO_CAL1__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_VCO_CAL1_VCO_CAL_START__MASK                0x01      
#define FSTID135_AFE_AFE_VCO_CAL1_VCO_CAL_OFF__MASK                  0x02      
#define FSTID135_AFE_AFE_VCO_CAL1_VCO_DIVCAL__MASK                   0x1C      

/* AFE_VCO_CAL2 */
#define RSTID135_AFE_AFE_VCO_CAL2                                    0x00000008
#define RSTID135_AFE_AFE_VCO_CAL2__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_VCO_CAL2_VCO_CAL__MASK                      0x7F      

/* AFE_VCO_CTRL */
#define RSTID135_AFE_AFE_VCO_CTRL                                    0x00000009
#define RSTID135_AFE_AFE_VCO_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_VCO_CTRL_VCO_AMP__MASK                      0x07      
#define FSTID135_AFE_AFE_VCO_CTRL_VCO_BUF_AMP__MASK                  0x38      

/* AFE_DFECLK_CTRL1 */
#define RSTID135_AFE_AFE_DFECLK_CTRL1                                0x0000000a
#define RSTID135_AFE_AFE_DFECLK_CTRL1__DEFAULT                       0x0       
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE1_CLK_ENA__MASK             0x01      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE2_CLK_ENA__MASK             0x02      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE3_CLK_ENA__MASK             0x04      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE1_CLK_SEL__MASK             0x08      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE2_CLK_SEL__MASK             0x10      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE3_CLK_SEL__MASK             0x20      
#define FSTID135_AFE_AFE_DFECLK_CTRL1_DFE_CLK_RST_N__MASK            0x40      

/* AFE_DFECLK_CTRL2 */
#define RSTID135_AFE_AFE_DFECLK_CTRL2                                0x0000000b
#define RSTID135_AFE_AFE_DFECLK_CTRL2__DEFAULT                       0x0       
#define FSTID135_AFE_AFE_DFECLK_CTRL2_DFE1_CLK_SS_ENA__MASK          0x01      
#define FSTID135_AFE_AFE_DFECLK_CTRL2_DFE2_CLK_SS_ENA__MASK          0x02      
#define FSTID135_AFE_AFE_DFECLK_CTRL2_DFE3_CLK_SS_ENA__MASK          0x04      
#define FSTID135_AFE_AFE_DFECLK_CTRL2_DFE_CLK_SS_DIV__MASK           0x18      

/* AFE_RX1_CTRL */
#define RSTID135_AFE_AFE_RX1_CTRL                                    0x00000010
#define RSTID135_AFE_AFE_RX1_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_RX1_CTRL_ADC1_VREG_SEL__MASK                0x06      
#define FSTID135_AFE_AFE_RX1_CTRL_VGLNA1_ENA__MASK                   0x08      
#define FSTID135_AFE_AFE_RX1_CTRL_MIXER1_ENA__MASK                   0x10      
#define FSTID135_AFE_AFE_RX1_CTRL_BB1_ENA__MASK                      0x20      
#define FSTID135_AFE_AFE_RX1_CTRL_ADC1_ENA__MASK                     0x40      
#define FSTID135_AFE_AFE_RX1_CTRL_LO1_ENA__MASK                      0x80      

/* AFE_RX2_CTRL */
#define RSTID135_AFE_AFE_RX2_CTRL                                    0x00000011
#define RSTID135_AFE_AFE_RX2_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_RX2_CTRL_ADC2_VREG_SEL__MASK                0x06      
#define FSTID135_AFE_AFE_RX2_CTRL_VGLNA2_ENA__MASK                   0x08      
#define FSTID135_AFE_AFE_RX2_CTRL_MIXER2_ENA__MASK                   0x10      
#define FSTID135_AFE_AFE_RX2_CTRL_BB2_ENA__MASK                      0x20      
#define FSTID135_AFE_AFE_RX2_CTRL_ADC2_ENA__MASK                     0x40      
#define FSTID135_AFE_AFE_RX2_CTRL_LO2_ENA__MASK                      0x80      

/* AFE_RX3_CTRL */
#define RSTID135_AFE_AFE_RX3_CTRL                                    0x00000012
#define RSTID135_AFE_AFE_RX3_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_RX3_CTRL_ADC3_VREG_SEL__MASK                0x06      
#define FSTID135_AFE_AFE_RX3_CTRL_VGLNA3_ENA__MASK                   0x08      
#define FSTID135_AFE_AFE_RX3_CTRL_MIXER3_ENA__MASK                   0x10      
#define FSTID135_AFE_AFE_RX3_CTRL_BB3_ENA__MASK                      0x20      
#define FSTID135_AFE_AFE_RX3_CTRL_ADC3_ENA__MASK                     0x40      
#define FSTID135_AFE_AFE_RX3_CTRL_LO3_ENA__MASK                      0x80      

/* AFE_RX4_CTRL */
#define RSTID135_AFE_AFE_RX4_CTRL                                    0x00000013
#define RSTID135_AFE_AFE_RX4_CTRL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_RX4_CTRL_ADC4_VREG_SEL__MASK                0x06      
#define FSTID135_AFE_AFE_RX4_CTRL_VGLNA4_ENA__MASK                   0x08      
#define FSTID135_AFE_AFE_RX4_CTRL_MIXER4_ENA__MASK                   0x10      
#define FSTID135_AFE_AFE_RX4_CTRL_BB4_ENA__MASK                      0x20      
#define FSTID135_AFE_AFE_RX4_CTRL_ADC4_ENA__MASK                     0x40      
#define FSTID135_AFE_AFE_RX4_CTRL_LO4_ENA__MASK                      0x80      

/* AFE_BB_CAL */
#define RSTID135_AFE_AFE_BB_CAL                                      0x00000014
#define RSTID135_AFE_AFE_BB_CAL__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_BB_CAL_BB1_CAL_START__MASK                  0x01      
#define FSTID135_AFE_AFE_BB_CAL_BB2_CAL_START__MASK                  0x02      
#define FSTID135_AFE_AFE_BB_CAL_BB3_CAL_START__MASK                  0x04      
#define FSTID135_AFE_AFE_BB_CAL_BB4_CAL_START__MASK                  0x08      
#define FSTID135_AFE_AFE_BB_CAL_BB1_CAL_SAF_DIS__MASK                0x10      
#define FSTID135_AFE_AFE_BB_CAL_BB2_CAL_SAF_DIS__MASK                0x20      
#define FSTID135_AFE_AFE_BB_CAL_BB3_CAL_SAF_DIS__MASK                0x40      
#define FSTID135_AFE_AFE_BB_CAL_BB4_CAL_SAF_DIS__MASK                0x80      

/* AFE_BB1I_CAL */
#define RSTID135_AFE_AFE_BB1I_CAL                                    0x00000015
#define RSTID135_AFE_AFE_BB1I_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB1I_CAL_BB1I_CAL__MASK                     0xFF      

/* AFE_BB1Q_CAL */
#define RSTID135_AFE_AFE_BB1Q_CAL                                    0x00000016
#define RSTID135_AFE_AFE_BB1Q_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB1Q_CAL_BB1Q_CAL__MASK                     0xC0      

/* AFE_BB2I_CAL */
#define RSTID135_AFE_AFE_BB2I_CAL                                    0x00000017
#define RSTID135_AFE_AFE_BB2I_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB2I_CAL_BB2I_CAL__MASK                     0xFF      

/* AFE_BB2Q_CAL */
#define RSTID135_AFE_AFE_BB2Q_CAL                                    0x00000018
#define RSTID135_AFE_AFE_BB2Q_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB2Q_CAL_BB2Q_CAL__MASK                     0xC0      

/* AFE_BB3I_CAL */
#define RSTID135_AFE_AFE_BB3I_CAL                                    0x00000019
#define RSTID135_AFE_AFE_BB3I_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB3I_CAL_BB3I_CAL__MASK                     0xFF      

/* AFE_BB3Q_CAL */
#define RSTID135_AFE_AFE_BB3Q_CAL                                    0x0000001a
#define RSTID135_AFE_AFE_BB3Q_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB3Q_CAL_BB3Q_CAL__MASK                     0xC0      

/* AFE_BB4I_CAL */
#define RSTID135_AFE_AFE_BB4I_CAL                                    0x0000001b
#define RSTID135_AFE_AFE_BB4I_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB4I_CAL_BB4I_CAL__MASK                     0xFF      

/* AFE_BB4Q_CAL */
#define RSTID135_AFE_AFE_BB4Q_CAL                                    0x0000001c
#define RSTID135_AFE_AFE_BB4Q_CAL__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_BB4Q_CAL_BB4Q_CAL__MASK                     0xC0      

/* AFE_RF_CFG1 */
#define RSTID135_AFE_AFE_RF_CFG1                                     0x0000001d
#define RSTID135_AFE_AFE_RF_CFG1__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA1_SELGAIN__MASK                0x01      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA2_SELGAIN__MASK                0x02      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA3_SELGAIN__MASK                0x04      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA4_SELGAIN__MASK                0x08      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA1_DIFF__MASK                   0x10      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA2_DIFF__MASK                   0x20      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA3_DIFF__MASK                   0x40      
#define FSTID135_AFE_AFE_RF_CFG1_VGLNA4_DIFF__MASK                   0x80      

/* AFE_RF_CFG2 */
#define RSTID135_AFE_AFE_RF_CFG2                                     0x0000001e
#define RSTID135_AFE_AFE_RF_CFG2__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_RF_CFG2_RF1_CTRL__MASK                      0x03      
#define FSTID135_AFE_AFE_RF_CFG2_RF2_CTRL__MASK                      0x0C      
#define FSTID135_AFE_AFE_RF_CFG2_RF3_CTRL__MASK                      0x30      
#define FSTID135_AFE_AFE_RF_CFG2_RF4_CTRL__MASK                      0xC0      

/* AFE_ADC_ADDR1 */
#define RSTID135_AFE_AFE_ADC_ADDR1                                   0x00000020
#define RSTID135_AFE_AFE_ADC_ADDR1__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_ADC_ADDR1_ADC_READ_SEL__MASK                0x01      
#define FSTID135_AFE_AFE_ADC_ADDR1_ADC_ADDR__MASK                    0x1E      
#define FSTID135_AFE_AFE_ADC_ADDR1_ADC_IQ__MASK                      0x20      
#define FSTID135_AFE_AFE_ADC_ADDR1_ADC_PATH_SEL__MASK                0xC0      

/* AFE_ADC_ADDR2 */
#define RSTID135_AFE_AFE_ADC_ADDR2                                   0x00000021
#define RSTID135_AFE_AFE_ADC_ADDR2__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_ADC_ADDR2_ADC_DSEL__MASK                    0x03      
#define FSTID135_AFE_AFE_ADC_ADDR2_ADC_RW__MASK                      0x04      
#define FSTID135_AFE_AFE_ADC_ADDR2_ADC_REQ__MASK                     0x08      

/* AFE_ADC_CORR1 */
#define RSTID135_AFE_AFE_ADC_CORR1                                   0x00000022
#define RSTID135_AFE_AFE_ADC_CORR1__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_ADC_CORR1_ADC_DATA_1__MASK                  0x0F      

/* AFE_ADC_CORR2 */
#define RSTID135_AFE_AFE_ADC_CORR2                                   0x00000023
#define RSTID135_AFE_AFE_ADC_CORR2__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_ADC_CORR2_ADC_DATA_0__MASK                  0xFF      

/* AFE_ADC1_CTRL1 */
#define RSTID135_AFE_AFE_ADC1_CTRL1                                  0x00000024
#define RSTID135_AFE_AFE_ADC1_CTRL1__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_CALC_RST__MASK              0x01      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_CORR_PWD__MASK              0x02      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_OFFSET_CORR_ENA__MASK       0x04      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_OFFSET_CALC_ENA__MASK       0x08      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_SKEW_CORR_ENA__MASK         0x10      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_SKEW_CALC_ENA__MASK         0x20      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_GAIN_CORR_ENA__MASK         0x40      
#define FSTID135_AFE_AFE_ADC1_CTRL1_ADC1_GAIN_CALC_ENA__MASK         0x80      

/* AFE_ADC1_CTRL2 */
#define RSTID135_AFE_AFE_ADC1_CTRL2                                  0x00000025
#define RSTID135_AFE_AFE_ADC1_CTRL2__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC1_CTRL2_ADC1_OFFSET_EXT_ENA__MASK        0x01      
#define FSTID135_AFE_AFE_ADC1_CTRL2_ADC1_SKEW_EXT_ENA__MASK          0x02      
#define FSTID135_AFE_AFE_ADC1_CTRL2_ADC1_GAIN_EXT_ENA__MASK          0x04      
#define FSTID135_AFE_AFE_ADC1_CTRL2_ADC1_RST_N__MASK                 0x08      

/* AFE_ADC2_CTRL1 */
#define RSTID135_AFE_AFE_ADC2_CTRL1                                  0x00000026
#define RSTID135_AFE_AFE_ADC2_CTRL1__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_CALC_RST__MASK              0x01      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_CORR_PWD__MASK              0x02      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_OFFSET_CORR_ENA__MASK       0x04      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_OFFSET_CALC_ENA__MASK       0x08      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_SKEW_CORR_ENA__MASK         0x10      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_SKEW_CALC_ENA__MASK         0x20      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_GAIN_CORR_ENA__MASK         0x40      
#define FSTID135_AFE_AFE_ADC2_CTRL1_ADC2_GAIN_CALC_ENA__MASK         0x80      

/* AFE_ADC2_CTRL2 */
#define RSTID135_AFE_AFE_ADC2_CTRL2                                  0x00000027
#define RSTID135_AFE_AFE_ADC2_CTRL2__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC2_CTRL2_ADC2_OFFSET_EXT_ENA__MASK        0x01      
#define FSTID135_AFE_AFE_ADC2_CTRL2_ADC2_SKEW_EXT_ENA__MASK          0x02      
#define FSTID135_AFE_AFE_ADC2_CTRL2_ADC2_GAIN_EXT_ENA__MASK          0x04      
#define FSTID135_AFE_AFE_ADC2_CTRL2_ADC2_RST_N__MASK                 0x08      

/* AFE_ADC3_CTRL1 */
#define RSTID135_AFE_AFE_ADC3_CTRL1                                  0x00000028
#define RSTID135_AFE_AFE_ADC3_CTRL1__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_CALC_RST__MASK              0x01      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_CORR_PWD__MASK              0x02      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_OFFSET_CORR_ENA__MASK       0x04      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_OFFSET_CALC_ENA__MASK       0x08      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_SKEW_CORR_ENA__MASK         0x10      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_SKEW_CALC_ENA__MASK         0x20      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_GAIN_CORR_ENA__MASK         0x40      
#define FSTID135_AFE_AFE_ADC3_CTRL1_ADC3_GAIN_CALC_ENA__MASK         0x80      

/* AFE_ADC3_CTRL2 */
#define RSTID135_AFE_AFE_ADC3_CTRL2                                  0x00000029
#define RSTID135_AFE_AFE_ADC3_CTRL2__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC3_CTRL2_ADC3_OFFSET_EXT_ENA__MASK        0x01      
#define FSTID135_AFE_AFE_ADC3_CTRL2_ADC3_SKEW_EXT_ENA__MASK          0x02      
#define FSTID135_AFE_AFE_ADC3_CTRL2_ADC3_GAIN_EXT_ENA__MASK          0x04      
#define FSTID135_AFE_AFE_ADC3_CTRL2_ADC3_RST_N__MASK                 0x08      

/* AFE_ADC4_CTRL1 */
#define RSTID135_AFE_AFE_ADC4_CTRL1                                  0x0000002a
#define RSTID135_AFE_AFE_ADC4_CTRL1__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_CALC_RST__MASK              0x01      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_CORR_PWD__MASK              0x02      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_OFFSET_CORR_ENA__MASK       0x04      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_OFFSET_CALC_ENA__MASK       0x08      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_SKEW_CORR_ENA__MASK         0x10      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_SKEW_CALC_ENA__MASK         0x20      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_GAIN_CORR_ENA__MASK         0x40      
#define FSTID135_AFE_AFE_ADC4_CTRL1_ADC4_GAIN_CALC_ENA__MASK         0x80      

/* AFE_ADC4_CTRL2 */
#define RSTID135_AFE_AFE_ADC4_CTRL2                                  0x0000002b
#define RSTID135_AFE_AFE_ADC4_CTRL2__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_ADC4_CTRL2_ADC4_OFFSET_EXT_ENA__MASK        0x01      
#define FSTID135_AFE_AFE_ADC4_CTRL2_ADC4_SKEW_EXT_ENA__MASK          0x02      
#define FSTID135_AFE_AFE_ADC4_CTRL2_ADC4_GAIN_EXT_ENA__MASK          0x04      
#define FSTID135_AFE_AFE_ADC4_CTRL2_ADC4_RST_N__MASK                 0x08      

/* AFE_ADC_CFG */
#define RSTID135_AFE_AFE_ADC_CFG                                     0x0000002c
#define RSTID135_AFE_AFE_ADC_CFG__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_ADC_CFG_ADC1_BUF_PRECH__MASK                0x01      
#define FSTID135_AFE_AFE_ADC_CFG_ADC2_BUF_PRECH__MASK                0x02      
#define FSTID135_AFE_AFE_ADC_CFG_ADC3_BUF_PRECH__MASK                0x04      
#define FSTID135_AFE_AFE_ADC_CFG_ADC4_BUF_PRECH__MASK                0x08      
#define FSTID135_AFE_AFE_ADC_CFG_ADC1_STUP_DL__MASK                  0x10      
#define FSTID135_AFE_AFE_ADC_CFG_ADC2_STUP_DL__MASK                  0x20      
#define FSTID135_AFE_AFE_ADC_CFG_ADC3_STUP_DL__MASK                  0x40      
#define FSTID135_AFE_AFE_ADC_CFG_ADC4_STUP_DL__MASK                  0x80      

/* AFE_ADC_TST */
#define RSTID135_AFE_AFE_ADC_TST                                     0x0000002d
#define RSTID135_AFE_AFE_ADC_TST__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_ADC_TST_ADC1_TST__MASK                      0x03      
#define FSTID135_AFE_AFE_ADC_TST_ADC2_TST__MASK                      0x0C      
#define FSTID135_AFE_AFE_ADC_TST_ADC3_TST__MASK                      0x30      
#define FSTID135_AFE_AFE_ADC_TST_ADC4_TST__MASK                      0xC0      

/* AFE_AGC1_CTRL */
#define RSTID135_AFE_AFE_AGC1_CTRL                                   0x00000030
#define RSTID135_AFE_AFE_AGC1_CTRL__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_AGC1_CTRL_AGC1_MODE__MASK                   0x03      
#define FSTID135_AFE_AFE_AGC1_CTRL_AGC1_RF_CTRL__MASK                0x0C      
#define FSTID135_AFE_AFE_AGC1_CTRL_AGC1_BB_CTRL__MASK                0x30      
#define FSTID135_AFE_AFE_AGC1_CTRL_AGC1_PWM_FDIV__MASK               0xC0      

/* AFE_AGC2_CTRL */
#define RSTID135_AFE_AFE_AGC2_CTRL                                   0x00000031
#define RSTID135_AFE_AFE_AGC2_CTRL__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_AGC2_CTRL_AGC2_MODE__MASK                   0x03      
#define FSTID135_AFE_AFE_AGC2_CTRL_AGC2_RF_CTRL__MASK                0x0C      
#define FSTID135_AFE_AFE_AGC2_CTRL_AGC2_BB_CTRL__MASK                0x30      
#define FSTID135_AFE_AFE_AGC2_CTRL_AGC2_PWM_FDIV__MASK               0xC0      

/* AFE_AGC3_CTRL */
#define RSTID135_AFE_AFE_AGC3_CTRL                                   0x00000032
#define RSTID135_AFE_AFE_AGC3_CTRL__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_AGC3_CTRL_AGC3_MODE__MASK                   0x03      
#define FSTID135_AFE_AFE_AGC3_CTRL_AGC3_RF_CTRL__MASK                0x0C      
#define FSTID135_AFE_AFE_AGC3_CTRL_AGC3_BB_CTRL__MASK                0x30      
#define FSTID135_AFE_AFE_AGC3_CTRL_AGC3_PWM_FDIV__MASK               0xC0      

/* AFE_AGC4_CTRL */
#define RSTID135_AFE_AFE_AGC4_CTRL                                   0x00000033
#define RSTID135_AFE_AFE_AGC4_CTRL__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_AGC4_CTRL_AGC4_MODE__MASK                   0x03      
#define FSTID135_AFE_AFE_AGC4_CTRL_AGC4_RF_CTRL__MASK                0x0C      
#define FSTID135_AFE_AFE_AGC4_CTRL_AGC4_BB_CTRL__MASK                0x30      
#define FSTID135_AFE_AFE_AGC4_CTRL_AGC4_PWM_FDIV__MASK               0xC0      

/* AFE_AGC1_RF_PWM */
#define RSTID135_AFE_AFE_AGC1_RF_PWM                                 0x00000034
#define RSTID135_AFE_AFE_AGC1_RF_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC1_RF_PWM_AGC1_RF_PWM__MASK               0xFF      

/* AFE_AGC2_RF_PWM */
#define RSTID135_AFE_AFE_AGC2_RF_PWM                                 0x00000035
#define RSTID135_AFE_AFE_AGC2_RF_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC2_RF_PWM_AGC2_RF_PWM__MASK               0xFF      

/* AFE_AGC3_RF_PWM */
#define RSTID135_AFE_AFE_AGC3_RF_PWM                                 0x00000036
#define RSTID135_AFE_AFE_AGC3_RF_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC3_RF_PWM_AGC3_RF_PWM__MASK               0xFF      

/* AFE_AGC4_RF_PWM */
#define RSTID135_AFE_AFE_AGC4_RF_PWM                                 0x00000037
#define RSTID135_AFE_AFE_AGC4_RF_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC4_RF_PWM_AGC4_RF_PWM__MASK               0xFF      

/* AFE_AGC1_BB_PWM */
#define RSTID135_AFE_AFE_AGC1_BB_PWM                                 0x00000038
#define RSTID135_AFE_AFE_AGC1_BB_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC1_BB_PWM_AGC1_BB_PWM__MASK               0xFF      

/* AFE_AGC2_BB_PWM */
#define RSTID135_AFE_AFE_AGC2_BB_PWM                                 0x00000039
#define RSTID135_AFE_AFE_AGC2_BB_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC2_BB_PWM_AGC2_BB_PWM__MASK               0xFF      

/* AFE_AGC3_BB_PWM */
#define RSTID135_AFE_AFE_AGC3_BB_PWM                                 0x0000003a
#define RSTID135_AFE_AFE_AGC3_BB_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC3_BB_PWM_AGC3_BB_PWM__MASK               0xFF      

/* AFE_AGC4_BB_PWM */
#define RSTID135_AFE_AFE_AGC4_BB_PWM                                 0x0000003b
#define RSTID135_AFE_AFE_AGC4_BB_PWM__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_AGC4_BB_PWM_AGC4_BB_PWM__MASK               0xFF      

/* AFE_FSK */
#define RSTID135_AFE_AFE_FSK                                         0x00000040
#define RSTID135_AFE_AFE_FSK__DEFAULT                                0x0       
#define FSTID135_AFE_AFE_FSK_FSK_PWD__MASK                           0x01      
#define FSTID135_AFE_AFE_FSK_FSK_OPENLOOP__MASK                      0x02      

/* AFE_DISEQC */
#define RSTID135_AFE_AFE_DISEQC                                      0x00000041
#define RSTID135_AFE_AFE_DISEQC__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_DISEQC_DISEQC_ENA__MASK                     0x01      
#define FSTID135_AFE_AFE_DISEQC_DISEQC_CLK_DIV__MASK                 0x3E      
#define FSTID135_AFE_AFE_DISEQC_DISEQC_ENCH__MASK                    0x40      

/* AFE_LNBCTRL */
#define RSTID135_AFE_AFE_LNBCTRL                                     0x00000042
#define RSTID135_AFE_AFE_LNBCTRL__DEFAULT                            0x0       
#define FSTID135_AFE_AFE_LNBCTRL_LNBCTRL_ENA__MASK                   0x01      
#define FSTID135_AFE_AFE_LNBCTRL_LNBCTRL_ISENSE_TH__MASK             0x06      
#define FSTID135_AFE_AFE_LNBCTRL_LNBCTRL_TST__MASK                   0x80      

/* AFE_BIAS_CTRL */
#define RSTID135_AFE_AFE_BIAS_CTRL                                   0x00000050
#define RSTID135_AFE_AFE_BIAS_CTRL__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_BIAS_CTRL_BIAS_RCAL_START__MASK             0x01      
#define FSTID135_AFE_AFE_BIAS_CTRL_BIAS_RCAL_OFF__MASK               0x02      
#define FSTID135_AFE_AFE_BIAS_CTRL_BIAS_RCAL__MASK                   0x3C      
#define FSTID135_AFE_AFE_BIAS_CTRL_BIAS_RCAL_CLK_DIV__MASK           0x40      
#define FSTID135_AFE_AFE_BIAS_CTRL_BIAS_TST__MASK                    0x80      

/* AFE_LDO2V5_CTRL */
#define RSTID135_AFE_AFE_LDO2V5_CTRL                                 0x00000051
#define RSTID135_AFE_AFE_LDO2V5_CTRL__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_PWD__MASK                   0x01      
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_VSEL__MASK                  0x0E      
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_VREG_OK_SEL__MASK           0x10      
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_POR_SEL__MASK               0x20      
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_POR_BYPASS__MASK            0x40      
#define FSTID135_AFE_AFE_LDO2V5_CTRL_LDO_TST__MASK                   0x80      

/* AFE_DCDC1V8_CTRL */
#define RSTID135_AFE_AFE_DCDC1V8_CTRL                                0x00000052
#define RSTID135_AFE_AFE_DCDC1V8_CTRL__DEFAULT                       0x0       
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_PWD__MASK                 0x01      
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_ISEL__MASK                0x02      
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_VREF_SEL__MASK            0x1C      
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_CLK_SEL__MASK             0x20      
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_POR_BYPASS__MASK          0x40      
#define FSTID135_AFE_AFE_DCDC1V8_CTRL_DCDC_SAF_DIS__MASK             0x80      

/* AFE_DCDC1V8_CAL1 */
#define RSTID135_AFE_AFE_DCDC1V8_CAL1                                0x00000053
#define RSTID135_AFE_AFE_DCDC1V8_CAL1__DEFAULT                       0x0       
#define FSTID135_AFE_AFE_DCDC1V8_CAL1_DCDC_CAL_START__MASK           0x01      
#define FSTID135_AFE_AFE_DCDC1V8_CAL1_DCDC_CAL_OFF__MASK             0x02      

/* AFE_DCDC1V8_CAL2 */
#define RSTID135_AFE_AFE_DCDC1V8_CAL2                                0x00000054
#define RSTID135_AFE_AFE_DCDC1V8_CAL2__DEFAULT                       0x0       
#define FSTID135_AFE_AFE_DCDC1V8_CAL2_DCDC_CAPA__MASK                0x1F      

/* AFE_DCDC1V8_TST */
#define RSTID135_AFE_AFE_DCDC1V8_TST                                 0x00000055
#define RSTID135_AFE_AFE_DCDC1V8_TST__DEFAULT                        0x0       
#define FSTID135_AFE_AFE_DCDC1V8_TST_DCDC_TST__MASK                  0x01      
#define FSTID135_AFE_AFE_DCDC1V8_TST_DCDC_TSTA__MASK                 0x0E      

/* AFE_TST_CTRL1 */
#define RSTID135_AFE_AFE_TST_CTRL1                                   0x00000070
#define RSTID135_AFE_AFE_TST_CTRL1__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL1_BUF12_I_ENA__MASK                 0x01      
#define FSTID135_AFE_AFE_TST_CTRL1_BUF12_I_DIR__MASK                 0x02      
#define FSTID135_AFE_AFE_TST_CTRL1_KELVIN12_IN__MASK                 0x1C      
#define FSTID135_AFE_AFE_TST_CTRL1_KELVIN12_IP__MASK                 0xE0      

/* AFE_TST_CTRL2 */
#define RSTID135_AFE_AFE_TST_CTRL2                                   0x00000071
#define RSTID135_AFE_AFE_TST_CTRL2__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL2_BUF12_Q_ENA__MASK                 0x01      
#define FSTID135_AFE_AFE_TST_CTRL2_BUF12_Q_DIR__MASK                 0x02      
#define FSTID135_AFE_AFE_TST_CTRL2_KELVIN12_QN__MASK                 0x1C      
#define FSTID135_AFE_AFE_TST_CTRL2_KELVIN12_QP__MASK                 0xE0      

/* AFE_TST_CTRL3 */
#define RSTID135_AFE_AFE_TST_CTRL3                                   0x00000072
#define RSTID135_AFE_AFE_TST_CTRL3__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL3_BUF34_I_ENA__MASK                 0x01      
#define FSTID135_AFE_AFE_TST_CTRL3_BUF34_I_DIR__MASK                 0x02      
#define FSTID135_AFE_AFE_TST_CTRL3_KELVIN34_IN__MASK                 0x1C      
#define FSTID135_AFE_AFE_TST_CTRL3_KELVIN34_IP__MASK                 0xE0      

/* AFE_TST_CTRL4 */
#define RSTID135_AFE_AFE_TST_CTRL4                                   0x00000073
#define RSTID135_AFE_AFE_TST_CTRL4__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL4_BUF34_Q_ENA__MASK                 0x01      
#define FSTID135_AFE_AFE_TST_CTRL4_BUF34_Q_DIR__MASK                 0x02      
#define FSTID135_AFE_AFE_TST_CTRL4_KELVIN34_QN__MASK                 0x1C      
#define FSTID135_AFE_AFE_TST_CTRL4_KELVIN34_QP__MASK                 0xE0      

/* AFE_TST_CTRL5 */
#define RSTID135_AFE_AFE_TST_CTRL5                                   0x00000074
#define RSTID135_AFE_AFE_TST_CTRL5__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL5_BUF12_I_ZIN50__MASK               0x01      
#define FSTID135_AFE_AFE_TST_CTRL5_BUF12_Q_ZIN50__MASK               0x02      
#define FSTID135_AFE_AFE_TST_CTRL5_BUF34_I_ZIN50__MASK               0x04      
#define FSTID135_AFE_AFE_TST_CTRL5_BUF34_Q_ZIN50__MASK               0x08      

/* AFE_TST_CTRL6 */
#define RSTID135_AFE_AFE_TST_CTRL6                                   0x00000075
#define RSTID135_AFE_AFE_TST_CTRL6__DEFAULT                          0x0       
#define FSTID135_AFE_AFE_TST_CTRL6_BB1_I_TST__MASK                   0x01      
#define FSTID135_AFE_AFE_TST_CTRL6_BB1_Q_TST__MASK                   0x02      
#define FSTID135_AFE_AFE_TST_CTRL6_BB2_I_TST__MASK                   0x04      
#define FSTID135_AFE_AFE_TST_CTRL6_BB2_Q_TST__MASK                   0x08      
#define FSTID135_AFE_AFE_TST_CTRL6_BB3_I_TST__MASK                   0x10      
#define FSTID135_AFE_AFE_TST_CTRL6_BB3_Q_TST__MASK                   0x20      
#define FSTID135_AFE_AFE_TST_CTRL6_BB4_I_TST__MASK                   0x40      
#define FSTID135_AFE_AFE_TST_CTRL6_BB4_Q_TST__MASK                   0x80      

/* AFE_TST_RF12 */
#define RSTID135_AFE_AFE_TST_RF12                                    0x00000076
#define RSTID135_AFE_AFE_TST_RF12__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_TST_RF12_RF1_TST__MASK                      0x0F      
#define FSTID135_AFE_AFE_TST_RF12_RF2_TST__MASK                      0xF0      

/* AFE_TST_RF34 */
#define RSTID135_AFE_AFE_TST_RF34                                    0x00000077
#define RSTID135_AFE_AFE_TST_RF34__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_TST_RF34_RF3_TST__MASK                      0x0F      
#define FSTID135_AFE_AFE_TST_RF34_RF4_TST__MASK                      0xF0      

/* AFE_TST_BB12 */
#define RSTID135_AFE_AFE_TST_BB12                                    0x00000078
#define RSTID135_AFE_AFE_TST_BB12__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_TST_BB12_BB1_TST_AVDD_SENSE__MASK           0x01      
#define FSTID135_AFE_AFE_TST_BB12_BB1_TST_BYPASS__MASK               0x02      
#define FSTID135_AFE_AFE_TST_BB12_BB1_TST_GMCOMP_DIS__MASK           0x04      
#define FSTID135_AFE_AFE_TST_BB12_BB2_TST_AVDD_SENSE__MASK           0x10      
#define FSTID135_AFE_AFE_TST_BB12_BB2_TST_BYPASS__MASK               0x20      
#define FSTID135_AFE_AFE_TST_BB12_BB2_TST_GMCOMP_DIS__MASK           0x40      

/* AFE_TST_BB34 */
#define RSTID135_AFE_AFE_TST_BB34                                    0x00000079
#define RSTID135_AFE_AFE_TST_BB34__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_TST_BB34_BB3_TST_AVDD_SENSE__MASK           0x01      
#define FSTID135_AFE_AFE_TST_BB34_BB3_TST_BYPASS__MASK               0x02      
#define FSTID135_AFE_AFE_TST_BB34_BB3_TST_GMCOMP_DIS__MASK           0x04      
#define FSTID135_AFE_AFE_TST_BB34_BB4_TST_AVDD_SENSE__MASK           0x10      
#define FSTID135_AFE_AFE_TST_BB34_BB4_TST_BYPASS__MASK               0x20      
#define FSTID135_AFE_AFE_TST_BB34_BB4_TST_GMCOMP_DIS__MASK           0x40      

/* AFE_TST_SPARE1 */
#define RSTID135_AFE_AFE_TST_SPARE1                                  0x0000007a
#define RSTID135_AFE_AFE_TST_SPARE1__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_TST_SPARE1_TST_SPARE1_BITS__MASK            0xFF      

/* AFE_TST_SPARE2 */
#define RSTID135_AFE_AFE_TST_SPARE2                                  0x0000007b
#define RSTID135_AFE_AFE_TST_SPARE2__DEFAULT                         0x0       
#define FSTID135_AFE_AFE_TST_SPARE2_TST_SPARE2_BITS__MASK            0xFF      

/* AFE_TST_MODE */
#define RSTID135_AFE_AFE_TST_MODE                                    0x0000007f
#define RSTID135_AFE_AFE_TST_MODE__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_TST_MODE_TST_MODE__MASK                     0xFF      

/* AFE_ID */
#define RSTID135_AFE_AFE_ID                                          0x00000080
#define RSTID135_AFE_AFE_ID__DEFAULT                                 0x0       
#define FSTID135_AFE_AFE_ID_FIX_ID__MASK                             0x03      
#define FSTID135_AFE_AFE_ID_CUT_ID__MASK                             0x0C      

/* AFE_STATUS */
#define RSTID135_AFE_AFE_STATUS                                      0x00000081
#define RSTID135_AFE_AFE_STATUS__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_STATUS_LDO_VREG_OK__MASK                    0x01      
#define FSTID135_AFE_AFE_STATUS_LDO_POR_3V3__MASK                    0x02      
#define FSTID135_AFE_AFE_STATUS_DCDC_VREG_OK__MASK                   0x04      
#define FSTID135_AFE_AFE_STATUS_LNBCTRL_ISENSE__MASK                 0x10      
#define FSTID135_AFE_AFE_STATUS_PLL_LOCK__MASK                       0x20      

/* AFE_FUSE1 */
#define RSTID135_AFE_AFE_FUSE1                                       0x00000082
#define RSTID135_AFE_AFE_FUSE1__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE1_SAF_RX_DIS__MASK                      0x0F      
#define FSTID135_AFE_AFE_FUSE1_SAF_TSTMODE_REG_DIS__MASK             0x10      
#define FSTID135_AFE_AFE_FUSE1_SAF_DCDC1V8_VREF_SEL__MASK            0xE0      

/* AFE_FUSE2 */
#define RSTID135_AFE_AFE_FUSE2                                       0x00000083
#define RSTID135_AFE_AFE_FUSE2__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE2_SAF_BB1I_CAL__MASK                    0xFF      

/* AFE_FUSE3 */
#define RSTID135_AFE_AFE_FUSE3                                       0x00000084
#define RSTID135_AFE_AFE_FUSE3__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE3_SAF_BB2I_CAL__MASK                    0xFF      

/* AFE_FUSE4 */
#define RSTID135_AFE_AFE_FUSE4                                       0x00000085
#define RSTID135_AFE_AFE_FUSE4__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE4_SAF_BB3I_CAL__MASK                    0xFF      

/* AFE_FUSE5 */
#define RSTID135_AFE_AFE_FUSE5                                       0x00000086
#define RSTID135_AFE_AFE_FUSE5__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE5_SAF_BB4I_CAL__MASK                    0xFF      

/* AFE_FUSE6 */
#define RSTID135_AFE_AFE_FUSE6                                       0x00000087
#define RSTID135_AFE_AFE_FUSE6__DEFAULT                              0x0       
#define FSTID135_AFE_AFE_FUSE6_SAF_BB1Q_CAL__MASK                    0x03      
#define FSTID135_AFE_AFE_FUSE6_SAF_BB2Q_CAL__MASK                    0x0C      
#define FSTID135_AFE_AFE_FUSE6_SAF_BB3Q_CAL__MASK                    0x30      
#define FSTID135_AFE_AFE_FUSE6_SAF_BB4Q_CAL__MASK                    0xC0      

/* AFE_IRQ_MASK */
#define RSTID135_AFE_AFE_IRQ_MASK                                    0x00000090
#define RSTID135_AFE_AFE_IRQ_MASK__DEFAULT                           0x0       
#define FSTID135_AFE_AFE_IRQ_MASK_LDO_KO_MSK__MASK                   0x01      
#define FSTID135_AFE_AFE_IRQ_MASK_DCDC_KO_MSK__MASK                  0x02      

/* AFE_IRQ */
#define RSTID135_AFE_AFE_IRQ                                         0x00000091
#define RSTID135_AFE_AFE_IRQ__DEFAULT                                0x0       
#define FSTID135_AFE_AFE_IRQ_LDO_KO__MASK                            0x01      
#define FSTID135_AFE_AFE_IRQ_DCDC_KO__MASK                           0x02      

/* AFE_SPARE1 */
#define RSTID135_AFE_AFE_SPARE1                                      0x000000f0
#define RSTID135_AFE_AFE_SPARE1__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_SPARE1_SPARE1_BITS__MASK                    0xFF      

/* AFE_SPARE2 */
#define RSTID135_AFE_AFE_SPARE2                                      0x000000f1
#define RSTID135_AFE_AFE_SPARE2__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_SPARE2_SPARE2_BITS__MASK                    0xFF      

/* AFE_SPARE3 */
#define RSTID135_AFE_AFE_SPARE3                                      0x000000f2
#define RSTID135_AFE_AFE_SPARE3__DEFAULT                             0x0       
#define FSTID135_AFE_AFE_SPARE3_SPARE3_BITS__MASK                    0xFF      


/* Number of registers */
#define STID135_AFE_CTRL_REG_NBREGS                                  88        

/* Number of fields */
#define STID135_AFE_CTRL_REG_NBFIELDS                                285       



#endif /* #ifndef _AFE_CTRL_REG_INIT_H */
