/* 
* This file is part of STiD135 OXFORD LLA 
* 
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
* 
* License terms: BSD 3-clause "New" or "Revised" License. 
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
* 
*/ 
#ifndef _DVBSX_DEMOD_REG_INIT_H
#define _DVBSX_DEMOD_REG_INIT_H

/* -------------------------------------------------------------------------
 * File name  : dvbsx_demod_reg_init.h
 * File type  : C header file
 * -------------------------------------------------------------------------
 * Description:  Register map constants
 * Generated by spirit2regtest v2.24_alpha3
 * -------------------------------------------------------------------------
 */


/* Register map constants */

/* IQCONST */
#define RC8CODEW_DVBSX_DEMOD_IQCONST                                 0x00000000
#define RC8CODEW_DVBSX_DEMOD_IQCONST__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_IQCONST_IQSYMB_SEL__MASK                0x1F      
#define FC8CODEW_DVBSX_DEMOD_IQCONST_CONSTEL_SELECT__MASK            0x60      

/* IQOPTION */
#define RC8CODEW_DVBSX_DEMOD_IQOPTION                                0x00000001
#define RC8CODEW_DVBSX_DEMOD_IQOPTION__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_IQOPTION_I2CCONSTEL_LIGNE__MASK         0x0F      

/* ISYMB */
#define RC8CODEW_DVBSX_DEMOD_ISYMB                                   0x00000002
#define RC8CODEW_DVBSX_DEMOD_ISYMB__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_ISYMB_I_SYMBOL__MASK                    0xFF      

/* QSYMB */
#define RC8CODEW_DVBSX_DEMOD_QSYMB                                   0x00000003
#define RC8CODEW_DVBSX_DEMOD_QSYMB__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_QSYMB_Q_SYMBOL__MASK                    0xFF      

/* AGC1CFG */
#define RC8CODEW_DVBSX_DEMOD_AGC1CFG                                 0x00000010
#define RC8CODEW_DVBSX_DEMOD_AGC1CFG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_IQMISM_SLOW__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_DCCOMP_SLOW__MASK               0x02      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_QUAD_CORRECT__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_QUAD_FROZEN__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_AMM_CORRECT__MASK               0x10      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_AMM_FROZEN__MASK                0x20      
#define FC8CODEW_DVBSX_DEMOD_AGC1CFG_DC_CTRL__MASK                   0xC0      

/* AGC1CN */
#define RC8CODEW_DVBSX_DEMOD_AGC1CN                                  0x00000012
#define RC8CODEW_DVBSX_DEMOD_AGC1CN__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGCIQ_BETA__MASK                 0x07      
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGCOUT_FAST__MASK                0x08      
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGC1_MINPOWER__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGC1_NOSLOWLK__MASK              0x20      
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGC1_NOSIGNAL__MASK              0x40      
#define FC8CODEW_DVBSX_DEMOD_AGC1CN_AGC1_LOCKED__MASK                0x80      

/* AGC1REF */
#define RC8CODEW_DVBSX_DEMOD_AGC1REF                                 0x00000013
#define RC8CODEW_DVBSX_DEMOD_AGC1REF__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1REF_AGCIQ_REF__MASK                 0xFF      

/* AGC1POWERI */
#define RC8CODEW_DVBSX_DEMOD_AGC1POWERI                              0x00000016
#define RC8CODEW_DVBSX_DEMOD_AGC1POWERI__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1POWERI_POWER_I__MASK                0xFF      

/* AGC1POWERQ */
#define RC8CODEW_DVBSX_DEMOD_AGC1POWERQ                              0x00000017
#define RC8CODEW_DVBSX_DEMOD_AGC1POWERQ__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1POWERQ_POWER_Q__MASK                0xFF      

/* AGC1AMM */
#define RC8CODEW_DVBSX_DEMOD_AGC1AMM                                 0x00000018
#define RC8CODEW_DVBSX_DEMOD_AGC1AMM__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1AMM_AMM_VALUE__MASK                 0xFF      

/* AGC1QUAD */
#define RC8CODEW_DVBSX_DEMOD_AGC1QUAD                                0x00000019
#define RC8CODEW_DVBSX_DEMOD_AGC1QUAD__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1QUAD_QUAD_VALUE__MASK               0xFF      

/* AGC1IQIN1 */
#define RC8CODEW_DVBSX_DEMOD_AGC1IQIN1                               0x0000001a
#define RC8CODEW_DVBSX_DEMOD_AGC1IQIN1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1IQIN1_AGCIQ_VALUE__MASK             0xFF      

/* AGC1IQIN0 */
#define RC8CODEW_DVBSX_DEMOD_AGC1IQIN0                               0x0000001b
#define RC8CODEW_DVBSX_DEMOD_AGC1IQIN0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1IQIN0_AGCIQ_VALUE__MASK             0xFF      

/* AGC1SHDB */
#define RC8CODEW_DVBSX_DEMOD_AGC1SHDB                                0x0000001c
#define RC8CODEW_DVBSX_DEMOD_AGC1SHDB__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1SHDB_DCVAL_SELECT__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_AGC1SHDB_ADCIN_IQOFF__MASK              0x30      
#define FC8CODEW_DVBSX_DEMOD_AGC1SHDB_DCCOMP_DRIFT__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_AGC1SHDB_SHDB_PERMUTE__MASK             0x80      

/* AGC1OPT */
#define RC8CODEW_DVBSX_DEMOD_AGC1OPT                                 0x0000001d
#define RC8CODEW_DVBSX_DEMOD_AGC1OPT__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_XOR_ADCIN__MASK                 0x01      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_XOR_AGCRF__MASK                 0x02      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_XORDAC_AGCRF__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_AGC1OUT_DIV2__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_AGC1OUT_LSBOFF__MASK            0x10      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_SHDB_LSBPERMUTE__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_AGC1OPT_XOR2_ADCIN__MASK                0x40      

/* DEMOD */
#define RC8CODEW_DVBSX_DEMOD_DEMOD                                   0x00000020
#define RC8CODEW_DVBSX_DEMOD_DEMOD__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_DEMOD_ROLLOFF_CONTROL__MASK             0x07      
#define FC8CODEW_DVBSX_DEMOD_DEMOD_MANUALSX_ROLLOFF__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_DEMOD_SPECINV_CONTROL__MASK             0x30      
#define FC8CODEW_DVBSX_DEMOD_DEMOD_MANUAL_MODCOD__MASK               0x40      
#define FC8CODEW_DVBSX_DEMOD_DEMOD_MANUALS2_ROLLOFF__MASK            0x80      

/* DMDCFGMD */
#define RC8CODEW_DVBSX_DEMOD_DMDCFGMD                                0x00000022
#define RC8CODEW_DVBSX_DEMOD_DMDCFGMD__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_TUN_RNG__MASK                  0x03      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_NOFORCE_RELOCK__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_CFR_AUTOSCAN__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_SCAN_ENABLE__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_STC_ENABLE__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_DVBS1_ENABLE__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDCFGMD_DVBS2_ENABLE__MASK             0x80      

/* DMDCFG2 */
#define RC8CODEW_DVBSX_DEMOD_DMDCFG2                                 0x00000023
#define RC8CODEW_DVBSX_DEMOD_DMDCFG2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_NSTOP_ETAPE8__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_COARSE_LK23MODE__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_TMGLOCK_NSCANSTOP__MASK         0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_BWOFFSET_COLDWARM__MASK         0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_INFINITE_RELOCK__MASK           0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_BLINDPEA_MODE__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_S1S2_SEQUENTIAL__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG2_AGC1_WAITLOCK__MASK             0x80      

/* DMDISTATE */
#define RC8CODEW_DVBSX_DEMOD_DMDISTATE                               0x00000024
#define RC8CODEW_DVBSX_DEMOD_DMDISTATE__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDISTATE_I2C_DEMOD_MODE__MASK          0x1F      
#define FC8CODEW_DVBSX_DEMOD_DMDISTATE_SDMDRST_DIRCLK__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDISTATE_FORCE_ETAPED__MASK            0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDISTATE_I2C_NORESETDMODE__MASK        0x80      

/* DMDT0M */
#define RC8CODEW_DVBSX_DEMOD_DMDT0M                                  0x00000025
#define RC8CODEW_DVBSX_DEMOD_DMDT0M__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDT0M_DMDT0_MIN__MASK                  0xFF      

/* DMDT0L */
#define RC8CODEW_DVBSX_DEMOD_DMDT0L                                  0x00000026
#define RC8CODEW_DVBSX_DEMOD_DMDT0L__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDT0L_DMDT0_MAX__MASK                  0xFF      

/* DMDT1M */
#define RC8CODEW_DVBSX_DEMOD_DMDT1M                                  0x00000027
#define RC8CODEW_DVBSX_DEMOD_DMDT1M__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDT1M_DMDT1ETAPE6_MIN__MASK            0x07      
#define FC8CODEW_DVBSX_DEMOD_DMDT1M_DMDT1ET6_SYMB__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDT1M_DMDT1ETAPE3_MIN__MASK            0x70      
#define FC8CODEW_DVBSX_DEMOD_DMDT1M_DMDT1ET3_SYMB__MASK              0x80      

/* DMDT1L */
#define RC8CODEW_DVBSX_DEMOD_DMDT1L                                  0x00000028
#define RC8CODEW_DVBSX_DEMOD_DMDT1L__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDT1L_DMDT1ETAPE6_MAX__MASK            0x0F      
#define FC8CODEW_DVBSX_DEMOD_DMDT1L_DMDT1ETAPE3_MAX__MASK            0xF0      

/* DMDCFG3 */
#define RC8CODEW_DVBSX_DEMOD_DMDCFG3                                 0x00000029
#define RC8CODEW_DVBSX_DEMOD_DMDCFG3__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_LOCKTIME_MODE__MASK             0x07      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_NOSTOP_FIFOFULL__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_DIS_SFRUPLOW_TRK__MASK          0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_INV_SEQSRCH__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_NO_BWCENTERING__MASK            0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG3_DVBS1_TMGWAIT__MASK             0x80      

/* DMDCFG4 */
#define RC8CODEW_DVBSX_DEMOD_DMDCFG4                                 0x0000002a
#define RC8CODEW_DVBSX_DEMOD_DMDCFG4__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_NO_TNRBWINIT__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_DIS_HDRDIVLOCK__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_DIS_CLKENABLE__MASK             0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_TUNER_NRELAUNCH__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_S1HIER_ENABLE__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_DEMOD_FASTLOCK__MASK            0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_S1S2TOUT_FAST__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG4_DIS_VITLOCK__MASK               0x80      

/* DMDCFG5 */
#define RC8CODEW_DVBSX_DEMOD_DMDCFG5                                 0x0000002b
#define RC8CODEW_DVBSX_DEMOD_DMDCFG5__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_CFRINIT_INVZIGZAG__MASK         0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_TOUT_TMGNLOCK__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_DMDTOUT_NBACK__MASK             0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_DIS_S2REJECT__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_DUMMYPL_CFG__MASK               0x70      
#define FC8CODEW_DVBSX_DEMOD_DMDCFG5_DMDSLOW_NCONSTEL__MASK          0x80      

/* DMDMODCOD */
#define RC8CODEW_DVBSX_DEMOD_DMDMODCOD                               0x00000030
#define RC8CODEW_DVBSX_DEMOD_DMDMODCOD__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDMODCOD_DEMOD_TYPE__MASK              0x03      
#define FC8CODEW_DVBSX_DEMOD_DMDMODCOD_DEMOD_MODCOD__MASK            0xFC      

/* DMDPLFNUM */
#define RC8CODEW_DVBSX_DEMOD_DMDPLFNUM                               0x00000031
#define RC8CODEW_DVBSX_DEMOD_DMDPLFNUM__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDPLFNUM_DEMOD_PLFNUM__MASK            0xFF      

/* DMDSTATE */
#define RC8CODEW_DVBSX_DEMOD_DMDSTATE                                0x00000032
#define RC8CODEW_DVBSX_DEMOD_DMDSTATE__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDSTATE_DEMOD_MODE__MASK               0x1F      
#define FC8CODEW_DVBSX_DEMOD_DMDSTATE_HEADER_MODE__MASK              0x60      
#define FC8CODEW_DVBSX_DEMOD_DMDSTATE_DEMOD_LOCKED__MASK             0x80      

/* DMDFLYW */
#define RC8CODEW_DVBSX_DEMOD_DMDFLYW                                 0x00000033
#define RC8CODEW_DVBSX_DEMOD_DMDFLYW__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDFLYW_FLYWHEEL_CPT__MASK              0x0F      
#define FC8CODEW_DVBSX_DEMOD_DMDFLYW_I2C_IRQVAL__MASK                0xF0      

/* DSTATUS */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS                                 0x00000034
#define RC8CODEW_DVBSX_DEMOD_DSTATUS__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_OVADC_DETECT__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_DEMOD_SYSCFG__MASK              0x02      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_TIMING_IS_LOCKED__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_LOCK_DEFINITIF__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_SDVBS1_ENABLE__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_TMGLOCK_QUALITY__MASK           0x60      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS_CAR_LOCK__MASK                  0x80      

/* DSTATUS2 */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS2                                0x00000035
#define RC8CODEW_DVBSX_DEMOD_DSTATUS2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_GAMMA_OVERUNDER__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_CFR_OVERFLOW__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_AGC2_OVERFLOW__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_AGC1_NOSIGNALACK__MASK         0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_POLYPH_SATEVENT__MASK          0x10      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_MODCODRQ_SYNCTAG__MASK         0x20      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_DEMOD_TIMEOUT__MASK            0x40      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS2_DEMOD_DELOCK__MASK             0x80      

/* DSTATUS3 */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS3                                0x00000036
#define RC8CODEW_DVBSX_DEMOD_DSTATUS3__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_ETAPE1A_DVBXMEM__MASK          0x03      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_DEMOD_FAIL__MASK               0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_RELOCK_MODE__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_GAMMA_LOWBAUDRATE__MASK        0x10      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_DEMOD_CFGMODE__MASK            0x60      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS3_CFR_ZIGZAG__MASK               0x80      

/* DSTATUS4 */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS4                                0x00000037
#define RC8CODEW_DVBSX_DEMOD_DSTATUS4__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_DETECTION_TRIAX__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_CSTENV_DETECT__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_DMDPROG_ERROR__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_HIER_DETECT__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_PILOT_FAILDETECT__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_NOSTHRES1_FAIL__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_NOSTHRES2_FAIL__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS4_RAINFADE_DETECT__MASK          0x80      

/* DSTATUS5 */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS5                                0x00000038
#define RC8CODEW_DVBSX_DEMOD_DSTATUS5__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_DEROT1B_ON__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_SHDB_ERROR__MASK               0x02      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_SHDB_OVERFLOW__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_SDEMAP_FIFOUSE__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_FIFO2_ON__MASK                 0x10      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_SUPERHDEBMODE__MASK            0x60      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS5_FIFO2_ACTBOURRAGE__MASK        0x80      

/* DSTATUS6 */
#define RC8CODEW_DVBSX_DEMOD_DSTATUS6                                0x00000039
#define RC8CODEW_DVBSX_DEMOD_DSTATUS6__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_SPECINV_DEMOD__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_AGC2_NOSIGNAL__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_AGC2_MODOV__MASK               0x04      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_SFRAME_DETECT__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_DUMMY_DVBS2X__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_DSTATUS6_SIGNAL_ANNEXEM__MASK           0xC0      

/* DMDERRORS */
#define RC8CODEW_DVBSX_DEMOD_DMDERRORS                               0x0000003a
#define RC8CODEW_DVBSX_DEMOD_DMDERRORS__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_DVBSXSEL_ERROR__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_AGC2REF_ERROR__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_TRNPROG_ERROR__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_CARPROG_ERROR__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_GAMMAPROG_ERROR__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_CKSYMPROG_ERROR__MASK         0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDERRORS_FIFO2PROG_ERROR__MASK         0x40      

/* HDEBITCFG2 */
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG2                              0x00000040
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG2_DEMODFLT_XXXMODE__MASK       0x1F      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG2_EN_FIFO2DIV2__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG2_MODE_HAUTDEBIT__MASK         0xC0      

/* HDEBITCFG1 */
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG1                              0x00000041
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_DEMODFLT_WORKMODE__MASK      0x03      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_DIS_SKIPFAST__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_DIS_SDEMAPFIFO__MASK         0x08      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_DIS_SKIPSDDATA__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_NSHDB_BOURRAGE__MASK         0x20      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_NFIFO2_ZERODEL__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG1_NPOLYPH_S1SHORT__MASK        0x80      

/* HDEBITCFG0 */
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG0                              0x00000042
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG0_SDEMAP_MAXLLRRATE__MASK      0x07      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG0_CARRIER1_NFASTLOOP__MASK     0x08      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG0_STC_HDBJUMP__MASK            0x10      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG0_DEROT1G_DISLOCK__MASK        0x20      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG0_FIFO2_ULTRABS__MASK          0xC0      

/* DSAMPDLY */
#define RC8CODEW_DVBSX_DEMOD_DSAMPDLY                                0x00000043
#define RC8CODEW_DVBSX_DEMOD_DSAMPDLY__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSAMPDLY_DEMOD_SAMPDELAYX2__MASK        0xFF      

/* DSYMBDLY */
#define RC8CODEW_DVBSX_DEMOD_DSYMBDLY                                0x00000044
#define RC8CODEW_DVBSX_DEMOD_DSYMBDLY__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DSYMBDLY_DEMOD_SYMBDELAY__MASK          0xFF      

/* SHDBFIFO21 */
#define RC8CODEW_DVBSX_DEMOD_SHDBFIFO21                              0x00000048
#define RC8CODEW_DVBSX_DEMOD_SHDBFIFO21__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SHDBFIFO21_FIFO2_DATANBR__MASK          0xFF      

/* SHDBFIFO20 */
#define RC8CODEW_DVBSX_DEMOD_SHDBFIFO20                              0x00000049
#define RC8CODEW_DVBSX_DEMOD_SHDBFIFO20__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SHDBFIFO20_FIFO2_DATANBR__MASK          0xFF      

/* SHDBPARAL */
#define RC8CODEW_DVBSX_DEMOD_SHDBPARAL                               0x0000004a
#define RC8CODEW_DVBSX_DEMOD_SHDBPARAL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SHDBPARAL_SHDBVECT_SAMPLEN__MASK        0x1F      
#define FC8CODEW_DVBSX_DEMOD_SHDBPARAL_SHDBVECT_SYMBLEN__MASK        0xE0      

/* SLICEADR */
#define RC8CODEW_DVBSX_DEMOD_SLICEADR                                0x00000050
#define RC8CODEW_DVBSX_DEMOD_SLICEADR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICEADR_DEMODFLT_RAMI2CADR__MASK       0x7F      
#define FC8CODEW_DVBSX_DEMOD_SLICEADR_DEMODFLT_RAMCFG__MASK          0x80      

/* SLICEDATA */
#define RC8CODEW_DVBSX_DEMOD_SLICEDATA                               0x00000051
#define RC8CODEW_DVBSX_DEMOD_SLICEDATA__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICEDATA_DEMODFLT_RAMDATA__MASK        0xFF      

/* SLICECFG */
#define RC8CODEW_DVBSX_DEMOD_SLICECFG                                0x00000052
#define RC8CODEW_DVBSX_DEMOD_SLICECFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICECFG_DEMODFLT_RAMPAGE__MASK         0x03      
#define FC8CODEW_DVBSX_DEMOD_SLICECFG_DEMODFLT_RAMMODE__MASK         0x0C      
#define FC8CODEW_DVBSX_DEMOD_SLICECFG_DEMODFLT_INCDEC__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_SLICECFG_DIS_DUMMYFLT__MASK             0x40      

/* SLICENBR */
#define RC8CODEW_DVBSX_DEMOD_SLICENBR                                0x00000053
#define RC8CODEW_DVBSX_DEMOD_SLICENBR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICENBR_DEMODFLT_SLICENBR__MASK        0xFF      

/* SLICESYMB2 */
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB2                              0x00000054
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICESYMB2_DEMODFLT_SYMBNBR__MASK       0xFF      

/* SLICESYMB1 */
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB1                              0x00000055
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICESYMB1_DEMODFLT_SYMBNBR__MASK       0xFF      

/* SLICESYMB0 */
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB0                              0x00000056
#define RC8CODEW_DVBSX_DEMOD_SLICESYMB0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICESYMB0_DEMODFLT_SYMBNBR__MASK       0xFF      

/* SLICERATIO */
#define RC8CODEW_DVBSX_DEMOD_SLICERATIO                              0x00000057
#define RC8CODEW_DVBSX_DEMOD_SLICERATIO__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICERATIO_DEMODFLT_RATIO__MASK         0xFF      

/* SLICESTAT */
#define RC8CODEW_DVBSX_DEMOD_SLICESTAT                               0x00000058
#define RC8CODEW_DVBSX_DEMOD_SLICESTAT__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICESTAT_DEMODFLT_PKTDELIN__MASK       0x0F      
#define FC8CODEW_DVBSX_DEMOD_SLICESTAT_DEMODFLT_ISIMODE__MASK        0x30      
#define FC8CODEW_DVBSX_DEMOD_SLICESTAT_DEMODFLT_PDELSYNC__MASK       0xC0      

/* SLICEMAX */
#define RC8CODEW_DVBSX_DEMOD_SLICEMAX                                0x00000059
#define RC8CODEW_DVBSX_DEMOD_SLICEMAX__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICEMAX_DEMODFLT_SLICEMAX__MASK        0xFF      

/* SLICEMIN */
#define RC8CODEW_DVBSX_DEMOD_SLICEMIN                                0x0000005a
#define RC8CODEW_DVBSX_DEMOD_SLICEMIN__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICEMIN_DEMODFLT_SLICEMIN__MASK        0xFF      

/* SLICESEL */
#define RC8CODEW_DVBSX_DEMOD_SLICESEL                                0x0000005b
#define RC8CODEW_DVBSX_DEMOD_SLICESEL__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICESEL_DEMODFLT_SLICESEL__MASK        0xFF      

/* SLICEANC */
#define RC8CODEW_DVBSX_DEMOD_SLICEANC                                0x0000005c
#define RC8CODEW_DVBSX_DEMOD_SLICEANC__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SLICEANC_DEMODFLT_TYPE__MASK            0x03      
#define FC8CODEW_DVBSX_DEMOD_SLICEANC_DEMODFLT_MODCOD__MASK          0xFC      

/* DEMODAUX */
#define RC8CODEW_DVBSX_DEMOD_DEMODAUX                                0x0000005d
#define RC8CODEW_DVBSX_DEMOD_DEMODAUX__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DEMODAUX_DEMODAUX_INDEX__MASK           0x07      

/* HDEBITCFG4 */
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG4                              0x0000005e
#define RC8CODEW_DVBSX_DEMOD_HDEBITCFG4__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_DIS_SOFDEROT1B__MASK         0x01      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_FIFO2_NCRCARE__MASK          0x06      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_EN_SUPERFRAME__MASK          0x08      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_DIS_HWAREDELAI__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_DIS_SDEMAPDLY__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_DIS_SDEMAPGAP__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_HDEBITCFG4_DIS_PCRCLOCKOV__MASK         0x80      

/* FILTCFGM */
#define RC8CODEW_DVBSX_DEMOD_FILTCFGM                                0x00000070
#define RC8CODEW_DVBSX_DEMOD_FILTCFGM__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_FILTRE3_MANUEL__MASK           0x01      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_FILTRE2_MANUEL__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_FILTRE1_MANUEL__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_BYP_HDBFILTRE__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_FILTRES_BETA__MASK             0x30      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGM_HDBFILTRE_MODE__MASK           0xC0      

/* FILTCFGL */
#define RC8CODEW_DVBSX_DEMOD_FILTCFGL                                0x00000071
#define RC8CODEW_DVBSX_DEMOD_FILTCFGL__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_FILTCFGL_FILTRE3_AMPL__MASK             0x03      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGL_FILTRE2_AMPL__MASK             0x0C      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGL_FILTRE1_AMPL__MASK             0x30      
#define FC8CODEW_DVBSX_DEMOD_FILTCFGL_FILTRE_DEBUG__MASK             0x80      

/* IQFILT0 */
#define RC8CODEW_DVBSX_DEMOD_IQFILT0                                 0x00000072
#define RC8CODEW_DVBSX_DEMOD_IQFILT0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_IQFILT0_IQPOWER_DEROT1G__MASK           0xFF      

/* IQFILT1 */
#define RC8CODEW_DVBSX_DEMOD_IQFILT1                                 0x00000073
#define RC8CODEW_DVBSX_DEMOD_IQFILT1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_IQFILT1_IQPOWER_FILTRE1__MASK           0xFF      

/* IQFILT2 */
#define RC8CODEW_DVBSX_DEMOD_IQFILT2                                 0x00000074
#define RC8CODEW_DVBSX_DEMOD_IQFILT2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_IQFILT2_IQPOWER_FILTRE2__MASK           0xFF      

/* IQFILT3 */
#define RC8CODEW_DVBSX_DEMOD_IQFILT3                                 0x00000075
#define RC8CODEW_DVBSX_DEMOD_IQFILT3__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_IQFILT3_IQPOWER_FILTRE3__MASK           0xFF      

/* CORRELMANT */
#define RC8CODEW_DVBSX_DEMOD_CORRELMANT                              0x00000080
#define RC8CODEW_DVBSX_DEMOD_CORRELMANT__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELMANT_CORREL_MANT__MASK            0xFF      

/* CORRELABS */
#define RC8CODEW_DVBSX_DEMOD_CORRELABS                               0x00000081
#define RC8CODEW_DVBSX_DEMOD_CORRELABS__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELABS_CORREL_ABS__MASK              0xFF      

/* CORRELABSM */
#define RC8CODEW_DVBSX_DEMOD_CORRELABSM                              0x00000082
#define RC8CODEW_DVBSX_DEMOD_CORRELABSM__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELABSM_CORREL_ABSM__MASK            0xFF      

/* CORRELEXP */
#define RC8CODEW_DVBSX_DEMOD_CORRELEXP                               0x00000083
#define RC8CODEW_DVBSX_DEMOD_CORRELEXP__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELEXP_CORREL_EXP__MASK              0x0F      
#define FC8CODEW_DVBSX_DEMOD_CORRELEXP_CORREL_ABSEXP__MASK           0xF0      

/* CORRELCOEF */
#define RC8CODEW_DVBSX_DEMOD_CORRELCOEF                              0x00000084
#define RC8CODEW_DVBSX_DEMOD_CORRELCOEF__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELCOEF_CORREL_COEFM__MASK           0xFF      

/* CORRELCFG */
#define RC8CODEW_DVBSX_DEMOD_CORRELCFG                               0x00000085
#define RC8CODEW_DVBSX_DEMOD_CORRELCFG__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELCFG_CONFIG_I_ONLY__MASK           0x01      
#define FC8CODEW_DVBSX_DEMOD_CORRELCFG_CONFIG_DISABLE_INV__MASK      0x02      
#define FC8CODEW_DVBSX_DEMOD_CORRELCFG_CONFIG_SATUR__MASK            0x0C      
#define FC8CODEW_DVBSX_DEMOD_CORRELCFG_CONFIG_CONFIDENCE__MASK       0x10      
#define FC8CODEW_DVBSX_DEMOD_CORRELCFG_CORRELABSM_NDIV4__MASK        0x80      

/* CORRELFREQ */
#define RC8CODEW_DVBSX_DEMOD_CORRELFREQ                              0x00000086
#define RC8CODEW_DVBSX_DEMOD_CORRELFREQ__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_DIFFPILOT_MODE__MASK         0x07      
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_DIS_PLHEGALMODE__MASK        0x08      
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_EN_EGALPLH__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_DIFFPILOT_LOCKSEL__MASK      0x20      
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_EGALPLH_BEFLOCK__MASK        0x40      
#define FC8CODEW_DVBSX_DEMOD_CORRELFREQ_NODEL_BADFRAME__MASK         0x80      

/* PLHMODCOD */
#define RC8CODEW_DVBSX_DEMOD_PLHMODCOD                               0x00000087
#define RC8CODEW_DVBSX_DEMOD_PLHMODCOD__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHMODCOD_PLH_TYPE__MASK                0x03      
#define FC8CODEW_DVBSX_DEMOD_PLHMODCOD_PLH_MODCOD__MASK              0xFC      

/* DMDREG */
#define RC8CODEW_DVBSX_DEMOD_DMDREG                                  0x00000088
#define RC8CODEW_DVBSX_DEMOD_DMDREG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDREG_DECIM_PLFRAMES__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDREG_HIER_SHORTFRAME__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDREG_PMGR_PSYNCMODE__MASK             0x0C      
#define FC8CODEW_DVBSX_DEMOD_DMDREG_DIS_STCPUNCT__MASK               0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDREG_DIS_STCPILOTS__MASK              0x20      

/* AGC2O */
#define RC8CODEW_DVBSX_DEMOD_AGC2O                                   0x00000090
#define RC8CODEW_DVBSX_DEMOD_AGC2O__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2O_AGC2_COEF__MASK                   0x07      
#define FC8CODEW_DVBSX_DEMOD_AGC2O_AGC2_LKEQUA__MASK                 0x08      
#define FC8CODEW_DVBSX_DEMOD_AGC2O_AGC2OV_FSTOP__MASK                0x10      
#define FC8CODEW_DVBSX_DEMOD_AGC2O_CSTENV_MODE__MASK                 0xC0      

/* AGC2REF */
#define RC8CODEW_DVBSX_DEMOD_AGC2REF                                 0x00000091
#define RC8CODEW_DVBSX_DEMOD_AGC2REF__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2REF_AGC2_REF__MASK                  0xFF      

/* AGCNADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCNADJ                                 0x00000092
#define RC8CODEW_DVBSX_DEMOD_AGCNADJ__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCNADJ_AGCADJ_XXDB__MASK               0x0F      

/* AGCKS */
#define RC8CODEW_DVBSX_DEMOD_AGCKS                                   0x00000093
#define RC8CODEW_DVBSX_DEMOD_AGCKS__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCKS_AGC2AMPL_MODE__MASK               0x03      
#define FC8CODEW_DVBSX_DEMOD_AGCKS_AGC2AMPL_DVBS1__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_AGCKS_AGC2GEN_MODE__MASK                0x18      
#define FC8CODEW_DVBSX_DEMOD_AGCKS_DIS_RHIER__MASK                   0x20      
#define FC8CODEW_DVBSX_DEMOD_AGCKS_RSADJ_CCMMODE__MASK               0x40      
#define FC8CODEW_DVBSX_DEMOD_AGCKS_RSADJ_MANUALCFG__MASK             0x80      

/* AGCRSADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCRSADJ                                0x00000094
#define RC8CODEW_DVBSX_DEMOD_AGCRSADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCRSADJ_RS_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCRSADJ_RSADJ_MANUAL__MASK             0x80      

/* AGCRQ8ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ                               0x00000095
#define RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ_RQ8_ADJUSTED__MASK            0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ_RQ8ADJ_MANUAL__MASK           0x80      

/* AGCR1ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR1ADJ                                0x00000096
#define RC8CODEW_DVBSX_DEMOD_AGCR1ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR1ADJ_R1_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR1ADJ_R1ADJ_MANUAL__MASK             0x80      

/* AGCR2ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR2ADJ                                0x00000097
#define RC8CODEW_DVBSX_DEMOD_AGCR2ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR2ADJ_R2_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR2ADJ_R2ADJ_MANUAL__MASK             0x80      

/* AGCR3ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR3ADJ                                0x00000098
#define RC8CODEW_DVBSX_DEMOD_AGCR3ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR3ADJ_R3_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR3ADJ_R3ADJ_MANUAL__MASK             0x80      

/* AGCR4ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR4ADJ                                0x00000099
#define RC8CODEW_DVBSX_DEMOD_AGCR4ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR4ADJ_R4_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR4ADJ_R4ADJ_MANUAL__MASK             0x80      

/* AGCR5ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR5ADJ                                0x0000009a
#define RC8CODEW_DVBSX_DEMOD_AGCR5ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR5ADJ_R5_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR5ADJ_R5ADJ_MANUAL__MASK             0x80      

/* AGCR6ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR6ADJ                                0x0000009b
#define RC8CODEW_DVBSX_DEMOD_AGCR6ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR6ADJ_R6_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR6ADJ_R6ADJ_MANUAL__MASK             0x80      

/* AGCR7ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR7ADJ                                0x0000009c
#define RC8CODEW_DVBSX_DEMOD_AGCR7ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR7ADJ_R7_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR7ADJ_R7ADJ_MANUAL__MASK             0x80      

/* AGCR8ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR8ADJ                                0x0000009d
#define RC8CODEW_DVBSX_DEMOD_AGCR8ADJ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR8ADJ_R8_ADJUSTED__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR8ADJ_R8ADJ_MANUAL__MASK             0x80      

/* AGCR1BADJ */
#define RC8CODEW_DVBSX_DEMOD_AGCR1BADJ                               0x0000009e
#define RC8CODEW_DVBSX_DEMOD_AGCR1BADJ__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGCR1BADJ_R1B_ADJUSTED__MASK            0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGCR1BADJ_R1BADJ_MANUAL__MASK           0x80      

/* AGC2ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGC2ADJ                                 0x0000009f
#define RC8CODEW_DVBSX_DEMOD_AGC2ADJ__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2ADJ_AGC2REF_XXDB__MASK              0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGC2ADJ_AGC2ADJ_MANUAL__MASK            0x80      

/* AGC2I1 */
#define RC8CODEW_DVBSX_DEMOD_AGC2I1                                  0x000000a0
#define RC8CODEW_DVBSX_DEMOD_AGC2I1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2I1_AGC2ACC_MANT__MASK               0xFF      

/* AGC2I0 */
#define RC8CODEW_DVBSX_DEMOD_AGC2I0                                  0x000000a1
#define RC8CODEW_DVBSX_DEMOD_AGC2I0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2I0_AGC2ACC_EXP__MASK                0x3F      
#define FC8CODEW_DVBSX_DEMOD_AGC2I0_AGC2ACC_MANT__MASK               0xC0      

/* AGC2IMP */
#define RC8CODEW_DVBSX_DEMOD_AGC2IMP                                 0x000000a2
#define RC8CODEW_DVBSX_DEMOD_AGC2IMP__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2IMP_AGC2_IMPCPT__MASK               0xFF      

/* AGC1ADJ */
#define RC8CODEW_DVBSX_DEMOD_AGC1ADJ                                 0x000000a3
#define RC8CODEW_DVBSX_DEMOD_AGC1ADJ__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC1ADJ_AGC1_ADJUSTED__MASK             0x7F      
#define FC8CODEW_DVBSX_DEMOD_AGC1ADJ_AGC1ADJ_MANUAL__MASK            0x80      

/* AGC2R10DB */
#define RC8CODEW_DVBSX_DEMOD_AGC2R10DB                               0x000000a4
#define RC8CODEW_DVBSX_DEMOD_AGC2R10DB__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2R10DB_AGC2AMPL_10DB__MASK           0xFF      

/* AGC2R20DB */
#define RC8CODEW_DVBSX_DEMOD_AGC2R20DB                               0x000000a5
#define RC8CODEW_DVBSX_DEMOD_AGC2R20DB__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2R20DB_AGC2AMPL_20DB__MASK           0xFF      

/* AGC2AMPL */
#define RC8CODEW_DVBSX_DEMOD_AGC2AMPL                                0x000000a6
#define RC8CODEW_DVBSX_DEMOD_AGC2AMPL__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2AMPL_AGC2AMPL_AGC2IN__MASK          0x07      
#define FC8CODEW_DVBSX_DEMOD_AGC2AMPL_AGC2STRUCT_AGC2IN__MASK        0x38      
#define FC8CODEW_DVBSX_DEMOD_AGC2AMPL_AGC2GEN_AGC2IN__MASK           0xC0      

/* AGC2VAR */
#define RC8CODEW_DVBSX_DEMOD_AGC2VAR                                 0x000000a7
#define RC8CODEW_DVBSX_DEMOD_AGC2VAR__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2VAR_ACCU_AGC2DIFF_I2C__MASK         0xFF      

/* AGC2RATIO */
#define RC8CODEW_DVBSX_DEMOD_AGC2RATIO                               0x000000a8
#define RC8CODEW_DVBSX_DEMOD_AGC2RATIO__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AGC2RATIO_AGC2AMPL_RATIO__MASK          0xFF      

/* CARCFG */
#define RC8CODEW_DVBSX_DEMOD_CARCFG                                  0x000000b0
#define RC8CODEW_DVBSX_DEMOD_CARCFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CARCFG_PH_DET_ALGO__MASK                0x03      
#define FC8CODEW_DVBSX_DEMOD_CARCFG_ROTAON__MASK                     0x04      
#define FC8CODEW_DVBSX_DEMOD_CARCFG_EN_S2FREQDET__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_CARCFG_CARHDR_NODIV8__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_CARCFG_CFRCNTR_ISOL__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_CARCFG_CFRUPLOW_USEMODE__MASK           0xC0      

/* ACLCNLK */
#define RC8CODEW_DVBSX_DEMOD_ACLCNLK                                 0x000000b1
#define RC8CODEW_DVBSX_DEMOD_ACLCNLK__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLCNLK_CAR1NLK_ALPHA_EXP__MASK         0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLCNLK_CAR1NLK_ALPHA_MANTISSE__MASK    0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLCNLK_WIDE_FREQDET__MASK              0x40      
#define FC8CODEW_DVBSX_DEMOD_ACLCNLK_ABCLC1_OLDMODE__MASK            0x80      

/* BCLCNLK */
#define RC8CODEW_DVBSX_DEMOD_BCLCNLK                                 0x000000b2
#define RC8CODEW_DVBSX_DEMOD_BCLCNLK__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLCNLK_CAR1NLK_BETA_EXP__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLCNLK_CAR1NLK_BETA_MANTISSE__MASK     0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLCNLK_ROTA1G_MANUEL__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLCNLK_ROTA1G_OFF__MASK                0x80      

/* ACLCLK */
#define RC8CODEW_DVBSX_DEMOD_ACLCLK                                  0x000000b3
#define RC8CODEW_DVBSX_DEMOD_ACLCLK__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLCLK_CAR1LK_ALPHA_EXP__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLCLK_CAR1LK_ALPHA_MANTISSE__MASK      0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLCLK_CAR1LK_ABS2_MODE__MASK           0xC0      

/* BCLCLK */
#define RC8CODEW_DVBSX_DEMOD_BCLCLK                                  0x000000b4
#define RC8CODEW_DVBSX_DEMOD_BCLCLK__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLCLK_CAR1LK_BETA_EXP__MASK            0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLCLK_CAR1LK_BETA_MANTISSE__MASK       0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLCLK_CAR1LK_ABNOSAUTO__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLCLK_FORCE_DELTAF__MASK               0x80      

/* CARFREQ */
#define RC8CODEW_DVBSX_DEMOD_CARFREQ                                 0x000000b5
#define RC8CODEW_DVBSX_DEMOD_CARFREQ__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CARFREQ_BETA_FREQ__MASK                 0x0F      
#define FC8CODEW_DVBSX_DEMOD_CARFREQ_KC_COARSE_EXP__MASK             0xF0      

/* CARHDR */
#define RC8CODEW_DVBSX_DEMOD_CARHDR                                  0x000000b6
#define RC8CODEW_DVBSX_DEMOD_CARHDR__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CARHDR_K_FREQ_HDR__MASK                 0xFF      

/* LDT */
#define RC8CODEW_DVBSX_DEMOD_LDT                                     0x000000b7
#define RC8CODEW_DVBSX_DEMOD_LDT__DEFAULT                            0x0       
#define FC8CODEW_DVBSX_DEMOD_LDT_CARLOCK_THRES__MASK                 0xFF      

/* LDT2 */
#define RC8CODEW_DVBSX_DEMOD_LDT2                                    0x000000b8
#define RC8CODEW_DVBSX_DEMOD_LDT2__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_LDT2_CARLOCK_THRES2__MASK               0xFF      

/* CFRICFG */
#define RC8CODEW_DVBSX_DEMOD_CFRICFG                                 0x000000b9
#define RC8CODEW_DVBSX_DEMOD_CFRICFG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_NEG_CFRSTEP__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRIROLL_GARDER__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_CSTINC__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_UNVALSKIP__MASK         0x08      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_ABORTPRED__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_ABORTDBL__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_LUNVALCPT__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_CFRICFG_CFRINIT_UNVALRNG__MASK          0x80      

/* CFR1BCFG */
#define RC8CODEW_DVBSX_DEMOD_CFR1BCFG                                0x000000ba
#define RC8CODEW_DVBSX_DEMOD_CFR1BCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1BCFG_CFR1BTOCFR1_BETA__MASK         0x07      
#define FC8CODEW_DVBSX_DEMOD_CFR1BCFG_ROTA1F_OFF__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_CFR1BCFG_CENTER1B_BETA__MASK            0x70      
#define FC8CODEW_DVBSX_DEMOD_CFR1BCFG_CFR1BTO1_FEPSMODE__MASK        0x80      

/* CFRULB1 */
#define RC8CODEW_DVBSX_DEMOD_CFRULB1                                 0x000000bb
#define RC8CODEW_DVBSX_DEMOD_CFRULB1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRULB1_CFR_ULBORNE__MASK               0x0F      
#define FC8CODEW_DVBSX_DEMOD_CFRULB1_CFRULB_MODE__MASK               0xE0      

/* CFRULB0 */
#define RC8CODEW_DVBSX_DEMOD_CFRULB0                                 0x000000bc
#define RC8CODEW_DVBSX_DEMOD_CFRULB0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRULB0_CFR_ULBORNE__MASK               0xFF      

/* CFRCNTR2 */
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR2                                0x000000bd
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRCNTR2_CFRINIT_CENTRE__MASK           0xFF      

/* CFRCNTR1 */
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR1                                0x000000be
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRCNTR1_CFRINIT_CENTRE__MASK           0xFF      

/* CFRCNTR0 */
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR0                                0x000000bf
#define RC8CODEW_DVBSX_DEMOD_CFRCNTR0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRCNTR0_CFRINIT_CENTRE__MASK           0xFF      

/* CFRIBASE2 */
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE2                               0x000000c0
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRIBASE2_CFRINIT_BASE__MASK            0xFF      

/* CFRIBASE1 */
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE1                               0x000000c1
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRIBASE1_CFRINIT_BASE__MASK            0xFF      

/* CFRIBASE0 */
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE0                               0x000000c2
#define RC8CODEW_DVBSX_DEMOD_CFRIBASE0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRIBASE0_CFRINIT_BASE__MASK            0xFF      

/* CFRINIT2 */
#define RC8CODEW_DVBSX_DEMOD_CFRINIT2                                0x000000c3
#define RC8CODEW_DVBSX_DEMOD_CFRINIT2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINIT2_CFR_INIT__MASK                 0xFF      

/* CFRINIT1 */
#define RC8CODEW_DVBSX_DEMOD_CFRINIT1                                0x000000c4
#define RC8CODEW_DVBSX_DEMOD_CFRINIT1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINIT1_CFR_INIT__MASK                 0xFF      

/* CFRINIT0 */
#define RC8CODEW_DVBSX_DEMOD_CFRINIT0                                0x000000c5
#define RC8CODEW_DVBSX_DEMOD_CFRINIT0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINIT0_CFR_INIT__MASK                 0xFF      

/* CFRUP2 */
#define RC8CODEW_DVBSX_DEMOD_CFRUP2                                  0x000000c6
#define RC8CODEW_DVBSX_DEMOD_CFRUP2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRUP2_CFR_UP__MASK                     0xFF      

/* CFRUP1 */
#define RC8CODEW_DVBSX_DEMOD_CFRUP1                                  0x000000c7
#define RC8CODEW_DVBSX_DEMOD_CFRUP1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRUP1_CFR_UP__MASK                     0xFF      

/* CFRUP0 */
#define RC8CODEW_DVBSX_DEMOD_CFRUP0                                  0x000000c8
#define RC8CODEW_DVBSX_DEMOD_CFRUP0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRUP0_CFR_UP__MASK                     0xFF      

/* CFRLOW2 */
#define RC8CODEW_DVBSX_DEMOD_CFRLOW2                                 0x000000c9
#define RC8CODEW_DVBSX_DEMOD_CFRLOW2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRLOW2_CFR_LOW__MASK                   0xFF      

/* CFRLOW1 */
#define RC8CODEW_DVBSX_DEMOD_CFRLOW1                                 0x000000ca
#define RC8CODEW_DVBSX_DEMOD_CFRLOW1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRLOW1_CFR_LOW__MASK                   0xFF      

/* CFRLOW0 */
#define RC8CODEW_DVBSX_DEMOD_CFRLOW0                                 0x000000cb
#define RC8CODEW_DVBSX_DEMOD_CFRLOW0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRLOW0_CFR_LOW__MASK                   0xFF      

/* CFRINC2 */
#define RC8CODEW_DVBSX_DEMOD_CFRINC2                                 0x000000cc
#define RC8CODEW_DVBSX_DEMOD_CFRINC2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINC2_CFR_INC__MASK                   0x3F      
#define FC8CODEW_DVBSX_DEMOD_CFRINC2_MANUAL_CFRINC__MASK             0x80      

/* CFRINC1 */
#define RC8CODEW_DVBSX_DEMOD_CFRINC1                                 0x000000cd
#define RC8CODEW_DVBSX_DEMOD_CFRINC1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINC1_CFR_INC__MASK                   0xFF      

/* CFRINC0 */
#define RC8CODEW_DVBSX_DEMOD_CFRINC0                                 0x000000ce
#define RC8CODEW_DVBSX_DEMOD_CFRINC0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFRINC0_CFR_INC__MASK                   0xFF      

/* CFR12 */
#define RC8CODEW_DVBSX_DEMOD_CFR12                                   0x000000cf
#define RC8CODEW_DVBSX_DEMOD_CFR12__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR12_CAR_FREQ__MASK                    0xFF      

/* CFR11 */
#define RC8CODEW_DVBSX_DEMOD_CFR11                                   0x000000d0
#define RC8CODEW_DVBSX_DEMOD_CFR11__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR11_CAR_FREQ__MASK                    0xFF      

/* CFR10 */
#define RC8CODEW_DVBSX_DEMOD_CFR10                                   0x000000d1
#define RC8CODEW_DVBSX_DEMOD_CFR10__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR10_CAR_FREQ__MASK                    0xFF      

/* LDI */
#define RC8CODEW_DVBSX_DEMOD_LDI                                     0x000000d2
#define RC8CODEW_DVBSX_DEMOD_LDI__DEFAULT                            0x0       
#define FC8CODEW_DVBSX_DEMOD_LDI_LOCK_DET_INTEGR__MASK               0xFF      

/* CFR1F2 */
#define RC8CODEW_DVBSX_DEMOD_CFR1F2                                  0x000000d3
#define RC8CODEW_DVBSX_DEMOD_CFR1F2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1F2_CFR1F_VALUE__MASK                0xFF      

/* CFR1F1 */
#define RC8CODEW_DVBSX_DEMOD_CFR1F1                                  0x000000d4
#define RC8CODEW_DVBSX_DEMOD_CFR1F1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1F1_CFR1F_VALUE__MASK                0xFF      

/* CFR1F0 */
#define RC8CODEW_DVBSX_DEMOD_CFR1F0                                  0x000000d5
#define RC8CODEW_DVBSX_DEMOD_CFR1F0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1F0_CFR1F_VALUE__MASK                0xFF      

/* CFR1G */
#define RC8CODEW_DVBSX_DEMOD_CFR1G                                   0x000000d6
#define RC8CODEW_DVBSX_DEMOD_CFR1G__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1G_CFR1G_VALUE__MASK                 0xFF      

/* CFR1B2 */
#define RC8CODEW_DVBSX_DEMOD_CFR1B2                                  0x000000d7
#define RC8CODEW_DVBSX_DEMOD_CFR1B2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1B2_CFR1B_VALUE__MASK                0xFF      

/* CFR1B1 */
#define RC8CODEW_DVBSX_DEMOD_CFR1B1                                  0x000000d8
#define RC8CODEW_DVBSX_DEMOD_CFR1B1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1B1_CFR1B_VALUE__MASK                0xFF      

/* CFR1B0 */
#define RC8CODEW_DVBSX_DEMOD_CFR1B0                                  0x000000d9
#define RC8CODEW_DVBSX_DEMOD_CFR1B0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR1B0_CFR1B_VALUE__MASK                0xFF      

/* GAUSSR0 */
#define RC8CODEW_DVBSX_DEMOD_GAUSSR0                                 0x000000da
#define RC8CODEW_DVBSX_DEMOD_GAUSSR0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_GAUSSR0_R0_GAUSSIEN__MASK               0x7F      
#define FC8CODEW_DVBSX_DEMOD_GAUSSR0_EN_CCIMODE__MASK                0x80      

/* CCIR0 */
#define RC8CODEW_DVBSX_DEMOD_CCIR0                                   0x000000db
#define RC8CODEW_DVBSX_DEMOD_CCIR0__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CCIR0_R0_CCI__MASK                      0x7F      
#define FC8CODEW_DVBSX_DEMOD_CCIR0_CCIDETECT_PLHONLY__MASK           0x80      

/* CCIQUANT */
#define RC8CODEW_DVBSX_DEMOD_CCIQUANT                                0x000000dc
#define RC8CODEW_DVBSX_DEMOD_CCIQUANT__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CCIQUANT_CCI_QUANT__MASK                0x1F      
#define FC8CODEW_DVBSX_DEMOD_CCIQUANT_CCI_BETA__MASK                 0xE0      

/* CCITHRES */
#define RC8CODEW_DVBSX_DEMOD_CCITHRES                                0x000000dd
#define RC8CODEW_DVBSX_DEMOD_CCITHRES__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CCITHRES_CCI_THRESHOLD__MASK            0xFF      

/* CCIACC */
#define RC8CODEW_DVBSX_DEMOD_CCIACC                                  0x000000de
#define RC8CODEW_DVBSX_DEMOD_CCIACC__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CCIACC_CCI_VALUE__MASK                  0xFF      

/* TMGCFG */
#define RC8CODEW_DVBSX_DEMOD_TMGCFG                                  0x000000e0
#define RC8CODEW_DVBSX_DEMOD_TMGCFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGCFG_TMG_MINFREQ__MASK                0x03      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG_MANUAL_SCAN__MASK                0x0C      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG_DO_TIMING_CORR__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG_TMGLOCK_BETA__MASK               0xC0      

/* RTCNLK */
#define RC8CODEW_DVBSX_DEMOD_RTCNLK                                  0x000000e1
#define RC8CODEW_DVBSX_DEMOD_RTCNLK__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_RTCNLK_TMGBETA_NLKEXP__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_RTCNLK_TMGALPHA_NLKEXP__MASK            0xF0      

/* RTCLK */
#define RC8CODEW_DVBSX_DEMOD_RTCLK                                   0x000000e2
#define RC8CODEW_DVBSX_DEMOD_RTCLK__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_RTCLK_TMGBETA_LKEXP__MASK               0x0F      
#define FC8CODEW_DVBSX_DEMOD_RTCLK_TMGALPHA_LKEXP__MASK              0xF0      

/* TMGTHRISE */
#define RC8CODEW_DVBSX_DEMOD_TMGTHRISE                               0x000000e3
#define RC8CODEW_DVBSX_DEMOD_TMGTHRISE__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGTHRISE_TMGLOCK_THRISE__MASK          0xFF      

/* TMGTHFALL */
#define RC8CODEW_DVBSX_DEMOD_TMGTHFALL                               0x000000e4
#define RC8CODEW_DVBSX_DEMOD_TMGTHFALL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGTHFALL_TMGLOCK_THFALL__MASK          0xFF      

/* SFRUPRATIO */
#define RC8CODEW_DVBSX_DEMOD_SFRUPRATIO                              0x000000e5
#define RC8CODEW_DVBSX_DEMOD_SFRUPRATIO__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRUPRATIO_SFR_UPRATIO__MASK            0xFF      

/* SFRLOWRATIO */
#define RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO                             0x000000e6
#define RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRLOWRATIO_SFR_LOWRATIO__MASK          0xFF      

/* KTTMG */
#define RC8CODEW_DVBSX_DEMOD_KTTMG                                   0x000000e7
#define RC8CODEW_DVBSX_DEMOD_KTTMG__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_KTTMG_DIS_DFACTLOW__MASK                0x02      
#define FC8CODEW_DVBSX_DEMOD_KTTMG_POLYOV2_ADJ__MASK                 0x04      
#define FC8CODEW_DVBSX_DEMOD_KTTMG_KT_TMG_EXP__MASK                  0xF0      

/* KREFTMG */
#define RC8CODEW_DVBSX_DEMOD_KREFTMG                                 0x000000e8
#define RC8CODEW_DVBSX_DEMOD_KREFTMG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_KREFTMG_START_KREFTMG__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_KREFTMG_STOP_KREFTMG__MASK              0xF0      

/* SFRSTEP */
#define RC8CODEW_DVBSX_DEMOD_SFRSTEP                                 0x000000e9
#define RC8CODEW_DVBSX_DEMOD_SFRSTEP__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRSTEP_SFR_CENTERSTEP__MASK            0x0F      
#define FC8CODEW_DVBSX_DEMOD_SFRSTEP_SFR_SCANSTEP__MASK              0xF0      

/* TMGCFG2 */
#define RC8CODEW_DVBSX_DEMOD_TMGCFG2                                 0x000000ea
#define RC8CODEW_DVBSX_DEMOD_TMGCFG2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_SFRRATIO_FINE__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_NOTMG_DVBS1DERAT__MASK          0x02      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_SCANINIT_QUART__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_DIS_SMOOTHTMG__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_TIMING_DEBUG__MASK              0x20      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG2_KREFTMG2_DECMODE__MASK          0xC0      

/* KREFTMG2 */
#define RC8CODEW_DVBSX_DEMOD_KREFTMG2                                0x000000eb
#define RC8CODEW_DVBSX_DEMOD_KREFTMG2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_KREFTMG2_KREF_TMG2__MASK                0xFF      

/* TMGCFG3 */
#define RC8CODEW_DVBSX_DEMOD_TMGCFG3                                 0x000000ec
#define RC8CODEW_DVBSX_DEMOD_TMGCFG3__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_SFRVAL_MINMODE__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_AUTO_GLOW__MASK                 0x02      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_AUTO_GUP__MASK                  0x04      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_CONT_TMGCENTER__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_CFRINC_MODE__MASK               0x70      
#define FC8CODEW_DVBSX_DEMOD_TMGCFG3_TIMING_NEWALGO__MASK            0x80      

/* TMGMTHRES */
#define RC8CODEW_DVBSX_DEMOD_TMGMTHRES                               0x000000ed
#define RC8CODEW_DVBSX_DEMOD_TMGMTHRES__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGMTHRES_NTIMING_D81C__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_TMGMTHRES_NTIMING_PLFSTART__MASK        0x02      
#define FC8CODEW_DVBSX_DEMOD_TMGMTHRES_NTIMING_QPSK__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_TMGMTHRES_TMG_MOD_THRES__MASK           0xF8      

/* SFRINIT2 */
#define RC8CODEW_DVBSX_DEMOD_SFRINIT2                                0x000000f0
#define RC8CODEW_DVBSX_DEMOD_SFRINIT2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRINIT2_SFR_INIT__MASK                 0xFF      

/* SFRINIT1 */
#define RC8CODEW_DVBSX_DEMOD_SFRINIT1                                0x000000f1
#define RC8CODEW_DVBSX_DEMOD_SFRINIT1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRINIT1_SFR_INIT__MASK                 0xFF      

/* SFRINIT0 */
#define RC8CODEW_DVBSX_DEMOD_SFRINIT0                                0x000000f2
#define RC8CODEW_DVBSX_DEMOD_SFRINIT0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRINIT0_SFR_INIT__MASK                 0xFF      

/* SFRUP2 */
#define RC8CODEW_DVBSX_DEMOD_SFRUP2                                  0x000000f3
#define RC8CODEW_DVBSX_DEMOD_SFRUP2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRUP2_SYMB_FREQ_UP__MASK               0xFF      

/* SFRUP1 */
#define RC8CODEW_DVBSX_DEMOD_SFRUP1                                  0x000000f4
#define RC8CODEW_DVBSX_DEMOD_SFRUP1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRUP1_SYMB_FREQ_UP__MASK               0xFF      

/* SFRUP0 */
#define RC8CODEW_DVBSX_DEMOD_SFRUP0                                  0x000000f5
#define RC8CODEW_DVBSX_DEMOD_SFRUP0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRUP0_SYMB_FREQ_UP__MASK               0xFF      

/* SFRLOW2 */
#define RC8CODEW_DVBSX_DEMOD_SFRLOW2                                 0x000000f6
#define RC8CODEW_DVBSX_DEMOD_SFRLOW2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRLOW2_SYMB_FREQ_LOW__MASK             0xFF      

/* SFRLOW1 */
#define RC8CODEW_DVBSX_DEMOD_SFRLOW1                                 0x000000f7
#define RC8CODEW_DVBSX_DEMOD_SFRLOW1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRLOW1_SYMB_FREQ_LOW__MASK             0xFF      

/* SFRLOW0 */
#define RC8CODEW_DVBSX_DEMOD_SFRLOW0                                 0x000000f8
#define RC8CODEW_DVBSX_DEMOD_SFRLOW0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_SFRLOW0_SYMB_FREQ_LOW__MASK             0xFF      

/* SFR3 */
#define RC8CODEW_DVBSX_DEMOD_SFR3                                    0x000000fc
#define RC8CODEW_DVBSX_DEMOD_SFR3__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_SFR3_SYMB_FREQ__MASK                    0xFF      

/* SFR2 */
#define RC8CODEW_DVBSX_DEMOD_SFR2                                    0x000000fd
#define RC8CODEW_DVBSX_DEMOD_SFR2__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_SFR2_SYMB_FREQ__MASK                    0xFF      

/* SFR1 */
#define RC8CODEW_DVBSX_DEMOD_SFR1                                    0x000000fe
#define RC8CODEW_DVBSX_DEMOD_SFR1__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_SFR1_SYMB_FREQ__MASK                    0xFF      

/* SFR0 */
#define RC8CODEW_DVBSX_DEMOD_SFR0                                    0x000000ff
#define RC8CODEW_DVBSX_DEMOD_SFR0__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_SFR0_SYMB_FREQ__MASK                    0xFF      

/* TMGREG2 */
#define RC8CODEW_DVBSX_DEMOD_TMGREG2                                 0x00000100
#define RC8CODEW_DVBSX_DEMOD_TMGREG2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGREG2_TMGREG__MASK                    0xFF      

/* TMGREG1 */
#define RC8CODEW_DVBSX_DEMOD_TMGREG1                                 0x00000101
#define RC8CODEW_DVBSX_DEMOD_TMGREG1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGREG1_TMGREG__MASK                    0xFF      

/* TMGREG0 */
#define RC8CODEW_DVBSX_DEMOD_TMGREG0                                 0x00000102
#define RC8CODEW_DVBSX_DEMOD_TMGREG0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGREG0_TMGREG__MASK                    0xFF      

/* TMGLOCK1 */
#define RC8CODEW_DVBSX_DEMOD_TMGLOCK1                                0x00000103
#define RC8CODEW_DVBSX_DEMOD_TMGLOCK1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGLOCK1_TMGLOCK_LEVEL__MASK            0xFF      

/* TMGLOCK0 */
#define RC8CODEW_DVBSX_DEMOD_TMGLOCK0                                0x00000104
#define RC8CODEW_DVBSX_DEMOD_TMGLOCK0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGLOCK0_TMGLOCK_LEVEL__MASK            0xFF      

/* TMGOBS */
#define RC8CODEW_DVBSX_DEMOD_TMGOBS                                  0x00000105
#define RC8CODEW_DVBSX_DEMOD_TMGOBS__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_TMGOBS_TMG_SCANFAIL__MASK               0x02      
#define FC8CODEW_DVBSX_DEMOD_TMGOBS_CHCENTERING_MODE__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_TMGOBS_TMG_SCANNING__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_TMGOBS_SCAN_SIGN__MASK                  0x10      
#define FC8CODEW_DVBSX_DEMOD_TMGOBS_ROLLOFF_STATUS__MASK             0xE0      

/* DMDCODSFR2 */
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR2                              0x00000106
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCODSFR2_DEMOD_CODGAMMA__MASK         0xFF      

/* DMDCODSFR1 */
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR1                              0x00000107
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCODSFR1_DEMOD_CODGAMMA__MASK         0xFF      

/* DMDCODSFR0 */
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR0                              0x00000108
#define RC8CODEW_DVBSX_DEMOD_DMDCODSFR0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDCODSFR0_DEMOD_CODGAMMA__MASK         0xFF      

/* DFECFG */
#define RC8CODEW_DVBSX_DEMOD_DFECFG                                  0x00000110
#define RC8CODEW_DVBSX_DEMOD_DFECFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DFECFG_DFEFILT_BETA__MASK               0x07      
#define FC8CODEW_DVBSX_DEMOD_DFECFG_XFEFIELD_SELECT__MASK            0x38      
#define FC8CODEW_DVBSX_DEMOD_DFECFG_DFEFILT_ON__MASK                 0x40      
#define FC8CODEW_DVBSX_DEMOD_DFECFG_DFE_NEWCALC__MASK                0x80      

/* FFECFG */
#define RC8CODEW_DVBSX_DEMOD_FFECFG                                  0x00000111
#define RC8CODEW_DVBSX_DEMOD_FFECFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_FFECFG_FFEFILT_BETA__MASK               0x07      
#define FC8CODEW_DVBSX_DEMOD_FFECFG_EXTXFE_SELECT__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_FFECFG_FFENCALC_OFF__MASK               0x10      
#define FC8CODEW_DVBSX_DEMOD_FFECFG_FFEFILT_ON__MASK                 0x40      
#define FC8CODEW_DVBSX_DEMOD_FFECFG_FFE_NEWCALC__MASK                0x80      

/* XFECFG */
#define RC8CODEW_DVBSX_DEMOD_XFECFG                                  0x00000112
#define RC8CODEW_DVBSX_DEMOD_XFECFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_XFECFG_EGAL_POSTCAR3__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_XFECFG_EGAL_NOSATRST__MASK              0x02      
#define FC8CODEW_DVBSX_DEMOD_XFECFG_EGAL_DVBS2RST__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_XFECFG_EGAL_STARTCALC__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_XFECFG_NOTMG_NEGALWAIT__MASK            0x30      
#define FC8CODEW_DVBSX_DEMOD_XFECFG_EGALCALC_OBS__MASK               0x80      

/* XFECFG2 */
#define RC8CODEW_DVBSX_DEMOD_XFECFG2                                 0x00000113
#define RC8CODEW_DVBSX_DEMOD_XFECFG2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_XFECFG2_EQUAL_USEDSYMB__MASK            0x03      
#define FC8CODEW_DVBSX_DEMOD_XFECFG2_XFECALC_N256APSK__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_XFECFG2_EGALAGC2_DEBUG__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_XFECFG2_EXTWDFE_SELECT__MASK            0x10      

/* PEGALCFG */
#define RC8CODEW_DVBSX_DEMOD_PEGALCFG                                0x00000114
#define RC8CODEW_DVBSX_DEMOD_PEGALCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALAGC2_IMMEDIAT__MASK        0x01      
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALAGC2_PZERO__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALAGC2_NTMG__MASK            0x0C      
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALAGC2_NDATA__MASK           0x10      
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALPLH_MAN__MASK              0x40      
#define FC8CODEW_DVBSX_DEMOD_PEGALCFG_EGALAGC2_MAN__MASK             0x80      

/* WDFECFG */
#define RC8CODEW_DVBSX_DEMOD_WDFECFG                                 0x00000115
#define RC8CODEW_DVBSX_DEMOD_WDFECFG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFECFG_WDFEFILT_BETA__MASK             0x07      
#define FC8CODEW_DVBSX_DEMOD_WDFECFG_EGALWDFE_SIZE__MASK             0x18      
#define FC8CODEW_DVBSX_DEMOD_WDFECFG_WDFEFILT_MODE__MASK             0x60      
#define FC8CODEW_DVBSX_DEMOD_WDFECFG_WDFE_NEWCALC__MASK              0x80      

/* WDFERCFG */
#define RC8CODEW_DVBSX_DEMOD_WDFERCFG                                0x00000116
#define RC8CODEW_DVBSX_DEMOD_WDFERCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFERCFG_WDFERFILT_BETA__MASK           0x07      
#define FC8CODEW_DVBSX_DEMOD_WDFERCFG_WDFER_DEBUG__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_WDFERCFG_WDFER_MODE__MASK               0x30      
#define FC8CODEW_DVBSX_DEMOD_WDFERCFG_NWDFER_ORDERING__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_WDFERCFG_WDFER_NEWCALC__MASK            0x80      

/* WDFERAMPOS */
#define RC8CODEW_DVBSX_DEMOD_WDFERAMPOS                              0x00000117
#define RC8CODEW_DVBSX_DEMOD_WDFERAMPOS__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFERAMPOS_WDFERAM_POS__MASK            0xFF      

/* WDFERAMI */
#define RC8CODEW_DVBSX_DEMOD_WDFERAMI                                0x00000118
#define RC8CODEW_DVBSX_DEMOD_WDFERAMI__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFERAMI_WDFERAM_I__MASK                0xFF      

/* WDFERAMQ */
#define RC8CODEW_DVBSX_DEMOD_WDFERAMQ                                0x00000119
#define RC8CODEW_DVBSX_DEMOD_WDFERAMQ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFERAMQ_WDFERAM_Q__MASK                0xFF      

/* WDFEROBS */
#define RC8CODEW_DVBSX_DEMOD_WDFEROBS                                0x0000011a
#define RC8CODEW_DVBSX_DEMOD_WDFEROBS__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEROBS_WDFEOBS_VAL__MASK              0xFF      

/* DFESTNBR */
#define RC8CODEW_DVBSX_DEMOD_DFESTNBR                                0x0000011b
#define RC8CODEW_DVBSX_DEMOD_DFESTNBR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DFESTNBR_DFENBR_VAL__MASK               0x7F      
#define FC8CODEW_DVBSX_DEMOD_DFESTNBR_WDFE_PRESENCE__MASK            0x80      

/* FFESTNBR */
#define RC8CODEW_DVBSX_DEMOD_FFESTNBR                                0x0000011c
#define RC8CODEW_DVBSX_DEMOD_FFESTNBR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_FFESTNBR_FFENBR_VAL__MASK               0x7F      

/* EQUAI1 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI1                                  0x00000120
#define RC8CODEW_DVBSX_DEMOD_EQUAI1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI1_EQUA_ACCI1__MASK                 0xFF      

/* EQUAQ1 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ1                                  0x00000121
#define RC8CODEW_DVBSX_DEMOD_EQUAQ1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ1_EQUA_ACCQ1__MASK                 0xFF      

/* EQUAI2 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI2                                  0x00000122
#define RC8CODEW_DVBSX_DEMOD_EQUAI2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI2_EQUA_ACCI2__MASK                 0xFF      

/* EQUAQ2 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ2                                  0x00000123
#define RC8CODEW_DVBSX_DEMOD_EQUAQ2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ2_EQUA_ACCQ2__MASK                 0xFF      

/* EQUAI3 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI3                                  0x00000124
#define RC8CODEW_DVBSX_DEMOD_EQUAI3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI3_EQUA_ACCI3__MASK                 0xFF      

/* EQUAQ3 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ3                                  0x00000125
#define RC8CODEW_DVBSX_DEMOD_EQUAQ3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ3_EQUA_ACCQ3__MASK                 0xFF      

/* EQUAI4 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI4                                  0x00000126
#define RC8CODEW_DVBSX_DEMOD_EQUAI4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI4_EQUA_ACCI4__MASK                 0xFF      

/* EQUAQ4 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ4                                  0x00000127
#define RC8CODEW_DVBSX_DEMOD_EQUAQ4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ4_EQUA_ACCQ4__MASK                 0xFF      

/* EQUAI5 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI5                                  0x00000128
#define RC8CODEW_DVBSX_DEMOD_EQUAI5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI5_EQUA_ACCI5__MASK                 0xFF      

/* EQUAQ5 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ5                                  0x00000129
#define RC8CODEW_DVBSX_DEMOD_EQUAQ5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ5_EQUA_ACCQ5__MASK                 0xFF      

/* EQUAI6 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI6                                  0x0000012a
#define RC8CODEW_DVBSX_DEMOD_EQUAI6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI6_EQUA_ACCI6__MASK                 0xFF      

/* EQUAQ6 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ6                                  0x0000012b
#define RC8CODEW_DVBSX_DEMOD_EQUAQ6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ6_EQUA_ACCQ6__MASK                 0xFF      

/* EQUAI7 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI7                                  0x0000012c
#define RC8CODEW_DVBSX_DEMOD_EQUAI7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI7_EQUA_ACCI7__MASK                 0xFF      

/* EQUAQ7 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ7                                  0x0000012d
#define RC8CODEW_DVBSX_DEMOD_EQUAQ7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ7_EQUA_ACCQ7__MASK                 0xFF      

/* EQUAI8 */
#define RC8CODEW_DVBSX_DEMOD_EQUAI8                                  0x0000012e
#define RC8CODEW_DVBSX_DEMOD_EQUAI8__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAI8_EQUA_ACCI8__MASK                 0xFF      

/* EQUAQ8 */
#define RC8CODEW_DVBSX_DEMOD_EQUAQ8                                  0x0000012f
#define RC8CODEW_DVBSX_DEMOD_EQUAQ8__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EQUAQ8_EQUA_ACCQ8__MASK                 0xFF      

/* FFEI1 */
#define RC8CODEW_DVBSX_DEMOD_FFEI1                                   0x00000130
#define RC8CODEW_DVBSX_DEMOD_FFEI1__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEI1_FFE_ACCI1__MASK                   0xFF      

/* FFEQ1 */
#define RC8CODEW_DVBSX_DEMOD_FFEQ1                                   0x00000131
#define RC8CODEW_DVBSX_DEMOD_FFEQ1__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEQ1_FFE_ACCQ1__MASK                   0xFF      

/* FFEI2 */
#define RC8CODEW_DVBSX_DEMOD_FFEI2                                   0x00000132
#define RC8CODEW_DVBSX_DEMOD_FFEI2__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEI2_FFE_ACCI2__MASK                   0xFF      

/* FFEQ2 */
#define RC8CODEW_DVBSX_DEMOD_FFEQ2                                   0x00000133
#define RC8CODEW_DVBSX_DEMOD_FFEQ2__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEQ2_FFE_ACCQ2__MASK                   0xFF      

/* FFEI3 */
#define RC8CODEW_DVBSX_DEMOD_FFEI3                                   0x00000134
#define RC8CODEW_DVBSX_DEMOD_FFEI3__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEI3_FFE_ACCI3__MASK                   0xFF      

/* FFEQ3 */
#define RC8CODEW_DVBSX_DEMOD_FFEQ3                                   0x00000135
#define RC8CODEW_DVBSX_DEMOD_FFEQ3__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEQ3_FFE_ACCQ3__MASK                   0xFF      

/* FFEI4 */
#define RC8CODEW_DVBSX_DEMOD_FFEI4                                   0x00000136
#define RC8CODEW_DVBSX_DEMOD_FFEI4__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEI4_FFE_ACCI4__MASK                   0xFF      

/* FFEQ4 */
#define RC8CODEW_DVBSX_DEMOD_FFEQ4                                   0x00000137
#define RC8CODEW_DVBSX_DEMOD_FFEQ4__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEQ4_FFE_ACCQ4__MASK                   0xFF      

/* FFEI5 */
#define RC8CODEW_DVBSX_DEMOD_FFEI5                                   0x00000138
#define RC8CODEW_DVBSX_DEMOD_FFEI5__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEI5_FFE_ACCI5__MASK                   0xFF      

/* FFEQ5 */
#define RC8CODEW_DVBSX_DEMOD_FFEQ5                                   0x00000139
#define RC8CODEW_DVBSX_DEMOD_FFEQ5__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_FFEQ5_FFE_ACCQ5__MASK                   0xFF      

/* WDFEN1 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN1                                  0x00000140
#define RC8CODEW_DVBSX_DEMOD_WDFEN1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN1_NUM_WDFE1__MASK                  0xFF      

/* WDFEI1 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI1                                  0x00000141
#define RC8CODEW_DVBSX_DEMOD_WDFEI1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI1_I_WDFE1__MASK                    0xFF      

/* WDFEQ1 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ1                                  0x00000142
#define RC8CODEW_DVBSX_DEMOD_WDFEQ1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ1_Q_WDFE1__MASK                    0xFF      

/* WDFEN2 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN2                                  0x00000143
#define RC8CODEW_DVBSX_DEMOD_WDFEN2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN2_NUM_WDFE2__MASK                  0xFF      

/* WDFEI2 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI2                                  0x00000144
#define RC8CODEW_DVBSX_DEMOD_WDFEI2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI2_I_WDFE2__MASK                    0xFF      

/* WDFEQ2 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ2                                  0x00000145
#define RC8CODEW_DVBSX_DEMOD_WDFEQ2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ2_Q_WDFE2__MASK                    0xFF      

/* WDFEN3 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN3                                  0x00000146
#define RC8CODEW_DVBSX_DEMOD_WDFEN3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN3_NUM_WDFE3__MASK                  0xFF      

/* WDFEI3 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI3                                  0x00000147
#define RC8CODEW_DVBSX_DEMOD_WDFEI3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI3_I_WDFE3__MASK                    0xFF      

/* WDFEQ3 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ3                                  0x00000148
#define RC8CODEW_DVBSX_DEMOD_WDFEQ3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ3_Q_WDFE3__MASK                    0xFF      

/* WDFEN4 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN4                                  0x00000149
#define RC8CODEW_DVBSX_DEMOD_WDFEN4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN4_NUM_WDFE4__MASK                  0xFF      

/* WDFEI4 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI4                                  0x0000014a
#define RC8CODEW_DVBSX_DEMOD_WDFEI4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI4_I_WDFE4__MASK                    0xFF      

/* WDFEQ4 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ4                                  0x0000014b
#define RC8CODEW_DVBSX_DEMOD_WDFEQ4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ4_Q_WDFE4__MASK                    0xFF      

/* WDFEN5 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN5                                  0x0000014c
#define RC8CODEW_DVBSX_DEMOD_WDFEN5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN5_NUM_WDFE5__MASK                  0xFF      

/* WDFEI5 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI5                                  0x0000014d
#define RC8CODEW_DVBSX_DEMOD_WDFEI5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI5_I_WDFE5__MASK                    0xFF      

/* WDFEQ5 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ5                                  0x0000014e
#define RC8CODEW_DVBSX_DEMOD_WDFEQ5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ5_Q_WDFE5__MASK                    0xFF      

/* WDFEN6 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN6                                  0x0000014f
#define RC8CODEW_DVBSX_DEMOD_WDFEN6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN6_NUM_WDFE6__MASK                  0xFF      

/* WDFEI6 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI6                                  0x00000150
#define RC8CODEW_DVBSX_DEMOD_WDFEI6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI6_I_WDFE6__MASK                    0xFF      

/* WDFEQ6 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ6                                  0x00000151
#define RC8CODEW_DVBSX_DEMOD_WDFEQ6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ6_Q_WDFE6__MASK                    0xFF      

/* WDFEN7 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN7                                  0x00000152
#define RC8CODEW_DVBSX_DEMOD_WDFEN7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN7_NUM_WDFE7__MASK                  0xFF      

/* WDFEI7 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI7                                  0x00000153
#define RC8CODEW_DVBSX_DEMOD_WDFEI7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI7_I_WDFE7__MASK                    0xFF      

/* WDFEQ7 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ7                                  0x00000154
#define RC8CODEW_DVBSX_DEMOD_WDFEQ7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ7_Q_WDFE7__MASK                    0xFF      

/* WDFEN8 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN8                                  0x00000155
#define RC8CODEW_DVBSX_DEMOD_WDFEN8__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN8_NUM_WDFE8__MASK                  0xFF      

/* WDFEI8 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI8                                  0x00000156
#define RC8CODEW_DVBSX_DEMOD_WDFEI8__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI8_I_WDFE8__MASK                    0xFF      

/* WDFEQ8 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ8                                  0x00000157
#define RC8CODEW_DVBSX_DEMOD_WDFEQ8__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ8_Q_WDFE8__MASK                    0xFF      

/* WDFEN9 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN9                                  0x00000158
#define RC8CODEW_DVBSX_DEMOD_WDFEN9__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN9_NUM_WDFE9__MASK                  0xFF      

/* WDFEI9 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI9                                  0x00000159
#define RC8CODEW_DVBSX_DEMOD_WDFEI9__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI9_I_WDFE9__MASK                    0xFF      

/* WDFEQ9 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ9                                  0x0000015a
#define RC8CODEW_DVBSX_DEMOD_WDFEQ9__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ9_Q_WDFE9__MASK                    0xFF      

/* WDFEN10 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN10                                 0x0000015b
#define RC8CODEW_DVBSX_DEMOD_WDFEN10__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN10_NUM_WDFE10__MASK                0xFF      

/* WDFEI10 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI10                                 0x0000015c
#define RC8CODEW_DVBSX_DEMOD_WDFEI10__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI10_I_WDFE10__MASK                  0xFF      

/* WDFEQ10 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ10                                 0x0000015d
#define RC8CODEW_DVBSX_DEMOD_WDFEQ10__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ10_Q_WDFE10__MASK                  0xFF      

/* WDFEN11 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN11                                 0x0000015e
#define RC8CODEW_DVBSX_DEMOD_WDFEN11__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN11_NUM_WDFE11__MASK                0xFF      

/* WDFEI11 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI11                                 0x0000015f
#define RC8CODEW_DVBSX_DEMOD_WDFEI11__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI11_I_WDFE11__MASK                  0xFF      

/* CAR2CFG */
#define RC8CODEW_DVBSX_DEMOD_CAR2CFG                                 0x00000160
#define RC8CODEW_DVBSX_DEMOD_CAR2CFG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_PH_DET_ALGO2__MASK              0x03      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_ROTA2ON__MASK                   0x04      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_STOP_NCO2UPDATE__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_STOP_CFR2UPDATE__MASK           0x10      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_EN_PHNOSRAM__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_STOPCAR2_DELFRAME__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_CAR2CFG_DESCRAMB_OFF__MASK              0x80      

/* CFR2CFR1 */
#define RC8CODEW_DVBSX_DEMOD_CFR2CFR1                                0x00000161
#define RC8CODEW_DVBSX_DEMOD_CFR2CFR1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR2CFR1_CFR2TOCFR1_BETA__MASK          0x07      
#define FC8CODEW_DVBSX_DEMOD_CFR2CFR1_BCHERRCFR2_MODE__MASK          0x18      
#define FC8CODEW_DVBSX_DEMOD_CFR2CFR1_EN_S2CAR2CENTER__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_CFR2CFR1_CFR2_S2CONTROL__MASK           0xC0      

/* CAR3CFG */
#define RC8CODEW_DVBSX_DEMOD_CAR3CFG                                 0x00000162
#define RC8CODEW_DVBSX_DEMOD_CAR3CFG__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CAR3CFG_CARRIER3_ALPHA3DL__MASK         0x07      
#define FC8CODEW_DVBSX_DEMOD_CAR3CFG_ABAMPLIF_MODE__MASK             0x18      
#define FC8CODEW_DVBSX_DEMOD_CAR3CFG_CAR3INTERM_DVBS1__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_CAR3CFG_CARRIER23_MODE__MASK            0xC0      

/* CFR22 */
#define RC8CODEW_DVBSX_DEMOD_CFR22                                   0x00000163
#define RC8CODEW_DVBSX_DEMOD_CFR22__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR22_CAR2_FREQ__MASK                   0xFF      

/* CFR21 */
#define RC8CODEW_DVBSX_DEMOD_CFR21                                   0x00000164
#define RC8CODEW_DVBSX_DEMOD_CFR21__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR21_CAR2_FREQ__MASK                   0xFF      

/* CFR20 */
#define RC8CODEW_DVBSX_DEMOD_CFR20                                   0x00000165
#define RC8CODEW_DVBSX_DEMOD_CFR20__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR20_CAR2_FREQ__MASK                   0xFF      

/* ACLC2S1 */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S1                                 0x00000168
#define RC8CODEW_DVBSX_DEMOD_ACLC2S1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S1_CAR2S1_ALPHA_EXP__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S1_CAR2S1_ALPHA_MANT__MASK         0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S1_CAR2S1_ANOSAUTO__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S1_NOSRAM_COEFOBS__MASK            0x80      

/* ACLC2S2Q */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2Q                                0x00000169
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2Q__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2Q_CAR2S2_Q_ALPH_E__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2Q_CAR2S2_Q_ALPH_M__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2Q_CAR2S2_QANOSAUTO__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2Q_ENAB_SPSKSYMB__MASK            0x80      

/* ACLC2S28 */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S28                                0x0000016a
#define RC8CODEW_DVBSX_DEMOD_ACLC2S28__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S28_CAR2S2_8_ALPH_E__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S28_CAR2S2_8_ALPH_M__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S28_CAR2S2_8ANOSAUTO__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S28_PLFCALC_MODE__MASK             0x80      

/* ACLC2S216A */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S216A                              0x0000016b
#define RC8CODEW_DVBSX_DEMOD_ACLC2S216A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S216A_CAR2S2_16A_ALPH_E__MASK      0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S216A_CAR2S2_16A_ALPH_M__MASK      0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S216A_CAR2S2_16ANOSAUTO__MASK      0x40      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S216A_DIS_CPHERR__MASK             0x80      

/* ACLC2S232A */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S232A                              0x0000016c
#define RC8CODEW_DVBSX_DEMOD_ACLC2S232A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S232A_CAR2S2_32A_ALPH_E__MASK      0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S232A_CAR2S2_32A_ALPH_M__MASK      0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S232A_CAR2S2_32ANOSAUTO__MASK      0x40      

/* ACLC2S264A */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S264A                              0x0000016d
#define RC8CODEW_DVBSX_DEMOD_ACLC2S264A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S264A_CAR2S2_64APSK_ALPHA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S264A_CAR2S2_64APSK_ALPHA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S264A_CAR2S2_64ANOSAUTO__MASK      0x40      

/* ACLC2S2128A */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2128A                             0x0000016e
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2128A__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2128A_CAR2S2_128APSK_ALPHA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2128A_CAR2S2_128APSK_ALPHA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2128A_CAR2S2_128ANOSAUTO__MASK    0x40      

/* ACLC2S2256A */
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2256A                             0x0000016f
#define RC8CODEW_DVBSX_DEMOD_ACLC2S2256A__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2256A_CAR2S2_256APSK_ALPHA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2256A_CAR2S2_256APSK_ALPHA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_ACLC2S2256A_CAR2S2_256ANOSAUTO__MASK    0x40      

/* BCLC2S1 */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S1                                 0x00000170
#define RC8CODEW_DVBSX_DEMOD_BCLC2S1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S1_CAR2S1_BETA_EXP__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S1_CAR2S1_BETA_MANT__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S1_CAR2S1_BNOSAUTO__MASK           0x40      

/* BCLC2S2Q */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2Q                                0x00000171
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2Q__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2Q_CAR2S2_Q_BETA_E__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2Q_CAR2S2_Q_BETA_M__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2Q_CAR2S2_QBNOSAUTO__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2Q_DVBS2S2Q_NIP__MASK             0x80      

/* BCLC2S28 */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S28                                0x00000172
#define RC8CODEW_DVBSX_DEMOD_BCLC2S28__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S28_CAR2S2_8_BETA_E__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S28_CAR2S2_8_BETA_M__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S28_CAR2S2_8BNOSAUTO__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S28_DVBS2S28_NIP__MASK             0x80      

/* BCLC2S216A */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S216A                              0x00000173
#define RC8CODEW_DVBSX_DEMOD_BCLC2S216A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S216A_CAR2S2_16A_BETA_E__MASK      0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S216A_CAR2S2_16A_BETA_M__MASK      0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S216A_CAR2S2_16BNOSAUTO__MASK      0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S216A_DVBS2S216A_NIP__MASK         0x80      

/* BCLC2S232A */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S232A                              0x00000174
#define RC8CODEW_DVBSX_DEMOD_BCLC2S232A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S232A_CAR2S2_32A_BETA_E__MASK      0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S232A_CAR2S2_32A_BETA_M__MASK      0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S232A_CAR2S2_32BNOSAUTO__MASK      0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S232A_DVBS2S232A_NIP__MASK         0x80      

/* BCLC2S264A */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S264A                              0x00000175
#define RC8CODEW_DVBSX_DEMOD_BCLC2S264A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S264A_CAR2S2_64APSK_BETA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S264A_CAR2S2_64APSK_BETA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S264A_CAR2S2_64BNOSAUTO__MASK      0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S264A_DVBS2S264A_NIP__MASK         0x80      

/* BCLC2S2128A */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2128A                             0x00000176
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2128A__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2128A_CAR2S2_128APSK_BETA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2128A_CAR2S2_128APSK_BETA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2128A_CAR2S2_128BNOSAUTO__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2128A_DVBS2S2128A_NIP__MASK       0x80      

/* BCLC2S2256A */
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2256A                             0x00000177
#define RC8CODEW_DVBSX_DEMOD_BCLC2S2256A__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2256A_CAR2S2_256APSK_BETA_EXP__MASK 0x0F      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2256A_CAR2S2_256APSK_BETA_MANTISSE__MASK 0x30      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2256A_CAR2S2_256BNOSAUTO__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_BCLC2S2256A_DVBS2S2256A_NIP__MASK       0x80      

/* NCO2MAX1 */
#define RC8CODEW_DVBSX_DEMOD_NCO2MAX1                                0x00000184
#define RC8CODEW_DVBSX_DEMOD_NCO2MAX1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX1_TETA2MAX_VABS__MASK            0xFF      

/* NCO2MAX0 */
#define RC8CODEW_DVBSX_DEMOD_NCO2MAX0                                0x00000185
#define RC8CODEW_DVBSX_DEMOD_NCO2MAX0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX0_TETA3L_RSTCHG__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX0_TETA3D_RSTCHG__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX0_TETA2A_RSTCHG__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX0_TETA2T_RSTCHG__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_NCO2MAX0_TETA2MAX_VABS__MASK            0xF0      

/* NCO2FR1 */
#define RC8CODEW_DVBSX_DEMOD_NCO2FR1                                 0x00000186
#define RC8CODEW_DVBSX_DEMOD_NCO2FR1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_NCO2FR1_NCO2MAX_VABS__MASK              0xFF      

/* NCO2FR0 */
#define RC8CODEW_DVBSX_DEMOD_NCO2FR0                                 0x00000187
#define RC8CODEW_DVBSX_DEMOD_NCO2FR0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_NCO2FR0_TETA3L_DAMPLON__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_NCO2FR0_TETA3D_DAMPLON__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_NCO2FR0_TETA2_DAMPLON__MASK             0x04      
#define FC8CODEW_DVBSX_DEMOD_NCO2FR0_TETA1_DAMPLON__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_NCO2FR0_NCO2MAX_VABS__MASK              0xF0      

/* CFR2AVRGE1 */
#define RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1                              0x00000188
#define RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR2AVRGE1_I2C_CFR2AVERAGE__MASK        0xFF      

/* CFR2AVRGE0 */
#define RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0                              0x00000189
#define RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_CFR2AVRGE0_I2C_CFR2AVERAGE__MASK        0xFF      

/* DPILOTMAX1 */
#define RC8CODEW_DVBSX_DEMOD_DPILOTMAX1                              0x0000018a
#define RC8CODEW_DVBSX_DEMOD_DPILOTMAX1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DPILOTMAX1_ABSDIFF_PILOTRAMPE_MAX__MASK 0xFF      

/* DPILOTMAX0 */
#define RC8CODEW_DVBSX_DEMOD_DPILOTMAX0                              0x0000018b
#define RC8CODEW_DVBSX_DEMOD_DPILOTMAX0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DPILOTMAX0_ABSDIFF_PILOTRAMPE_MAX__MASK 0xFF      

/* NOSCFG */
#define RC8CODEW_DVBSX_DEMOD_NOSCFG                                  0x00000198
#define RC8CODEW_DVBSX_DEMOD_NOSCFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSCFG_NOSDATA_BETA__MASK               0x07      
#define FC8CODEW_DVBSX_DEMOD_NOSCFG_NOSPLH_BETA__MASK                0x18      
#define FC8CODEW_DVBSX_DEMOD_NOSCFG_DUMMYPL_NOSDATA__MASK            0x20      
#define FC8CODEW_DVBSX_DEMOD_NOSCFG_NOSIN_EGALSEL__MASK              0x40      
#define FC8CODEW_DVBSX_DEMOD_NOSCFG_DIS_ACMRATIO__MASK               0x80      

/* NOSCFGF1 */
#define RC8CODEW_DVBSX_DEMOD_NOSCFGF1                                0x00000199
#define RC8CODEW_DVBSX_DEMOD_NOSCFGF1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF1_FRAMESEL_TYPE__MASK            0x03      
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF1_FRAMESEL_TYPESEL__MASK         0x0C      
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF1_NOSDATA_MODE__MASK             0x30      
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF1_NOS_DELFRAME__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF1_LOWNOISE_MESURE__MASK          0x80      

/* NOSCFGF2 */
#define RC8CODEW_DVBSX_DEMOD_NOSCFGF2                                0x0000019a
#define RC8CODEW_DVBSX_DEMOD_NOSCFGF2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF2_FRAMESEL_MODCOD__MASK          0x3F      
#define FC8CODEW_DVBSX_DEMOD_NOSCFGF2_FRAMESEL_MODCODSEL__MASK       0xC0      

/* NNOSDATAT1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSDATAT1                              0x000001a0
#define RC8CODEW_DVBSX_DEMOD_NNOSDATAT1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSDATAT1_NOSDATAT_NORMED__MASK        0xFF      

/* NNOSDATAT0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSDATAT0                              0x000001a1
#define RC8CODEW_DVBSX_DEMOD_NNOSDATAT0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSDATAT0_NOSDATAT_NORMED__MASK        0xFF      

/* NNOSDATA1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSDATA1                               0x000001a2
#define RC8CODEW_DVBSX_DEMOD_NNOSDATA1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSDATA1_NOSDATA_NORMED__MASK          0xFF      

/* NNOSDATA0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSDATA0                               0x000001a3
#define RC8CODEW_DVBSX_DEMOD_NNOSDATA0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSDATA0_NOSDATA_NORMED__MASK          0xFF      

/* NNOSPLHT1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSPLHT1                               0x000001a4
#define RC8CODEW_DVBSX_DEMOD_NNOSPLHT1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSPLHT1_NOSPLHT_NORMED__MASK          0xFF      

/* NNOSPLHT0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSPLHT0                               0x000001a5
#define RC8CODEW_DVBSX_DEMOD_NNOSPLHT0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSPLHT0_NOSPLHT_NORMED__MASK          0xFF      

/* NNOSPLH1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSPLH1                                0x000001a6
#define RC8CODEW_DVBSX_DEMOD_NNOSPLH1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSPLH1_NOSPLH_NORMED__MASK            0xFF      

/* NNOSPLH0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSPLH0                                0x000001a7
#define RC8CODEW_DVBSX_DEMOD_NNOSPLH0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSPLH0_NOSPLH_NORMED__MASK            0xFF      

/* NOSDATAT1 */
#define RC8CODEW_DVBSX_DEMOD_NOSDATAT1                               0x000001a8
#define RC8CODEW_DVBSX_DEMOD_NOSDATAT1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSDATAT1_NOSDATAT_UNNORMED__MASK       0xFF      

/* NOSDATAT0 */
#define RC8CODEW_DVBSX_DEMOD_NOSDATAT0                               0x000001a9
#define RC8CODEW_DVBSX_DEMOD_NOSDATAT0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSDATAT0_NOSDATAT_UNNORMED__MASK       0xFF      

/* NNOSFRAME1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSFRAME1                              0x000001aa
#define RC8CODEW_DVBSX_DEMOD_NNOSFRAME1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSFRAME1_NOSFRAME_NORMED__MASK        0xFF      

/* NNOSFRAME0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSFRAME0                              0x000001ab
#define RC8CODEW_DVBSX_DEMOD_NNOSFRAME0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSFRAME0_NOSFRAME_NORMED__MASK        0xFF      

/* NNOSRAD1 */
#define RC8CODEW_DVBSX_DEMOD_NNOSRAD1                                0x000001ac
#define RC8CODEW_DVBSX_DEMOD_NNOSRAD1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSRAD1_NOSRADIAL_NORMED__MASK         0xFF      

/* NNOSRAD0 */
#define RC8CODEW_DVBSX_DEMOD_NNOSRAD0                                0x000001ad
#define RC8CODEW_DVBSX_DEMOD_NNOSRAD0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NNOSRAD0_NOSRADIAL_NORMED__MASK         0xFF      

/* NOSRAMCNR1 */
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1                              0x000001ae
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCNR1_NOSRAM_CNRVAL_EXT__MASK      0x1F      

/* NOSRAMCNR0 */
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0                              0x000001af
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCNR0_NOSRAM_CNRVAL_EXT__MASK      0xFF      

/* NOSTHRES1 */
#define RC8CODEW_DVBSX_DEMOD_NOSTHRES1                               0x000001c0
#define RC8CODEW_DVBSX_DEMOD_NOSTHRES1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSTHRES1_NOS_THRESHOLD1__MASK          0xFF      

/* NOSTHRES2 */
#define RC8CODEW_DVBSX_DEMOD_NOSTHRES2                               0x000001c1
#define RC8CODEW_DVBSX_DEMOD_NOSTHRES2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSTHRES2_NOS_THRESHOLD2__MASK          0xFF      

/* NOSDIFF1 */
#define RC8CODEW_DVBSX_DEMOD_NOSDIFF1                                0x000001c2
#define RC8CODEW_DVBSX_DEMOD_NOSDIFF1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSDIFF1_NOSTHRES1_DIFF__MASK           0xFF      

/* RAINFADE */
#define RC8CODEW_DVBSX_DEMOD_RAINFADE                                0x000001c3
#define RC8CODEW_DVBSX_DEMOD_RAINFADE__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_RAINFADE_RAINFADE_TIMEOUT__MASK         0x07      
#define FC8CODEW_DVBSX_DEMOD_RAINFADE_RAINFADE_CNLIMIT__MASK         0x70      
#define FC8CODEW_DVBSX_DEMOD_RAINFADE_NOSTHRES_UNITS__MASK           0x80      

/* NOSRAMCFG */
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCFG                               0x000001c4
#define RC8CODEW_DVBSX_DEMOD_NOSRAMCFG__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCFG_NOSRAM_LGNCNR__MASK           0x07      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCFG_NOSRAM_CNRONLY__MASK          0x08      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCFG_NOSRAM_ACTIVATION__MASK       0x30      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCFG_NOSRAM_QUADRAT__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMCFG_NOSRAM_DVBS2DATA__MASK        0x80      

/* NOSRAMPOS */
#define RC8CODEW_DVBSX_DEMOD_NOSRAMPOS                               0x000001c5
#define RC8CODEW_DVBSX_DEMOD_NOSRAMPOS__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSRAMPOS_NOSRAM_CNRVAL__MASK           0x03      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMPOS_NOSRAM_VALIDE__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_NOSRAMPOS_NOSRAM_LGNCNR__MASK           0xF0      

/* NOSRAMVAL */
#define RC8CODEW_DVBSX_DEMOD_NOSRAMVAL                               0x000001c6
#define RC8CODEW_DVBSX_DEMOD_NOSRAMVAL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_NOSRAMVAL_NOSRAM_CNRVAL__MASK           0xFF      

/* SOFCODE3 */
#define RC8CODEW_DVBSX_DEMOD_SOFCODE3                                0x000001d0
#define RC8CODEW_DVBSX_DEMOD_SOFCODE3__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SOFCODE3_USER_SOF_SEQUENCE__MASK        0x03      
#define FC8CODEW_DVBSX_DEMOD_SOFCODE3_USER_SOF_PROG__MASK            0x1C      
#define FC8CODEW_DVBSX_DEMOD_SOFCODE3_EGALPLH_MUXING__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_SOFCODE3_USERPLHEADER_ON__MASK          0xC0      

/* SOFCODE2 */
#define RC8CODEW_DVBSX_DEMOD_SOFCODE2                                0x000001d1
#define RC8CODEW_DVBSX_DEMOD_SOFCODE2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SOFCODE2_USER_SOF_SEQUENCE__MASK        0xFF      

/* SOFCODE1 */
#define RC8CODEW_DVBSX_DEMOD_SOFCODE1                                0x000001d2
#define RC8CODEW_DVBSX_DEMOD_SOFCODE1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SOFCODE1_USER_SOF_SEQUENCE__MASK        0xFF      

/* SOFCODE0 */
#define RC8CODEW_DVBSX_DEMOD_SOFCODE0                                0x000001d3
#define RC8CODEW_DVBSX_DEMOD_SOFCODE0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_SOFCODE0_USER_SOF_SEQUENCE__MASK        0xFF      

/* PLSSCRAMB7 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7                              0x000001d4
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB7_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB6 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6                              0x000001d5
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB6_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB5 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5                              0x000001d6
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB5_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB4 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4                              0x000001d7
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB4_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB3 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3                              0x000001d8
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB3_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB2 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2                              0x000001d9
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB2_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB1 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1                              0x000001da
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB1_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSSCRAMB0 */
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0                              0x000001db
#define RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSSCRAMB0_USER_PLSSCRAMB_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMBB */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB                             0x000001dc
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_USER_PLSSCRAMBM_SEQUENCE__MASK 0x03      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_MPLS_PERMUTE__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_PLFNUM_PERMUTE__MASK        0x08      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_EN_DVBS2ORIG__MASK          0x10      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_EN_DVBS2EXT__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_EN_ANNEXEM__MASK            0x40      
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB_PLHDETECT_SERIE__MASK       0x80      

/* PLSMSCRAMBA */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA                             0x000001dd
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB9 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9                             0x000001de
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB8 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8                             0x000001df
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB7 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7                             0x000001e0
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB6 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6                             0x000001e1
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB5 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5                             0x000001e2
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB4 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4                             0x000001e3
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB3 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3                             0x000001e4
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB2 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2                             0x000001e5
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB1 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1                             0x000001e6
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLSMSCRAMB0 */
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0                             0x000001e7
#define RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0_USER_PLSSCRAMBM_SEQUENCE__MASK 0xFF      

/* PLROOT2 */
#define RC8CODEW_DVBSX_DEMOD_PLROOT2                                 0x000001ec
#define RC8CODEW_DVBSX_DEMOD_PLROOT2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_PLROOT2_PLSCRAMB_ROOT__MASK             0x03      
#define FC8CODEW_DVBSX_DEMOD_PLROOT2_PLSCRAMB_MODE__MASK             0x0C      
#define FC8CODEW_DVBSX_DEMOD_PLROOT2_PLHAUTO_FASTMODE__MASK          0x10      
#define FC8CODEW_DVBSX_DEMOD_PLROOT2_PLHAUTO_MODE__MASK              0xE0      

/* PLROOT1 */
#define RC8CODEW_DVBSX_DEMOD_PLROOT1                                 0x000001ed
#define RC8CODEW_DVBSX_DEMOD_PLROOT1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_PLROOT1_PLSCRAMB_ROOT__MASK             0xFF      

/* PLROOT0 */
#define RC8CODEW_DVBSX_DEMOD_PLROOT0                                 0x000001ee
#define RC8CODEW_DVBSX_DEMOD_PLROOT0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_PLROOT0_PLSCRAMB_ROOT__MASK             0xFF      

/* MODCODLST0 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST0                              0x00000200
#define RC8CODEW_DVBSX_DEMOD_MODCODLST0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_NACCES_MODCODCH__MASK        0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_NOSPLHT_NOPILOT__MASK        0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_MODCOD_RESLST__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_MODCODRQ_MODE__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_SYNCTAG_SELECT__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST0_MODCODRQ_NRSTTOK__MASK       0x80      

/* MODCODLST1 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST1                              0x00000201
#define RC8CODEW_DVBSX_DEMOD_MODCODLST1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_DIS_32PSK_9_10__MASK         0x03      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_NRESET_MODCODLST__MASK       0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_SYMBRATE_FILTER__MASK        0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_HIER_MODCODSEL__MASK         0x30      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_AUTODET_HIERSFEC__MASK       0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST1_EN_HIERSFEC__MASK            0x80      

/* MODCODLST2 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST2                              0x00000202
#define RC8CODEW_DVBSX_DEMOD_MODCODLST2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST2_DIS_32PSK_5_6__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST2_DIS_32PSK_8_9__MASK          0xF0      

/* MODCODLST3 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST3                              0x00000203
#define RC8CODEW_DVBSX_DEMOD_MODCODLST3__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST3_DIS_32PSK_3_4__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST3_DIS_32PSK_4_5__MASK          0xF0      

/* MODCODLST4 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST4                              0x00000204
#define RC8CODEW_DVBSX_DEMOD_MODCODLST4__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST4_DIS_16PSK_8_9__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST4_DIS_16PSK_9_10__MASK         0x30      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST4_DUMMYPL_NOPILOT__MASK        0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST4_DUMMYPL_PILOT__MASK          0x80      

/* MODCODLST5 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST5                              0x00000205
#define RC8CODEW_DVBSX_DEMOD_MODCODLST5__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST5_DIS_16PSK_4_5__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST5_DIS_16PSK_5_6__MASK          0xF0      

/* MODCODLST6 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST6                              0x00000206
#define RC8CODEW_DVBSX_DEMOD_MODCODLST6__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST6_DIS_16PSK_2_3__MASK          0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST6_DIS_16PSK_3_4__MASK          0xF0      

/* MODCODLST7 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST7                              0x00000207
#define RC8CODEW_DVBSX_DEMOD_MODCODLST7__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST7_DIS_8P_8_9__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST7_DIS_8PSK_9_10__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST7_MODCOD_NNOSFILTER__MASK      0x80      

/* MODCODLST8 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST8                              0x00000208
#define RC8CODEW_DVBSX_DEMOD_MODCODLST8__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST8_DIS_8P_3_4__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST8_DIS_8P_5_6__MASK             0xF0      

/* MODCODLST9 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLST9                              0x00000209
#define RC8CODEW_DVBSX_DEMOD_MODCODLST9__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLST9_DIS_8P_3_5__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLST9_DIS_8P_2_3__MASK             0xF0      

/* MODCODLSTA */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTA                              0x0000020a
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTA__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTA_DIS_QP_8_9__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTA_DIS_QPSK_9_10__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTA_NOSFILTER_MODE__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTA_NOSFILTER_LIMITE__MASK       0x80      

/* MODCODLSTB */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTB                              0x0000020b
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTB__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTB_DIS_QP_4_5__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTB_DIS_QP_5_6__MASK             0xF0      

/* MODCODLSTC */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTC                              0x0000020c
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTC__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTC_DIS_QP_2_3__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTC_DIS_QP_3_4__MASK             0xF0      

/* MODCODLSTD */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTD                              0x0000020d
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTD__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTD_DIS_QPSK_1_2__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTD_DIS_QPSK_3_5__MASK           0xF0      

/* MODCODLSTE */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTE                              0x0000020e
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTE__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTE_DIS_QPSK_1_3__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTE_DIS_QPSK_2_5__MASK           0xF0      

/* MODCODLSTF */
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTF                              0x0000020f
#define RC8CODEW_DVBSX_DEMOD_MODCODLSTF__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTF_MODCOD_NSTOCK__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTF_DDEMOD_NSET__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTF_DEMODOUT_ENABLE__MASK        0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTF_DEMOD_INVMODLST__MASK        0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLSTF_DIS_QPSK_1_4__MASK           0xF0      

/* MODCODLS10 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS10                              0x00000210
#define RC8CODEW_DVBSX_DEMOD_MODCODLS10__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_32APSK_32_45_SH_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_32APSK_32_45_SH_PON__MASK 0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R250_8PSK_PON__MASK      0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R251_16APSK_PON__MASK    0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R252_32APSK_PON__MASK    0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R253_64APSK_PON__MASK    0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R254_256APSK_PON__MASK   0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS10_DIS_R255_1024APSK_PON__MASK  0x80      

/* MODCODLS11 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS11                              0x00000211
#define RC8CODEW_DVBSX_DEMOD_MODCODLS11__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_26_45_SH_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_26_45_SH_PON__MASK 0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_3_5_SH_POFF__MASK 0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_3_5_SH_PON__MASK  0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_32_45_SH_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_16APSK_32_45_SH_PON__MASK 0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_32APSK_2_3_SH_POFF__MASK 0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS11_DIS_32APSK_2_3_SH_PON__MASK  0x80      

/* MODCODLS12 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS12                              0x00000212
#define RC8CODEW_DVBSX_DEMOD_MODCODLS12__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_8PSK_26_45_SH_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_8PSK_26_45_SH_PON__MASK  0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_8PSK_32_45_SH_POFF__MASK 0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_8PSK_32_45_SH_PON__MASK  0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_16APSK_7_15_SH_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_16APSK_7_15_SH_PON__MASK 0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_16APSK_8_15_SH_POFF__MASK 0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS12_DIS_16APSK_8_15_SH_PON__MASK 0x80      

/* MODCODLS13 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS13                              0x00000213
#define RC8CODEW_DVBSX_DEMOD_MODCODLS13__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_QPSK_8_15_SH_POFF__MASK  0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_QPSK_8_15_SH_PON__MASK   0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_QPSK_32_45_SH_POFF__MASK 0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_QPSK_32_45_SH_PON__MASK  0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_8PSK_7_15_SH_POFF__MASK  0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_8PSK_7_15_SH_PON__MASK   0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_8PSK_8_15_SH_POFF__MASK  0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS13_DIS_8PSK_8_15_SH_PON__MASK   0x80      

/* MODCODLS14 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS14                              0x00000214
#define RC8CODEW_DVBSX_DEMOD_MODCODLS14__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_11_45_SH_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_11_45_SH_PON__MASK  0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_4_15_SH_POFF__MASK  0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_4_15_SH_PON__MASK   0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_14_45_SH_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_14_45_SH_PON__MASK  0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_7_15_SH_POFF__MASK  0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS14_DIS_QPSK_7_15_SH_PON__MASK   0x80      

/* MODCODLS15 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS15                              0x00000215
#define RC8CODEW_DVBSX_DEMOD_MODCODLS15__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_31_45_L_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_31_45_L_PON__MASK 0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_32_45_POFF__MASK 0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_32_45_PON__MASK  0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_11_15_L_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_11_15_L_PON__MASK 0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_3_4_POFF__MASK   0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS15_DIS_256APSK_3_4_PON__MASK    0x80      

/* MODCODLS16 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS16                              0x00000216
#define RC8CODEW_DVBSX_DEMOD_MODCODLS16__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_128APSK_3_4_POFF__MASK   0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_128APSK_3_4_PON__MASK    0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_128APSK_7_9_POFF__MASK   0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_128APSK_7_9_PON__MASK    0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_256APSK_29_45_L_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_256APSK_29_45_L_PON__MASK 0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_256APSK_2_3_L_POFF__MASK 0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS16_DIS_256APSK_2_3_L_PON__MASK  0x80      

/* MODCODLS17 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS17                              0x00000217
#define RC8CODEW_DVBSX_DEMOD_MODCODLS17__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_R192_64APSK_POFF__MASK   0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_R193_64APSK_PON__MASK    0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_64APSK_4_5_POFF__MASK    0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_64APSK_4_5_PON__MASK     0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_R196_64APSK_POFF__MASK   0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_R197_64APSK_PON__MASK    0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_64APSK_5_6_POFF__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS17_DIS_64APSK_5_6_PON__MASK     0x80      

/* MODCODLS18 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS18                              0x00000218
#define RC8CODEW_DVBSX_DEMOD_MODCODLS18__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_32_45_L_POFF__MASK 0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_32_45_L_PON__MASK 0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_11_15_POFF__MASK  0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_11_15_PON__MASK   0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_R188_64APSK_POFF__MASK   0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_R189_64APSK_PON__MASK    0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_7_9_POFF__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS18_DIS_64APSK_7_9_PON__MASK     0x80      

/* MODCODLS19 */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS19                              0x00000219
#define RC8CODEW_DVBSX_DEMOD_MODCODLS19__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_R176_32APSK_POFF__MASK   0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_R177_32APSK_PON__MASK    0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_32_45_POFF__MASK  0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_32_45_PON__MASK   0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_11_15_POFF__MASK  0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_11_15_PON__MASK   0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_7_9_POFF__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS19_DIS_32APSK_7_9_PON__MASK     0x80      

/* MODCODLS1A */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1A                              0x0000021a
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1A__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_13_18_POFF__MASK  0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_13_18_PON__MASK   0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_7_9_POFF__MASK    0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_7_9_PON__MASK     0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_77_90_POFF__MASK  0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_16APSK_77_90_PON__MASK   0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_32APSK_2_3_L_POFF__MASK  0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1A_DIS_32APSK_2_3_L_PON__MASK   0x80      

/* MODCODLS1B */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1B                              0x0000021b
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1B__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_28_45_POFF__MASK  0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_28_45_PON__MASK   0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_23_36_POFF__MASK  0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_23_36_PON__MASK   0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_2_3_L_POFF__MASK  0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_2_3_L_PON__MASK   0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_25_36_POFF__MASK  0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1B_DIS_16APSK_25_36_PON__MASK   0x80      

/* MODCODLS1C */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1C                              0x0000021c
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1C__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_5_9_L_POFF__MASK  0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_5_9_L_PON__MASK   0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_26_45_POFF__MASK  0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_26_45_PON__MASK   0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_3_5_POFF__MASK    0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_3_5_PON__MASK     0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_3_5_L_POFF__MASK  0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1C_DIS_16APSK_3_5_L_PON__MASK   0x80      

/* MODCODLS1D */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1D                              0x0000021d
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1D__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_8PSK_25_36_POFF__MASK    0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_8PSK_25_36_PON__MASK     0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_8PSK_13_18_POFF__MASK    0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_8PSK_13_18_PON__MASK     0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_16APSK_1_2_L_POFF__MASK  0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_16APSK_1_2_L_PON__MASK   0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_16APSK_8_15_L_POFF__MASK 0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1D_DIS_16APSK_8_15_L_PON__MASK  0x80      

/* MODCODLS1E */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1E                              0x0000021e
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1E__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_QPSK_11_20_POFF__MASK    0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_QPSK_11_20_PON__MASK     0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8APSK_5_9_L_POFF__MASK   0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8APSK_5_9_L_PON__MASK    0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8APSK_26_45_L_POFF__MASK 0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8APSK_26_45_L_PON__MASK  0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8PSK_23_36_POFF__MASK    0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1E_DIS_8PSK_23_36_PON__MASK     0x80      

/* MODCODLS1F */
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1F                              0x0000021f
#define RC8CODEW_DVBSX_DEMOD_MODCODLS1F__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_R128_8PSK_POFF__MASK     0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_VLSRN1__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_R130_16APSK_POFF__MASK   0x04      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_VLSNR2__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_QPSK_13_45_POFF__MASK    0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_QPSK_13_45_PON__MASK     0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_QPSK_9_20_POFF__MASK     0x40      
#define FC8CODEW_DVBSX_DEMOD_MODCODLS1F_DIS_QPSK_9_20_PON__MASK      0x80      

/* MODCODCH3 */
#define RC8CODEW_DVBSX_DEMOD_MODCODCH3                               0x00000220
#define RC8CODEW_DVBSX_DEMOD_MODCODCH3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODCH3_MODCOD_CHOOSEN3__MASK         0xFF      

/* MODCODCH2 */
#define RC8CODEW_DVBSX_DEMOD_MODCODCH2                               0x00000221
#define RC8CODEW_DVBSX_DEMOD_MODCODCH2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODCH2_MODCOD_CHOOSEN2__MASK         0xFF      

/* MODCODCH1 */
#define RC8CODEW_DVBSX_DEMOD_MODCODCH1                               0x00000222
#define RC8CODEW_DVBSX_DEMOD_MODCODCH1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODCH1_MODCOD_CHOOSEN1__MASK         0xFF      

/* MODCODCHM */
#define RC8CODEW_DVBSX_DEMOD_MODCODCHM                               0x00000223
#define RC8CODEW_DVBSX_DEMOD_MODCODCHM__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_MODCOD_INF1__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_MODCOD_FENETRE23__MASK        0x06      
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_MODCODLST_S2X__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_OLD_NCOCALC__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_ROTAPLS_OFF__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_MODCODCHM_NFIFO2_MANOFFSET__MASK        0xC0      

/* DMDRESCFG */
#define RC8CODEW_DVBSX_DEMOD_DMDRESCFG                               0x00000224
#define RC8CODEW_DVBSX_DEMOD_DMDRESCFG__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_AGC2MEM__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_NOSTORE__MASK          0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_NEWONLY__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_STRALL__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_UNVALID__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDRESCFG_DMDRES_RST__MASK              0x80      

/* DMDRESADR */
#define RC8CODEW_DVBSX_DEMOD_DMDRESADR                               0x00000225
#define RC8CODEW_DVBSX_DEMOD_DMDRESADR__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESADR_DMDRES_RESNBR__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_DMDRESADR_DMDRES_MEMFULL__MASK          0x30      
#define FC8CODEW_DVBSX_DEMOD_DMDRESADR_DMDRES_VALIDCFR__MASK         0x40      
#define FC8CODEW_DVBSX_DEMOD_DMDRESADR_SUSP_PREDCANAL__MASK          0x80      

/* DMDRESDATA7 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA7                             0x00000226
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA7__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA7_DMDRES_SFRVAL__MASK         0xFF      

/* DMDRESDATA6 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA6                             0x00000227
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA6__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA6_DMDRES_SFRVAL__MASK         0xFF      

/* DMDRESDATA5 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA5                             0x00000228
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA5__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA5_DMDRES_CFRVAL__MASK         0xFF      

/* DMDRESDATA4 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA4                             0x00000229
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA4__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA4_DMDRES_CFRVAL__MASK         0xFF      

/* DMDRESDATA3 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA3                             0x0000022a
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA3__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA3_DMDRES_CNRVAL__MASK         0xFF      

/* DMDRESDATA2 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA2                             0x0000022b
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA2__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA2_DMDRES_ROLLOFF2__MASK       0x07      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA2_DMDRES_VALIDDATA__MASK      0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA2_DMDRES_SPECINV__MASK        0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA2_DMDRES_CNRVAL__MASK         0xC0      

/* DMDRESDATA1 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA1                             0x0000022c
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA1__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA1_RMODCOD5__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA1_RANNEXE_M__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA1_RLOCK_DEFINITIF__MASK       0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA1_DMDRES_RESCPT__MASK         0xF8      

/* DMDRESDATA0 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA0                             0x0000022d
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA0__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA0_DMDRES_PUNCTVIT__MASK       0x07      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA0_DMDRES_DSSVIT__MASK         0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA0_DMDRES_SYMIQVIT__MASK       0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA0_DMDRES_VALIDCHNL__MASK      0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA0_DMDRES_DVBS2__MASK          0x80      

/* DMDRESDATA8 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA8                             0x0000022e
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA8__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA8_DMDRES_SFRVAL__MASK         0xFF      

/* DMDRESDATA9 */
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA9                             0x0000022f
#define RC8CODEW_DVBSX_DEMOD_DMDRESDATA9__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDRESDATA9_DMDRES_CFRVAL__MASK         0xFF      

/* TNRCFG */
#define RC8CODEW_DVBSX_DEMOD_TNRCFG                                  0x00000230
#define RC8CODEW_DVBSX_DEMOD_TNRCFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_TNRCFG_TUN_MADDRESS__MASK               0x03      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG_TUN_VCOSRCH__MASK                0x04      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG_TUN_SECSTOP__MASK                0x08      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG_TUN_TYPE__MASK                   0x70      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG_TUN_ACKFAIL__MASK                0x80      

/* TNRCFG2 */
#define RC8CODEW_DVBSX_DEMOD_TNRCFG2                                 0x00000231
#define RC8CODEW_DVBSX_DEMOD_TNRCFG2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_DIS_2BWAGC1__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_SHORT_WAITSTATES__MASK          0x02      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_DIS_BWCALC__MASK                0x04      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_TUNER_OBSPAGE__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_TUNER_LBAND__MASK               0x10      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_STB6120_DBLI2C__MASK            0x20      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_STB6110_STEP2MHZ__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_TNRCFG2_TUN_IQSWAP__MASK                0x80      

/* WDFEQ11 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ11                                 0x00000260
#define RC8CODEW_DVBSX_DEMOD_WDFEQ11__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ11_Q_WDFE11__MASK                  0xFF      

/* WDFEN12 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN12                                 0x00000261
#define RC8CODEW_DVBSX_DEMOD_WDFEN12__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN12_NUM_WDFE12__MASK                0xFF      

/* WDFEI12 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI12                                 0x00000262
#define RC8CODEW_DVBSX_DEMOD_WDFEI12__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI12_I_WDFE12__MASK                  0xFF      

/* WDFEQ12 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ12                                 0x00000263
#define RC8CODEW_DVBSX_DEMOD_WDFEQ12__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ12_Q_WDFE12__MASK                  0xFF      

/* WDFEN13 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN13                                 0x00000264
#define RC8CODEW_DVBSX_DEMOD_WDFEN13__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN13_NUM_WDFE13__MASK                0xFF      

/* WDFEI13 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI13                                 0x00000265
#define RC8CODEW_DVBSX_DEMOD_WDFEI13__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI13_I_WDFE13__MASK                  0xFF      

/* WDFEQ13 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ13                                 0x00000266
#define RC8CODEW_DVBSX_DEMOD_WDFEQ13__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ13_Q_WDFE13__MASK                  0xFF      

/* WDFEN14 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN14                                 0x00000267
#define RC8CODEW_DVBSX_DEMOD_WDFEN14__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN14_NUM_WDFE14__MASK                0xFF      

/* WDFEI14 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI14                                 0x00000268
#define RC8CODEW_DVBSX_DEMOD_WDFEI14__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI14_I_WDFE14__MASK                  0xFF      

/* WDFEQ14 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ14                                 0x00000269
#define RC8CODEW_DVBSX_DEMOD_WDFEQ14__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ14_Q_WDFE14__MASK                  0xFF      

/* WDFEN15 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN15                                 0x0000026a
#define RC8CODEW_DVBSX_DEMOD_WDFEN15__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN15_NUM_WDFE15__MASK                0xFF      

/* WDFEI15 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI15                                 0x0000026b
#define RC8CODEW_DVBSX_DEMOD_WDFEI15__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI15_I_WDFE15__MASK                  0xFF      

/* WDFEQ15 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ15                                 0x0000026c
#define RC8CODEW_DVBSX_DEMOD_WDFEQ15__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ15_Q_WDFE15__MASK                  0xFF      

/* WDFEN16 */
#define RC8CODEW_DVBSX_DEMOD_WDFEN16                                 0x0000026d
#define RC8CODEW_DVBSX_DEMOD_WDFEN16__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEN16_NUM_WDFE16__MASK                0xFF      

/* WDFEI16 */
#define RC8CODEW_DVBSX_DEMOD_WDFEI16                                 0x0000026e
#define RC8CODEW_DVBSX_DEMOD_WDFEI16__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEI16_I_WDFE16__MASK                  0xFF      

/* WDFEQ16 */
#define RC8CODEW_DVBSX_DEMOD_WDFEQ16                                 0x0000026f
#define RC8CODEW_DVBSX_DEMOD_WDFEQ16__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_WDFEQ16_Q_WDFE16__MASK                  0xFF      

/* SMAPCOEF7 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF7                               0x00000280
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF7__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF7_SMAPCOEF_IQMULT__MASK         0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF7_DIS_QSCALE__MASK              0x80      

/* SMAPCOEF6 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF6                               0x00000281
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF6__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_DIS_AB8PSK__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_LLRDIV_NOREM__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_ADJ_8PSKLLR1__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_ATTEN_AGC2DXX__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_OLD_32APSK__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_CORDIC_LSBMODE__MASK          0x20      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_DIS_LLRATTEN__MASK            0x40      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF6_DIS_AGC2SCALE__MASK           0x80      

/* SMAPCOEF5 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF5                               0x00000282
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF5__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF5_SMAPCOEF_IQSINCOS__MASK       0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF5_DIS_8SCALE__MASK              0x80      

/* SMAPCOEF4 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF4                               0x00000283
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF4__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF4_SMAPCOEF_RAYONA__MASK         0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF4_DIS_16APSKRMP__MASK           0x80      

/* SMAPCOEF3 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF3                               0x00000284
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF3_SMAPCOEF_RAYONB__MASK         0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF3_DIS_16APSKADJ__MASK           0x80      

/* SMAPCOEF2 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF2                               0x00000285
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF2_SMAPCOEF_IQDIFF__MASK         0x7F      

/* SMAPCOEF1 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF1                               0x00000286
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF1_SMAPCOEF_SINCOSLLR1__MASK     0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF1_DIS_16SCALE__MASK             0x80      

/* SMAPCOEF0 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF0                               0x00000287
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEF0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF0_SMAPCOEF_SINCOS30__MASK       0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEF0_DIS_32SCALE__MASK             0x80      

/* SDEMAP */
#define RC8CODEW_DVBSX_DEMOD_SDEMAP                                  0x00000288
#define RC8CODEW_DVBSX_DEMOD_SDEMAP__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_LLRFACTOR_MANUAL__MASK           0x01      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SMAPDEL_MODE__MASK               0x02      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SMAPCOEF_TBLSELECT__MASK         0x04      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SDDSOF_MSKMODE__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_HARDDEMAP_MODE__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SDDATACK_DELAI__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SDDATAHIER_SELECT__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_SDEMAP_SDDSTOP_NOSIGNAL__MASK           0x80      

/* SMAPCOEFM2 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2                              0x00000289
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM2_SMAPCOEF_SINCOS22__MASK      0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM2_DIS_64SCALE__MASK            0x80      

/* SMAPCOEFM1 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1                              0x0000028a
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM1_SMAPCOEF_SINCOS60__MASK      0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM1_DIS_128SCALE__MASK           0x80      

/* SMAPCOEFM0 */
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0                              0x0000028b
#define RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM0_SMAPCOEF_RAYONC__MASK        0x7F      
#define FC8CODEW_DVBSX_DEMOD_SMAPCOEFM0_DIS_256SCALE__MASK           0x80      

/* LLROBS5 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS5                                 0x000002a0
#define RC8CODEW_DVBSX_DEMOD_LLROBS5__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS5_LLRX_RESULT__MASK               0xFF      

/* LLROBS4 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS4                                 0x000002a1
#define RC8CODEW_DVBSX_DEMOD_LLROBS4__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS4_LLRX_RESULT__MASK               0xFF      

/* LLROBS3 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS3                                 0x000002a2
#define RC8CODEW_DVBSX_DEMOD_LLROBS3__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS3_LLRX_RESULT__MASK               0xFF      

/* LLROBS2 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS2                                 0x000002a3
#define RC8CODEW_DVBSX_DEMOD_LLROBS2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS2_LLRX_RESULT__MASK               0xFF      

/* LLROBS1 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS1                                 0x000002a4
#define RC8CODEW_DVBSX_DEMOD_LLROBS1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS1_LLRX_RESULT__MASK               0xFF      

/* LLROBS0 */
#define RC8CODEW_DVBSX_DEMOD_LLROBS0                                 0x000002a5
#define RC8CODEW_DVBSX_DEMOD_LLROBS0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBS0_LLRX_RESULT__MASK               0xFF      

/* LLROBSCFG */
#define RC8CODEW_DVBSX_DEMOD_LLROBSCFG                               0x000002a6
#define RC8CODEW_DVBSX_DEMOD_LLROBSCFG__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_LLROBSCFG_LLROBS_CFG__MASK              0xFF      

/* DMDPLHSTAT */
#define RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT                              0x000002b0
#define RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDPLHSTAT_PLH_STATISTIC__MASK          0xFF      

/* DMDSELOBS */
#define RC8CODEW_DVBSX_DEMOD_DMDSELOBS                               0x000002b1
#define RC8CODEW_DVBSX_DEMOD_DMDSELOBS__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_CCILIST_INVALIDATE__MASK      0x01      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NODVBS1_SEL__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NODVBS2_SEL__MASK             0x04      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NOVCM_SEL__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NONCR_SEL__MASK               0x10      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NOS2X_SEL__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_DMDSELOBS_NOSHDB_SEL__MASK              0xC0      

/* LOCKTIME3 */
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME3                               0x000002b2
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_LOCKTIME3_DEMOD_LOCKTIME__MASK          0xFF      

/* LOCKTIME2 */
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME2                               0x000002b3
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_LOCKTIME2_DEMOD_LOCKTIME__MASK          0xFF      

/* LOCKTIME1 */
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME1                               0x000002b4
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_LOCKTIME1_DEMOD_LOCKTIME__MASK          0xFF      

/* LOCKTIME0 */
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME0                               0x000002b5
#define RC8CODEW_DVBSX_DEMOD_LOCKTIME0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_LOCKTIME0_DEMOD_LOCKTIME__MASK          0xFF      

/* CALCFG */
#define RC8CODEW_DVBSX_DEMOD_CALCFG                                  0x000002c0
#define RC8CODEW_DVBSX_DEMOD_CALCFG__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_I2CPAGE__MASK                0x03      
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_INCMODE__MASK                0x0C      
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_INCINIT__MASK                0x10      
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_LTIMEOUT__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_OBSMODE__MASK                0x40      
#define FC8CODEW_DVBSX_DEMOD_CALCFG_CAL_RUNENABLE__MASK              0x80      

/* CALADDR */
#define RC8CODEW_DVBSX_DEMOD_CALADDR                                 0x000002c1
#define RC8CODEW_DVBSX_DEMOD_CALADDR__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CALADDR_CAL_I2CADDR__MASK               0xFF      

/* CALSTART */
#define RC8CODEW_DVBSX_DEMOD_CALSTART                                0x000002c2
#define RC8CODEW_DVBSX_DEMOD_CALSTART__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CALSTART_CAL_STARTVAL__MASK             0xFF      

/* CALMASK */
#define RC8CODEW_DVBSX_DEMOD_CALMASK                                 0x000002c3
#define RC8CODEW_DVBSX_DEMOD_CALMASK__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CALMASK_CAL_MASKVAL__MASK               0xFF      

/* CALSTOP */
#define RC8CODEW_DVBSX_DEMOD_CALSTOP                                 0x000002c4
#define RC8CODEW_DVBSX_DEMOD_CALSTOP__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CALSTOP_CAL_STOPVAL__MASK               0xFF      

/* CALOBS */
#define RC8CODEW_DVBSX_DEMOD_CALOBS                                  0x000002c5
#define RC8CODEW_DVBSX_DEMOD_CALOBS__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CALOBS_CAL_OBSERVATION__MASK            0xFF      

/* CALRESINC */
#define RC8CODEW_DVBSX_DEMOD_CALRESINC                               0x000002c6
#define RC8CODEW_DVBSX_DEMOD_CALRESINC__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CALRESINC_CAL_RESULTINC__MASK           0xFF      

/* CALRESDEC */
#define RC8CODEW_DVBSX_DEMOD_CALRESDEC                               0x000002c7
#define RC8CODEW_DVBSX_DEMOD_CALRESDEC__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_CALRESDEC_CAL_RESULTDEC__MASK           0xFF      

/* CALRLIST */
#define RC8CODEW_DVBSX_DEMOD_CALRLIST                                0x000002c8
#define RC8CODEW_DVBSX_DEMOD_CALRLIST__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_TIMING__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_CARRIER1__MASK             0x02      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_CARRIER2__MASK             0x04      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_GAINLLRVIT__MASK           0x08      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_AGCXREF__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_CAR1S2AB__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_DISCAL_I2CIDLE__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_CALRLIST_CAL_DOUBLERUN__MASK            0x80      

/* PLHCCMP1 */
#define RC8CODEW_DVBSX_DEMOD_PLHCCMP1                                0x000002e0
#define RC8CODEW_DVBSX_DEMOD_PLHCCMP1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHCCMP1_CORREL_COMPARE__MASK           0xFF      

/* PLHCCMP0 */
#define RC8CODEW_DVBSX_DEMOD_PLHCCMP0                                0x000002e1
#define RC8CODEW_DVBSX_DEMOD_PLHCCMP0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHCCMP0_CORREL_COMPARE__MASK           0xFF      

/* DMDTIMER */
#define RC8CODEW_DVBSX_DEMOD_DMDTIMER                                0x000002e2
#define RC8CODEW_DVBSX_DEMOD_DMDTIMER__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDTIMER_DEMOD_TIMER__MASK              0xFF      

/* DMDATTEMPT */
#define RC8CODEW_DVBSX_DEMOD_DMDATTEMPT                              0x000002e3
#define RC8CODEW_DVBSX_DEMOD_DMDATTEMPT__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_DMDATTEMPT_DEMOD_ATTEMPTS__MASK         0xFF      

/* PLFHEADER1 */
#define RC8CODEW_DVBSX_DEMOD_PLFHEADER1                              0x000002e4
#define RC8CODEW_DVBSX_DEMOD_PLFHEADER1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLFHEADER1_PLF_HEADER__MASK             0xFF      

/* PLFHEADER0 */
#define RC8CODEW_DVBSX_DEMOD_PLFHEADER0                              0x000002e5
#define RC8CODEW_DVBSX_DEMOD_PLFHEADER0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLFHEADER0_PLF_HEADER__MASK             0xFF      

/* PLHSFRDIFF1 */
#define RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1                             0x000002e6
#define RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1_PLFRAME_DIFF__MASK          0xFF      

/* PLHSFRDIFF0 */
#define RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0                             0x000002e7
#define RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0_PLFRAME_DIFF__MASK          0xFF      

/* PLHRCMP1 */
#define RC8CODEW_DVBSX_DEMOD_PLHRCMP1                                0x000002e8
#define RC8CODEW_DVBSX_DEMOD_PLHRCMP1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRCMP1_COMPARE_HEADER__MASK           0xFF      

/* PLHRCMP0 */
#define RC8CODEW_DVBSX_DEMOD_PLHRCMP0                                0x000002e9
#define RC8CODEW_DVBSX_DEMOD_PLHRCMP0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRCMP0_COMPARE_HEADER__MASK           0xFF      

/* PLHRECORD1 */
#define RC8CODEW_DVBSX_DEMOD_PLHRECORD1                              0x000002ea
#define RC8CODEW_DVBSX_DEMOD_PLHRECORD1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRECORD1_RECORD_HEADER__MASK          0xFF      

/* PLHRECORD0 */
#define RC8CODEW_DVBSX_DEMOD_PLHRECORD0                              0x000002eb
#define RC8CODEW_DVBSX_DEMOD_PLHRECORD0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRECORD0_RECORD_HEADER__MASK          0xFF      

/* PLHRECNCO1 */
#define RC8CODEW_DVBSX_DEMOD_PLHRECNCO1                              0x000002ec
#define RC8CODEW_DVBSX_DEMOD_PLHRECNCO1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRECNCO1_RECORD_HEADER_NCO__MASK      0xFF      

/* PLHRECNCO0 */
#define RC8CODEW_DVBSX_DEMOD_PLHRECNCO0                              0x000002ed
#define RC8CODEW_DVBSX_DEMOD_PLHRECNCO0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHRECNCO0_RECORD_HEADER_NCO__MASK      0xFF      

/* PLHDELTAF1 */
#define RC8CODEW_DVBSX_DEMOD_PLHDELTAF1                              0x000002ee
#define RC8CODEW_DVBSX_DEMOD_PLHDELTAF1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHDELTAF1_PLH_DELTAF__MASK             0xFF      

/* PLHDELTAF0 */
#define RC8CODEW_DVBSX_DEMOD_PLHDELTAF0                              0x000002ef
#define RC8CODEW_DVBSX_DEMOD_PLHDELTAF0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHDELTAF0_PLH_DELTAF__MASK             0xFF      

/* PHERRCMP5 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP5                               0x00000300
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP5__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP5_DEMOD_DEBUGVAL__MASK          0xFF      

/* PHERRCMP4 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP4                               0x00000301
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP4__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP4_DEMOD_DEBUGVAL__MASK          0xFF      

/* PHERRCMP3 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP3                               0x00000302
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP3_DEMOD_DEBUGVAL__MASK          0xFF      

/* PHERRCMP2 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP2                               0x00000303
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP2_DEMOD_DEBUGVAL__MASK          0xFF      

/* PHERRCMP1 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP1                               0x00000304
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP1_DEMOD_DEBUGVAL__MASK          0xFF      

/* PHERRCMP0 */
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP0                               0x00000305
#define RC8CODEW_DVBSX_DEMOD_PHERRCMP0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_PHERRCMP0_DEMOD_DEBUGVAL__MASK          0xFF      

/* PLHDEBUG */
#define RC8CODEW_DVBSX_DEMOD_PLHDEBUG                                0x00000306
#define RC8CODEW_DVBSX_DEMOD_PLHDEBUG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_PLHDEBUG_PLH_DEBUG__MASK                0xFF      

/* ASYMCFGM */
#define RC8CODEW_DVBSX_DEMOD_ASYMCFGM                                0x00000310
#define RC8CODEW_DVBSX_DEMOD_ASYMCFGM__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGM_ASYMAGC_COEF__MASK             0x07      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGM_TST_ANTISYMB__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGM_DIS_ASYMQUAD__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGM_DIS_ASYMAMM__MASK              0x20      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGM_ANTISYMBOLE_MODE__MASK         0xC0      

/* ASYMCFGL */
#define RC8CODEW_DVBSX_DEMOD_ASYMCFGL                                0x00000311
#define RC8CODEW_DVBSX_DEMOD_ASYMCFGL__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGL_ASYM_IQCONST__MASK             0x07      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGL_ASYM_CORRFAST__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGL_ASYM_BETA__MASK                0x30      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGL_ASYM_RNDMODE__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFGL_ASYM_ALIASLOCK__MASK           0x80      

/* ASYMAGC1 */
#define RC8CODEW_DVBSX_DEMOD_ASYMAGC1                                0x00000312
#define RC8CODEW_DVBSX_DEMOD_ASYMAGC1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMAGC1_ASYMAGC2_MANT__MASK            0xFF      

/* ASYMAGC0 */
#define RC8CODEW_DVBSX_DEMOD_ASYMAGC0                                0x00000313
#define RC8CODEW_DVBSX_DEMOD_ASYMAGC0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMAGC0_ASYMAGC2_EXP__MASK             0x0F      
#define FC8CODEW_DVBSX_DEMOD_ASYMAGC0_ASYMAGC2_MANT__MASK            0xF0      

/* ASYMOBSI */
#define RC8CODEW_DVBSX_DEMOD_ASYMOBSI                                0x00000314
#define RC8CODEW_DVBSX_DEMOD_ASYMOBSI__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMOBSI_ASYM_IOBS__MASK                0xFF      

/* ASYMOBSQ */
#define RC8CODEW_DVBSX_DEMOD_ASYMOBSQ                                0x00000315
#define RC8CODEW_DVBSX_DEMOD_ASYMOBSQ__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMOBSQ_ASYM_QOBS__MASK                0xFF      

/* ASYMSTATUS */
#define RC8CODEW_DVBSX_DEMOD_ASYMSTATUS                              0x00000316
#define RC8CODEW_DVBSX_DEMOD_ASYMSTATUS__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMSTATUS_TGTETA_MULT4__MASK           0x01      
#define FC8CODEW_DVBSX_DEMOD_ASYMSTATUS_AMM_MULT4__MASK              0x02      
#define FC8CODEW_DVBSX_DEMOD_ASYMSTATUS_ASYMCTRL_ON__MASK            0x20      
#define FC8CODEW_DVBSX_DEMOD_ASYMSTATUS_ASYMCTRL_QUAD__MASK          0x40      
#define FC8CODEW_DVBSX_DEMOD_ASYMSTATUS_ASYMCTRL_AMM__MASK           0x80      

/* ASYMWSAR */
#define RC8CODEW_DVBSX_DEMOD_ASYMWSAR                                0x00000317
#define RC8CODEW_DVBSX_DEMOD_ASYMWSAR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMWSAR_ASYM_WSAR__MASK                0xFF      

/* AFILTCFGM */
#define RC8CODEW_DVBSX_DEMOD_AFILTCFGM                               0x00000318
#define RC8CODEW_DVBSX_DEMOD_AFILTCFGM__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_AFILTRE3_MANUEL__MASK         0x01      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_AFILTRE2_MANUEL__MASK         0x02      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_AFILTRE1_MANUEL__MASK         0x04      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_ABYP_HDBFILTRE__MASK          0x08      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_AFILTRES_BETA__MASK           0x30      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGM_AHDBFILTRE_MODE__MASK         0xC0      

/* AFILTCFGL */
#define RC8CODEW_DVBSX_DEMOD_AFILTCFGL                               0x00000319
#define RC8CODEW_DVBSX_DEMOD_AFILTCFGL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGL_AFILTRE3_AMPL__MASK           0x03      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGL_AFILTRE2_AMPL__MASK           0x0C      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGL_AFILTRE1_AMPL__MASK           0x30      
#define FC8CODEW_DVBSX_DEMOD_AFILTCFGL_AFILTRE_DEBUG__MASK           0x80      

/* AIQFILT0 */
#define RC8CODEW_DVBSX_DEMOD_AIQFILT0                                0x0000031a
#define RC8CODEW_DVBSX_DEMOD_AIQFILT0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AIQFILT0_AIQPOWER_DEROT1G__MASK         0xFF      

/* AIQFILT1 */
#define RC8CODEW_DVBSX_DEMOD_AIQFILT1                                0x0000031b
#define RC8CODEW_DVBSX_DEMOD_AIQFILT1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AIQFILT1_AIQPOWER_FILTRE1__MASK         0xFF      

/* AIQFILT2 */
#define RC8CODEW_DVBSX_DEMOD_AIQFILT2                                0x0000031c
#define RC8CODEW_DVBSX_DEMOD_AIQFILT2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AIQFILT2_AIQPOWER_FILTRE2__MASK         0xFF      

/* AIQFILT3 */
#define RC8CODEW_DVBSX_DEMOD_AIQFILT3                                0x0000031d
#define RC8CODEW_DVBSX_DEMOD_AIQFILT3__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_AIQFILT3_AIQPOWER_FILTRE3__MASK         0xFF      

/* ASYMCFG3 */
#define RC8CODEW_DVBSX_DEMOD_ASYMCFG3                                0x0000031e
#define RC8CODEW_DVBSX_DEMOD_ASYMCFG3__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYM_CORRSGN__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYMQUAD_MULT4__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYMAMM_MULT4__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYMQUAD_INV__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYMAMM_INV__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_DIS_ASYMWSAR__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYM_CPTMODE__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_ASYMCFG3_ASYM_EGALINV__MASK             0x80      

/* GCTRL */
#define RC8CODEW_DVBSX_DEMOD_GCTRL                                   0x00000380
#define RC8CODEW_DVBSX_DEMOD_GCTRL__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_GCTRL_UFBS_ENABLE__MASK                 0x01      
#define FC8CODEW_DVBSX_DEMOD_GCTRL_UFBS_RESTART__MASK                0x02      
#define FC8CODEW_DVBSX_DEMOD_GCTRL_INPUT_MODE__MASK                  0x3C      
#define FC8CODEW_DVBSX_DEMOD_GCTRL_LOW_RATE__MASK                    0x40      

/* FFTCTRL */
#define RC8CODEW_DVBSX_DEMOD_FFTCTRL                                 0x00000381
#define RC8CODEW_DVBSX_DEMOD_FFTCTRL__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_FFTCTRL_FFT_MODE__MASK                  0x07      
#define FC8CODEW_DVBSX_DEMOD_FFTCTRL_FFT_SHIFT__MASK                 0x08      
#define FC8CODEW_DVBSX_DEMOD_FFTCTRL_CTE_MODE__MASK                  0x70      
#define FC8CODEW_DVBSX_DEMOD_FFTCTRL_MODE_INTERSYMBOL__MASK          0x80      

/* FFTACC */
#define RC8CODEW_DVBSX_DEMOD_FFTACC                                  0x00000382
#define RC8CODEW_DVBSX_DEMOD_FFTACC__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_FFTACC_NB_ACC_FFT__MASK                 0xFF      

/* THRESHOLD */
#define RC8CODEW_DVBSX_DEMOD_THRESHOLD                               0x00000383
#define RC8CODEW_DVBSX_DEMOD_THRESHOLD__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_THRESHOLD_MAX_THRESHOLD__MASK           0x0F      
#define FC8CODEW_DVBSX_DEMOD_THRESHOLD_NO_STOP__MASK                 0x10      

/* GAINCONT */
#define RC8CODEW_DVBSX_DEMOD_GAINCONT                                0x00000384
#define RC8CODEW_DVBSX_DEMOD_GAINCONT__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_GAINCONT_GAIN_CONTINUOUS__MASK          0x7F      
#define FC8CODEW_DVBSX_DEMOD_GAINCONT_MODE_CONTINUOUS__MASK          0x80      

/* UPDCONT */
#define RC8CODEW_DVBSX_DEMOD_UPDCONT                                 0x00000385
#define RC8CODEW_DVBSX_DEMOD_UPDCONT__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_UPDCONT_UPD_CONTINUOUS__MASK            0xFF      

/* GSTAT */
#define RC8CODEW_DVBSX_DEMOD_GSTAT                                   0x00000386
#define RC8CODEW_DVBSX_DEMOD_GSTAT__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_GSTAT_PSD_DONE__MASK                    0x01      
#define FC8CODEW_DVBSX_DEMOD_GSTAT_PEAK_FOUND__MASK                  0x02      
#define FC8CODEW_DVBSX_DEMOD_GSTAT_STATUS_MAX3__MASK                 0x04      
#define FC8CODEW_DVBSX_DEMOD_GSTAT_STATUS_INPUT_SAT__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_GSTAT_CTE_FREQ_OK__MASK                 0x10      

/* EXPMAX */
#define RC8CODEW_DVBSX_DEMOD_EXPMAX                                  0x00000387
#define RC8CODEW_DVBSX_DEMOD_EXPMAX__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_EXPMAX_EXP_MAX__MASK                    0x1F      

/* BINMAX1 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX1                                 0x00000388
#define RC8CODEW_DVBSX_DEMOD_BINMAX1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX1_BIN_MAX__MASK                   0x1F      

/* BINMAX0 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX0                                 0x00000389
#define RC8CODEW_DVBSX_DEMOD_BINMAX0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX0_BIN_MAX__MASK                   0xFF      

/* VALMAX2 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX2                                 0x0000038a
#define RC8CODEW_DVBSX_DEMOD_VALMAX2__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX2_VAL_MAX__MASK                   0xFF      

/* VALMAX1 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX1                                 0x0000038b
#define RC8CODEW_DVBSX_DEMOD_VALMAX1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX1_VAL_MAX__MASK                   0xFF      

/* VALMAX0 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX0                                 0x0000038c
#define RC8CODEW_DVBSX_DEMOD_VALMAX0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX0_VAL_MAX__MASK                   0xFF      

/* BINMAX21 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX21                                0x0000038d
#define RC8CODEW_DVBSX_DEMOD_BINMAX21__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX21_BIN_MAX2__MASK                 0x1F      

/* BINMAX20 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX20                                0x0000038e
#define RC8CODEW_DVBSX_DEMOD_BINMAX20__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX20_BIN_MAX2__MASK                 0xFF      

/* VALMAX22 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX22                                0x0000038f
#define RC8CODEW_DVBSX_DEMOD_VALMAX22__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX22_VAL_MAX2__MASK                 0xFF      

/* VALMAX21 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX21                                0x00000390
#define RC8CODEW_DVBSX_DEMOD_VALMAX21__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX21_VAL_MAX2__MASK                 0xFF      

/* VALMAX20 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX20                                0x00000391
#define RC8CODEW_DVBSX_DEMOD_VALMAX20__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX20_VAL_MAX2__MASK                 0xFF      

/* BINMAX31 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX31                                0x00000392
#define RC8CODEW_DVBSX_DEMOD_BINMAX31__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX31_BIN_MAX3__MASK                 0x1F      

/* BINMAX30 */
#define RC8CODEW_DVBSX_DEMOD_BINMAX30                                0x00000393
#define RC8CODEW_DVBSX_DEMOD_BINMAX30__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_BINMAX30_BIN_MAX3__MASK                 0xFF      

/* VALMAX32 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX32                                0x00000394
#define RC8CODEW_DVBSX_DEMOD_VALMAX32__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX32_VAL_MAX3__MASK                 0xFF      

/* VALMAX31 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX31                                0x00000395
#define RC8CODEW_DVBSX_DEMOD_VALMAX31__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX31_VAL_MAX3__MASK                 0xFF      

/* VALMAX30 */
#define RC8CODEW_DVBSX_DEMOD_VALMAX30                                0x00000396
#define RC8CODEW_DVBSX_DEMOD_VALMAX30__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_VALMAX30_VAL_MAX3__MASK                 0xFF      

/* CPTACC */
#define RC8CODEW_DVBSX_DEMOD_CPTACC                                  0x00000397
#define RC8CODEW_DVBSX_DEMOD_CPTACC__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_CPTACC_CPT_ACC_FFT__MASK                0xFF      

/* CTESTAT */
#define RC8CODEW_DVBSX_DEMOD_CTESTAT                                 0x00000398
#define RC8CODEW_DVBSX_DEMOD_CTESTAT__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CTESTAT_MODE_CTE_EFF__MASK              0x03      

/* CFOEST1 */
#define RC8CODEW_DVBSX_DEMOD_CFOEST1                                 0x0000039a
#define RC8CODEW_DVBSX_DEMOD_CFOEST1__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFOEST1_CFO_EST__MASK                   0xFF      

/* CFOEST0 */
#define RC8CODEW_DVBSX_DEMOD_CFOEST0                                 0x0000039b
#define RC8CODEW_DVBSX_DEMOD_CFOEST0__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_CFOEST0_CFO_EST__MASK                   0xFF      

/* DEBUG1 */
#define RC8CODEW_DVBSX_DEMOD_DEBUG1                                  0x000003ac
#define RC8CODEW_DVBSX_DEMOD_DEBUG1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_DISABLE_RESCALE__MASK            0x01      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_DISABLE_AVERAGE__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_DEBUG_INTERSYMBOL__MASK          0x04      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_MODE_DB__MASK                    0x08      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_SEL_MEM__MASK                    0x10      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_MODE_FULL__MASK                  0x20      
#define FC8CODEW_DVBSX_DEMOD_DEBUG1_CFO_FILT__MASK                   0x40      

/* MEMADDR1 */
#define RC8CODEW_DVBSX_DEMOD_MEMADDR1                                0x000003ad
#define RC8CODEW_DVBSX_DEMOD_MEMADDR1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMADDR1_MEM_ADDR__MASK                 0x07      

/* MEMADDR0 */
#define RC8CODEW_DVBSX_DEMOD_MEMADDR0                                0x000003ae
#define RC8CODEW_DVBSX_DEMOD_MEMADDR0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMADDR0_MEM_ADDR__MASK                 0xFF      

/* MEMSTAT */
#define RC8CODEW_DVBSX_DEMOD_MEMSTAT                                 0x000003af
#define RC8CODEW_DVBSX_DEMOD_MEMSTAT__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMSTAT_MEM_STAT__MASK                  0x01      

/* MEMVA01 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA01                                 0x000003b0
#define RC8CODEW_DVBSX_DEMOD_MEMVA01__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA01_MEM_VAL0__MASK                  0xFF      

/* MEMVA00 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA00                                 0x000003b1
#define RC8CODEW_DVBSX_DEMOD_MEMVA00__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA00_MEM_VAL0__MASK                  0xFF      

/* MEMVA11 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA11                                 0x000003b2
#define RC8CODEW_DVBSX_DEMOD_MEMVA11__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA11_MEM_VAL1__MASK                  0xFF      

/* MEMVA10 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA10                                 0x000003b3
#define RC8CODEW_DVBSX_DEMOD_MEMVA10__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA10_MEM_VAL1__MASK                  0xFF      

/* MEMVA21 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA21                                 0x000003b4
#define RC8CODEW_DVBSX_DEMOD_MEMVA21__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA21_MEM_VAL2__MASK                  0xFF      

/* MEMVA20 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA20                                 0x000003b5
#define RC8CODEW_DVBSX_DEMOD_MEMVA20__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA20_MEM_VAL2__MASK                  0xFF      

/* MEMVA31 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA31                                 0x000003b6
#define RC8CODEW_DVBSX_DEMOD_MEMVA31__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA31_MEM_VAL3__MASK                  0xFF      

/* MEMVA30 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA30                                 0x000003b7
#define RC8CODEW_DVBSX_DEMOD_MEMVA30__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA30_MEM_VAL3__MASK                  0xFF      

/* MEMVA41 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA41                                 0x000003b8
#define RC8CODEW_DVBSX_DEMOD_MEMVA41__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA41_MEM_VAL4__MASK                  0xFF      

/* MEMVA40 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA40                                 0x000003b9
#define RC8CODEW_DVBSX_DEMOD_MEMVA40__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA40_MEM_VAL4__MASK                  0xFF      

/* MEMVA51 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA51                                 0x000003ba
#define RC8CODEW_DVBSX_DEMOD_MEMVA51__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA51_MEM_VAL5__MASK                  0xFF      

/* MEMVA50 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA50                                 0x000003bb
#define RC8CODEW_DVBSX_DEMOD_MEMVA50__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA50_MEM_VAL5__MASK                  0xFF      

/* MEMVA61 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA61                                 0x000003bc
#define RC8CODEW_DVBSX_DEMOD_MEMVA61__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA61_MEM_VAL6__MASK                  0xFF      

/* MEMVA60 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA60                                 0x000003bd
#define RC8CODEW_DVBSX_DEMOD_MEMVA60__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA60_MEM_VAL6__MASK                  0xFF      

/* MEMVA71 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA71                                 0x000003be
#define RC8CODEW_DVBSX_DEMOD_MEMVA71__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA71_MEM_VAL7__MASK                  0xFF      

/* MEMVA70 */
#define RC8CODEW_DVBSX_DEMOD_MEMVA70                                 0x000003bf
#define RC8CODEW_DVBSX_DEMOD_MEMVA70__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_MEMVA70_MEM_VAL7__MASK                  0xFF      

/* TSTDMD */
#define RC8CODEW_DVBSX_DEMOD_TSTDMD                                  0x000003c0
#define RC8CODEW_DVBSX_DEMOD_TSTDMD__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_TNRRESTART_OFF__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_STEP3_NOTMG__MASK                0x02      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_STEP3_NOTCAR__MASK               0x04      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_OLDPEA0_LOOP__MASK               0x08      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_DIS_RANDOMCFRI__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_DIS_CFRINCLARGE__MASK            0x20      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_TSTDMD_NORELCK__MASK             0x40      
#define FC8CODEW_DVBSX_DEMOD_TSTDMD_TSTDMD_RESET__MASK               0x80      

/* TPOLY */
#define RC8CODEW_DVBSX_DEMOD_TPOLY                                   0x000003c1
#define RC8CODEW_DVBSX_DEMOD_TPOLY__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TPOLY_SEL_IQTHEORI__MASK                0x02      
#define FC8CODEW_DVBSX_DEMOD_TPOLY_MSURLIGNED_PIBPSK__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_TPOLY_TSTDMD_ISOLATION__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_TPOLY_OBSFIELD_SELECT__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_TPOLY_DIS_STCNLOCK__MASK                0x40      
#define FC8CODEW_DVBSX_DEMOD_TPOLY_IQFORCE_MODE__MASK                0x80      

/* TSTR */
#define RC8CODEW_DVBSX_DEMOD_TSTR                                    0x000003c2
#define RC8CODEW_DVBSX_DEMOD_TSTR__DEFAULT                           0x0       
#define FC8CODEW_DVBSX_DEMOD_TSTR_STOPTMG_CRS_MODE__MASK             0x03      
#define FC8CODEW_DVBSX_DEMOD_TSTR_DIS_TLOCKRST__MASK                 0x04      
#define FC8CODEW_DVBSX_DEMOD_TSTR_EN_S1VERYLOW__MASK                 0x08      
#define FC8CODEW_DVBSX_DEMOD_TSTR_DIS_TMGLOWRTSUB__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_TSTR_DIS_TMGRSTSAT__MASK                0x20      
#define FC8CODEW_DVBSX_DEMOD_TSTR_TMGERR_INV__MASK                   0x40      
#define FC8CODEW_DVBSX_DEMOD_TSTR_TMGRST_ETAPE9__MASK                0x80      

/* TAGC2 */
#define RC8CODEW_DVBSX_DEMOD_TAGC2                                   0x000003c3
#define RC8CODEW_DVBSX_DEMOD_TAGC2__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TAGC2_AGC2EXP_NOSFR__MASK               0x01      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_SOFAGC1_TEST__MASK                0x02      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_AGC2_NFASTOV__MASK                0x04      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_AGC2_NLKMODE__MASK                0x08      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_NOCALC_KREFTMG__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_DCADJ_TSTFAST__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_EN_SR1AGC2__MASK                  0x40      
#define FC8CODEW_DVBSX_DEMOD_TAGC2_AGC2_PLHONLY__MASK                0x80      

/* TCTL1 */
#define RC8CODEW_DVBSX_DEMOD_TCTL1                                   0x000003c4
#define RC8CODEW_DVBSX_DEMOD_TCTL1__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TCTL1_TST_IQSYMBSEL__MASK               0x1F      
#define FC8CODEW_DVBSX_DEMOD_TCTL1_TSTDMD_IQECH__MASK                0x20      
#define FC8CODEW_DVBSX_DEMOD_TCTL1_TSTJETON_SELECT__MASK             0xC0      

/* TCTL2 */
#define RC8CODEW_DVBSX_DEMOD_TCTL2                                   0x000003c5
#define RC8CODEW_DVBSX_DEMOD_TCTL2__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TCTL2_PLF1MEM_READ__MASK                0x01      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_USE_CFR2PLH__MASK                 0x02      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_DIS_DFFAIBLE__MASK                0x04      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_CORDIC_OLDLOAD__MASK              0x08      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_DIS_DUMMYPLCFR2__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_DIS_KCCARSTEP36__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_EN_CCARADJ__MASK                  0x40      
#define FC8CODEW_DVBSX_DEMOD_TCTL2_DEMBYP_270MD__MASK                0x80      

/* TCTL3 */
#define RC8CODEW_DVBSX_DEMOD_TCTL3                                   0x000003c6
#define RC8CODEW_DVBSX_DEMOD_TCTL3__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TCTL3_DIS_COARSELOCK__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_CFRUPLOW_NRSTMODE__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_DIS_CFR2SMOOTH__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_DIS_SDFIFOOV__MASK                0x08      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_LDPC_LLR_DLY__MASK                0x10      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_ENDIS_INITFRAME__MASK             0x20      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_SDEMAP_TSTBIT__MASK               0x40      
#define FC8CODEW_DVBSX_DEMOD_TCTL3_SDEMAP_DEBUG__MASK                0x80      

/* TCTL4 */
#define RC8CODEW_DVBSX_DEMOD_TCTL4                                   0x000003c8
#define RC8CODEW_DVBSX_DEMOD_TCTL4__DEFAULT                          0x0       
#define FC8CODEW_DVBSX_DEMOD_TCTL4_CAR3_NOFORWARD__MASK              0x01      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_CAR3_NOTRACEBACK__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_DIS_FORCEBETA2__MASK              0x04      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_TETA3L_RSTTETA3D__MASK            0x08      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_EN_PLHCALC__MASK                  0x10      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_TSTINV_PHERR__MASK                0x20      
#define FC8CODEW_DVBSX_DEMOD_TCTL4_CFR2TOCFR1_DVBS1__MASK            0xC0      

/* TSTCAR3 */
#define RC8CODEW_DVBSX_DEMOD_TSTCAR3                                 0x000003c9
#define RC8CODEW_DVBSX_DEMOD_TSTCAR3__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_DEMOD_TSTCAR3_DIS_TRIPLECAR__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_TSTCAR3_TETA3_OBSMODE__MASK             0x0C      
#define FC8CODEW_DVBSX_DEMOD_TSTCAR3_EN_OCTANTRST__MASK              0x10      
#define FC8CODEW_DVBSX_DEMOD_TSTCAR3_OLD_NCO2RST__MASK               0x20      
#define FC8CODEW_DVBSX_DEMOD_TSTCAR3_DFACT23DL_CSTE__MASK            0xC0      

/* TSTHDEBIT */
#define RC8CODEW_DVBSX_DEMOD_TSTHDEBIT                               0x000003ca
#define RC8CODEW_DVBSX_DEMOD_TSTHDEBIT__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_EGAL_TSTBIT__MASK             0x01      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_FIFO2_ENWAIT__MASK            0x02      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_DVBS1_NOJUMP__MASK            0x04      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_NO_SDEMODBD__MASK             0x08      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_FIFO2_ENDELSYMB__MASK         0x10      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_EGALDFE0_MODE__MASK           0x20      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_POLYPH_S1ASYM__MASK           0x40      
#define FC8CODEW_DVBSX_DEMOD_TSTHDEBIT_EN_AGC2AMPL1B__MASK           0x80      

/* DEMODEND */
#define RC8CODEW_DVBSX_DEMOD_DEMODEND                                0x000003f0
#define RC8CODEW_DVBSX_DEMOD_DEMODEND__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMDIRQ_CFRRANGE__MASK          0x01      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMDIRQ_NTHRES1__MASK           0x02      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMDIRQ_NTHRES2__MASK           0x04      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMDIRQ_RAINFADE__MASK          0x08      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMDIRQ_DISLK__MASK             0x10      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DMD_SGNLCUT__MASK              0x20      
#define FC8CODEW_DVBSX_DEMOD_DEMODEND_DEMOD_I2CLOCK__MASK            0x80      


/* Number of registers */
#define C8CODEW_DVBSX_DEMOD_REG_NBREGS                               533       

/* Number of fields */
#define C8CODEW_DVBSX_DEMOD_REG_NBFIELDS                             1221      



#endif /* #ifndef _DVBSX_DEMOD_REG_INIT_H */
