/* 
* This file is part of STiD135 OXFORD LLA 
* 
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
* 
* License terms: BSD 3-clause "New" or "Revised" License. 
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
* 
*/ 
#ifndef _DVBSX_HWARE_REG_INIT_H
#define _DVBSX_HWARE_REG_INIT_H

/* -------------------------------------------------------------------------
 * File name  : dvbsx_hware_reg_init.h
 * File type  : C header file
 * -------------------------------------------------------------------------
 * Description:  Register map constants
 * Generated by spirit2regtest v2.24_alpha3
 * -------------------------------------------------------------------------
 */


/* Register map constants */

/* TSSTATE1 */
#define RC8CODEW_DVBSX_HWARE_TSSTATE1                                0x00000000
#define RC8CODEW_DVBSX_HWARE_TSSTATE1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSOUT_NOSYNC__MASK             0x01      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSACM_MODE__MASK               0x02      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TS_DISABLE__MASK               0x04      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSFRAME_MODE__MASK             0x08      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSDESCRAMB_ON__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSRS_ON__MASK                  0x20      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSSKIPRS_ON__MASK              0x40      
#define FC8CODEW_DVBSX_HWARE_TSSTATE1_TSDIL_ON__MASK                 0x80      

/* TSSTATE0 */
#define RC8CODEW_DVBSX_HWARE_TSSTATE0                                0x00000001
#define RC8CODEW_DVBSX_HWARE_TSSTATE0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSDSS_PACKET__MASK             0x01      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSCRC8_ON__MASK                0x02      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSNPD_ON__MASK                 0x04      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSISSYI_ON__MASK               0x08      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSDVBX2_MODE__MASK             0x10      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSSYNCOUTRS_ON__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSPARITY_ON__MASK              0x40      
#define FC8CODEW_DVBSX_HWARE_TSSTATE0_TSNOSYNCBYTE__MASK             0x80      

/* TSCFG2 */
#define RC8CODEW_DVBSX_HWARE_TSCFG2                                  0x00000002
#define RC8CODEW_DVBSX_HWARE_TSCFG2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG2_RST_HWARE__MASK                  0x01      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_ERRMODE__MASK             0x06      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_HSGNLOUT__MASK            0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_DUTY50__MASK              0x10      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_TEIUPDATE__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_SERIAL__MASK              0x40      
#define FC8CODEW_DVBSX_HWARE_TSCFG2_TSFIFO_DVBCI__MASK               0x80      

/* TSCFG1 */
#define RC8CODEW_DVBSX_HWARE_TSCFG1                                  0x00000003
#define RC8CODEW_DVBSX_HWARE_TSCFG1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG1_TSFIFO_INVDATA__MASK             0x01      
#define FC8CODEW_DVBSX_HWARE_TSCFG1_TSFIFO_DPUNACTIVE__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG1_TSFIFO_NONEWSGNL__MASK           0x10      
#define FC8CODEW_DVBSX_HWARE_TSCFG1_TSFIFO_PERMDATA__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSCFG1_TSFIFO_MANSPEED__MASK            0xC0      

/* TSCFG0 */
#define RC8CODEW_DVBSX_HWARE_TSCFG0                                  0x00000004
#define RC8CODEW_DVBSX_HWARE_TSCFG0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG0_TSFIFO_BITSPEED__MASK            0x03      
#define FC8CODEW_DVBSX_HWARE_TSCFG0_TSFIFO_EMBINDVB__MASK            0x04      
#define FC8CODEW_DVBSX_HWARE_TSCFG0_TSFIFO_NSGNL2DATA__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG0_BCHERROR_MODE__MASK              0x30      
#define FC8CODEW_DVBSX_HWARE_TSCFG0_TSFIFO_BCLKDEL1CK__MASK          0xC0      

/* TSSYNC */
#define RC8CODEW_DVBSX_HWARE_TSSYNC                                  0x00000005
#define RC8CODEW_DVBSX_HWARE_TSSYNC__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSSYNC_TSFIFO_2BITMODE__MASK            0x03      
#define FC8CODEW_DVBSX_HWARE_TSSYNC_TSFIFO_SYNCMODE__MASK            0x18      
#define FC8CODEW_DVBSX_HWARE_TSSYNC_TSFIFO_FISCR3B__MASK             0x60      
#define FC8CODEW_DVBSX_HWARE_TSSYNC_TSFIFO_PERMUTE__MASK             0x80      

/* TSDIVN */
#define RC8CODEW_DVBSX_HWARE_TSDIVN                                  0x00000006
#define RC8CODEW_DVBSX_HWARE_TSDIVN__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSDIVN_TSFIFO_RISEOK__MASK              0x07      
#define FC8CODEW_DVBSX_HWARE_TSDIVN_BYTE_OVERSAMPLING__MASK          0x38      
#define FC8CODEW_DVBSX_HWARE_TSDIVN_TSFIFO_SPEEDMODE__MASK           0xC0      

/* TSCFG4 */
#define RC8CODEW_DVBSX_HWARE_TSCFG4                                  0x00000007
#define RC8CODEW_DVBSX_HWARE_TSCFG4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_DELSPEEDUP__MASK          0x01      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_EXT_FECSPYIN__MASK               0x02      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_FRFORCEPKT__MASK          0x04      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_NWATCHDOG__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_SPECTOKEN__MASK           0x10      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_HIERSEL__MASK             0x20      
#define FC8CODEW_DVBSX_HWARE_TSCFG4_TSFIFO_TSSPEEDMODE__MASK         0xC0      

/* TSHEMCFG */
#define RC8CODEW_DVBSX_HWARE_TSHEMCFG                                0x00000008
#define RC8CODEW_DVBSX_HWARE_TSHEMCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_TSFIFO_GSEDECAP__MASK          0x01      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_TSBITRATE_SLOW__MASK           0x02      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_TSBITRATE_LSBSELECT__MASK      0x04      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_DIS_ISCRRETARD__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_ISCR_SURESTIMATION__MASK       0x10      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_EN_TTODELETE__MASK             0x60      
#define FC8CODEW_DVBSX_HWARE_TSHEMCFG_ENDIS_TTOISCR__MASK            0x80      

/* TSCPLPCFG */
#define RC8CODEW_DVBSX_HWARE_TSCPLPCFG                               0x00000009
#define RC8CODEW_DVBSX_HWARE_TSCPLPCFG__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_SEL_TTOLATENCE__MASK          0x07      
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_DIS_CPLPERASE__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_NSTOPCOMMON_TTOA__MASK        0x10      
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_PKTFRAME_BUGSEL__MASK         0x20      
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_TSFIFO_NPDSGNL__MASK          0x40      
#define FC8CODEW_DVBSX_HWARE_TSCPLPCFG_TSFIFO_FSPYCPLP__MASK         0x80      

/* TSPCRCFG */
#define RC8CODEW_DVBSX_HWARE_TSPCRCFG                                0x0000000a
#define RC8CODEW_DVBSX_HWARE_TSPCRCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_27MHZ__MASK             0x03      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_RESET__MASK             0x04      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_FASTTRK__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_PCROUT__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_NCRMODE__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_PROTECT__MASK           0x40      
#define FC8CODEW_DVBSX_HWARE_TSPCRCFG_PCRADJ_ENABLE__MASK            0x80      

/* TSPCRPID1 */
#define RC8CODEW_DVBSX_HWARE_TSPCRPID1                               0x0000000b
#define RC8CODEW_DVBSX_HWARE_TSPCRPID1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRPID1_TSFIFO_PCRPID__MASK           0x1F      
#define FC8CODEW_DVBSX_HWARE_TSPCRPID1_TSFIFO_AUTOPCR__MASK          0x20      
#define FC8CODEW_DVBSX_HWARE_TSPCRPID1_MPEGSGNL_PID__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_TSPCRPID1_SOFFIFO_PCRADJ__MASK          0x80      

/* TSPCRPID0 */
#define RC8CODEW_DVBSX_HWARE_TSPCRPID0                               0x0000000c
#define RC8CODEW_DVBSX_HWARE_TSPCRPID0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRPID0_TSFIFO_PCRPID__MASK           0xFF      

/* TSNCRCFG */
#define RC8CODEW_DVBSX_HWARE_TSNCRCFG                                0x0000000d
#define RC8CODEW_DVBSX_HWARE_TSNCRCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_TSFIFO_NCRCKOUT__MASK          0x03      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_NCRADJ_NCRBYTE__MASK           0x04      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_NCRADJ_INTERLDLY__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_NCRADJ_NVERIF__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_TSXCROBS_MODE__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_NCRADJ_PROTECT__MASK           0x40      
#define FC8CODEW_DVBSX_HWARE_TSNCRCFG_NCRADJ_ENABLE__MASK            0x80      

/* TSNCRPID1 */
#define RC8CODEW_DVBSX_HWARE_TSNCRPID1                               0x0000000e
#define RC8CODEW_DVBSX_HWARE_TSNCRPID1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRPID1_TSFIFO_NCRPID__MASK           0x1F      
#define FC8CODEW_DVBSX_HWARE_TSNCRPID1_NCRADJ_MANUEL__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSNCRPID1_NCROUT_SEROFF__MASK           0x40      
#define FC8CODEW_DVBSX_HWARE_TSNCRPID1_NCRADJ_FINEMODE__MASK         0x80      

/* TSNCRPID0 */
#define RC8CODEW_DVBSX_HWARE_TSNCRPID0                               0x0000000f
#define RC8CODEW_DVBSX_HWARE_TSNCRPID0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRPID0_TSFIFO_NCRPID__MASK           0xFF      

/* TSNCRADJ2 */
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ2                               0x00000010
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRADJ2_TSFIFO_NCRADJUST__MASK        0x7F      
#define FC8CODEW_DVBSX_HWARE_TSNCRADJ2_NCRADJUST_MODE__MASK          0x80      

/* TSNCRADJ1 */
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ1                               0x00000011
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRADJ1_TSFIFO_NCRADJUST__MASK        0xFF      

/* TSNCRADJ0 */
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ0                               0x00000012
#define RC8CODEW_DVBSX_HWARE_TSNCRADJ0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSNCRADJ0_TSFIFO_NCRADJUST__MASK        0xFF      

/* TSPIDFLTM */
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTM                               0x00000013
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTM__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTM_PIDFLT_ADDR__MASK             0xFF      

/* TSPIDFLTL */
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTL                               0x00000014
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTL_PIDFLT_DATA__MASK             0xFF      

/* TSPIDFLTC */
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTC                               0x00000015
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTC__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_DELDEFAUT__MASK        0x01      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_SAVEBRATE__MASK        0x02      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_DELMAC__MASK           0x04      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_DELGSE__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_LEAKPKT__MASK          0x30      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTC_PIDFLT_ENABLE__MASK           0xC0      

/* TSDLYSET2 */
#define RC8CODEW_DVBSX_HWARE_TSDLYSET2                               0x00000016
#define RC8CODEW_DVBSX_HWARE_TSDLYSET2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLYSET2_SOFFIFO_SYMBOFFS__MASK        0x0F      
#define FC8CODEW_DVBSX_HWARE_TSDLYSET2_HYSTERESIS_THRESHOLD__MASK    0x30      
#define FC8CODEW_DVBSX_HWARE_TSDLYSET2_SOFFIFO_OFFSET__MASK          0xC0      

/* TSDLYSET1 */
#define RC8CODEW_DVBSX_HWARE_TSDLYSET1                               0x00000017
#define RC8CODEW_DVBSX_HWARE_TSDLYSET1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLYSET1_SOFFIFO_SYMBOFFS__MASK        0xFF      

/* TSDLYSET0 */
#define RC8CODEW_DVBSX_HWARE_TSDLYSET0                               0x00000018
#define RC8CODEW_DVBSX_HWARE_TSDLYSET0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLYSET0_SOFFIFO_SYMBOFFS__MASK        0xFF      

/* TSINSDELH */
#define RC8CODEW_DVBSX_HWARE_TSINSDELH                               0x00000019
#define RC8CODEW_DVBSX_HWARE_TSINSDELH__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSINSDEL_CRC8__MASK           0x01      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSINSDEL_RSPARITY__MASK       0x02      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSINSDEL_NPD__MASK            0x04      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSINSDEL_ISCR__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSDEL_DATAFIELD__MASK         0x10      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSDEL_BBHEADER__MASK          0x20      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSDEL_XXHEADER__MASK          0x40      
#define FC8CODEW_DVBSX_HWARE_TSINSDELH_TSINSDEL_SYNCBYTE__MASK       0x80      

/* TSINSDELM */
#define RC8CODEW_DVBSX_HWARE_TSINSDELM                               0x0000001a
#define RC8CODEW_DVBSX_HWARE_TSINSDELM__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_UPL__MASK               0x01      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_MATYPE__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_XXXERR__MASK            0x04      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_TOKEN__MASK             0x08      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_EMODCOD__MASK           0x10      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_MPEGSGNL__MASK          0x20      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_BCHFEC__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_TSINSDELM_TSINS_BBPADDING__MASK         0x80      

/* TSINSDELL */
#define RC8CODEW_DVBSX_HWARE_TSINSDELL                               0x0000001b
#define RC8CODEW_DVBSX_HWARE_TSINSDELL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_LATENCY__MASK           0x01      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_TSCONFIG__MASK          0x02      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_REALPACK__MASK          0x04      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_FIFO__MASK              0x08      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_SIGPCOUNT__MASK         0x10      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_BLOCLEN__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_SYNCD__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSINSDELL_TSINS_DFL__MASK               0x80      

/* TSCFG5 */
#define RC8CODEW_DVBSX_HWARE_TSCFG5                                  0x0000001c
#define RC8CODEW_DVBSX_HWARE_TSCFG5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG5_TSPCR_OBSMODE__MASK              0x07      
#define FC8CODEW_DVBSX_HWARE_TSCFG5_DIS_SOFADJUST__MASK              0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG5_DIS_TSEXPMODE__MASK              0x10      
#define FC8CODEW_DVBSX_HWARE_TSCFG5_DIS_XCRCLOCKLSB__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSCFG5_XCRCLK_NOVERIF__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSCFG5_PCRADJ_MANUEL__MASK              0x80      

/* TSCFG6 */
#define RC8CODEW_DVBSX_HWARE_TSCFG6                                  0x0000001d
#define RC8CODEW_DVBSX_HWARE_TSCFG6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSCFG6_NOSLOW_ISCRUNIT__MASK            0x01      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIS_ISCRACCEL__MASK              0x02      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_NCRADJ_PLFM0__MASK               0x04      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIS_NCRBBFRAME__MASK             0x08      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIL_NMAXSPEED__MASK              0x10      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIS_DMDPREDSKIP__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIS_PREACCEL__MASK               0x40      
#define FC8CODEW_DVBSX_HWARE_TSCFG6_DIS_ISCRTEST__MASK               0x80      

/* TSPIDFLTD */
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTD                               0x0000001e
#define RC8CODEW_DVBSX_HWARE_TSPIDFLTD__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTD_PIDFLT_CPTMODE__MASK          0x01      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTD_PIDFLT_ADAPTPROT__MASK        0x02      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTD_STFEPKT_CONTENT__MASK         0x04      
#define FC8CODEW_DVBSX_HWARE_TSPIDFLTD_PIDFLT_UNIVERSEL__MASK        0x08      

/* TSSAMPDLY */
#define RC8CODEW_DVBSX_HWARE_TSSAMPDLY                               0x0000001f
#define RC8CODEW_DVBSX_HWARE_TSSAMPDLY__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSSAMPDLY_TSFIFO_SAMPDELAYX2__MASK      0xFF      

/* TSMINSPEED */
#define RC8CODEW_DVBSX_HWARE_TSMINSPEED                              0x00000020
#define RC8CODEW_DVBSX_HWARE_TSMINSPEED__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSMINSPEED_TSFIFO_MINSPEED__MASK        0xFF      

/* TSMAXSPEED */
#define RC8CODEW_DVBSX_HWARE_TSMAXSPEED                              0x00000021
#define RC8CODEW_DVBSX_HWARE_TSMAXSPEED__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSMAXSPEED_TSFIFO_MAXSPEED__MASK        0xFF      

/* TSSPEED */
#define RC8CODEW_DVBSX_HWARE_TSSPEED                                 0x00000022
#define RC8CODEW_DVBSX_HWARE_TSSPEED__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_HWARE_TSSPEED_TSFIFO_OUTSPEED__MASK           0xFF      

/* TSDILSTK1 */
#define RC8CODEW_DVBSX_HWARE_TSDILSTK1                               0x00000024
#define RC8CODEW_DVBSX_HWARE_TSDILSTK1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSDILSTK1_TSFIFO_DILSTK__MASK           0xFF      

/* TSDILSTK0 */
#define RC8CODEW_DVBSX_HWARE_TSDILSTK0                               0x00000025
#define RC8CODEW_DVBSX_HWARE_TSDILSTK0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSDILSTK0_TSFIFO_DILSTK__MASK           0xFF      

/* TSSTATUS */
#define RC8CODEW_DVBSX_HWARE_TSSTATUS                                0x00000026
#define RC8CODEW_DVBSX_HWARE_TSSTATUS__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_DIL_READY__MASK                0x01      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_SOFFIFO_UNREGUL__MASK          0x02      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_TSREGUL_ERROR__MASK            0x04      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_ISCR_INITIALIZED__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_TSFIFO_NOSYNC__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_TSFIFO_DATA7__MASK             0x20      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_TSFIFO_ERROR__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS_TSFIFO_LINEOK__MASK            0x80      

/* TSSTATUS2 */
#define RC8CODEW_DVBSX_HWARE_TSSTATUS2                               0x00000027
#define RC8CODEW_DVBSX_HWARE_TSSTATUS2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_ULDTV67_FALSELOCK__MASK       0x01      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_SCRAMBDETECT__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_TSFIFO_MUXSTREAM__MASK        0x04      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_TSFIFO_LINENOK__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_TSSPEED_IMPOSSIBLE__MASK      0x10      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_DIL_NOSYNC__MASK              0x20      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_TSFIFOSPEED_STORE__MASK       0x40      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS2_TSFIFO_DEMODSEL__MASK         0x80      

/* TSSTATUS3 */
#define RC8CODEW_DVBSX_HWARE_TSSTATUS3                               0x00000028
#define RC8CODEW_DVBSX_HWARE_TSSTATUS3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSSTATUS3_PCRCALC_NCRREADY__MASK        0x03      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS3_PCRCALC_PCRREADY__MASK        0x04      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS3_PCRCALC_ERROR__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSSTATUS3_TSFIFO_PKTDESC__MASK          0xF0      

/* TSMODCOD1 */
#define RC8CODEW_DVBSX_HWARE_TSMODCOD1                               0x00000029
#define RC8CODEW_DVBSX_HWARE_TSMODCOD1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSMODCOD1_TSFIFO_CODINGMODE__MASK       0x0F      
#define FC8CODEW_DVBSX_HWARE_TSMODCOD1_TSFIFO_HEMMODE__MASK          0x10      
#define FC8CODEW_DVBSX_HWARE_TSMODCOD1_SFECRAM_DILUSE__MASK          0x20      
#define FC8CODEW_DVBSX_HWARE_TSMODCOD1_SFECRAM_TOKUSE__MASK          0x40      
#define FC8CODEW_DVBSX_HWARE_TSMODCOD1_TSFIFO_SERIALLOCK__MASK       0x80      

/* TSMODCOD0 */
#define RC8CODEW_DVBSX_HWARE_TSMODCOD0                               0x0000002a
#define RC8CODEW_DVBSX_HWARE_TSMODCOD0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSMODCOD0_TSFIFO_TYPE__MASK             0x03      
#define FC8CODEW_DVBSX_HWARE_TSMODCOD0_TSFIFO_MODCOD__MASK           0xFC      

/* TSBITRATE1 */
#define RC8CODEW_DVBSX_HWARE_TSBITRATE1                              0x00000030
#define RC8CODEW_DVBSX_HWARE_TSBITRATE1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBITRATE1_TSFIFO_BITRATE__MASK         0xFF      

/* TSBITRATE0 */
#define RC8CODEW_DVBSX_HWARE_TSBITRATE0                              0x00000031
#define RC8CODEW_DVBSX_HWARE_TSBITRATE0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBITRATE0_TSFIFO_BITRATE__MASK         0xFF      

/* TSPACKLEN1 */
#define RC8CODEW_DVBSX_HWARE_TSPACKLEN1                              0x00000032
#define RC8CODEW_DVBSX_HWARE_TSPACKLEN1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSPACKLEN1_TSFIFO_REALPKTLEN__MASK      0x1F      
#define FC8CODEW_DVBSX_HWARE_TSPACKLEN1_TSFIFO_PACKCPT__MASK         0xE0      

/* TSPACKLEN0 */
#define RC8CODEW_DVBSX_HWARE_TSPACKLEN0                              0x00000033
#define RC8CODEW_DVBSX_HWARE_TSPACKLEN0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSPACKLEN0_TSFIFO_REALPKTLEN__MASK      0xFF      

/* TSBLOCLEN1 */
#define RC8CODEW_DVBSX_HWARE_TSBLOCLEN1                              0x00000034
#define RC8CODEW_DVBSX_HWARE_TSBLOCLEN1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBLOCLEN1_TSFIFO_PLFRAMELEN__MASK      0xFF      

/* TSBLOCLEN0 */
#define RC8CODEW_DVBSX_HWARE_TSBLOCLEN0                              0x00000035
#define RC8CODEW_DVBSX_HWARE_TSBLOCLEN0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBLOCLEN0_TSFIFO_PLFRAMELEN__MASK      0xFF      

/* TSDLY2 */
#define RC8CODEW_DVBSX_HWARE_TSDLY2                                  0x00000036
#define RC8CODEW_DVBSX_HWARE_TSDLY2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLY2_SOFFIFO_LATENCY__MASK            0x0F      
#define FC8CODEW_DVBSX_HWARE_TSDLY2_SOFFIFO_REGULATED__MASK          0x10      
#define FC8CODEW_DVBSX_HWARE_TSDLY2_SOFFIFO_STOP__MASK               0x20      
#define FC8CODEW_DVBSX_HWARE_TSDLY2_SOFFIFO_SPEEDUP__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_TSDLY2_SOFFIFO_TSTIMEV__MASK            0x80      

/* TSDLY1 */
#define RC8CODEW_DVBSX_HWARE_TSDLY1                                  0x00000037
#define RC8CODEW_DVBSX_HWARE_TSDLY1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLY1_SOFFIFO_LATENCY__MASK            0xFF      

/* TSDLY0 */
#define RC8CODEW_DVBSX_HWARE_TSDLY0                                  0x00000038
#define RC8CODEW_DVBSX_HWARE_TSDLY0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSDLY0_SOFFIFO_LATENCY__MASK            0xFF      

/* ISCRUNIT2 */
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT2                               0x00000039
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_ISCRUNIT2_I2C_ISCRUNIT__MASK            0x3F      
#define FC8CODEW_DVBSX_HWARE_ISCRUNIT2_I2C_ISCRFINE__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_ISCRUNIT2_ISCRUNIT_WRMODE__MASK         0x80      

/* ISCRUNIT1 */
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT1                               0x0000003a
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_ISCRUNIT1_I2C_ISCRUNIT__MASK            0xFF      

/* ISCRUNIT0 */
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT0                               0x0000003b
#define RC8CODEW_DVBSX_HWARE_ISCRUNIT0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_ISCRUNIT0_I2C_ISCRUNIT__MASK            0xFF      

/* TSNPDAV */
#define RC8CODEW_DVBSX_HWARE_TSNPDAV                                 0x0000003c
#define RC8CODEW_DVBSX_HWARE_TSNPDAV__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_HWARE_TSNPDAV_TSNPD_AVERAGE__MASK             0xFF      

/* TSBUFSTAT2 */
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT2                              0x0000003d
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBUFSTAT2_TSISCR_BUFSTAT__MASK         0x3F      
#define FC8CODEW_DVBSX_HWARE_TSBUFSTAT2_TSISCR_NEWDATA__MASK         0x40      
#define FC8CODEW_DVBSX_HWARE_TSBUFSTAT2_TSISCR_3BYTES__MASK          0x80      

/* TSBUFSTAT1 */
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT1                              0x0000003e
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBUFSTAT1_TSISCR_BUFSTAT__MASK         0xFF      

/* TSBUFSTAT0 */
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT0                              0x0000003f
#define RC8CODEW_DVBSX_HWARE_TSBUFSTAT0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSBUFSTAT0_TSISCR_BUFSTAT__MASK         0xFF      

/* TSXCROBS1 */
#define RC8CODEW_DVBSX_HWARE_TSXCROBS1                               0x00000040
#define RC8CODEW_DVBSX_HWARE_TSXCROBS1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSXCROBS1_NCRTIME_DERIVE__MASK          0xFF      

/* TSXCROBS0 */
#define RC8CODEW_DVBSX_HWARE_TSXCROBS0                               0x00000041
#define RC8CODEW_DVBSX_HWARE_TSXCROBS0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSXCROBS0_NCRTIME_DERIVE__MASK          0xFF      

/* TSPCR272 */
#define RC8CODEW_DVBSX_HWARE_TSPCR272                                0x00000042
#define RC8CODEW_DVBSX_HWARE_TSPCR272__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCR272_TSFIFO_PCRCLOCK_MANT__MASK     0x3F      
#define FC8CODEW_DVBSX_HWARE_TSPCR272_TSFIFO_PCRCLOCK_4EXP__MASK     0xC0      

/* TSPCR271 */
#define RC8CODEW_DVBSX_HWARE_TSPCR271                                0x00000043
#define RC8CODEW_DVBSX_HWARE_TSPCR271__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCR271_TSFIFO_PCRCLOCK_MANT__MASK     0xFF      

/* TSPCR270 */
#define RC8CODEW_DVBSX_HWARE_TSPCR270                                0x00000044
#define RC8CODEW_DVBSX_HWARE_TSPCR270__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCR270_TSFIFO_PCRCLOCK_MANT__MASK     0xFF      

/* TSPCRADJ2 */
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ2                               0x00000045
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRADJ2_TSFIFO_PCRADJUST__MASK        0xFF      

/* TSPCRADJ1 */
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ1                               0x00000046
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRADJ1_TSFIFO_PCRADJUST__MASK        0xFF      

/* TSPCRADJ0 */
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ0                               0x00000047
#define RC8CODEW_DVBSX_HWARE_TSPCRADJ0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSPCRADJ0_TSFIFO_PCRADJUST__MASK        0xFF      

/* TSDEBUG1 */
#define RC8CODEW_DVBSX_HWARE_TSDEBUG1                                0x00000050
#define RC8CODEW_DVBSX_HWARE_TSDEBUG1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_SOFFIFO_SPEEDUPM__MASK         0x01      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_SOFFIFO_STOPM__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_TIMING_OVERFLOW__MASK          0x04      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_TSFIFO_EMPTYPKT__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_DILOUT_BSYNCB__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_DIL_LONGISSYI__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_DVBDIL_RDRESET__MASK           0x40      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG1_TSFIFO_ILLPACKET__MASK         0x80      

/* TSDEBUG0 */
#define RC8CODEW_DVBSX_HWARE_TSDEBUG0                                0x00000051
#define RC8CODEW_DVBSX_HWARE_TSDEBUG0__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_OVERFLOWM__MASK         0x01      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSSPEED_OVERFLOW__MASK         0x02      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_ERROR_EVNT__MASK        0x04      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_BOOSTDELM__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_BOOSTSPDM__MASK         0x10      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_VITLIBRE__MASK          0x20      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_SYNCBFAIL__MASK         0x40      
#define FC8CODEW_DVBSX_HWARE_TSDEBUG0_TSFIFO_PCKLENFAIL__MASK        0x80      

/* TSOBSCFG */
#define RC8CODEW_DVBSX_HWARE_TSOBSCFG                                0x00000052
#define RC8CODEW_DVBSX_HWARE_TSOBSCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSOBSCFG_TSFIFO_OBSCFG__MASK            0xFF      

/* TSOBS1 */
#define RC8CODEW_DVBSX_HWARE_TSOBS1                                  0x00000053
#define RC8CODEW_DVBSX_HWARE_TSOBS1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSOBS1_TSFIFO_OBSDATA__MASK             0xFF      

/* TSOBS0 */
#define RC8CODEW_DVBSX_HWARE_TSOBS0                                  0x00000054
#define RC8CODEW_DVBSX_HWARE_TSOBS0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSOBS0_TSFIFO_OBSDATA__MASK             0xFF      

/* ERRCTRL1 */
#define RC8CODEW_DVBSX_HWARE_ERRCTRL1                                0x00000060
#define RC8CODEW_DVBSX_HWARE_ERRCTRL1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCTRL1_NUM_EVENT1__MASK               0x07      
#define FC8CODEW_DVBSX_HWARE_ERRCTRL1_ERRPAGE2_SOURCE1__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_ERRCTRL1_ERR_SOURCE1__MASK              0xF0      

/* ERRCNT12 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT12                                0x00000061
#define RC8CODEW_DVBSX_HWARE_ERRCNT12__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT12_ERR_CNT1__MASK                 0x7F      
#define FC8CODEW_DVBSX_HWARE_ERRCNT12_ERRCNT1_OLDVALUE__MASK         0x80      

/* ERRCNT11 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT11                                0x00000062
#define RC8CODEW_DVBSX_HWARE_ERRCNT11__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT11_ERR_CNT1__MASK                 0xFF      

/* ERRCNT10 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT10                                0x00000063
#define RC8CODEW_DVBSX_HWARE_ERRCNT10__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT10_ERR_CNT1__MASK                 0xFF      

/* ERRCTRL2 */
#define RC8CODEW_DVBSX_HWARE_ERRCTRL2                                0x00000064
#define RC8CODEW_DVBSX_HWARE_ERRCTRL2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCTRL2_NUM_EVENT2__MASK               0x07      
#define FC8CODEW_DVBSX_HWARE_ERRCTRL2_ERRPAGE2_SOURCE2__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_ERRCTRL2_ERR_SOURCE2__MASK              0xF0      

/* ERRCNT22 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT22                                0x00000065
#define RC8CODEW_DVBSX_HWARE_ERRCNT22__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT22_ERR_CNT2__MASK                 0x7F      
#define FC8CODEW_DVBSX_HWARE_ERRCNT22_ERRCNT2_OLDVALUE__MASK         0x80      

/* ERRCNT21 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT21                                0x00000066
#define RC8CODEW_DVBSX_HWARE_ERRCNT21__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT21_ERR_CNT2__MASK                 0xFF      

/* ERRCNT20 */
#define RC8CODEW_DVBSX_HWARE_ERRCNT20                                0x00000067
#define RC8CODEW_DVBSX_HWARE_ERRCNT20__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_ERRCNT20_ERR_CNT2__MASK                 0xFF      

/* TSTTS1 */
#define RC8CODEW_DVBSX_HWARE_TSTTS1                                  0x00000070
#define RC8CODEW_DVBSX_HWARE_TSTTS1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TSTTSEN__MASK                    0x01      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_DESCR_NOTAUTO__MASK              0x02      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TTO_GENMODE__MASK                0x04      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TSTTS_NOFTHRESHOLD__MASK         0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TSTTS_EMBINDVB__MASK             0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TSTTS_FSPYBEFRS__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_TSFIFO_DSSSYNCB__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS1_DIS_SOFFIFOOV__MASK              0x80      

/* TSTTS2 */
#define RC8CODEW_DVBSX_HWARE_TSTTS2                                  0x00000071
#define RC8CODEW_DVBSX_HWARE_TSTTS2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS2_TSTTS_SELECT__MASK               0x1F      
#define FC8CODEW_DVBSX_HWARE_TSTTS2_SOFFIFO_DECIMDIS__MASK           0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS2_TSTTS_NOBADXXX__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS2_DIL_DBBHEADER__MASK              0x80      

/* TSTTS3 */
#define RC8CODEW_DVBSX_HWARE_TSTTS3                                  0x00000072
#define RC8CODEW_DVBSX_HWARE_TSTTS3__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS3_TSTTS_STACKSEL__MASK             0x07      
#define FC8CODEW_DVBSX_HWARE_TSTTS3_TSTTS_NOBADSTART__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS3_TSTTS_DISBUG__MASK               0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS3_TSTTS_ISOLATION__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS3_DIS_ISCRRYTHME__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS3_RESET_SOFFIFO__MASK              0x80      

/* TSTTS4 */
#define RC8CODEW_DVBSX_HWARE_TSTTS4                                  0x00000073
#define RC8CODEW_DVBSX_HWARE_TSTTS4__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS4_TSTTS_NODIV3__MASK               0x01      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_TSTTS_NODPZERO__MASK             0x02      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_DIS_PLOADFAST__MASK              0x04      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_TSTTS_FASTNOSYNC__MASK           0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_EN_EFFEXP__MASK                  0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_DIS_TOKFILTER__MASK              0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_TSTTS_INPUTOFF__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS4_DIS_RSTRDCNT__MASK               0x80      

/* TSTTS5 */
#define RC8CODEW_DVBSX_HWARE_TSTTS5                                  0x00000074
#define RC8CODEW_DVBSX_HWARE_TSTTS5__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS5_TSTDMD_XXMODE__MASK              0x07      
#define FC8CODEW_DVBSX_HWARE_TSTTS5_TSTDMD_HWARE__MASK               0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS5_DIS_ABANDHSGNL__MASK             0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS5_NOGEN_SPECIALTOKEN2__MASK        0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS5_DIS_SUMDELDFL__MASK              0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS5_DIS_DELACCEL__MASK               0x80      

/* TSTTS6 */
#define RC8CODEW_DVBSX_HWARE_TSTTS6                                  0x00000075
#define RC8CODEW_DVBSX_HWARE_TSTTS6__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS6_TSFIFO_SYNCSEL__MASK             0x07      
#define FC8CODEW_DVBSX_HWARE_TSTTS6_TSSLICE_SELECT__MASK             0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS6_DMDTIME_DIV__MASK                0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS6_SFECRAM_NOREUSE__MASK            0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS6_DISHWARE_CLKENABL__MASK          0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS6_DIS_SYNCDLIM__MASK               0x80      

/* TSTTS7 */
#define RC8CODEW_DVBSX_HWARE_TSTTS7                                  0x00000076
#define RC8CODEW_DVBSX_HWARE_TSTTS7__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTS7_DIS_TOKSAVEDEL__MASK             0x01      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_DIS_SYNCDMAX__MASK               0x02      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_DIS_DIRECTCRC8__MASK             0x04      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_DIS_HWAREOFF__MASK               0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_SFECRAM_INVSEL__MASK             0x10      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_NCRADJ_NOFINE__MASK              0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_NCRADJ_CALCERR__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSTTS7_NCRADJ_XSOFWAIT__MASK            0x80      

/* TSTCPLP */
#define RC8CODEW_DVBSX_HWARE_TSTCPLP                                 0x00000077
#define RC8CODEW_DVBSX_HWARE_TSTCPLP__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_DIS_ISCRVERIF__MASK             0x01      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_DIS_PKT2XSPEED__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_ENDIS_TOKSELECT__MASK           0x04      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_CPLP_SYNCBYTE__MASK             0x08      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_TTO_OVERMODE__MASK              0x30      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_DIS_INBANDTTO__MASK             0x40      
#define FC8CODEW_DVBSX_HWARE_TSTCPLP_NORST_ADJOV__MASK               0x80      

/* TSRCSCFG */
#define RC8CODEW_DVBSX_HWARE_TSRCSCFG                                0x00000080
#define RC8CODEW_DVBSX_HWARE_TSRCSCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_TSRCS_MODE__MASK               0x03      
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_TSRCS_NCROUT__MASK             0x04      
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_TSRCS_INVGATE__MASK            0x08      
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_NCROUT_CLKLEN__MASK            0x30      
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_TSRCS_CONTCLK__MASK            0x40      
#define FC8CODEW_DVBSX_HWARE_TSRCSCFG_TSRCS_EXTGATE__MASK            0x80      

/* TSRCSSTAT */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTAT                               0x00000081
#define RC8CODEW_DVBSX_HWARE_TSRCSSTAT__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_DONE__MASK              0x01      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_FAIL__MASK              0x02      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_READY__MASK             0x04      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_SGNVAL__MASK            0x08      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_SELCMP__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_NCROUT_SLOW__MASK             0x20      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSFIFO_DSSPKT__MASK           0x40      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTAT_TSRCS_GATE__MASK              0x80      

/* TSRCSSTART5 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART5                             0x00000082
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART5__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART5_TSRCSMSB_START__MASK        0xFF      

/* TSRCSSTART4 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART4                             0x00000083
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART4__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART4_TSRCSMSB_START__MASK        0xFF      

/* TSRCSSTART3 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART3                             0x00000084
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART3__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART3_TSRCSMSB_START__MASK        0xFF      

/* TSRCSSTART2 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART2                             0x00000085
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART2__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART2_TSRCSMSB_START__MASK        0xFF      

/* TSRCSSTART1 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART1                             0x00000086
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART1__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCS300_START__MASK        0x01      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCS_STARTLOCK__MASK       0x02      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCS_STARTLOAD__MASK       0x1C      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCS_PERMUTE__MASK         0x20      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCS_MESGATE__MASK         0x40      
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART1_TSRCSMSB_START__MASK        0x80      

/* TSRCSSTART0 */
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART0                             0x00000087
#define RC8CODEW_DVBSX_HWARE_TSRCSSTART0__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSSTART0_TSRCS300_START__MASK        0xFF      

/* TSRCSEND5 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND5                               0x00000088
#define RC8CODEW_DVBSX_HWARE_TSRCSEND5__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND5_TSRCSMSB_END__MASK            0xFF      

/* TSRCSEND4 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND4                               0x00000089
#define RC8CODEW_DVBSX_HWARE_TSRCSEND4__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND4_TSRCSMSB_END__MASK            0xFF      

/* TSRCSEND3 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND3                               0x0000008a
#define RC8CODEW_DVBSX_HWARE_TSRCSEND3__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND3_TSRCSMSB_END__MASK            0xFF      

/* TSRCSEND2 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND2                               0x0000008b
#define RC8CODEW_DVBSX_HWARE_TSRCSEND2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND2_TSRCSMSB_END__MASK            0xFF      

/* TSRCSEND1 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND1                               0x0000008c
#define RC8CODEW_DVBSX_HWARE_TSRCSEND1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_TSRCS300_END__MASK            0x01      
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_TSRCS_ENDLOCK__MASK           0x02      
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_TSRCS_ENDLOAD__MASK           0x1C      
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_TSRCS_DEBUG__MASK             0x20      
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_NCRADJ_FORCE27__MASK          0x40      
#define FC8CODEW_DVBSX_HWARE_TSRCSEND1_TSRCSMSB_END__MASK            0x80      

/* TSRCSEND0 */
#define RC8CODEW_DVBSX_HWARE_TSRCSEND0                               0x0000008d
#define RC8CODEW_DVBSX_HWARE_TSRCSEND0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSEND0_TSRCS300_END__MASK            0xFF      

/* TSRCSPRE */
#define RC8CODEW_DVBSX_HWARE_TSRCSPRE                                0x0000008f
#define RC8CODEW_DVBSX_HWARE_TSRCSPRE__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSPRE_TSRCSPRE_LEN__MASK             0x7F      
#define FC8CODEW_DVBSX_HWARE_TSRCSPRE_TSRCSPRE_MODE__MASK            0x80      

/* TSRCSTIME5 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME5                              0x00000090
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME5__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME5_TSRCSMSB_TIME__MASK          0xFF      

/* TSRCSTIME4 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME4                              0x00000091
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME4__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME4_TSRCSMSB_TIME__MASK          0xFF      

/* TSRCSTIME3 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME3                              0x00000092
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME3__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME3_TSRCSMSB_TIME__MASK          0xFF      

/* TSRCSTIME2 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME2                              0x00000093
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME2__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME2_TSRCSMSB_TIME__MASK          0xFF      

/* TSRCSTIME1 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME1                              0x00000094
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME1__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME1_TSRCS300_TIME__MASK          0x01      
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME1_TSRCS_ANAGATE__MASK          0x02      
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME1_TSRCS_CAPTURE__MASK          0x04      
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME1_TSRCSMSB_TIME__MASK          0x80      

/* TSRCSTIME0 */
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME0                              0x00000095
#define RC8CODEW_DVBSX_HWARE_TSRCSTIME0__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_HWARE_TSRCSTIME0_TSRCS300_TIME__MASK          0xFF      

/* SFDILSTK1 */
#define RC8CODEW_DVBSX_HWARE_SFDILSTK1                               0x000000c0
#define RC8CODEW_DVBSX_HWARE_SFDILSTK1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFDILSTK1_SFEC_DILSTK__MASK             0xFF      

/* SFDILSTK0 */
#define RC8CODEW_DVBSX_HWARE_SFDILSTK0                               0x000000c1
#define RC8CODEW_DVBSX_HWARE_SFDILSTK0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFDILSTK0_SFEC_DILSTK__MASK             0xFF      

/* SFSTATUS */
#define RC8CODEW_DVBSX_HWARE_SFSTATUS                                0x000000c2
#define RC8CODEW_DVBSX_HWARE_SFSTATUS__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_READY__MASK               0x01      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_UNREGULA__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_NOSYNC__MASK              0x04      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_TSSFEC_DEMODSEL__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_OVERFLOW__MASK            0x10      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_DATA7__MASK               0x20      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_ERROR__MASK               0x40      
#define FC8CODEW_DVBSX_HWARE_SFSTATUS_SFEC_LINEOK__MASK              0x80      

/* SFDLY2 */
#define RC8CODEW_DVBSX_HWARE_SFDLY2                                  0x000000c3
#define RC8CODEW_DVBSX_HWARE_SFDLY2__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLY2_SFEC_REALSYMBOFFSET__MASK        0x0F      
#define FC8CODEW_DVBSX_HWARE_SFDLY2_SFEC_REGULATED__MASK             0x10      
#define FC8CODEW_DVBSX_HWARE_SFDLY2_SFEC_STOP__MASK                  0x20      
#define FC8CODEW_DVBSX_HWARE_SFDLY2_SFEC_SPEEDUP__MASK               0x40      
#define FC8CODEW_DVBSX_HWARE_SFDLY2_SFEC_TSTIMEVALID__MASK           0x80      

/* SFDLY1 */
#define RC8CODEW_DVBSX_HWARE_SFDLY1                                  0x000000c4
#define RC8CODEW_DVBSX_HWARE_SFDLY1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLY1_SFEC_REALSYMBOFFSET__MASK        0xFF      

/* SFDLY0 */
#define RC8CODEW_DVBSX_HWARE_SFDLY0                                  0x000000c5
#define RC8CODEW_DVBSX_HWARE_SFDLY0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLY0_SFEC_REALSYMBOFFSET__MASK        0xFF      

/* SFDLYSET2 */
#define RC8CODEW_DVBSX_HWARE_SFDLYSET2                               0x000000c6
#define RC8CODEW_DVBSX_HWARE_SFDLYSET2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLYSET2_SFEC_UNREGUL__MASK            0x01      
#define FC8CODEW_DVBSX_HWARE_SFDLYSET2_SFEC_DISABLE__MASK            0x02      
#define FC8CODEW_DVBSX_HWARE_SFDLYSET2_DILDLINE_ERROR__MASK          0x04      
#define FC8CODEW_DVBSX_HWARE_SFDLYSET2_RST_SFEC__MASK                0x08      
#define FC8CODEW_DVBSX_HWARE_SFDLYSET2_SFEC_OFFSET__MASK             0xC0      

/* SFDLYSET1 */
#define RC8CODEW_DVBSX_HWARE_SFDLYSET1                               0x000000c7
#define RC8CODEW_DVBSX_HWARE_SFDLYSET1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLYSET1_SFEC_SYMBOFFSET__MASK         0xFF      

/* SFDLYSET0 */
#define RC8CODEW_DVBSX_HWARE_SFDLYSET0                               0x000000c8
#define RC8CODEW_DVBSX_HWARE_SFDLYSET0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFDLYSET0_SFEC_SYMBOFFSET__MASK         0xFF      

/* SFOBSCFG */
#define RC8CODEW_DVBSX_HWARE_SFOBSCFG                                0x000000c9
#define RC8CODEW_DVBSX_HWARE_SFOBSCFG__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_SFOBSCFG_SFEC_OBSCFG__MASK              0xFF      

/* SFOBS1 */
#define RC8CODEW_DVBSX_HWARE_SFOBS1                                  0x000000ca
#define RC8CODEW_DVBSX_HWARE_SFOBS1__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_SFOBS1_SFEC_OBSDATA__MASK               0xFF      

/* SFOBS0 */
#define RC8CODEW_DVBSX_HWARE_SFOBS0                                  0x000000cb
#define RC8CODEW_DVBSX_HWARE_SFOBS0__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_HWARE_SFOBS0_SFEC_OBSDATA__MASK               0xFF      

/* SFECINFO */
#define RC8CODEW_DVBSX_HWARE_SFECINFO                                0x000000cc
#define RC8CODEW_DVBSX_HWARE_SFECINFO__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_SFECINFO_SFCE_S1CPHASE__MASK            0x0F      
#define FC8CODEW_DVBSX_HWARE_SFECINFO_SFEC_SYNCDLSB__MASK            0x70      

/* SFERRCTRL */
#define RC8CODEW_DVBSX_HWARE_SFERRCTRL                               0x000000d0
#define RC8CODEW_DVBSX_HWARE_SFERRCTRL__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFERRCTRL_SFEC_NUM_EVENT__MASK          0x07      
#define FC8CODEW_DVBSX_HWARE_SFERRCTRL_SFEC_ERR_SOURCE__MASK         0xF0      

/* SFERRCNT2 */
#define RC8CODEW_DVBSX_HWARE_SFERRCNT2                               0x000000d1
#define RC8CODEW_DVBSX_HWARE_SFERRCNT2__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFERRCNT2_SFEC_ERR_CNT__MASK            0x7F      
#define FC8CODEW_DVBSX_HWARE_SFERRCNT2_SFERRC_OLDVALUE__MASK         0x80      

/* SFERRCNT1 */
#define RC8CODEW_DVBSX_HWARE_SFERRCNT1                               0x000000d2
#define RC8CODEW_DVBSX_HWARE_SFERRCNT1__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFERRCNT1_SFEC_ERR_CNT__MASK            0xFF      

/* SFERRCNT0 */
#define RC8CODEW_DVBSX_HWARE_SFERRCNT0                               0x000000d3
#define RC8CODEW_DVBSX_HWARE_SFERRCNT0__DEFAULT                      0x0       
#define FC8CODEW_DVBSX_HWARE_SFERRCNT0_SFEC_ERR_CNT__MASK            0xFF      

/* TSTTSSF1 */
#define RC8CODEW_DVBSX_HWARE_TSTTSSF1                                0x000000d8
#define RC8CODEW_DVBSX_HWARE_TSTTSSF1__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTSSF1_TSTTSSF_STACKSEL__MASK         0x07      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF1_DIS_SFECAUTOADJ__MASK          0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF1_SFEC_OUTMODE__MASK             0x30      

/* TSTTSSF2 */
#define RC8CODEW_DVBSX_HWARE_TSTTSSF2                                0x000000d9
#define RC8CODEW_DVBSX_HWARE_TSTTSSF2__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTSSF2_TSTTSSF_SELECT__MASK           0x1F      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF2_TSTTSSF_NOBADSTART__MASK       0x20      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF2_TSTTSSF_DISBUG__MASK           0x40      

/* TSTTSSF3 */
#define RC8CODEW_DVBSX_HWARE_TSTTSSF3                                0x000000da
#define RC8CODEW_DVBSX_HWARE_TSTTSSF3__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_HWARE_TSTTSSF3_DISSF_CLKENABLE__MASK          0x01      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF3_DISSF_ERRMEM__MASK             0x02      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF3_EN_SOFFIFODEL__MASK            0x04      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF3_SFEC_BFIFORST__MASK            0x08      
#define FC8CODEW_DVBSX_HWARE_TSTTSSF3_SFEC_NRSTPKTOV__MASK           0x10      


/* Number of registers */
#define C8CODEW_DVBSX_HWARE_REG_NBREGS                               128       

/* Number of fields */
#define C8CODEW_DVBSX_HWARE_REG_NBFIELDS                             389       



#endif /* #ifndef _DVBSX_HWARE_REG_INIT_H */
