/* 
* This file is part of STiD135 OXFORD LLA 
* 
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
* 
* License terms: BSD 3-clause "New" or "Revised" License. 
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
* 
*/ 
#ifndef _DVBSX_VITERBI_REG_INIT_H
#define _DVBSX_VITERBI_REG_INIT_H

/* -------------------------------------------------------------------------
 * File name  : dvbsx_viterbi_reg_init.h
 * File type  : C header file
 * -------------------------------------------------------------------------
 * Description:  Register map constants
 * Generated by spirit2regtest v2.24_alpha3
 * -------------------------------------------------------------------------
 */


/* Register map constants */

/* SIGPOWER */
#define RC8CODEW_DVBSX_VITERBI_SIGPOWER                              0x00000000
#define RC8CODEW_DVBSX_VITERBI_SIGPOWER__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_VITERBI_SIGPOWER_SIG_POWER__MASK              0x7F      
#define FC8CODEW_DVBSX_VITERBI_SIGPOWER_SIGPOWER_MANUAL__MASK        0x80      

/* DEMAPVIT */
#define RC8CODEW_DVBSX_VITERBI_DEMAPVIT                              0x00000001
#define RC8CODEW_DVBSX_VITERBI_DEMAPVIT__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_VITERBI_DEMAPVIT_K_DIVIDER_VIT__MASK          0x7F      
#define FC8CODEW_DVBSX_VITERBI_DEMAPVIT_VIT_VXINOBS__MASK            0x80      

/* VITSCALE */
#define RC8CODEW_DVBSX_VITERBI_VITSCALE                              0x00000002
#define RC8CODEW_DVBSX_VITERBI_VITSCALE__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_VERROR_DBMODE__MASK          0x01      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_DIS_RSFLOCK__MASK            0x02      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_DELOCK_PRFLOSS__MASK         0x04      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_NSLOWSN_LOCKED__MASK         0x08      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_NOSTBL_SELECT__MASK          0x30      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_VERROR_MAXMODE__MASK         0x40      
#define FC8CODEW_DVBSX_VITERBI_VITSCALE_NVTH_NOSRANGE__MASK          0x80      

/* FECM */
#define RC8CODEW_DVBSX_VITERBI_FECM                                  0x00000003
#define RC8CODEW_DVBSX_VITERBI_FECM__DEFAULT                         0x0       
#define FC8CODEW_DVBSX_VITERBI_FECM_IQINV__MASK                      0x01      
#define FC8CODEW_DVBSX_VITERBI_FECM_SYNCVIT__MASK                    0x02      
#define FC8CODEW_DVBSX_VITERBI_FECM_DIFF_MODEVIT__MASK               0x04      
#define FC8CODEW_DVBSX_VITERBI_FECM_DSS_SRCH__MASK                   0x10      
#define FC8CODEW_DVBSX_VITERBI_FECM_CMP_SLOWMODE__MASK               0x20      
#define FC8CODEW_DVBSX_VITERBI_FECM_DEMOD_BYPASS__MASK               0x40      
#define FC8CODEW_DVBSX_VITERBI_FECM_DSS_DVB__MASK                    0x80      

/* VTH12 */
#define RC8CODEW_DVBSX_VITERBI_VTH12                                 0x00000004
#define RC8CODEW_DVBSX_VITERBI_VTH12__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH12_VTH12__MASK                     0xFF      

/* VTH23 */
#define RC8CODEW_DVBSX_VITERBI_VTH23                                 0x00000005
#define RC8CODEW_DVBSX_VITERBI_VTH23__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH23_VTH23__MASK                     0xFF      

/* VTH34 */
#define RC8CODEW_DVBSX_VITERBI_VTH34                                 0x00000006
#define RC8CODEW_DVBSX_VITERBI_VTH34__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH34_VTH34__MASK                     0xFF      

/* VTH56 */
#define RC8CODEW_DVBSX_VITERBI_VTH56                                 0x00000007
#define RC8CODEW_DVBSX_VITERBI_VTH56__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH56_VTH56__MASK                     0xFF      

/* VTH67 */
#define RC8CODEW_DVBSX_VITERBI_VTH67                                 0x00000008
#define RC8CODEW_DVBSX_VITERBI_VTH67__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH67_VTH67__MASK                     0xFF      

/* VTH78 */
#define RC8CODEW_DVBSX_VITERBI_VTH78                                 0x00000009
#define RC8CODEW_DVBSX_VITERBI_VTH78__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_VTH78_VTH78__MASK                     0xFF      

/* PRVIT */
#define RC8CODEW_DVBSX_VITERBI_PRVIT                                 0x0000000a
#define RC8CODEW_DVBSX_VITERBI_PRVIT__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E1_2VIT__MASK                   0x01      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E2_3VIT__MASK                   0x02      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E3_4VIT__MASK                   0x04      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E5_6VIT__MASK                   0x08      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E6_7VIT__MASK                   0x10      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_E7_8VIT__MASK                   0x20      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_DIS_VTHLOCK__MASK               0x40      
#define FC8CODEW_DVBSX_VITERBI_PRVIT_VTHNOS_PLUS16__MASK             0x80      

/* VAVSRVIT */
#define RC8CODEW_DVBSX_VITERBI_VAVSRVIT                              0x0000000b
#define RC8CODEW_DVBSX_VITERBI_VAVSRVIT__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_VITERBI_VAVSRVIT_HYPVIT__MASK                 0x03      
#define FC8CODEW_DVBSX_VITERBI_VAVSRVIT_TOVVIT__MASK                 0x0C      
#define FC8CODEW_DVBSX_VITERBI_VAVSRVIT_SNVIT__MASK                  0x30      
#define FC8CODEW_DVBSX_VITERBI_VAVSRVIT_FROZENVIT__MASK              0x40      
#define FC8CODEW_DVBSX_VITERBI_VAVSRVIT_AMVIT__MASK                  0x80      

/* VITCURPUN */
#define RC8CODEW_DVBSX_VITERBI_VITCURPUN                             0x00000010
#define RC8CODEW_DVBSX_VITERBI_VITCURPUN__DEFAULT                    0x0       
#define FC8CODEW_DVBSX_VITERBI_VITCURPUN_VIT_CURPUN__MASK            0x1F      
#define FC8CODEW_DVBSX_VITERBI_VITCURPUN_VIT_ROTA90__MASK            0x20      
#define FC8CODEW_DVBSX_VITERBI_VITCURPUN_VIT_ROTA180__MASK           0x40      
#define FC8CODEW_DVBSX_VITERBI_VITCURPUN_CYCLESLIP_VIT__MASK         0x80      

/* VERROR */
#define RC8CODEW_DVBSX_VITERBI_VERROR                                0x00000011
#define RC8CODEW_DVBSX_VITERBI_VERROR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_VERROR_REGERR_VIT__MASK               0xFF      

/* VITCNR */
#define RC8CODEW_DVBSX_VITERBI_VITCNR                                0x00000012
#define RC8CODEW_DVBSX_VITERBI_VITCNR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_VITCNR_REGERR_CNR__MASK               0xFF      

/* VTHINUSE */
#define RC8CODEW_DVBSX_VITERBI_VTHINUSE                              0x00000013
#define RC8CODEW_DVBSX_VITERBI_VTHINUSE__DEFAULT                     0x0       
#define FC8CODEW_DVBSX_VITERBI_VTHINUSE_VIT_INUSE__MASK              0xFF      

/* VSTATUSVIT */
#define RC8CODEW_DVBSX_VITERBI_VSTATUSVIT                            0x00000014
#define RC8CODEW_DVBSX_VITERBI_VSTATUSVIT__DEFAULT                   0x0       
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VITERBI_COMPOUT__MASK      0x01      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VIT_DEMODSEL__MASK         0x02      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VITERBI_DELOCK__MASK       0x04      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_LOCKEDVIT__MASK            0x08      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_PRFVIT__MASK               0x10      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VITERBI_DEPRF__MASK        0x20      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VIT_OVFIFO__MASK           0x40      
#define FC8CODEW_DVBSX_VITERBI_VSTATUSVIT_VITERBI_ON__MASK           0x80      

/* KDIV12 */
#define RC8CODEW_DVBSX_VITERBI_KDIV12                                0x00000018
#define RC8CODEW_DVBSX_VITERBI_KDIV12__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV12_K_DIVIDER_12__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV12_KDIV12_MANUAL__MASK            0x80      

/* KDIV23 */
#define RC8CODEW_DVBSX_VITERBI_KDIV23                                0x00000019
#define RC8CODEW_DVBSX_VITERBI_KDIV23__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV23_K_DIVIDER_23__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV23_KDIV23_MANUAL__MASK            0x80      

/* KDIV34 */
#define RC8CODEW_DVBSX_VITERBI_KDIV34                                0x0000001a
#define RC8CODEW_DVBSX_VITERBI_KDIV34__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV34_K_DIVIDER_34__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV34_KDIV34_MANUAL__MASK            0x80      

/* KDIV56 */
#define RC8CODEW_DVBSX_VITERBI_KDIV56                                0x0000001b
#define RC8CODEW_DVBSX_VITERBI_KDIV56__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV56_K_DIVIDER_56__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV56_KDIV56_MANUAL__MASK            0x80      

/* KDIV67 */
#define RC8CODEW_DVBSX_VITERBI_KDIV67                                0x0000001c
#define RC8CODEW_DVBSX_VITERBI_KDIV67__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV67_K_DIVIDER_67__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV67_KDIV67_MANUAL__MASK            0x80      

/* KDIV78 */
#define RC8CODEW_DVBSX_VITERBI_KDIV78                                0x0000001d
#define RC8CODEW_DVBSX_VITERBI_KDIV78__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_KDIV78_K_DIVIDER_78__MASK             0x7F      
#define FC8CODEW_DVBSX_VITERBI_KDIV78_KDIV78_MANUAL__MASK            0x80      

/* SELOUT */
#define RC8CODEW_DVBSX_VITERBI_SELOUT                                0x00000020
#define RC8CODEW_DVBSX_VITERBI_SELOUT__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_SELOUT_TSTSYNCHRO_MODE__MASK          0x0F      
#define FC8CODEW_DVBSX_VITERBI_SELOUT_CCPTDLY_MODE__MASK             0x30      
#define FC8CODEW_DVBSX_VITERBI_SELOUT_EN_TBUSDEMAP__MASK             0x40      
#define FC8CODEW_DVBSX_VITERBI_SELOUT_EN_SYNC__MASK                  0x80      

/* TSYNC */
#define RC8CODEW_DVBSX_VITERBI_TSYNC                                 0x00000021
#define RC8CODEW_DVBSX_VITERBI_TSYNC__DEFAULT                        0x0       
#define FC8CODEW_DVBSX_VITERBI_TSYNC_TST_BCHERROR__MASK              0x01      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_FROTA45_FIRST__MASK             0x02      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_PXX_BYPALL__MASK                0x04      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_SLOWPHA_MODE__MASK              0x08      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_SHIFTSOF_MODE__MASK             0x30      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_CERR_TSTMODE__MASK              0x40      
#define FC8CODEW_DVBSX_VITERBI_TSYNC_CURPUN_DECMODE__MASK            0x80      

/* TSTERR */
#define RC8CODEW_DVBSX_VITERBI_TSTERR                                0x00000022
#define RC8CODEW_DVBSX_VITERBI_TSTERR__DEFAULT                       0x0       
#define FC8CODEW_DVBSX_VITERBI_TSTERR_METRIQUE_MODE__MASK            0x03      
#define FC8CODEW_DVBSX_VITERBI_TSTERR_TRACEBACK_MODE__MASK           0x08      
#define FC8CODEW_DVBSX_VITERBI_TSTERR_TST_ERRGEN__MASK               0x10      
#define FC8CODEW_DVBSX_VITERBI_TSTERR_TST_ERASURE__MASK              0x80      


/* Number of registers */
#define C8CODEW_DVBSX_VITERBI_REG_NBREGS                             26        

/* Number of fields */
#define C8CODEW_DVBSX_VITERBI_REG_NBFIELDS                           79        



#endif /* #ifndef _DVBSX_VITERBI_REG_INIT_H */
