/* 
* This file is part of STiD135 OXFORD LLA 
* 
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
* 
* License terms: BSD 3-clause "New" or "Revised" License. 
* 
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
* 
*/ 
#ifndef H_OXFORD_INIT
	#define H_OXFORD_INIT
	
	#include "globaldefs.h"
	#include "chip.h"

	/* =======================================================================
	-- Registers Declaration
    	-- -------------------------
	-- Each register () is defined by its address (2 bytes).	 						    
	--
	-- Each field (F368ter_XXXXX)is defined as follow: 
	-- [register address -- 2bytes][field sign -- 1byte][field mask -- 1byte]
	=======================================================================  */
#ifdef ATB
/* DEMOD 185 REGISTERS 57 FIELDS*/
/* debug purpose only: declarations to be removed for final application*/
#define RDEMOD_P1_AGCRFIN1		0x20C   
#define RDEMOD_P1_AGCRFIN0		0x20D   
#define RDEMOD_P1_AGCRF_PWMRFINC	0x210   
#define RDEMOD_P1_AGCRF_PWMBBINC	0x211   
#define RDEMOD_P2_AGCRFIN1		0x22C   
#define RDEMOD_P2_AGCRFIN0		0x22D   
#define RDEMOD_P2_AGCRF_PWMRFINC	0x230   
#define RDEMOD_P2_AGCRF_PWMBBINC	0x231   
#define RDEMOD_P3_AGCRFIN1		0x24C   
#define RDEMOD_P3_AGCRFIN0		0x24D   
#define RDEMOD_P3_AGCRF_PWMRFINC	0x250   
#define RDEMOD_P3_AGCRF_PWMBBINC	0x251   
#define RDEMOD_P4_AGCRFIN1		0x26C   
#define RDEMOD_P4_AGCRFIN0		0x26D   
#define RDEMOD_P4_AGCRF_PWMRFINC	0x270   
#define RDEMOD_P4_AGCRF_PWMBBINC	0x271   
#define RDEMOD_RFMUX0     		0x2A0   
#define RDEMOD_RFMUX1     		0x2A1   
#define RDEMOD_RFMUX2     		0x2A2   
#define RDEMOD_RFMUX3     		0x2A3   
#define RDEMOD_RFMUX4     		0x2A4   
#define RDEMOD_RFMUX5     		0x2A5   
#define RDEMOD_RFMUX6     		0x2A6   
#define RDEMOD_RFMUX7     		0x2A7   
#define RDEMOD_P1_AGC1REF 		0x913   
#define RDEMOD_P1_AGC1POWERI	0x916   
#define RDEMOD_P1_AGC1POWERQ	0x917
#define RDEMOD_P1_AGC1IQINM		0x91A
#define RDEMOD_P1_AGC1IQINL		0x91B
#define RDEMOD_P1_DMDISTAT		0x924
#define FDEMOD_P1_I2C_DEMOD_MODE  	0x0924001f   
#define RDEMOD_P1_DMDSTATE		0x932
#define FDEMOD_P1_DEMOD_LOCKED  	0x09320080
#define FDEMOD_P1_DEMOD_MODE    	0x0932001f   
#define RDEMOD_P1_HDEBITCFG2    0x940
#define FDEMOD_P1_MODE_HAUTDEBIT	0x094000c0
#define RDEMOD_P1_AGC2REF 		0x991   
#define RDEMOD_P1_AGC2I1  		0x9A0   
#define RDEMOD_P1_AGC2I0  		0x9A1   
#define RDEMOD_P1_CFRINIT2		0x9C3   
#define RDEMOD_P1_CFRINIT1		0x9C4   
#define RDEMOD_P1_CFRINIT0		0x9C5   
#define RDEMOD_P1_SFRINIT2		0x9F0   
#define RDEMOD_P1_SFRINIT1		0x9F1   
#define RDEMOD_P1_SFRINIT0		0x9F2   
#define RDEMOD_P1_TAGC2 		0x0CC3
#define FDEMOD_P1_AGC2EXP_NOSFR		0x0cc30001   
#define RDEMOD_P1_TSSTATE1		0xE00
#define FDEMOD_P1_TS_DISABLE 		0x0e000004   
#define RDEMOD_P1_TSSTATUS		0xE26
#define FDEMOD_P1_TSFIFO_LINEOK 	0x0E260080     
#define RDEMOD_P2_AGC1REF 		0x1113  
#define RDEMOD_P2_AGC1POWERI	0x1116  
#define RDEMOD_P2_AGC1POWERQ	0x1117 
#define RDEMOD_P2_AGC1IQINM		0x111A
#define RDEMOD_P2_AGC1IQINL		0x111B
#define RDEMOD_P2_DMDISTAT		0x1124
#define FDEMOD_P2_I2C_DEMOD_MODE  	0x1124001f
#define RDEMOD_P2_DMDSTATE		0x1132
#define FDEMOD_P2_DEMOD_LOCKED  	0x11320080
#define FDEMOD_P2_DEMOD_MODE    	0x1132001f  
#define RDEMOD_P2_HDEBITCFG2    0x1140
#define FDEMOD_P2_MODE_HAUTDEBIT	0x114000c0
#define RDEMOD_P2_AGC2REF 		0x1191  
#define RDEMOD_P2_AGC2I1  		0x11A0  
#define RDEMOD_P2_AGC2I0  		0x11A1  
#define RDEMOD_P2_CFRINIT2		0x11C3  
#define RDEMOD_P2_CFRINIT1		0x11C4  
#define RDEMOD_P2_CFRINIT0		0x11C5  
#define RDEMOD_P2_SFRINIT2		0x11F0  
#define RDEMOD_P2_SFRINIT1		0x11F1  
#define RDEMOD_P2_SFRINIT0		0x11F2  
#define RDEMOD_P2_TAGC2 		0x14C3
#define FDEMOD_P2_AGC2EXP_NOSFR		0x14c30001  
#define RDEMOD_P2_TSSTATE1		0x1600
#define FDEMOD_P2_TS_DISABLE 		0x16000004  
#define RDEMOD_P2_TSSTATUS		0x1626
#define FDEMOD_P2_TSFIFO_LINEOK 	0x16260080 
#define RDEMOD_P3_AGC1REF 		0x1913  
#define RDEMOD_P3_AGC1POWERI	0x1916  
#define RDEMOD_P3_AGC1POWERQ	0x1917
#define RDEMOD_P3_AGC1IQINM		0x191A
#define RDEMOD_P3_AGC1IQINL		0x191B
#define RDEMOD_P3_DMDISTAT		0x1924
#define FDEMOD_P3_I2C_DEMOD_MODE  	0x1924001f  
#define RDEMOD_P3_DMDSTATE		0x1932
#define FDEMOD_P3_DEMOD_LOCKED  	0x19320080
#define FDEMOD_P3_DEMOD_MODE    	0x1932001f  
#define RDEMOD_P3_HDEBITCFG2    0x1940
#define FDEMOD_P3_MODE_HAUTDEBIT	0x194000c0
#define RDEMOD_P3_AGC2REF 		0x1991  
#define RDEMOD_P3_AGC2I1  		0x19A0  
#define RDEMOD_P3_AGC2I0  		0x19A1  
#define RDEMOD_P3_CFRINIT2		0x19C3  
#define RDEMOD_P3_CFRINIT1		0x19C4  
#define RDEMOD_P3_CFRINIT0		0x19C5  
#define RDEMOD_P3_SFRINIT2		0x19F0  
#define RDEMOD_P3_SFRINIT1		0x19F1  
#define RDEMOD_P3_SFRINIT0		0x19F2  
#define RDEMOD_P3_TAGC2 		0x1CC3
#define FDEMOD_P3_AGC2EXP_NOSFR		0x1cc30001  
#define RDEMOD_P3_TSSTATE1		0x1E00
#define FDEMOD_P3_TS_DISABLE 		0x1e000004  
#define RDEMOD_P3_TSSTATUS		0x1E26
#define FDEMOD_P3_TSFIFO_LINEOK 	0x1E260080  
#define RDEMOD_P4_AGC1REF 		0x2113  
#define RDEMOD_P4_AGC1POWERI	0x2116  
#define RDEMOD_P4_AGC1POWERQ	0x2117
#define RDEMOD_P4_AGC1IQINM		0x211A
#define RDEMOD_P4_AGC1IQINL		0x211B
#define RDEMOD_P4_DMDISTAT		0x2124
#define FDEMOD_P4_I2C_DEMOD_MODE  	0x2124001f  
#define RDEMOD_P4_DMDSTATE		0x2132
#define FDEMOD_P4_DEMOD_LOCKED  	0x21320080
#define FDEMOD_P4_DEMOD_MODE    	0x2132001f  
#define RDEMOD_P4_HDEBITCFG2    0x2140
#define FDEMOD_P4_MODE_HAUTDEBIT	0x214000c0
#define RDEMOD_P4_AGC2REF 		0x2191  
#define RDEMOD_P4_AGC2I1  		0x21A0  
#define RDEMOD_P4_AGC2I0  		0x21A1  
#define RDEMOD_P4_CFRINIT2		0x21C3  
#define RDEMOD_P4_CFRINIT1		0x21C4  
#define RDEMOD_P4_CFRINIT0		0x21C5  
#define RDEMOD_P4_SFRINIT2		0x21F0  
#define RDEMOD_P4_SFRINIT1		0x21F1  
#define RDEMOD_P4_SFRINIT0		0x21F2  
#define RDEMOD_P4_TAGC2 		0x24C3
#define FDEMOD_P4_AGC2EXP_NOSFR		0x24c30001  
#define RDEMOD_P4_TSSTATE1		0x2600
#define FDEMOD_P4_TS_DISABLE 		0x26000004  
#define RDEMOD_P4_TSSTATUS		0x2626
#define FDEMOD_P4_TSFIFO_LINEOK 	0x26260080  
#define RDEMOD_P5_AGC1REF 		0x2913  
#define RDEMOD_P5_AGC1POWERI	0x2916  
#define RDEMOD_P5_AGC1POWERQ	0x2917
#define RDEMOD_P5_AGC1IQINM		0x291A
#define RDEMOD_P5_AGC1IQINL		0x291B
#define RDEMOD_P5_DMDISTAT		0x2924
#define FDEMOD_P5_I2C_DEMOD_MODE  	0x2924001f  
#define RDEMOD_P5_DMDSTATE		0x2932
#define FDEMOD_P5_DEMOD_LOCKED  	0x29320080
#define FDEMOD_P5_DEMOD_MODE    	0x2932001f  
#define RDEMOD_P5_HDEBITCFG2    0x2940
#define FDEMOD_P5_MODE_HAUTDEBIT	0x294000c0
#define RDEMOD_P5_AGC2REF 		0x2991  
#define RDEMOD_P5_AGC2I1  		0x29A0  
#define RDEMOD_P5_AGC2I0  		0x29A1  
#define RDEMOD_P5_CFRINIT2		0x29C3  
#define RDEMOD_P5_CFRINIT1		0x29C4  
#define RDEMOD_P5_CFRINIT0		0x29c5  
#define RDEMOD_P5_SFRINIT2		0x29F0  
#define RDEMOD_P5_SFRINIT1		0x29F1  
#define RDEMOD_P5_SFRINIT0		0x29F2  
#define RDEMOD_P5_TAGC2 		0x2CC3 
#define FDEMOD_P5_AGC2EXP_NOSFR		0x2cc30001 
#define RDEMOD_P5_TSSTATE1		0x2E00
#define FDEMOD_P5_TS_DISABLE 		0x2e000004  
#define RDEMOD_P5_TSSTATUS		0x2E26
#define FDEMOD_P5_TSFIFO_LINEOK 	0x2E260080  
#define RDEMOD_P6_AGC1REF 		0x3113  
#define RDEMOD_P6_AGC1POWERI	0x3116  
#define RDEMOD_P6_AGC1POWERQ	0x3117
#define RDEMOD_P6_AGC1IQINM		0x311A
#define RDEMOD_P6_AGC1IQINL		0x311B
#define RDEMOD_P6_DMDISTAT		0x3124
#define FDEMOD_P6_I2C_DEMOD_MODE  	0x3124001f  
#define RDEMOD_P6_DMDSTATE		0x3132
#define FDEMOD_P6_DEMOD_LOCKED  	0x31320080
#define FDEMOD_P6_DEMOD_MODE    	0x3132001f  
#define RDEMOD_P6_HDEBITCFG2    0x3140
#define FDEMOD_P6_MODE_HAUTDEBIT	0x314000c0
#define RDEMOD_P6_AGC2REF 		0x3191  
#define RDEMOD_P6_AGC2I1  		0x31A0  
#define RDEMOD_P6_AGC2I0  		0x31A1  
#define RDEMOD_P6_CFRINIT2		0x31C3  
#define RDEMOD_P6_CFRINIT1		0x31C4  
#define RDEMOD_P6_CFRINIT0		0x31c5  
#define RDEMOD_P6_SFRINIT2		0x31F0  
#define RDEMOD_P6_SFRINIT1		0x31F1  
#define RDEMOD_P6_SFRINIT0		0x31F2  
#define RDEMOD_P6_TAGC2 		0x34C3
#define FDEMOD_P6_AGC2EXP_NOSFR		0x34c30001  
#define RDEMOD_P6_TSSTATE1		0x3600
#define FDEMOD_P6_TS_DISABLE 		0x36000004  
#define RDEMOD_P6_TSSTATUS		0x3626
#define FDEMOD_P6_TSFIFO_LINEOK 	0x36260080  
#define RDEMOD_P7_AGC1REF 		0x3913  
#define RDEMOD_P7_AGC1POWERI	0x3916  
#define RDEMOD_P7_AGC1POWERQ	0x3917
#define RDEMOD_P7_AGC1IQINM		0x391A
#define RDEMOD_P7_AGC1IQINL		0x391B
#define RDEMOD_P7_DMDISTAT		0x3924
#define FDEMOD_P7_I2C_DEMOD_MODE  	0x3924001f  
#define RDEMOD_P7_DMDSTATE		0x3932
#define FDEMOD_P7_DEMOD_LOCKED  	0x39320080
#define FDEMOD_P7_DEMOD_MODE    	0x3932001f  
#define RDEMOD_P7_HDEBITCFG2    0x3940
#define FDEMOD_P7_MODE_HAUTDEBIT	0x394000c0
#define RDEMOD_P7_AGC2REF 		0x3991  
#define RDEMOD_P7_AGC2I1  		0x39A0  
#define RDEMOD_P7_AGC2I0  		0x39A1  
#define RDEMOD_P7_CFRINIT2		0x39C3  
#define RDEMOD_P7_CFRINIT1		0x39C4  
#define RDEMOD_P7_CFRINIT0		0x39C5  
#define RDEMOD_P7_SFRINIT2		0x39F0  
#define RDEMOD_P7_SFRINIT1		0x39F1  
#define RDEMOD_P7_SFRINIT0		0x39F2  
#define RDEMOD_P7_TAGC2 		0x3CC3
#define FDEMOD_P7_AGC2EXP_NOSFR		0x3cc30001 
#define RDEMOD_P7_TSSTATE1		0x3E00
#define FDEMOD_P7_TS_DISABLE 		0x3e000004  
#define RDEMOD_P7_TSSTATUS		0x3E26
#define FDEMOD_P7_TSFIFO_LINEOK 	0x3E260080  
#define RDEMOD_P8_AGC1REF 		0x4113  
#define RDEMOD_P8_AGC1POWERI	0x4116  
#define RDEMOD_P8_AGC1POWERQ	0x4117
#define RDEMOD_P8_AGC1IQINM		0x411A
#define RDEMOD_P8_AGC1IQINL		0x411B
#define RDEMOD_P8_DMDISTAT		0x4124
#define FDEMOD_P8_I2C_DEMOD_MODE  	0x4124001f  
#define RDEMOD_P8_DMDSTATE		0x4132 
#define FDEMOD_P8_DEMOD_LOCKED  	0x41320080
#define FDEMOD_P8_DEMOD_MODE    	0x4132001f 
#define RDEMOD_P8_HDEBITCFG2    0x4140
#define FDEMOD_P8_MODE_HAUTDEBIT	0x414000c0
#define RDEMOD_P8_AGC2REF 		0x4191  
#define RDEMOD_P8_AGC2I1  		0x41A0  
#define RDEMOD_P8_AGC2I0  		0x41A1  
#define RDEMOD_P8_CFRINIT2		0x41C3  
#define RDEMOD_P8_CFRINIT1		0x41C4  
#define RDEMOD_P8_CFRINIT0		0x41C5  
#define RDEMOD_P8_SFRINIT2		0x41F0  
#define RDEMOD_P8_SFRINIT1		0x41F1  
#define RDEMOD_P8_SFRINIT0		0x41F2  
#define RDEMOD_P8_TAGC2 		0x44C3
#define FDEMOD_P8_AGC2EXP_NOSFR		0x44c30001  
#define RDEMOD_P8_TSSTATE1		0x4600  
#define FDEMOD_P8_TS_DISABLE 		0x46000004
#define RDEMOD_P8_TSSTATUS		0x4626
#define FDEMOD_P8_TSFIFO_LINEOK 	0x46260080  
#define RDEMOD_CFGEXT 			0x5080  
#define FDEMOD_BYPLDPC		 	0x50800020

#endif /*#ifdef ATB*/

/* AFE 88 REGISTERS 327 FIELDS*/
/*OSC*/
#define RAFE_OSC  0x9000
#define FAFE_RESERVED1  0x900000c0
#define FAFE_CLK_DCDC_DIV  0x90000020
#define FAFE_CLK_DCDC_ENA  0x90000010
#define FAFE_DIG2_CLK_ENA  0x90000008
#define FAFE_DIG1_CLK_ENA  0x90000004
#define FAFE_OSC_EXT_PWD  0x90000002
#define FAFE_OSC_PWD  0x90000001


/*CTRL*/
#define RAFE_PLL_CTRL  0x9001
#define FAFE_PLL_RST_N  0x90010080
#define FAFE_RESERVED2  0x90010040
#define FAFE_PLL_START_FAST  0x90010020
#define FAFE_PLL_ICP  0x9001001c
#define FAFE_PLL_REFDIV_N  0x90010002
#define FAFE_PLL_ENA  0x90010001

/*PLL_INT*/
#define RAFE_PLL_INT  0x9002
#define FAFE_PLL_INT  0x900200ff

/*PLL_FRAC1*/
#define RAFE_PLL_FRAC1  0x9003			 
#define FAFE_PLL_SDON  0x90030080
#define FAFE_PLL_FRAC_H  0x9003007f

/*PLL_FRAC2*/
#define RAFE_PLL_FRAC2  0x9004
#define FAFE_PLL_FRAC_L  0x900400ff

/*PLL_TST1*/
#define RAFE_PLL_TST1  0x9005
#define FAFE_RESERVED3  0x900500c0
#define FAFE_PLL_CP_HZ  0x90050020
#define FAFE_TSTBUF_BYPASS  0x90050010
#define FAFE_TCP  0x9005000c
#define FAFE_CPA  0x90050002
#define FAFE_CPDNS  0x90050001

/*PLL_TST2*/
#define RAFE_PLL_TST2  0x9006
#define FAFE_TSELD  0x900600f0
#define FAFE_TSELA  0x9006000f

/*VCO_CAL1*/
#define RAFE_VCO_CAL1  0x9007
#define FAFE_RESERVED4  0x900700e0
#define FAFE_DIVCAL  	0x9007001c
#define FAFE_CAL_OFF  	0x90070002
#define FAFE_CAL_START  0x90070001

/*VCO_CAL2*/
#define RAFE_VCO_CAL2  0x9008
#define FAFE_RESERVED5  0x90080080
#define FAFE_VCO_CAL  0x9008007f

/*VCO_CTRL*/
#define RAFE_VCO_CTRL  0x9009
#define FAFE_RESERVED6  0x900900c0
#define FAFE_VCO_BUF_AMP  0x90090038
#define FAFE_VCO_AMP  0x90090007

/*DFE_CLK_CTRL1*/
#define RAFE_DFE_CLK_CTRL1  0x900a
#define FAFE_RESERVED7  0x900a0080
#define FAFE_DFE_CLK_RST_N  0x900a0040
#define FAFE_DFE3_CLK_SEL  0x900a0020
#define FAFE_DFE2_CLK_SEL  0x900a0010
#define FAFE_DFE1_CLK_SEL  0x900a0008
#define FAFE_DFE3_CLK_ENA  0x900a0004
#define FAFE_DFE2_CLK_ENA  0x900a0002
#define FAFE_DFE1_CLK_ENA  0x900a0001

/*DFE_CLK_CTRL2*/
#define RAFE_DFE_CLK_CTRL2  0x900b
#define FAFE_RESERVED8  	 0x900b00e0
#define FAFE_DFE_CLK_SS_DIV  0x900b0018
#define FAFE_DFE3_CLK_SS_ENA 0x900b0004
#define FAFE_DFE2_CLK_SS_ENA 0x900b0002
#define FAFE_DFE1_CLK_SS_ENA 0x900b0001

/*RX1_CTRL*/
#define RAFE_RX1_CTRL  0x9010
#define FAFE_LO1_ENA  		0x90100080
#define FAFE_ADC1_ENA  		0x90100040
#define FAFE_BB1_ENA  		0x90100020
#define FAFE_MIXER1_ENA  	0x90100010
#define FAFE_VGLNA1_ENA  	0x90100008
#define FAFE_ADC1_VREG_SEL  0x90100006
#define FAFE_RESERVED20		0x90100001

/*RX2_CTRL*/
#define RAFE_RX2_CTRL  0x9011
#define FAFE_LO2_ENA  		0x90110080
#define FAFE_ADC2_ENA  		0x90110040
#define FAFE_BB2_ENA  		0x90110020
#define FAFE_MIXER2_ENA  	0x90110010
#define FAFE_VGLNA2_ENA  	0x90110008
#define FAFE_ADC2_VREG_SEL  0x90110006
#define FAFE_RESERVED21 	0x90110001

/*RX3_CTRL*/
#define RAFE_RX3_CTRL  0x9012
#define FAFE_LO3_ENA		0x90120080
#define FAFE_ADC3_ENA		0x90120040
#define FAFE_BB3_ENA		0x90120020
#define FAFE_MIXER3_ENA  	0x90120010
#define FAFE_VGLNA3_ENA  	0x90120008
#define FAFE_ADC3_VREG_SEL  0x90120006
#define FAFE_RESERVED22		0x90120001

/*RX4_CTRL*/
#define RAFE_RX4_CTRL  0x9013
#define FAFE_LO4_ENA		0x90130080
#define FAFE_ADC4_ENA		0x90130040
#define FAFE_BB4_ENA		0x90130020
#define FAFE_MIXER4_ENA		0x90130010
#define FAFE_VGLNA4_ENA  	0x90130008
#define FAFE_ADC4_VREG_SEL  0x90130006
#define FAFE_RESERVED23		0x90130001

/*BB_CAL*/
#define RAFE_BB_CAL  0x9014
#define FAFE_BB4_CAL_SAF_DIS 0x90140080   
#define FAFE_BB3_CAL_SAF_DIS 0x90140040   
#define FAFE_BB2_CAL_SAF_DIS 0x90140020   
#define FAFE_BB1_CAL_SAF_DIS 0x90140010   
#define FAFE_BB4_CAL_START   0x90140008
#define FAFE_BB3_CAL_START   0x90140004
#define FAFE_BB2_CAL_START   0x90140002
#define FAFE_BB1_CAL_START   0x90140001

/*BB1I_CAL*/
#define RAFE_BB1I_CAL  0x9015
#define FAFE_BB1_I_CAL  0x901500ff

/*BB1Q_CAL*/
#define RAFE_BB1Q_CAL  0x9016
#define FAFE_BB1_Q_CAL  	0x901600c0
#define FAFE_RESERVED24		0x9016003f

/*BB2I_CAL*/
#define RAFE_BB2I_CAL  0x9017
#define FAFE_BB2_I_CAL  0x901700ff

/*BB2Q_CAL*/
#define RAFE_BB2Q_CAL  0x9018
#define FAFE_BB2_Q_CAL  	0x901800c0
#define FAFE_RESERVED25		0x9018003f

/*BB3I_CAL*/
#define RAFE_BB3I_CAL  0x9019
#define FAFE_BB3_I_CAL  	0x901900ff

/*BB3Q_CAL*/
#define RAFE_BB3Q_CAL  0x901a
#define FAFE_BB3_Q_CAL  	0x901a00c0
#define FAFE_RESERVED26		0x901a003f

/*BB4I_CAL*/
#define RAFE_BB4I_CAL  0x901b
#define FAFE_BB4_I_CAL  	0x901b00ff

/*BB4Q_CAL*/
#define RAFE_BB4Q_CAL  0x901c
#define FAFE_BB4_Q_CAL  	0x901c00c0
#define FAFE_RESERVED27		0x901c003f

/*RF_CFG*/
#define RAFE_RF_CFG1  0x901d
#define FAFE_VGLNA4_DIFF  0x901d0080
#define FAFE_VGLNA3_DIFF  0x901d0040
#define FAFE_VGLNA2_DIFF  0x901d0020
#define FAFE_VGLNA1_DIFF  0x901d0010
#define FAFE_VGLNA4_SELGAIN  0x901d0008
#define FAFE_VGLNA3_SELGAIN  0x901d0004
#define FAFE_VGLNA2_SELGAIN  0x901d0002
#define FAFE_VGLNA1_SELGAIN  0x901d0001

/*RF_CFG*/
#define RAFE_RF_CFG2  0x901e
#define FAFE_RF4_CTRL 		0x901e00c0  
#define FAFE_RF3_CTRL 		0x901e0030  
#define FAFE_RF2_CTRL 		0x901e000c  
#define FAFE_RF1_CTRL		0x901e0003  

/*ADC_ADRR1*/
#define RAFE_ADC_ADRR1  0x9020
#define FAFE_ADC_PATH_SEL  	0x902000c0
#define FAFE_ADC_IQ  		0x90200020
#define FAFE_ADC_ADDR  		0x9020001e
#define FAFE_ADC_READ_SEL  	0x90200001

/*ADC_ADRR2*/
#define RAFE_ADC_ADRR2  0x9021
#define FAFE_RESERVED9		0x902100f0
#define FAFE_ADC_REQ  		0x90210008
#define FAFE_ADC_RW  		0x90210004
#define FAFE_ADC_DSEL  		0x90210003

/*ADC_CORR1*/
#define RAFE_ADC_CORR1  0x9022
#define FAFE_RESERVED10		0x902200f0
#define FAFE_ADC_DATA_H  	0x9022000f

/*ADC_CORR2*/
#define RAFE_ADC_CORR2  0x9023
#define FAFE_ADC_DATA_L  0x902300ff

/*ADC1_CTRL1*/
#define RAFE_ADC1_CTRL1  0x9024
#define FAFE_ADC1_GAIN_CALC_ENA   	0x90240080
#define FAFE_ADC1_GAIN_CORR_ENA  	0x90240040
#define FAFE_ADC1_SKEW_CALC_ENA  	0x90240020
#define FAFE_ADC1_SKEW_CORR_ENA  	0x90240010
#define FAFE_ADC1_OFFSET_CALC_ENA  	0x90240008
#define FAFE_ADC1_OFFSET_CORR_ENA  	0x90240004
#define FAFE_ADC1_CORR_PWD  		0x90240002
#define FAFE_ADC1_CALC_RST  		0x90240001

/*ADC1_CTRL2*/
#define RAFE_ADC1_CTRL2  0x9025
#define FAFE_RESERVED11				0x902500f0
#define FAFE_ADC1_RST_N  			0x90250008
#define FAFE_ADC1_GAIN_EXT_ENA  	0x90250004
#define FAFE_ADC1_SKEW_EXT_ENA  	0x90250002
#define FAFE_ADC1_OFFSET_EXT_ENA	0x90250001

/*ADC2_CTRL1*/
#define RAFE_ADC2_CTRL1  0x9026
#define FAFE_ADC2_GAIN_CALC_ENA   0x90260080
#define FAFE_ADC2_GAIN_CORR_ENA  0x90260040
#define FAFE_ADC2_SKEW_CALC_ENA  0x90260020
#define FAFE_ADC2_SKEW_CORR_ENA  0x90260010
#define FAFE_ADC2_OFFSET_CALC_ENA  0x90260008
#define FAFE_ADC2_OFFSET_CORR_ENA  0x90260004
#define FAFE_ADC2_CORR_PWD  0x90260002
#define FAFE_ADC2_CALC_RST  0x90260001

/*ADC2_CTRL2*/
#define RAFE_ADC2_CTRL2  0x9027
#define FAFE_RESERVED12  0x902700f0
#define FAFE_ADC2_RST_N  0x90270008
#define FAFE_ADC2_GAIN_EXT_ENA  0x90270004
#define FAFE_ADC2_SKEW_EXT_ENA  0x90270002
#define FAFE_ADC2_OFFSET_EXT_ENA  0x90270001

/*ADC3_CTRL1*/
#define RAFE_ADC3_CTRL1  0x9028
#define FAFE_ADC3_GAIN_CALC_ENA   0x90280080
#define FAFE_ADC3_GAIN_CORR_ENA  	0x90280040
#define FAFE_ADC3_SKEW_CALC_ENA  	0x90280020
#define FAFE_ADC3_SKEW_CORR_ENA  	0x90280010
#define FAFE_ADC3_OFFSET_CALC_ENA 	 0x90280008
#define FAFE_ADC3_OFFSET_CORR_ENA  	0x90280004
#define FAFE_ADC3_CORR_PWD  		0x90280002
#define FAFE_ADC3_CALC_RST  		0x90280001

/*ADC3_CTRL2*/
#define RAFE_ADC3_CTRL2  0x9029
#define FAFE_RESERVED13  0x902900f0 
#define FAFE_ADC3_RST_N  0x90290008
#define FAFE_ADC3_GAIN_EXT_ENA  0x90290004
#define FAFE_ADC3_SKEW_EXT_ENA  0x90290002
#define FAFE_ADC3_OFFSET_EXT_ENA  0x90290001

/*ADC4_CTRL1*/
#define RAFE_ADC4_CTRL1  0x902a
#define FAFE_ADC4_GAIN_CALC_ENA   0x902a0080
#define FAFE_ADC4_GAIN_CORR_ENA  0x902a0040
#define FAFE_ADC4_SKEW_CALC_ENA  0x902a0020
#define FAFE_ADC4_SKEW_CORR_ENA  0x902a0010
#define FAFE_ADC4_OFFSET_CALC_ENA  0x902a0008
#define FAFE_ADC4_OFFSET_CORR_ENA  0x902a0004
#define FAFE_ADC4_CORR_PWD  0x902a0002
#define FAFE_ADC4_CALC_RST  0x902a0001

/*ADC4_CTRL2*/
#define RAFE_ADC4_CTRL2  0x902b
#define FAFE_RESERVED14  0x902b00f0
#define FAFE_ADC4_RST_N  0x902b0008
#define FAFE_ADC4_GAIN_EXT_ENA  0x902b0004
#define FAFE_ADC4_SKEW_EXT_ENA  0x902b0002
#define FAFE_ADC4_OFFSET_EXT_ENA  0x902b0001

/*ADC_CFG*/
#define RAFE_ADC_CFG  0x902c
#define FAFE_ADC4_STUP_DL   0x902c0080
#define FAFE_ADC3_STUP_DL  0x902c0040
#define FAFE_ADC2_STUP_DL  0x902c0020
#define FAFE_ADC1_STUP_DL  0x902c0010
#define FAFE_ADC4_BUF_PRECH  0x902c0008
#define FAFE_ADC3_BUF_PRECH  0x902c0004
#define FAFE_ADC2_BUF_PRECH  0x902c0002
#define FAFE_ADC1_BUF_PRECH  0x902c0001

/*ADC_TST*/
#define RAFE_ADC_TST  0x902d
#define FAFE_ADC4_TST   0x902d00c0
#define FAFE_ADC3_TST  0x902d0030
#define FAFE_ADC2_TST  0x902d000c
#define FAFE_ADC1_TST  0x902d0003

/*AGC1_CTRL*/
#define RAFE_AGC1_CTRL  0x9030
#define FAFE_AGC1_PWM_FDIV  0x903000c0
#define FAFE_AGC1_BB_CTRL  0x90300030
#define FAFE_AGC1_RF_CTRL  0x9030000c
#define FAFE_AGC1_MODE  0x90300003

/*AGC2_CTRL*/
#define RAFE_AGC2_CTRL  0x9031
#define FAFE_AGC2_PWM_FDIV  0x903100c0
#define FAFE_AGC2_BB_CTRL  0x90310030
#define FAFE_AGC2_RF_CTRL  0x9031000c
#define FAFE_AGC2_MODE  0x90310003

/*AGC3_CTRL*/
#define RAFE_AGC3_CTRL  0x9032
#define FAFE_AGC3_PWM_FDIV  0x903200c0
#define FAFE_AGC3_BB_CTRL  0x90320030
#define FAFE_AGC3_RF_CTRL  0x9032000c
#define FAFE_AGC3_MODE  0x90320003

/*AGC4_CTRL*/
#define RAFE_AGC4_CTRL  0x9033
#define FAFE_AGC4_PWM_FDIV  0x903300c0
#define FAFE_AGC4_BB_CTRL  0x90330030
#define FAFE_AGC4_RF_CTRL  0x9033000c
#define FAFE_AGC4_MODE  0x90330003

/*AGC1_RF_PWM*/
#define RAFE_AGC1_RF_PWM  0x9034
#define FAFE_AGC1_RFPWM  0x903400ff

/*AGC2_RF_PWM*/
#define RAFE_AGC2_RF_PWM  0x9035
#define FAFE_AGC2_RFPWM  0x903500ff

/*AGC3_RF_PWM*/
#define RAFE_AGC3_RF_PWM  0x9036
#define FAFE_AGC3_RFPWM  0x903600ff

/*AGC4_RF_PWM*/
#define RAFE_AGC4_RF_PWM  0x9037
#define FAFE_AGC4_RFPWM  0x903700ff

/*AGC1_BB_PWM*/
#define RAFE_AGC1_BB_PWM  0x9038
#define FAFE_AGC1_BBPWM  0x903800ff

/*AGC2_BB_PWM*/
#define RAFE_AGC2_BB_PWM  0x9039
#define FAFE_AGC2_BBPWM  0x903900ff

/*AGC3_BB_PWM*/
#define RAFE_AGC3_BB_PWM  0x903a
#define FAFE_AGC3_BBPWM  0x903a00ff

/*AGC4_BB_PWM*/
#define RAFE_AGC4_BB_PWM  0x903b
#define FAFE_AGC4_BBPWM  0x903b00ff

/*FSK*/
#define RAFE_FSK  0x9040
#define FAFE_RESERVED15	   0x904000fc
#define FAFE_FSK_OPENLOOP  0x90400002
#define FAFE_FSK_PWD  	   0x90400001

/*DISEQC*/
#define RAFE_DISEQC  0x9041
#define FAFE_RESERVED16		0x90410080
#define FAFE_DISEQC_ENCH  	0x90410040
#define FAFE_DISEQC_CLK_DIV 0x9041003e
#define FAFE_DISEQC_ENA		0x90410001

/*LNBCTRL*/
#define RAFE_LNBCTRL  0x9042
#define FAFE_LNBCTRL_TST  		0x90420080
#define FAFE_RESERVED17			0x90420078
#define FAFE_LNBCTRL_ISENSE_TH  0x90420006
#define FAFE_LNBCTRL_ENA  		0x90420001

/*BIAS_CTRL*/
#define RAFE_BIAS_CTRL  0x9050
#define FAFE_BIAS_TST  0x90500080
#define FAFE_BIAS_RCAL_CLK_DIV  0x90500040
#define FAFE_BIAS_RCAL  0x9050003c
#define FAFE_BIAS_RCAL_OFF  0x90500002
#define FAFE_BIAS_RCAL_START  0x90500001

/*LDO2V5_CTRL*/
#define RAFE_LDO2V5_CTRL  0x9051
#define FAFE_LDO_TST  0x90510080
#define FAFE_LDO_POR_BYPASS  0x90510040
#define FAFE_LDO_POR_SEL  0x90510020
#define FAFE_LDO_VREG_OK_SEL  0x90510010
#define FAFE_LDO_VSEL  0x9051000e
#define FAFE_LDO_PWD  0x90510001

/*DCDC1V8_CTRL*/
#define RAFE_DCDC1V8_CTRL  0x9052
#define FAFE_DCDC_SAF_DIS  0x90520080
#define FAFE_DCDC_POR_BYPASS  0x90520040
#define FAFE_DCDC_CLK_SEL  0x90520020
#define FAFE_DCDC_VREF_SEL  0x9052001c
#define FAFE_DCDC_ISEL  0x90520002
#define FAFE_DCDC_PWD  0x90520001

/*DCDC1V8_CAL1*/
#define RAFE_DCDC1V8_CAL1  0x9053
#define FAFE_RESERVED18  0x905300fc
#define FAFE_DCDC_CAL_OFF  0x90530002
#define FAFE_DCDC_CAL_START  0x90530001

/*DCDC1V8_CAL2*/
#define RAFE_DCDC1V8_CAL2  	0x9054
#define FAFE_RESERVED19 	0x905400e0
#define FAFE_DCDC_CAPA  	0x9054001f

/*DCDC1V8_TST*/
#define RAFE_DCDC1V8_TST  0x9055
#define FAFE_RESERVED30  0x905500f0
#define FAFE_DCDC_TSTA  0x9055000e
#define FAFE_DCDC_TST  0x90550001

/*TST_CTRL1*/
#define RAFE_TST_CTRL1  0x9070
#define FAFE_KELVIN12_IP  0x907000e0
#define FAFE_KELVIN12_IN  0x9070001c
#define FAFE_BUF12_I_DIR  0x90700002
#define FAFE_BUF12_I_ENA  0x90700001

/*TST_CTRL2*/
#define RAFE_TST_CTRL2  0x9071
#define FAFE_KELVIN12_QP  0x907100e0
#define FAFE_KELVIN12_QN  0x9071001c
#define FAFE_BUF12_Q_DIR  0x90710002
#define FAFE_BUF12_Q_ENA  0x90710001

/*TST_CTRL3*/
#define RAFE_TST_CTRL3  0x9072
#define FAFE_KELVIN34_IP  0x907200e0
#define FAFE_KELVIN34_IN  0x9072001c
#define FAFE_BUF34_I_DIR  0x90720002
#define FAFE_BUF34_I_ENA  0x90720001

/*TST_CTRL4*/
#define RAFE_TST_CTRL4  0x9073
#define FAFE_KELVIN34_QP  0x907300e0
#define FAFE_KELVIN34_QN  0x9073001c
#define FAFE_BUF34_Q_DIR  0x90730002
#define FAFE_BUF34_Q_ENA  0x90730001

/*TST_CTRL5*/
#define RAFE_TST_CTRL5  0x9074
#define FAFE_RESERVED31  	0x907400f0
#define FAFE_BUF34_Q_ZIN50  0x90740008
#define FAFE_BUF34_I_ZIN50  0x90740004
#define FAFE_BUF12_Q_ZIN50  0x90740002
#define FAFE_BUF12_I_ZIN50  0x90740001

/*TST_CTRL6*/
#define RAFE_TST_CTRL6  0x9075
#define FAFE_BB4_Q_TST  0x90750080
#define FAFE_BB4_I_TST  0x90750040
#define FAFE_BB3_Q_TST  0x90750020
#define FAFE_BB3_I_TST  0x90750010
#define FAFE_BB2_Q_TST  0x90750008
#define FAFE_BB2_I_TST  0x90750004
#define FAFE_BB1_Q_TST  0x90750002
#define FAFE_BB1_I_TST  0x90750001

/*TST_RF12*/
#define RAFE_TST_RF12  0x9076
#define FAFE_RF2_TST  0x907600f0
#define FAFE_RF1_TST  0x9076000f

/*TST_RF34*/
#define RAFE_TST_RF34  0x9077
#define FAFE_RF4_TST  0x907700f0
#define FAFE_RF3_TST  0x9077000f

/*TST_BB12*/
#define RAFE_TST_BB12  0x9078
#define FAFE_BB2_RESERVED32		0x90780080		
#define FAFE_BB2_TST_GMCOMP_DIS 0x90780040 	
#define FAFE_BB2_BB1_TST_BYPASS 0x90780020	
#define FAFE_BB2_TST_AVD_SENSE	0x90780010	
#define FAFE_BB1_RESERVED33		0x90780008	
#define FAFE_BB1_TST_GMCOMP_DIS 0x90780004	
#define FAFE_BB1_BB1_TST_BYPASS 0x90780002	
#define FAFE_BB1_TST_AVD_SENSE	0x90780001	


/*TST_BB34*/
#define RAFE_TST_BB34  0x9079
#define FAFE_BB4_RESERVED34		 0x90790080 	
#define FAFE_BB4_TST_GMCOMP_DIS  0x90790040
#define FAFE_BB4_BB1_TST_BYPASS  0x90790020
#define FAFE_BB4_TST_AVD_SENSE	 0x90790010
#define FAFE_BB3_RESERVED35		 0x90790008
#define FAFE_BB3_TST_GMCOMP_DIS  0x90790004
#define FAFE_BB3_BB1_TST_BYPASS  0x90790002
#define FAFE_BB3_TST_AVD_SENSE	 0x90790001

#define RAFE_TST_SPARE1 0x907A
#define FAFE_TST_SPARE1			0x907A00ff

#define RAFE_TST_SPARE2 0x907B
#define FAFE_TST_SPARE2			0x907B00ff

/*TST_MODE*/
#define RAFE_TST_MODE  0x907f
#define FAFE_TSTMODE   0x907f00ff

/*ID*/
#define RAFE_ID  0x9080
#define FAFE_RESERVED36			0x908000f0
#define FAFE_CUT_ID  			0x9080000c
#define FAFE_FIX_ID  			0x90800003

/*#ifdef IS_CUT2 */
/*STATUS*/
#define RAFE_STATUS  0x9081
#define FAFE_UNUSED2  		0x908100c0
#define FAFE_PLL_LOCK  		0x90810020
#define FAFE_LNBCTRL_ISENSE 0x90810010
#define FAFE_UNUSED1  		0x90810008
#define FAFE_DCDC_VREG_OK  	0x90810004
#define FAFE_LDO_POR_3V3  	0x90810002
#define FAFE_LDO_VREG_OK  	0x90810001

/*FUSE1  */
#define RAFE_FUSE1	0x9082
#define FAFE_DCDC1V8_VREF_SEL	0x908200e0
#define FAFE_TST_MODE_DIS		0x90820010
#define FAFE_RX4_DIS			0x90820008
#define FAFE_RX3_DIS			0x90820004
#define FAFE_RX2_DIS			0x90820002
#define FAFE_RX1_DIS			0x90820001

/*#else	   */

/*STATUS cut1*/
/*#define RAFE_STATUS  0x9082
#define FAFE_UNUSED2  		0x908200c0
#define FAFE_PLL_LOCK  		0x90820020
#define FAFE_LNBCTRL_ISENSE 0x90820010
#define FAFE_UNUSED1  		0x90820008
#define FAFE_DCDC_VREG_OK  	0x90820004
#define FAFE_LDO_POR_3V3  	0x90820002
#define FAFE_LDO_VREG_OK  	0x90820001  */

/*FUSE1 cut1 */
/*#define RAFE_FUSE1	0x9081
#define FAFE_DCDC1V8_VREF_SEL	0x908100e0
#define FAFE_TST_MODE_DIS		0x90810010
#define FAFE_RX4_DIS			0x90810008
#define FAFE_RX3_DIS			0x90810004
#define FAFE_RX2_DIS			0x90810002
#define FAFE_RX1_DIS			0x90810001 

#endif */
			/*FUSE2  */	
#define RAFE_FUSE2	0x9083
#define FAFE_BB1I_CAL  			0x908300ff
			
			/*FUSE3  */	
#define RAFE_FUSE3	0x9084 
#define FAFE_BB2I_CAL  			0x908400ff
			
			/*FUSE4  */	
#define RAFE_FUSE4	0x9085 
#define FAFE_BB3I_CAL 			0x908500ff
			
			/*FUSE5  */	
#define RAFE_FUSE5	0x9086 
#define FAFE_BB4I_CAL			0x908600ff
			
			/*FUSE6  */	
#define RAFE_FUSE6	0x9087 
#define FAFE_BB4Q_CAL			0x908700c0
#define FAFE_BB3Q_CAL			0x90870030 
#define FAFE_BB2Q_CAL			0x9087000c 
#define FAFE_BB1Q_CAL			0x90870003
			
/*IRQ_MASK*/
#define RAFE_IRQ_MASK  0x9090
#define FAFE_RESERVED37		0x909000fc
#define FAFE_DCDC_KO_MSK  	0x90900002
#define FAFE_LDO_KO_MSK  	0x90900001

/*IRQ*/
#define RAFE_IRQ  0x9091
#define FAFE_RESERVED38		0x909100fc
#define FAFE_DCDC_KO  		0x90910002
#define FAFE_LDO_KO  		0x90910001

/*SPARE1*/
#define RAFE_SPARE1  0x90f0
#define FAFE_AFE_SPARE1  0x90f000ff	

/*SPARE2*/
#define RAFE_SPARE2  0x90f1
#define FAFE_AFE_SPARE2  0x90f100ff

/*SPARE3*/
#define RAFE_SPARE3  0x90f2
#define FAFE_AFE_SPARE3  0x90f200ff



#ifdef ATB
	/* Number of registers including demod registers*/
	#define		OXFORD_NBREGS		273 
	/* Number of fields */
	#define		OXFORD_NBFIELDS		384 
	
#else
	/* Number of registers */
	#define		OXFORD_NBREGS		88 
	/* Number of fields */
	#define		OXFORD_NBFIELDS		327 	
#endif
	#ifdef __cplusplus
	 extern "C"
	 {
	#endif                  /* __cplusplus */


	/* create instance of register mappings */
   STCHIP_Error_t oxford_Init(Demod_InitParams_t *InitParams,STCHIP_Handle_t *hChipHandle); 


	#ifdef __cplusplus
	 }
	#endif                  /* __cplusplus */
	
#endif

