/*
* This file is part of STiD135 OXFORD LLA 
 *
* Copyright (c) <2014>-<2018>, STMicroelectronics - All Rights Reserved 
* Author(s): Mathias Hilaire (mathias.hilaire@st.com), Thierry Delahaye (thierry.delahaye@st.com) for STMicroelectronics. 
 *
* License terms: BSD 3-clause "New" or "Revised" License. 
 *
* Redistribution and use in source and binary forms, with or without 
* modification, are permitted provided that the following conditions are met: 
* 
* 1. Redistributions of source code must retain the above copyright notice, this 
* list of conditions and the following disclaimer. 
* 
* 2. Redistributions in binary form must reproduce the above copyright notice, 
* this list of conditions and the following disclaimer in the documentation 
* and/or other materials provided with the distribution. 
* 
* 3. Neither the name of the copyright holder nor the names of its contributors 
* may be used to endorse or promote products derived from this software 
* without specific prior written permission. 
* 
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" 
* AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE 
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE 
* DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE 
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL 
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR 
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
* CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, 
* OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
* OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE. 
 *
 */

#include "globaldefs.h"
#include "stid135_drv.h"
#include "oxford_anafe_init.h"

#include "c8codew_addr_map.h"
#include "stid135_addr_map.h"
#include "stid135_initLLA_cut2.h"
#include "stid135_init.h"

	
u32 C8CODEW_TOP_CTRL[1] = { C8CODEW_TOP_CTRL_ADDR(unit) };
u32 DVBSX_AGCRF[4] = { A1_DVBSX_AGCRF_ADDR(unit), A2_DVBSX_AGCRF_ADDR(unit), A3_DVBSX_AGCRF_ADDR(unit), A4_DVBSX_AGCRF_ADDR(unit) };
u32 C8CODEW_RFMUX[1] = { C8CODEW_RFMUX_ADDR(unit) };
u32 DVBSX_DISEQC[4] = { D1_DVBSX_DISEQC_ADDR(unit), D2_DVBSX_DISEQC_ADDR(unit), D3_DVBSX_DISEQC_ADDR(unit), D4_DVBSX_DISEQC_ADDR(unit) };
//u32 DVBSX_DISEQCTST[4] = { Q1_DVBSX_DISEQCTST_ADDR(unit), Q2_DVBSX_DISEQCTST_ADDR(unit), Q3_DVBSX_DISEQCTST_ADDR(unit), Q4_DVBSX_DISEQCTST_ADDR(unit) };
//u32 DVBSX_FSK[1] = { DVBSX_FSK_ADDR(unit) };
u32 DVBSX_LNBCTRL[1] = { DVBSX_LNBCTRL_ADDR(unit) };
u32 C8CODEW_PATH_CTRL[8] = { C1_C8CODEW_PATH_CTRL_ADDR(unit), C2_C8CODEW_PATH_CTRL_ADDR(unit), C3_C8CODEW_PATH_CTRL_ADDR(unit), C4_C8CODEW_PATH_CTRL_ADDR(unit), C5_C8CODEW_PATH_CTRL_ADDR(unit), C6_C8CODEW_PATH_CTRL_ADDR(unit), C7_C8CODEW_PATH_CTRL_ADDR(unit), C8_C8CODEW_PATH_CTRL_ADDR(unit) };
u32 C8CODEW_PATH_CTRL_GEN[4] = { G1_C8CODEW_PATH_CTRL_GEN_ADDR(unit), G2_C8CODEW_PATH_CTRL_GEN_ADDR(unit), G3_C8CODEW_PATH_CTRL_GEN_ADDR(unit), G4_C8CODEW_PATH_CTRL_GEN_ADDR(unit) };
u32 DVBSX_HWARE_GEN[4] = { H1_DVBSX_HWARE_GEN_ADDR(unit), H2_DVBSX_HWARE_GEN_ADDR(unit), H3_DVBSX_HWARE_GEN_ADDR(unit), H4_DVBSX_HWARE_GEN_ADDR(unit) };
u32 DVBSX_DEMOD[8] = { D1_DVBSX_DEMOD_ADDR(unit), D2_DVBSX_DEMOD_ADDR(unit), D3_DVBSX_DEMOD_ADDR(unit), D4_DVBSX_DEMOD_ADDR(unit), D5_DVBSX_DEMOD_ADDR(unit), D6_DVBSX_DEMOD_ADDR(unit), D7_DVBSX_DEMOD_ADDR(unit), D8_DVBSX_DEMOD_ADDR(unit) };
u32 DVBSX_VITERBI[8] = { V1_DVBSX_VITERBI_ADDR(unit), V2_DVBSX_VITERBI_ADDR(unit), V3_DVBSX_VITERBI_ADDR(unit), V4_DVBSX_VITERBI_ADDR(unit), V5_DVBSX_VITERBI_ADDR(unit), V6_DVBSX_VITERBI_ADDR(unit), V7_DVBSX_VITERBI_ADDR(unit), V8_DVBSX_VITERBI_ADDR(unit) };
u32 DVBSX_SUPERFEC[8] = { S1_DVBSX_SUPERFEC_ADDR(unit), S2_DVBSX_SUPERFEC_ADDR(unit), S3_DVBSX_SUPERFEC_ADDR(unit), S4_DVBSX_SUPERFEC_ADDR(unit), S5_DVBSX_SUPERFEC_ADDR(unit), S6_DVBSX_SUPERFEC_ADDR(unit), S7_DVBSX_SUPERFEC_ADDR(unit), S8_DVBSX_SUPERFEC_ADDR(unit) };
u32 DVBSX_HWARE[8] = { W1_DVBSX_HWARE_ADDR(unit), W2_DVBSX_HWARE_ADDR(unit), W3_DVBSX_HWARE_ADDR(unit), W4_DVBSX_HWARE_ADDR(unit), W5_DVBSX_HWARE_ADDR(unit), W6_DVBSX_HWARE_ADDR(unit), W7_DVBSX_HWARE_ADDR(unit), W8_DVBSX_HWARE_ADDR(unit) };
u32 DVBSX_PKTDELIN[8] = { K1_DVBSX_PKTDELIN_ADDR(unit), K2_DVBSX_PKTDELIN_ADDR(unit), K3_DVBSX_PKTDELIN_ADDR(unit), K4_DVBSX_PKTDELIN_ADDR(unit), K5_DVBSX_PKTDELIN_ADDR(unit), K6_DVBSX_PKTDELIN_ADDR(unit), K7_DVBSX_PKTDELIN_ADDR(unit), K8_DVBSX_PKTDELIN_ADDR(unit) };
u32 DVBSX_FECSPY[8] = { B1_DVBSX_FECSPY_ADDR(unit), B2_DVBSX_FECSPY_ADDR(unit), B3_DVBSX_FECSPY_ADDR(unit), B4_DVBSX_FECSPY_ADDR(unit), B5_DVBSX_FECSPY_ADDR(unit), B6_DVBSX_FECSPY_ADDR(unit), B7_DVBSX_FECSPY_ADDR(unit), B8_DVBSX_FECSPY_ADDR(unit) };
u32 C8CODEW_DVBS2FEC[1] = { C8CODEW_DVBS2FEC_ADDR(unit) };



u32 SYSCONFIGN[1] = { SYSCONFIGN_ADDR(unit) };
//u32 X5BANKPIONORTH[5] = { N1_X5BANKPIONORTH_ADDR(unit), N2_X5BANKPIONORTH_ADDR(unit), N3_X5BANKPIONORTH_ADDR(unit), N4_X5BANKPIONORTH_ADDR(unit), N5_X5BANKPIONORTH_ADDR(unit) };
u32 X5BANKPIONORTH[5] = { P1_5BANKPIONORTH_ADDR(unit), P2_5BANKPIONORTH_ADDR(unit), P3_5BANKPIONORTH_ADDR(unit), P4_5BANKPIONORTH_ADDR(unit), P5_5BANKPIONORTH_ADDR(unit) };
u32 PIONORTHMUX[1] = { PIONORTHMUX_ADDR(unit) };
u32 CLOCKGENNORTH[1] = { CLOCKGENNORTH_ADDR(unit) };
u32 AFE_CTRL[1] = { AFE_CTRL_ADDR(unit) };
u32 THSENSOR[1] = { THSENSOR_ADDR(unit) };
u32 PWM[1] = { PWM_ADDR(unit) };
//u32 IRQMERGER[1] = { IRQMERGER_ADDR(unit) };
u32 SYSCONFIGS[1] = { SYSCONFIGS_ADDR(unit) };
//u32 X5BANKPIOSOUTH[5] = { S1_X5BANKPIOSOUTH_ADDR(unit), S2_X5BANKPIOSOUTH_ADDR(unit), S3_X5BANKPIOSOUTH_ADDR(unit), S4_X5BANKPIOSOUTH_ADDR(unit), S5_X5BANKPIOSOUTH_ADDR(unit) };
u32 X5BANKPIOSOUTH[5] = { P6_5BANKPIOSOUTH_ADDR(unit), P7_5BANKPIOSOUTH_ADDR(unit), P8_5BANKPIOSOUTH_ADDR(unit), P9_5BANKPIOSOUTH_ADDR(unit), P10_5BANKPIOSOUTH_ADDR(unit) };
u32 PIOSOUTHMUX[1] = { PIOSOUTHMUX_ADDR(unit) };
u32 STFECONFIG[1] = { STFECONFIG_ADDR(unit) };
u32 C8SECTPFE_IB[8] = { P1_C8SECTPFE_IB_ADDR(unit), P2_C8SECTPFE_IB_ADDR(unit), P3_C8SECTPFE_IB_ADDR(unit), P4_C8SECTPFE_IB_ADDR(unit), P5_C8SECTPFE_IB_ADDR(unit), P6_C8SECTPFE_IB_ADDR(unit), P7_C8SECTPFE_IB_ADDR(unit), P8_C8SECTPFE_IB_ADDR(unit) };
//u32 C8SECTPFE_TC[2] = { T1_C8SECTPFE_TC_ADDR(unit), T2_C8SECTPFE_TC_ADDR(unit) };
u32 C8SECTPFE_TSDMA[1] = { C8SECTPFE_TSDMA_ADDR(unit) };

struct InstReg
{
	u16 Instance;
	u32 AddressRegister;
};		

static STCHIP_Register_t STiD135DefVal[]={
	{0x100,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_MID */
	{0x101,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_DID */
	{0x110,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TOP_FRES */
	{0x111,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TOP_STOPCLK */
	{0x120,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_ADCICFG */
	{0x121,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_DSQADCICFG */
	{0x122,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_ADCICLK */
	{0x130,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYNTCTRL */
	{0x131,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CCFG */
	{0x132,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYSSTATUS1 */
	{0x133,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYSSTATUS0 */
	{0x138,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CRPT1 */
	{0x139,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CRPT2 */
	{0x140,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_DACR1 */
	{0x141,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_DACR2 */
	{0x150,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYS_IRQMSK */
	{0x151,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYS_IRQSTATUS */
	{0x152,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SYS_IRQFORCE */
	{0x17c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TSRCSSEL */
	{0x17d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_AGCOBSSEL */
	{0x17e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SDDATASEL */
	{0x17f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_SGNLGSEL */
	{0x180,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO0CFG */
	{0x181,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO1CFG */
	{0x182,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO2CFG */
	{0x183,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO3CFG */
	{0x184,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO4CFG */
	{0x185,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO5CFG */
	{0x186,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO6CFG */
	{0x187,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO7CFG */
	{0x188,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO8CFG */
	{0x189,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO9CFG */
	{0x18a,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO10CFG */
	{0x18b,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO11CFG */
	{0x18c,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO12CFG */
	{0x18d,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO13CFG */
	{0x18e,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO14CFG */
	{0x18f,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO15CFG */
	{0x190,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO16CFG */
	{0x191,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO17CFG */
	{0x192,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO18CFG */
	{0x193,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIO19CFG */
	{0x1a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIOOBS2 */
	{0x1a2,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIOOBS1 */
	{0x1a3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_GPIOOBS0 */
	{0x1f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TSTOUT */
	{0x1f2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TSTSYS */
	{0x1f4,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TBUSXXX2 */
	{0x1f5,    0x4b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TBUSXXX1 */
	{0x1f6,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TBUSXXX0 */
	{0x1f7,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_BITSPEED1 */
	{0x1f8,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_BITSPEED0 */
	{0x1f9,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TBUSBIT1 */
	{0x1fa,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_TBUSBIT2 */
	{0x1fb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CMAPOCFG */
	{0x1fc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CMAPO11 */
	{0x1fd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CMAPO10 */
	{0x1fe,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CMAPO21 */
	{0x1ff,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_TOP_CTRL_I2CMAPO20 */
	{0x200,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCFG(1) */
	{0x201,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFRFN(1) */
	{0x202,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCN(1) */
	{0x203,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFREF(1) */
	{0x204,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDC_AGCCFG(1) */
	{0x205,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDCCOMPCFG(1) */
	{0x206,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP(1) */
	{0x207,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP2(1) */
	{0x208,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP(1) */
	{0x209,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP2(1) */
	{0x20a,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERI(1) */
	{0x20b,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERQ(1) */
	{0x20c,    0xca,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN1(1) */
	{0x20d,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN0(1) */
	{0x20e,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCINC(1) */
	{0x20f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_TESTBUS(1) */
	{0x210,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMRFINC(1) */
	{0x211,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMBBINC(1) */
	{0x220,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCFG(2) */
	{0x221,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFRFN(2) */
	{0x222,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCN(2) */
	{0x223,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFREF(2) */
	{0x224,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDC_AGCCFG(2) */
	{0x225,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDCCOMPCFG(2) */
	{0x226,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP(2) */
	{0x227,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP2(2) */
	{0x228,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP(2) */
	{0x229,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP2(2) */
	{0x22a,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERI(2) */
	{0x22b,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERQ(2) */
	{0x22c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN1(2) */
	{0x22d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN0(2) */
	{0x22e,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCINC(2) */
	{0x22f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_TESTBUS(2) */
	{0x230,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMRFINC(2) */
	{0x231,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMBBINC(2) */
	{0x240,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCFG(3) */
	{0x241,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFRFN(3) */
	{0x242,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCN(3) */
	{0x243,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFREF(3) */
	{0x244,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDC_AGCCFG(3) */
	{0x245,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDCCOMPCFG(3) */
	{0x246,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP(3) */
	{0x247,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP2(3) */
	{0x248,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP(3) */
	{0x249,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP2(3) */
	{0x24a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERI(3) */
	{0x24b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERQ(3) */
	{0x24c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN1(3) */
	{0x24d,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN0(3) */
	{0x24e,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCINC(3) */
	{0x24f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_TESTBUS(3) */
	{0x250,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMRFINC(3) */
	{0x251,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMBBINC(3) */
	{0x260,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCFG(4) */
	{0x261,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFRFN(4) */
	{0x262,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFCN(4) */
	{0x263,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFREF(4) */
	{0x264,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDC_AGCCFG(4) */
	{0x265,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_IQDCCOMPCFG(4) */
	{0x266,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP(4) */
	{0x267,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_IDCCOMP2(4) */
	{0x268,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP(4) */
	{0x269,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_QDCCOMP2(4) */
	{0x26a,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERI(4) */
	{0x26b,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_POWERQ(4) */
	{0x26c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN1(4) */
	{0x26d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRFIN0(4) */
	{0x26e,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCINC(4) */
	{0x26f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_TESTBUS(4) */
	{0x270,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMRFINC(4) */
	{0x271,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_AGCRF_AGCRF_PWMBBINC(4) */
	{0x2a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX0 */
	{0x2a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX1 */
	{0x2a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX2 */
	{0x2a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX3 */
	{0x2a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX4 */
	{0x2a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX5 */
	{0x2a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX6 */
	{0x2a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUX7 */
	{0x2a8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUXRV0 */
	{0x2a9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUXRV1 */
	{0x2aa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUXRV2 */
	{0x2ab,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_RFMUXRV3 */
	{0x2b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_RFMUX_AGCRFXOR */
	{0x300,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQCFG(1) */
	{0x301,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQSTAT(1) */
	{0x302,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXCFG(1) */
	{0x303,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXSTATUS(1) */
	{0x304,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXBYTES(1) */
	{0x305,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXFIFO(1) */
	{0x306,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXF22(1) */
	{0x307,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXWAIT(1) */
	{0x308,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOCFG(1) */
	{0x309,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOUT(1) */
	{0x30a,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXCFG(1) */
	{0x30b,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT1(1) */
	{0x30c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT0(1) */
	{0x30d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXBYTES(1) */
	{0x30e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY1(1) */
	{0x30f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY0(1) */
	{0x310,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXFIFO(1) */
	{0x311,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC1(1) */
	{0x312,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC0(1) */
	{0x313,    0x62,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXKOFF(1) */
	{0x314,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF221(1) */
	{0x315,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF220(1) */
	{0x316,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF100(1) */
	{0x317,    0x31,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK1(1) */
	{0x318,    0xb1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK2(1) */
	{0x319,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPK(1) */
	{0x31a,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXENV(1) */
	{0x31b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXVMIN(1) */
	{0x31c,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSHORT22K(1) */
	{0x31e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRPRESC(1) */
	{0x31f,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRDIV(1) */
	{0x330,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTBUS(1) */
	{0x331,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTSTCFG(1) */
	{0x332,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSEED(1) */
	{0x333,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT1(1) */
	{0x334,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT0(1) */
	{0x335,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR1(1) */
	{0x336,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR0(1) */
	{0x337,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT1(1) */
	{0x338,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT0(1) */
	{0x339,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN1(1) */
	{0x33a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN0(1) */
	{0x340,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQCFG(2) */
	{0x341,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQSTAT(2) */
	{0x342,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXCFG(2) */
	{0x343,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXSTATUS(2) */
	{0x344,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXBYTES(2) */
	{0x345,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXFIFO(2) */
	{0x346,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXF22(2) */
	{0x347,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXWAIT(2) */
	{0x348,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOCFG(2) */
	{0x349,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOUT(2) */
	{0x34a,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXCFG(2) */
	{0x34b,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT1(2) */
	{0x34c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT0(2) */
	{0x34d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXBYTES(2) */
	{0x34e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY1(2) */
	{0x34f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY0(2) */
	{0x350,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXFIFO(2) */
	{0x351,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC1(2) */
	{0x352,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC0(2) */
	{0x353,    0x62,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXKOFF(2) */
	{0x354,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF221(2) */
	{0x355,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF220(2) */
	{0x356,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF100(2) */
	{0x357,    0x31,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK1(2) */
	{0x358,    0xb1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK2(2) */
	{0x359,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPK(2) */
	{0x35a,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXENV(2) */
	{0x35b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXVMIN(2) */
	{0x35c,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSHORT22K(2) */
	{0x35e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRPRESC(2) */
	{0x35f,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRDIV(2) */
	{0x370,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTBUS(2) */
	{0x371,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTSTCFG(2) */
	{0x372,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSEED(2) */
	{0x373,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT1(2) */
	{0x374,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT0(2) */
	{0x375,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR1(2) */
	{0x376,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR0(2) */
	{0x377,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT1(2) */
	{0x378,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT0(2) */
	{0x379,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN1(2) */
	{0x37a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN0(2) */
	{0x380,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQCFG(3) */
	{0x381,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQSTAT(3) */
	{0x382,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXCFG(3) */
	{0x383,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXSTATUS(3) */
	{0x384,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXBYTES(3) */
	{0x385,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXFIFO(3) */
	{0x386,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXF22(3) */
	{0x387,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXWAIT(3) */
	{0x388,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOCFG(3) */
	{0x389,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOUT(3) */
	{0x38a,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXCFG(3) */
	{0x38b,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT1(3) */
	{0x38c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT0(3) */
	{0x38d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXBYTES(3) */
	{0x38e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY1(3) */
	{0x38f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY0(3) */
	{0x390,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXFIFO(3) */
	{0x391,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC1(3) */
	{0x392,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC0(3) */
	{0x393,    0x62,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXKOFF(3) */
	{0x394,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF221(3) */
	{0x395,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF220(3) */
	{0x396,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF100(3) */
	{0x397,    0x31,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK1(3) */
	{0x398,    0xb1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK2(3) */
	{0x399,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPK(3) */
	{0x39a,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXENV(3) */
	{0x39b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXVMIN(3) */
	{0x39c,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSHORT22K(3) */
	{0x39e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRPRESC(3) */
	{0x39f,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRDIV(3) */
	{0x3b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTBUS(3) */
	{0x3b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTSTCFG(3) */
	{0x3b2,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSEED(3) */
	{0x3b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT1(3) */
	{0x3b4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT0(3) */
	{0x3b5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR1(3) */
	{0x3b6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR0(3) */
	{0x3b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT1(3) */
	{0x3b8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT0(3) */
	{0x3b9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN1(3) */
	{0x3ba,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN0(3) */
	{0x3c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQCFG(4) */
	{0x3c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISIRQSTAT(4) */
	{0x3c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXCFG(4) */
	{0x3c3,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXSTATUS(4) */
	{0x3c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXBYTES(4) */
	{0x3c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXFIFO(4) */
	{0x3c6,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXF22(4) */
	{0x3c7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTXWAIT(4) */
	{0x3c8,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOCFG(4) */
	{0x3c9,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISTIMEOUT(4) */
	{0x3ca,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXCFG(4) */
	{0x3cb,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT1(4) */
	{0x3cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSTAT0(4) */
	{0x3cd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXBYTES(4) */
	{0x3ce,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY1(4) */
	{0x3cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPARITY0(4) */
	{0x3d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXFIFO(4) */
	{0x3d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC1(4) */
	{0x3d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXDC0(4) */
	{0x3d3,    0x62,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXKOFF(4) */
	{0x3d4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF221(4) */
	{0x3d5,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF220(4) */
	{0x3d6,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXF100(4) */
	{0x3d7,    0x31,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK1(4) */
	{0x3d8,    0xb1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXK2(4) */
	{0x3d9,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXPK(4) */
	{0x3da,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXENV(4) */
	{0x3db,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXVMIN(4) */
	{0x3dc,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_DISRXSHORT22K(4) */
	{0x3de,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRPRESC(4) */
	{0x3df,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQC_ACRDIV(4) */
	{0x3f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTBUS(4) */
	{0x3f1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISTSTCFG(4) */
	{0x3f2,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSEED(4) */
	{0x3f3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT1(4) */
	{0x3f4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISPRBSCNT0(4) */
	{0x3f5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR1(4) */
	{0x3f6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYERR0(4) */
	{0x3f7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT1(4) */
	{0x3f8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXSPYCNT0(4) */
	{0x3f9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN1(4) */
	{0x3fa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DISEQCTST_DISRXPEAKMEAN0(4) */
	{0x400,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTFC2 */
	{0x401,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTFC1 */
	{0x402,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTFC0 */
	{0x403,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTDELTAF1 */
	{0x404,    0x37,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTDELTAF0 */
	{0x405,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKTCTRL */
	{0x406,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFC2 */
	{0x407,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFC1 */
	{0x408,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFC0 */
	{0x409,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRK1 */
	{0x40a,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRK2 */
	{0x40b,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRAGCR */
	{0x40c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRAGC */
	{0x40d,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRALPHA */
	{0x40e,    0x90,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRPLTH1 */
	{0x40f,    0xbe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRPLTH0 */
	{0x410,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDF1 */
	{0x411,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDF0 */
	{0x412,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRSTEPP */
	{0x413,    0x6f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRSTEPM */
	{0x414,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDET1 */
	{0x415,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDET0 */
	{0x416,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDTH1 */
	{0x417,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDTH0 */
	{0x418,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRLOSS */
	{0x419,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRLEAK */
	{0x41a,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRAGCTH */
	{0x41b,    0x16,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFINIIR */
	{0x41c,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFBIT1 */
	{0x41d,    0xbc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFBIT0 */
	{0x41e,    0x3c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMINSTART */
	{0x41f,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMAXSTART */
	{0x420,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRPEAKDIF */
	{0x421,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMINPK */
	{0x422,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMAXPK */
	{0x423,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFWDWN */
	{0x424,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRFWTH */
	{0x425,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRINITDEV */
	{0x426,    0x37,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMINDEV */
	{0x427,    0x78,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMAXDEV */
	{0x428,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMAXTERR */
	{0x429,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRKTMG */
	{0x42a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRLOW */
	{0x42b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRHIGH */
	{0x42c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDVAL3 */
	{0x42d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDVAL2 */
	{0x42e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDVAL1 */
	{0x42f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDVAL0 */
	{0x430,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDMSK3 */
	{0x431,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDMSK2 */
	{0x432,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDMSK1 */
	{0x433,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRWORDMSK0 */
	{0x434,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRDELAYLG */
	{0x435,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRSTOPLG */
	{0x436,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRMESLG */
	{0x437,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FSK_FSKRCFG */
	{0x500,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VER */
	{0x504,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_FPWM0 */
	{0x505,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_FPWM1 */
	{0x506,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_FADC0 */
	{0x507,    0x6c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_FADC1 */
	{0x508,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_FTIMER */
	{0x509,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VCTRL */
	{0x50a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DMAX */
	{0x50b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DFORCED */
	{0x50c,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSEL0 */
	{0x50d,    0x9c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSEL1 */
	{0x50e,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSEL2 */
	{0x50f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSEL3 */
	{0x510,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DCFLT0 */
	{0x511,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DCFLT1 */
	{0x512,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_LOOPFLT0 */
	{0x513,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_LOOPFLT1 */
	{0x514,    0x36,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSTABLE1 */
	{0x515,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSTABLE2 */
	{0x516,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_ISAF0 */
	{0x517,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_ISAF1 */
	{0x518,    0x4b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_SCSAF */
	{0x519,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_OCSAF0 */
	{0x51a,    0x9a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_OCSAF1 */
	{0x51c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DSQDRV0 */
	{0x51d,    0x36,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DSQDRV1 */
	{0x51e,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DSQDRV2 */
	{0x51f,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_DSQDRV3 */
	{0x520,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_LOWICTRL1 */
	{0x521,    0x87,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_LOWICTRL2 */
	{0x522,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_LOWICTRL3 */
	{0x524,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_SAFSTAT */
	{0x525,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_VSENSESTAT */
	{0x526,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_PWMDSTAT */
	{0x528,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_ITEN */
	{0x529,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_LNBCTRL_LNB_ITSTAT */
	{0x800,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(1) */
	{0x801,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(1) */
	{0x810,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(1) */
	{0x811,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(1) */
	{0x812,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(1) */
	{0x813,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(1) */
	{0x814,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(1) */
	{0x815,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(1) */
	{0x820,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(1) */
	{0x821,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(1) */
	{0x822,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(1) */
	{0x840,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_FRESGEN(1) */
	{0x850,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_TBUSSEL(1) */
	{0x851,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_BYPASSEN(1) */
	{0x899,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG1(1) */
	{0x89a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG0(1) */
	{0x8a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENERAL(1) */
	{0x8a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENCFG2(1) */
	{0x8a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGSTATUS(1) */
	{0x8a3,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSRSCFG(1) */
	{0x8a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSTTSRS(1) */
	{0x900,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(1) */
	{0x901,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(1) */
	{0x902,    0xb9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(1) */
	{0x903,    0x4a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(1) */
	{0x910,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(1) */
	{0x912,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(1) */
	{0x913,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(1) */
	{0x916,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(1) */
	{0x917,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(1) */
	{0x918,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(1) */
	{0x919,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(1) */
	{0x91a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(1) */
	{0x91b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(1) */
	{0x91c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(1) */
	{0x91d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(1) */
	{0x920,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(1) */
	{0x922,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(1) */
	{0x923,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(1) */
	{0x924,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(1) */
	{0x925,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(1) */
	{0x926,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(1) */
	{0x927,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(1) */
	{0x928,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(1) */
	{0x929,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(1) */
	{0x92a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(1) */
	{0x92b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(1) */
	{0x930,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(1) */
	{0x931,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(1) */
	{0x932,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(1) */
	{0x933,    0xcf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(1) */
	{0x934,    0xec,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(1) */
	{0x935,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(1) */
	{0x936,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(1) */
	{0x937,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(1) */
	{0x938,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(1) */
	{0x939,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(1) */
	{0x93a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(1) */
	{0x940,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(1) */
	{0x941,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(1) */
	{0x942,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(1) */
	{0x943,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(1) */
	{0x944,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(1) */
	{0x948,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(1) */
	{0x949,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(1) */
	{0x94a,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(1) */
	{0x950,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(1) */
	{0x951,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(1) */
	{0x952,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(1) */
	{0x953,    0x9a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(1) */
	{0x954,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(1) */
	{0x955,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(1) */
	{0x956,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(1) */
	{0x957,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(1) */
	{0x958,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(1) */
	{0x959,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(1) */
	{0x95a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(1) */
	{0x95b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(1) */
	{0x95c,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(1) */
	{0x95d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(1) */
	{0x95e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(1) */
	{0x970,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(1) */
	{0x971,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(1) */
	{0x972,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(1) */
	{0x973,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(1) */
	{0x974,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(1) */
	{0x975,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(1) */
	{0x980,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(1) */
	{0x981,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(1) */
	{0x982,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(1) */
	{0x983,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(1) */
	{0x984,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(1) */
	{0x985,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(1) */
	{0x986,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(1) */
	{0x987,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(1) */
	{0x988,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(1) */
	{0x990,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(1) */
	{0x991,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(1) */
	{0x992,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(1) */
	{0x993,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(1) */
	{0x994,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(1) */
	{0x995,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(1) */
	{0x996,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(1) */
	{0x997,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(1) */
	{0x998,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(1) */
	{0x999,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(1) */
	{0x99a,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(1) */
	{0x99b,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(1) */
	{0x99c,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(1) */
	{0x99d,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(1) */
	{0x99e,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(1) */
	{0x99f,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(1) */
	{0x9a0,    0x6c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(1) */
	{0x9a1,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(1) */
	{0x9a2,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(1) */
	{0x9a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(1) */
	{0x9a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(1) */
	{0x9a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(1) */
	{0x9a6,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(1) */
	{0x9a7,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(1) */
	{0x9a8,    0x9f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(1) */
	{0x9b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(1) */
	{0x9b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(1) */
	{0x9b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(1) */
	{0x9b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(1) */
	{0x9b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(1) */
	{0x9b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(1) */
	{0x9b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(1) */
	{0x9b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(1) */
	{0x9b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(1) */
	{0x9b9,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(1) */
	{0x9ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(1) */
	{0x9bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(1) */
	{0x9bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(1) */
	{0x9bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(1) */
	{0x9be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(1) */
	{0x9bf,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(1) */
	{0x9c0,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(1) */
	{0x9c1,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(1) */
	{0x9c2,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(1) */
	{0x9c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(1) */
	{0x9c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(1) */
	{0x9c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(1) */
	{0x9c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(1) */
	{0x9c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(1) */
	{0x9c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(1) */
	{0x9c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(1) */
	{0x9ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(1) */
	{0x9cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(1) */
	{0x9cc,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(1) */
	{0x9cd,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(1) */
	{0x9ce,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(1) */
	{0x9cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(1) */
	{0x9d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(1) */
	{0x9d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(1) */
	{0x9d2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(1) */
	{0x9d3,    0xef,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(1) */
	{0x9d4,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(1) */
	{0x9d5,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(1) */
	{0x9d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(1) */
	{0x9d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(1) */
	{0x9d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(1) */
	{0x9d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(1) */
	{0x9da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(1) */
	{0x9db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(1) */
	{0x9dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(1) */
	{0x9dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(1) */
	{0x9de,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(1) */
	{0x9e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(1) */
	{0x9e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(1) */
	{0x9e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(1) */
	{0x9e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(1) */
	{0x9e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(1) */
	{0x9e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(1) */
	{0x9e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(1) */
	{0x9e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(1) */
	{0x9e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(1) */
	{0x9e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(1) */
	{0x9ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(1) */
	{0x9eb,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(1) */
	{0x9ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(1) */
	{0x9ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(1) */
	{0x9f0,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(1) */
	{0x9f1,    0x95,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(1) */
	{0x9f2,    0x86,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(1) */
	{0x9f3,    0x53,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(1) */
	{0x9f4,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(1) */
	{0x9f5,    0xe7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(1) */
	{0x9f6,    0x51,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(1) */
	{0x9f7,    0x9d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(1) */
	{0x9f8,    0xcd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(1) */
	{0x9fc,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(1) */
	{0x9fd,    0x95,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(1) */
	{0x9fe,    0x86,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(1) */
	{0x9ff,    0xf3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(1) */
	{0xa00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(1) */
	{0xa01,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(1) */
	{0xa02,    0xec,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(1) */
	{0xa03,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(1) */
	{0xa04,    0xd6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(1) */
	{0xa05,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(1) */
	{0xa06,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(1) */
	{0xa07,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(1) */
	{0xa08,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(1) */
	{0xa10,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(1) */
	{0xa11,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(1) */
	{0xa12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(1) */
	{0xa13,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(1) */
	{0xa14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(1) */
	{0xa15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(1) */
	{0xa16,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(1) */
	{0xa17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(1) */
	{0xa18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(1) */
	{0xa19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(1) */
	{0xa1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(1) */
	{0xa1b,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(1) */
	{0xa1c,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(1) */
	{0xa20,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(1) */
	{0xa21,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(1) */
	{0xa22,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(1) */
	{0xa23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(1) */
	{0xa24,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(1) */
	{0xa25,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(1) */
	{0xa26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(1) */
	{0xa27,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(1) */
	{0xa28,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(1) */
	{0xa29,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(1) */
	{0xa2a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(1) */
	{0xa2b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(1) */
	{0xa2c,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(1) */
	{0xa2d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(1) */
	{0xa2e,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(1) */
	{0xa2f,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(1) */
	{0xa30,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(1) */
	{0xa31,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(1) */
	{0xa32,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(1) */
	{0xa33,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(1) */
	{0xa34,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(1) */
	{0xa35,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(1) */
	{0xa36,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(1) */
	{0xa37,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(1) */
	{0xa38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(1) */
	{0xa39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(1) */
	{0xa40,    0xb4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(1) */
	{0xa41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(1) */
	{0xa42,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(1) */
	{0xa43,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(1) */
	{0xa44,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(1) */
	{0xa45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(1) */
	{0xa46,    0xdd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(1) */
	{0xa47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(1) */
	{0xa48,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(1) */
	{0xa49,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(1) */
	{0xa4a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(1) */
	{0xa4b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(1) */
	{0xa4c,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(1) */
	{0xa4d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(1) */
	{0xa4e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(1) */
	{0xa4f,    0x7a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(1) */
	{0xa50,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(1) */
	{0xa51,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(1) */
	{0xa52,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(1) */
	{0xa53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(1) */
	{0xa54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(1) */
	{0xa55,    0xf2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(1) */
	{0xa56,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(1) */
	{0xa57,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(1) */
	{0xa58,    0x76,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(1) */
	{0xa59,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(1) */
	{0xa5a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(1) */
	{0xa5b,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(1) */
	{0xa5c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(1) */
	{0xa5d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(1) */
	{0xa5e,    0xa3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(1) */
	{0xa5f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(1) */
	{0xa60,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(1) */
	{0xa61,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(1) */
	{0xa62,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(1) */
	{0xa63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(1) */
	{0xa64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(1) */
	{0xa65,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(1) */
	{0xa68,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(1) */
	{0xa69,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(1) */
	{0xa6a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(1) */
	{0xa6b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(1) */
	{0xa6c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(1) */
	{0xa6d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(1) */
	{0xa6e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(1) */
	{0xa6f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(1) */
	{0xa70,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(1) */
	{0xa71,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(1) */
	{0xa72,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(1) */
	{0xa73,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(1) */
	{0xa74,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(1) */
	{0xa75,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(1) */
	{0xa76,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(1) */
	{0xa77,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(1) */
	{0xa84,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(1) */
	{0xa85,    0x7c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(1) */
	{0xa86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(1) */
	{0xa87,    0x74,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(1) */
	{0xa88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(1) */
	{0xa89,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(1) */
	{0xa8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(1) */
	{0xa8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(1) */
	{0xa98,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(1) */
	{0xa99,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(1) */
	{0xa9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(1) */
	{0xaa0,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(1) */
	{0xaa1,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(1) */
	{0xaa2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(1) */
	{0xaa3,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(1) */
	{0xaa4,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(1) */
	{0xaa5,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(1) */
	{0xaa6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(1) */
	{0xaa7,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(1) */
	{0xaa8,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(1) */
	{0xaa9,    0xdc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(1) */
	{0xaaa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(1) */
	{0xaab,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(1) */
	{0xaac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(1) */
	{0xaad,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(1) */
	{0xaae,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(1) */
	{0xaaf,    0x49,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(1) */
	{0xac0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(1) */
	{0xac1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(1) */
	{0xac2,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(1) */
	{0xac3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(1) */
	{0xac4,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(1) */
	{0xac5,    0xc5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(1) */
	{0xac6,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(1) */
	{0xad0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(1) */
	{0xad1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(1) */
	{0xad2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(1) */
	{0xad3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(1) */
	{0xad4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(1) */
	{0xad5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(1) */
	{0xad6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(1) */
	{0xad7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(1) */
	{0xad8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(1) */
	{0xad9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(1) */
	{0xada,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(1) */
	{0xadb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(1) */
	{0xadc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(1) */
	{0xadd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(1) */
	{0xade,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(1) */
	{0xadf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(1) */
	{0xae0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(1) */
	{0xae1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(1) */
	{0xae2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(1) */
	{0xae3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(1) */
	{0xae4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(1) */
	{0xae5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(1) */
	{0xae6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(1) */
	{0xae7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(1) */
	{0xaec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(1) */
	{0xaed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(1) */
	{0xaee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(1) */
	{0xb00,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(1) */
	{0xb01,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(1) */
	{0xb02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(1) */
	{0xb03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(1) */
	{0xb04,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(1) */
	{0xb05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(1) */
	{0xb06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(1) */
	{0xb07,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(1) */
	{0xb08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(1) */
	{0xb09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(1) */
	{0xb0a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(1) */
	{0xb0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(1) */
	{0xb0c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(1) */
	{0xb0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(1) */
	{0xb0e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(1) */
	{0xb0f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(1) */
	{0xb10,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(1) */
	{0xb11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(1) */
	{0xb12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(1) */
	{0xb13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(1) */
	{0xb14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(1) */
	{0xb15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(1) */
	{0xb16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(1) */
	{0xb17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(1) */
	{0xb18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(1) */
	{0xb19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(1) */
	{0xb1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(1) */
	{0xb1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(1) */
	{0xb1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(1) */
	{0xb1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(1) */
	{0xb1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(1) */
	{0xb1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(1) */
	{0xb20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(1) */
	{0xb21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(1) */
	{0xb22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(1) */
	{0xb23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(1) */
	{0xb24,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(1) */
	{0xb25,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(1) */
	{0xb26,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(1) */
	{0xb27,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(1) */
	{0xb28,    0x95,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(1) */
	{0xb29,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(1) */
	{0xb2a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(1) */
	{0xb2b,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(1) */
	{0xb2c,    0xd8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(1) */
	{0xb2d,    0x86,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(1) */
	{0xb2e,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(1) */
	{0xb2f,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(1) */
	{0xb30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(1) */
	{0xb31,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(1) */
	{0xb60,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(1) */
	{0xb61,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(1) */
	{0xb62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(1) */
	{0xb63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(1) */
	{0xb64,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(1) */
	{0xb65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(1) */
	{0xb66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(1) */
	{0xb67,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(1) */
	{0xb68,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(1) */
	{0xb69,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(1) */
	{0xb6a,    0xb9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(1) */
	{0xb6b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(1) */
	{0xb6c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(1) */
	{0xb6d,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(1) */
	{0xb6e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(1) */
	{0xb6f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(1) */
	{0xb80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(1) */
	{0xb81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(1) */
	{0xb82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(1) */
	{0xb83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(1) */
	{0xb84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(1) */
	{0xb85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(1) */
	{0xb86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(1) */
	{0xb87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(1) */
	{0xb88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(1) */
	{0xb89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(1) */
	{0xb8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(1) */
	{0xb8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(1) */
	{0xba0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(1) */
	{0xba1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(1) */
	{0xba2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(1) */
	{0xba3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(1) */
	{0xba4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(1) */
	{0xba5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(1) */
	{0xba6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(1) */
	{0xbb0,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(1) */
	{0xbb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(1) */
	{0xbb2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(1) */
	{0xbb3,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(1) */
	{0xbb4,    0xc7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(1) */
	{0xbb5,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(1) */
	{0xbc0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(1) */
	{0xbc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(1) */
	{0xbc2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(1) */
	{0xbc3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(1) */
	{0xbc4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(1) */
	{0xbc5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(1) */
	{0xbc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(1) */
	{0xbc7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(1) */
	{0xbc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(1) */
	{0xbe0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(1) */
	{0xbe1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(1) */
	{0xbe2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(1) */
	{0xbe3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(1) */
	{0xbe4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(1) */
	{0xbe5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(1) */
	{0xbe6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(1) */
	{0xbe7,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(1) */
	{0xbe8,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(1) */
	{0xbe9,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(1) */
	{0xbea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(1) */
	{0xbeb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(1) */
	{0xbec,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(1) */
	{0xbed,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(1) */
	{0xbee,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(1) */
	{0xbef,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(1) */
	{0xc00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(1) */
	{0xc01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(1) */
	{0xc02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(1) */
	{0xc03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(1) */
	{0xc04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(1) */
	{0xc05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(1) */
	{0xc06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(1) */
	{0xc10,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(1) */
	{0xc11,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(1) */
	{0xc12,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(1) */
	{0xc13,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(1) */
	{0xc14,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(1) */
	{0xc15,    0xf9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(1) */
	{0xc16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(1) */
	{0xc17,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(1) */
	{0xc18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(1) */
	{0xc19,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(1) */
	{0xc1a,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(1) */
	{0xc1b,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(1) */
	{0xc1c,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(1) */
	{0xc1d,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(1) */
	{0xc1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(1) */
	{0xc80,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(1) */
	{0xc81,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(1) */
	{0xc82,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(1) */
	{0xc83,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(1) */
	{0xc84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(1) */
	{0xc85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(1) */
	{0xc86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(1) */
	{0xc87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(1) */
	{0xc88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(1) */
	{0xc89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(1) */
	{0xc8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(1) */
	{0xc8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(1) */
	{0xc8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(1) */
	{0xc8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(1) */
	{0xc8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(1) */
	{0xc8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(1) */
	{0xc90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(1) */
	{0xc91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(1) */
	{0xc92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(1) */
	{0xc93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(1) */
	{0xc94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(1) */
	{0xc95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(1) */
	{0xc96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(1) */
	{0xc97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(1) */
	{0xc98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(1) */
	{0xc9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(1) */
	{0xc9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(1) */
	{0xcac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(1) */
	{0xcad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(1) */
	{0xcae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(1) */
	{0xcaf,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(1) */
	{0xcb0,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(1) */
	{0xcb1,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(1) */
	{0xcb2,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(1) */
	{0xcb3,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(1) */
	{0xcb4,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(1) */
	{0xcb5,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(1) */
	{0xcb6,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(1) */
	{0xcb7,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(1) */
	{0xcb8,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(1) */
	{0xcb9,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(1) */
	{0xcba,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(1) */
	{0xcbb,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(1) */
	{0xcbc,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(1) */
	{0xcbd,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(1) */
	{0xcbe,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(1) */
	{0xcbf,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(1) */
	{0xcc0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(1) */
	{0xcc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(1) */
	{0xcc2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(1) */
	{0xcc3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(1) */
	{0xcc4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(1) */
	{0xcc5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(1) */
	{0xcc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(1) */
	{0xcc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(1) */
	{0xcc9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(1) */
	{0xcca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(1) */
	{0xcf0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(1) */
	{0xd00,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(1) */
	{0xd01,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(1) */
	{0xd02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(1) */
	{0xd03,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(1) */
	{0xd04,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(1) */
	{0xd05,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(1) */
	{0xd06,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(1) */
	{0xd07,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(1) */
	{0xd08,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(1) */
	{0xd09,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(1) */
	{0xd0a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(1) */
	{0xd0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(1) */
	{0xd10,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(1) */
	{0xd11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(1) */
	{0xd12,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(1) */
	{0xd13,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(1) */
	{0xd14,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(1) */
	{0xd18,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(1) */
	{0xd19,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(1) */
	{0xd1a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(1) */
	{0xd1b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(1) */
	{0xd1c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(1) */
	{0xd1d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(1) */
	{0xd20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(1) */
	{0xd21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(1) */
	{0xd22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(1) */
	{0xd80,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(1) */
	{0xd81,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(1) */
	{0xd82,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(1) */
	{0xd83,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(1) */
	{0xd84,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(1) */
	{0xd85,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(1) */
	{0xd86,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(1) */
	{0xd87,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(1) */
	{0xd88,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(1) */
	{0xd89,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(1) */
	{0xd8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(1) */
	{0xd8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(1) */
	{0xd8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(1) */
	{0xd8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(1) */
	{0xe00,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(1) */
	{0xe01,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(1) */
	{0xe02,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(1) */
	{0xe03,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(1) */
	{0xe04,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(1) */
	{0xe05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(1) */
	{0xe06,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(1) */
	{0xe07,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(1) */
	{0xe08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(1) */
	{0xe09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(1) */
	{0xe0a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(1) */
	{0xe0b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(1) */
	{0xe0c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(1) */
	{0xe0d,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(1) */
	{0xe0e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(1) */
	{0xe0f,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(1) */
	{0xe10,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(1) */
	{0xe11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(1) */
	{0xe12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(1) */
	{0xe13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(1) */
	{0xe14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(1) */
	{0xe15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(1) */
	{0xe16,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(1) */
	{0xe17,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(1) */
	{0xe18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(1) */
	{0xe19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(1) */
	{0xe1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(1) */
	{0xe1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(1) */
	{0xe1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(1) */
	{0xe1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(1) */
	{0xe1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(1) */
	{0xe1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(1) */
	{0xe20,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(1) */
	{0xe21,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(1) */
	{0xe22,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(1) */
	{0xe24,    0x63,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(1) */
	{0xe25,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(1) */
	{0xe26,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(1) */
	{0xe27,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(1) */
	{0xe28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(1) */
	{0xe29,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(1) */
	{0xe2a,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(1) */
	{0xe30,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(1) */
	{0xe31,    0x89,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(1) */
	{0xe32,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(1) */
	{0xe33,    0xf1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(1) */
	{0xe34,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(1) */
	{0xe35,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(1) */
	{0xe36,    0x90,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(1) */
	{0xe37,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(1) */
	{0xe38,    0x4f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(1) */
	{0xe39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(1) */
	{0xe3a,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(1) */
	{0xe3b,    0x66,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(1) */
	{0xe3c,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(1) */
	{0xe3d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(1) */
	{0xe3e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(1) */
	{0xe3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(1) */
	{0xe40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(1) */
	{0xe41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(1) */
	{0xe42,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(1) */
	{0xe43,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(1) */
	{0xe44,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(1) */
	{0xe45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(1) */
	{0xe46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(1) */
	{0xe47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(1) */
	{0xe50,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(1) */
	{0xe51,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(1) */
	{0xe52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(1) */
	{0xe53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(1) */
	{0xe54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(1) */
	{0xe60,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(1) */
	{0xe61,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(1) */
	{0xe62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(1) */
	{0xe63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(1) */
	{0xe64,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(1) */
	{0xe65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(1) */
	{0xe66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(1) */
	{0xe67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(1) */
	{0xe70,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(1) */
	{0xe71,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(1) */
	{0xe72,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(1) */
	{0xe73,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(1) */
	{0xe74,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(1) */
	{0xe75,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(1) */
	{0xe76,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(1) */
	{0xe77,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(1) */
	{0xe80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(1) */
	{0xe81,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(1) */
	{0xe82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(1) */
	{0xe83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(1) */
	{0xe84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(1) */
	{0xe85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(1) */
	{0xe86,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(1) */
	{0xe87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(1) */
	{0xe88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(1) */
	{0xe89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(1) */
	{0xe8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(1) */
	{0xe8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(1) */
	{0xe8c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(1) */
	{0xe8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(1) */
	{0xe8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(1) */
	{0xe90,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(1) */
	{0xe91,    0xa6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(1) */
	{0xe92,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(1) */
	{0xe93,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(1) */
	{0xe94,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(1) */
	{0xe95,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(1) */
	{0xec0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(1) */
	{0xec1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(1) */
	{0xec2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(1) */
	{0xec3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(1) */
	{0xec4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(1) */
	{0xec5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(1) */
	{0xec6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(1) */
	{0xec7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(1) */
	{0xec8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(1) */
	{0xec9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(1) */
	{0xeca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(1) */
	{0xecb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(1) */
	{0xecc,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(1) */
	{0xed0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(1) */
	{0xed1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(1) */
	{0xed2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(1) */
	{0xed3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(1) */
	{0xed8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(1) */
	{0xed9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(1) */
	{0xeda,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(1) */
	{0xf00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(1) */
	{0xf01,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(1) */
	{0xf02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(1) */
	{0xf03,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(1) */
	{0xf04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(1) */
	{0xf05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(1) */
	{0xf06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(1) */
	{0xf07,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(1) */
	{0xf08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(1) */
	{0xf09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(1) */
	{0xf0c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(1) */
	{0xf0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(1) */
	{0xf10,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(1) */
	{0xf11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(1) */
	{0xf12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(1) */
	{0xf13,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(1) */
	{0xf14,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(1) */
	{0xf15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(1) */
	{0xf16,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(1) */
	{0xf17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(1) */
	{0xf18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(1) */
	{0xf20,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(1) */
	{0xf21,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(1) */
	{0xf22,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(1) */
	{0xf23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(1) */
	{0xf24,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(1) */
	{0xf25,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(1) */
	{0xf26,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(1) */
	{0xf27,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(1) */
	{0xf28,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(1) */
	{0xf29,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(1) */
	{0xf2a,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(1) */
	{0xf30,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(1) */
	{0xf31,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(1) */
	{0xf32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(1) */
	{0xf34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(1) */
	{0xf35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(1) */
	{0xf36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(1) */
	{0xf37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(1) */
	{0xf3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(1) */
	{0xf80,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(1) */
	{0xf81,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(1) */
	{0xf82,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(1) */
	{0xf83,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(1) */
	{0xf84,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(1) */
	{0xf85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(1) */
	{0xf88,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(1) */
	{0xf89,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(1) */
	{0xf8a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(1) */
	{0xf8b,    0xf1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(1) */
	{0xf8c,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(1) */
	{0xf8d,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(1) */
	{0xf90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(1) */
	{0xf91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(1) */
	{0xf92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(1) */
	{0xf93,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(1) */
	{0xf94,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(1) */
	{0xf95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(1) */
	{0xf96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(1) */
	{0xf97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(1) */
	{0xf98,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(1) */
	{0xf99,    0xd8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(1) */
	{0xf9a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(1) */
	{0xf9b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(1) */
	{0xf9c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(1) */
	{0xf9d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(1) */
	{0xfa0,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(1) */
	{0xfa1,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(1) */
	{0xfa2,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(1) */
	{0xfa3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(1) */
	{0xfa4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(1) */
	{0xfa5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(1) */
	{0xfa6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(1) */
	{0xfa7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(1) */
	{0xfae,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(1) */
	{0xfaf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(1) */
	{0xfb0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(1) */
	{0xfb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(1) */
	{0xfb2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(1) */
	{0xfb3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(1) */
	{0xfb4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(1) */
	{0xfb5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(1) */
	{0xfb6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(1) */
	{0xfb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(1) */
	{0xfb8,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(1) */
	{0xfb9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(1) */
	{0xfba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(1) */
	{0xfbb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(1) */
	{0xfbc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(1) */
	{0xfbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(1) */
	{0xfbe,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(1) */
	{0xfbf,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(1) */
	{0x1000,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(2) */
	{0x1001,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(2) */
	{0x1010,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(2) */
	{0x1011,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(2) */
	{0x1012,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(2) */
	{0x1013,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(2) */
	{0x1014,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(2) */
	{0x1015,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(2) */
	{0x1020,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(2) */
	{0x1021,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(2) */
	{0x1022,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(2) */
	{0x1100,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(2) */
	{0x1101,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(2) */
	{0x1102,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(2) */
	{0x1103,    0xb3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(2) */
	{0x1110,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(2) */
	{0x1112,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(2) */
	{0x1113,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(2) */
	{0x1116,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(2) */
	{0x1117,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(2) */
	{0x1118,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(2) */
	{0x1119,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(2) */
	{0x111a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(2) */
	{0x111b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(2) */
	{0x111c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(2) */
	{0x111d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(2) */
	{0x1120,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(2) */
	{0x1122,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(2) */
	{0x1123,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(2) */
	{0x1124,    0x1C,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(2) */
	{0x1125,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(2) */
	{0x1126,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(2) */
	{0x1127,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(2) */
	{0x1128,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(2) */
	{0x1129,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(2) */
	{0x112a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(2) */
	{0x112b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(2) */
	{0x1130,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(2) */
	{0x1131,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(2) */
	{0x1132,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(2) */
	{0x1133,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(2) */
	{0x1134,    0xec,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(2) */
	{0x1135,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(2) */
	{0x1136,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(2) */
	{0x1137,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(2) */
	{0x1138,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(2) */
	{0x1139,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(2) */
	{0x113a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(2) */
	{0x1140,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(2) */
	{0x1141,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(2) */
	{0x1142,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(2) */
	{0x1143,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(2) */
	{0x1144,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(2) */
	{0x1148,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(2) */
	{0x1149,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(2) */
	{0x114a,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(2) */
	{0x1150,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(2) */
	{0x1151,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(2) */
	{0x1152,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(2) */
	{0x1153,    0xa1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(2) */
	{0x1154,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(2) */
	{0x1155,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(2) */
	{0x1156,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(2) */
	{0x1157,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(2) */
	{0x1158,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(2) */
	{0x1159,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(2) */
	{0x115a,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(2) */
	{0x115b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(2) */
	{0x115c,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(2) */
	{0x115d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(2) */
	{0x115e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(2) */
	{0x1170,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(2) */
	{0x1171,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(2) */
	{0x1172,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(2) */
	{0x1173,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(2) */
	{0x1174,    0x4b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(2) */
	{0x1175,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(2) */
	{0x1180,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(2) */
	{0x1181,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(2) */
	{0x1182,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(2) */
	{0x1183,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(2) */
	{0x1184,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(2) */
	{0x1185,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(2) */
	{0x1186,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(2) */
	{0x1187,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(2) */
	{0x1188,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(2) */
	{0x1190,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(2) */
	{0x1191,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(2) */
	{0x1192,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(2) */
	{0x1193,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(2) */
	{0x1194,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(2) */
	{0x1195,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(2) */
	{0x1196,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(2) */
	{0x1197,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(2) */
	{0x1198,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(2) */
	{0x1199,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(2) */
	{0x119a,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(2) */
	{0x119b,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(2) */
	{0x119c,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(2) */
	{0x119d,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(2) */
	{0x119e,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(2) */
	{0x119f,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(2) */
	{0x11a0,    0x72,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(2) */
	{0x11a1,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(2) */
	{0x11a2,    0x76,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(2) */
	{0x11a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(2) */
	{0x11a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(2) */
	{0x11a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(2) */
	{0x11a6,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(2) */
	{0x11a7,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(2) */
	{0x11a8,    0x9e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(2) */
	{0x11b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(2) */
	{0x11b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(2) */
	{0x11b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(2) */
	{0x11b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(2) */
	{0x11b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(2) */
	{0x11b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(2) */
	{0x11b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(2) */
	{0x11b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(2) */
	{0x11b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(2) */
	{0x11b9,    0xf9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(2) */
	{0x11ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(2) */
	{0x11bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(2) */
	{0x11bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(2) */
	{0x11bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(2) */
	{0x11be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(2) */
	{0x11bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(2) */
	{0x11c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(2) */
	{0x11c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(2) */
	{0x11c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(2) */
	{0x11c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(2) */
	{0x11c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(2) */
	{0x11c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(2) */
	{0x11c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(2) */
	{0x11c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(2) */
	{0x11c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(2) */
	{0x11c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(2) */
	{0x11ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(2) */
	{0x11cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(2) */
	{0x11cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(2) */
	{0x11cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(2) */
	{0x11ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(2) */
	{0x11cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(2) */
	{0x11d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(2) */
	{0x11d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(2) */
	{0x11d2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(2) */
	{0x11d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(2) */
	{0x11d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(2) */
	{0x11d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(2) */
	{0x11d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(2) */
	{0x11d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(2) */
	{0x11d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(2) */
	{0x11d9,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(2) */
	{0x11da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(2) */
	{0x11db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(2) */
	{0x11dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(2) */
	{0x11dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(2) */
	{0x11de,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(2) */
	{0x11e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(2) */
	{0x11e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(2) */
	{0x11e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(2) */
	{0x11e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(2) */
	{0x11e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(2) */
	{0x11e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(2) */
	{0x11e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(2) */
	{0x11e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(2) */
	{0x11e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(2) */
	{0x11e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(2) */
	{0x11ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(2) */
	{0x11eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(2) */
	{0x11ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(2) */
	{0x11ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(2) */
	{0x11f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(2) */
	{0x11f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(2) */
	{0x11f2,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(2) */
	{0x11f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(2) */
	{0x11f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(2) */
	{0x11f5,    0xe8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(2) */
	{0x11f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(2) */
	{0x11f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(2) */
	{0x11f8,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(2) */
	{0x11fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(2) */
	{0x11fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(2) */
	{0x11fe,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(2) */
	{0x11ff,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(2) */
	{0x1200,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(2) */
	{0x1201,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(2) */
	{0x1202,    0x3c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(2) */
	{0x1203,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(2) */
	{0x1204,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(2) */
	{0x1205,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(2) */
	{0x1206,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(2) */
	{0x1207,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(2) */
	{0x1208,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(2) */
	{0x1210,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(2) */
	{0x1211,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(2) */
	{0x1212,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(2) */
	{0x1213,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(2) */
	{0x1214,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(2) */
	{0x1215,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(2) */
	{0x1216,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(2) */
	{0x1217,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(2) */
	{0x1218,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(2) */
	{0x1219,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(2) */
	{0x121a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(2) */
	{0x121b,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(2) */
	{0x121c,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(2) */
	{0x1220,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(2) */
	{0x1221,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(2) */
	{0x1222,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(2) */
	{0x1223,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(2) */
	{0x1224,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(2) */
	{0x1225,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(2) */
	{0x1226,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(2) */
	{0x1227,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(2) */
	{0x1228,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(2) */
	{0x1229,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(2) */
	{0x122a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(2) */
	{0x122b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(2) */
	{0x122c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(2) */
	{0x122d,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(2) */
	{0x122e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(2) */
	{0x122f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(2) */
	{0x1230,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(2) */
	{0x1231,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(2) */
	{0x1232,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(2) */
	{0x1233,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(2) */
	{0x1234,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(2) */
	{0x1235,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(2) */
	{0x1236,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(2) */
	{0x1237,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(2) */
	{0x1238,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(2) */
	{0x1239,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(2) */
	{0x1240,    0x31,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(2) */
	{0x1241,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(2) */
	{0x1242,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(2) */
	{0x1243,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(2) */
	{0x1244,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(2) */
	{0x1245,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(2) */
	{0x1246,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(2) */
	{0x1247,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(2) */
	{0x1248,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(2) */
	{0x1249,    0x63,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(2) */
	{0x124a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(2) */
	{0x124b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(2) */
	{0x124c,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(2) */
	{0x124d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(2) */
	{0x124e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(2) */
	{0x124f,    0xdc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(2) */
	{0x1250,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(2) */
	{0x1251,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(2) */
	{0x1252,    0xc5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(2) */
	{0x1253,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(2) */
	{0x1254,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(2) */
	{0x1255,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(2) */
	{0x1256,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(2) */
	{0x1257,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(2) */
	{0x1258,    0x12,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(2) */
	{0x1259,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(2) */
	{0x125a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(2) */
	{0x125b,    0x64,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(2) */
	{0x125c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(2) */
	{0x125d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(2) */
	{0x125e,    0xa3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(2) */
	{0x125f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(2) */
	{0x1260,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(2) */
	{0x1261,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(2) */
	{0x1262,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(2) */
	{0x1263,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(2) */
	{0x1264,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(2) */
	{0x1265,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(2) */
	{0x1268,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(2) */
	{0x1269,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(2) */
	{0x126a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(2) */
	{0x126b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(2) */
	{0x126c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(2) */
	{0x126d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(2) */
	{0x126e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(2) */
	{0x126f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(2) */
	{0x1270,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(2) */
	{0x1271,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(2) */
	{0x1272,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(2) */
	{0x1273,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(2) */
	{0x1274,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(2) */
	{0x1275,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(2) */
	{0x1276,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(2) */
	{0x1277,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(2) */
	{0x1284,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(2) */
	{0x1285,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(2) */
	{0x1286,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(2) */
	{0x1287,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(2) */
	{0x1288,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(2) */
	{0x1289,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(2) */
	{0x128a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(2) */
	{0x128b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(2) */
	{0x1298,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(2) */
	{0x1299,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(2) */
	{0x129a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(2) */
	{0x12a0,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(2) */
	{0x12a1,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(2) */
	{0x12a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(2) */
	{0x12a3,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(2) */
	{0x12a4,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(2) */
	{0x12a5,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(2) */
	{0x12a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(2) */
	{0x12a7,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(2) */
	{0x12a8,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(2) */
	{0x12a9,    0xe3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(2) */
	{0x12aa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(2) */
	{0x12ab,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(2) */
	{0x12ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(2) */
	{0x12ad,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(2) */
	{0x12ae,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(2) */
	{0x12af,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(2) */
	{0x12c0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(2) */
	{0x12c1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(2) */
	{0x12c2,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(2) */
	{0x12c3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(2) */
	{0x12c4,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(2) */
	{0x12c5,    0xd5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(2) */
	{0x12c6,    0x4e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(2) */
	{0x12d0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(2) */
	{0x12d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(2) */
	{0x12d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(2) */
	{0x12d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(2) */
	{0x12d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(2) */
	{0x12d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(2) */
	{0x12d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(2) */
	{0x12d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(2) */
	{0x12d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(2) */
	{0x12d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(2) */
	{0x12da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(2) */
	{0x12db,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(2) */
	{0x12dc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(2) */
	{0x12dd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(2) */
	{0x12de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(2) */
	{0x12df,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(2) */
	{0x12e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(2) */
	{0x12e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(2) */
	{0x12e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(2) */
	{0x12e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(2) */
	{0x12e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(2) */
	{0x12e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(2) */
	{0x12e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(2) */
	{0x12e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(2) */
	{0x12ec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(2) */
	{0x12ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(2) */
	{0x12ee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(2) */
	{0x1300,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(2) */
	{0x1301,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(2) */
	{0x1302,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(2) */
	{0x1303,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(2) */
	{0x1304,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(2) */
	{0x1305,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(2) */
	{0x1306,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(2) */
	{0x1307,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(2) */
	{0x1308,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(2) */
	{0x1309,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(2) */
	{0x130a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(2) */
	{0x130b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(2) */
	{0x130c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(2) */
	{0x130d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(2) */
	{0x130e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(2) */
	{0x130f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(2) */
	{0x1310,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(2) */
	{0x1311,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(2) */
	{0x1312,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(2) */
	{0x1313,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(2) */
	{0x1314,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(2) */
	{0x1315,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(2) */
	{0x1316,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(2) */
	{0x1317,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(2) */
	{0x1318,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(2) */
	{0x1319,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(2) */
	{0x131a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(2) */
	{0x131b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(2) */
	{0x131c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(2) */
	{0x131d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(2) */
	{0x131e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(2) */
	{0x131f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(2) */
	{0x1320,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(2) */
	{0x1321,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(2) */
	{0x1322,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(2) */
	{0x1323,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(2) */
	{0x1324,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(2) */
	{0x1325,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(2) */
	{0x1326,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(2) */
	{0x1327,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(2) */
	{0x1328,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(2) */
	{0x1329,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(2) */
	{0x132a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(2) */
	{0x132b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(2) */
	{0x132c,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(2) */
	{0x132d,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(2) */
	{0x132e,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(2) */
	{0x132f,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(2) */
	{0x1330,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(2) */
	{0x1331,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(2) */
	{0x1360,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(2) */
	{0x1361,    0xad,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(2) */
	{0x1362,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(2) */
	{0x1363,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(2) */
	{0x1364,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(2) */
	{0x1365,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(2) */
	{0x1366,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(2) */
	{0x1367,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(2) */
	{0x1368,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(2) */
	{0x1369,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(2) */
	{0x136a,    0x74,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(2) */
	{0x136b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(2) */
	{0x136c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(2) */
	{0x136d,    0xbb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(2) */
	{0x136e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(2) */
	{0x136f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(2) */
	{0x1380,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(2) */
	{0x1381,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(2) */
	{0x1382,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(2) */
	{0x1383,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(2) */
	{0x1384,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(2) */
	{0x1385,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(2) */
	{0x1386,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(2) */
	{0x1387,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(2) */
	{0x1388,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(2) */
	{0x1389,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(2) */
	{0x138a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(2) */
	{0x138b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(2) */
	{0x13a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(2) */
	{0x13a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(2) */
	{0x13a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(2) */
	{0x13a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(2) */
	{0x13a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(2) */
	{0x13a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(2) */
	{0x13a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(2) */
	{0x13b0,    0x66,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(2) */
	{0x13b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(2) */
	{0x13b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(2) */
	{0x13b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(2) */
	{0x13b4,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(2) */
	{0x13b5,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(2) */
	{0x13c0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(2) */
	{0x13c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(2) */
	{0x13c2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(2) */
	{0x13c3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(2) */
	{0x13c4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(2) */
	{0x13c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(2) */
	{0x13c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(2) */
	{0x13c7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(2) */
	{0x13c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(2) */
	{0x13e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(2) */
	{0x13e1,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(2) */
	{0x13e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(2) */
	{0x13e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(2) */
	{0x13e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(2) */
	{0x13e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(2) */
	{0x13e6,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(2) */
	{0x13e7,    0x89,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(2) */
	{0x13e8,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(2) */
	{0x13e9,    0x90,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(2) */
	{0x13ea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(2) */
	{0x13eb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(2) */
	{0x13ec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(2) */
	{0x13ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(2) */
	{0x13ee,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(2) */
	{0x13ef,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(2) */
	{0x1400,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(2) */
	{0x1401,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(2) */
	{0x1402,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(2) */
	{0x1403,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(2) */
	{0x1404,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(2) */
	{0x1405,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(2) */
	{0x1406,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(2) */
	{0x1410,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(2) */
	{0x1411,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(2) */
	{0x1412,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(2) */
	{0x1413,    0xad,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(2) */
	{0x1414,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(2) */
	{0x1415,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(2) */
	{0x1416,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(2) */
	{0x1417,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(2) */
	{0x1418,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(2) */
	{0x1419,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(2) */
	{0x141a,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(2) */
	{0x141b,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(2) */
	{0x141c,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(2) */
	{0x141d,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(2) */
	{0x141e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(2) */
	{0x1480,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(2) */
	{0x1481,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(2) */
	{0x1482,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(2) */
	{0x1483,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(2) */
	{0x1484,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(2) */
	{0x1485,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(2) */
	{0x1486,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(2) */
	{0x1487,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(2) */
	{0x1488,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(2) */
	{0x1489,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(2) */
	{0x148a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(2) */
	{0x148b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(2) */
	{0x148c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(2) */
	{0x148d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(2) */
	{0x148e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(2) */
	{0x148f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(2) */
	{0x1490,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(2) */
	{0x1491,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(2) */
	{0x1492,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(2) */
	{0x1493,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(2) */
	{0x1494,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(2) */
	{0x1495,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(2) */
	{0x1496,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(2) */
	{0x1497,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(2) */
	{0x1498,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(2) */
	{0x149a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(2) */
	{0x149b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(2) */
	{0x14ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(2) */
	{0x14ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(2) */
	{0x14ae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(2) */
	{0x14af,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(2) */
	{0x14b0,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(2) */
	{0x14b1,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(2) */
	{0x14b2,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(2) */
	{0x14b3,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(2) */
	{0x14b4,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(2) */
	{0x14b5,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(2) */
	{0x14b6,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(2) */
	{0x14b7,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(2) */
	{0x14b8,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(2) */
	{0x14b9,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(2) */
	{0x14ba,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(2) */
	{0x14bb,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(2) */
	{0x14bc,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(2) */
	{0x14bd,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(2) */
	{0x14be,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(2) */
	{0x14bf,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(2) */
	{0x14c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(2) */
	{0x14c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(2) */
	{0x14c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(2) */
	{0x14c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(2) */
	{0x14c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(2) */
	{0x14c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(2) */
	{0x14c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(2) */
	{0x14c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(2) */
	{0x14c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(2) */
	{0x14ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(2) */
	{0x14f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(2) */
	{0x1500,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(2) */
	{0x1501,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(2) */
	{0x1502,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(2) */
	{0x1503,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(2) */
	{0x1504,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(2) */
	{0x1505,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(2) */
	{0x1506,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(2) */
	{0x1507,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(2) */
	{0x1508,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(2) */
	{0x1509,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(2) */
	{0x150a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(2) */
	{0x150b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(2) */
	{0x1510,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(2) */
	{0x1511,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(2) */
	{0x1512,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(2) */
	{0x1513,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(2) */
	{0x1514,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(2) */
	{0x1518,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(2) */
	{0x1519,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(2) */
	{0x151a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(2) */
	{0x151b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(2) */
	{0x151c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(2) */
	{0x151d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(2) */
	{0x1520,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(2) */
	{0x1521,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(2) */
	{0x1522,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(2) */
	{0x1580,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(2) */
	{0x1581,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(2) */
	{0x1582,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(2) */
	{0x1583,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(2) */
	{0x1584,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(2) */
	{0x1585,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(2) */
	{0x1586,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(2) */
	{0x1587,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(2) */
	{0x1588,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(2) */
	{0x1589,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(2) */
	{0x158a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(2) */
	{0x158d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(2) */
	{0x158e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(2) */
	{0x158f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(2) */
	{0x1600,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(2) */
	{0x1601,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(2) */
	{0x1602,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(2) */
	{0x1603,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(2) */
	{0x1604,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(2) */
	{0x1605,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(2) */
	{0x1606,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(2) */
	{0x1607,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(2) */
	{0x1608,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(2) */
	{0x1609,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(2) */
	{0x160a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(2) */
	{0x160b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(2) */
	{0x160c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(2) */
	{0x160d,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(2) */
	{0x160e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(2) */
	{0x160f,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(2) */
	{0x1610,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(2) */
	{0x1611,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(2) */
	{0x1612,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(2) */
	{0x1613,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(2) */
	{0x1614,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(2) */
	{0x1615,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(2) */
	{0x1616,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(2) */
	{0x1617,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(2) */
	{0x1618,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(2) */
	{0x1619,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(2) */
	{0x161a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(2) */
	{0x161b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(2) */
	{0x161c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(2) */
	{0x161d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(2) */
	{0x161e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(2) */
	{0x161f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(2) */
	{0x1620,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(2) */
	{0x1621,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(2) */
	{0x1622,    0x2d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(2) */
	{0x1624,    0x74,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(2) */
	{0x1625,    0xbd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(2) */
	{0x1626,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(2) */
	{0x1627,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(2) */
	{0x1628,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(2) */
	{0x1629,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(2) */
	{0x162a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(2) */
	{0x1630,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(2) */
	{0x1631,    0x6c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(2) */
	{0x1632,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(2) */
	{0x1633,    0xf1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(2) */
	{0x1634,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(2) */
	{0x1635,    0x5c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(2) */
	{0x1636,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(2) */
	{0x1637,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(2) */
	{0x1638,    0xb4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(2) */
	{0x1639,    0x63,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(2) */
	{0x163a,    0x39,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(2) */
	{0x163b,    0xef,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(2) */
	{0x163c,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(2) */
	{0x163d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(2) */
	{0x163e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(2) */
	{0x163f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(2) */
	{0x1640,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(2) */
	{0x1641,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(2) */
	{0x1642,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(2) */
	{0x1643,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(2) */
	{0x1644,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(2) */
	{0x1645,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(2) */
	{0x1646,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(2) */
	{0x1647,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(2) */
	{0x1650,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(2) */
	{0x1651,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(2) */
	{0x1652,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(2) */
	{0x1653,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(2) */
	{0x1654,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(2) */
	{0x1660,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(2) */
	{0x1661,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(2) */
	{0x1662,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(2) */
	{0x1663,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(2) */
	{0x1664,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(2) */
	{0x1665,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(2) */
	{0x1666,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(2) */
	{0x1667,    0x9a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(2) */
	{0x1670,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(2) */
	{0x1671,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(2) */
	{0x1672,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(2) */
	{0x1673,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(2) */
	{0x1674,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(2) */
	{0x1675,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(2) */
	{0x1676,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(2) */
	{0x1677,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(2) */
	{0x1680,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(2) */
	{0x1681,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(2) */
	{0x1682,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(2) */
	{0x1683,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(2) */
	{0x1684,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(2) */
	{0x1685,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(2) */
	{0x1686,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(2) */
	{0x1687,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(2) */
	{0x1688,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(2) */
	{0x1689,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(2) */
	{0x168a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(2) */
	{0x168b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(2) */
	{0x168c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(2) */
	{0x168d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(2) */
	{0x168f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(2) */
	{0x1690,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(2) */
	{0x1691,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(2) */
	{0x1692,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(2) */
	{0x1693,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(2) */
	{0x1694,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(2) */
	{0x1695,    0xeb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(2) */
	{0x16c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(2) */
	{0x16c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(2) */
	{0x16c2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(2) */
	{0x16c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(2) */
	{0x16c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(2) */
	{0x16c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(2) */
	{0x16c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(2) */
	{0x16c7,    0x6b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(2) */
	{0x16c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(2) */
	{0x16c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(2) */
	{0x16ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(2) */
	{0x16cb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(2) */
	{0x16cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(2) */
	{0x16d0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(2) */
	{0x16d1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(2) */
	{0x16d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(2) */
	{0x16d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(2) */
	{0x16d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(2) */
	{0x16d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(2) */
	{0x16da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(2) */
	{0x1700,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(2) */
	{0x1701,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(2) */
	{0x1702,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(2) */
	{0x1703,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(2) */
	{0x1704,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(2) */
	{0x1705,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(2) */
	{0x1706,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(2) */
	{0x1707,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(2) */
	{0x1708,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(2) */
	{0x1709,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(2) */
	{0x170c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(2) */
	{0x170d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(2) */
	{0x1710,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(2) */
	{0x1711,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(2) */
	{0x1712,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(2) */
	{0x1713,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(2) */
	{0x1714,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(2) */
	{0x1715,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(2) */
	{0x1716,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(2) */
	{0x1717,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(2) */
	{0x1718,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(2) */
	{0x1720,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(2) */
	{0x1721,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(2) */
	{0x1722,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(2) */
	{0x1723,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(2) */
	{0x1724,    0xbc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(2) */
	{0x1725,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(2) */
	{0x1726,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(2) */
	{0x1727,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(2) */
	{0x1728,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(2) */
	{0x1729,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(2) */
	{0x172a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(2) */
	{0x1730,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(2) */
	{0x1731,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(2) */
	{0x1732,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(2) */
	{0x1734,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(2) */
	{0x1735,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(2) */
	{0x1736,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(2) */
	{0x1737,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(2) */
	{0x173f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(2) */
	{0x1780,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(2) */
	{0x1781,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(2) */
	{0x1782,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(2) */
	{0x1783,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(2) */
	{0x1784,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(2) */
	{0x1785,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(2) */
	{0x1788,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(2) */
	{0x1789,    0xfb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(2) */
	{0x178a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(2) */
	{0x178b,    0x92,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(2) */
	{0x178c,    0x89,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(2) */
	{0x178d,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(2) */
	{0x1790,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(2) */
	{0x1791,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(2) */
	{0x1792,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(2) */
	{0x1793,    0x8a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(2) */
	{0x1794,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(2) */
	{0x1795,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(2) */
	{0x1796,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(2) */
	{0x1797,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(2) */
	{0x1798,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(2) */
	{0x1799,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(2) */
	{0x179a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(2) */
	{0x179b,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(2) */
	{0x179c,    0xa6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(2) */
	{0x179d,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(2) */
	{0x17a0,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(2) */
	{0x17a1,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(2) */
	{0x17a2,    0x74,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(2) */
	{0x17a3,    0xc4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(2) */
	{0x17a4,    0x37,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(2) */
	{0x17a5,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(2) */
	{0x17a6,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(2) */
	{0x17a7,    0xe5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(2) */
	{0x17ae,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(2) */
	{0x17af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(2) */
	{0x17b0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(2) */
	{0x17b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(2) */
	{0x17b2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(2) */
	{0x17b3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(2) */
	{0x17b4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(2) */
	{0x17b5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(2) */
	{0x17b6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(2) */
	{0x17b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(2) */
	{0x17b8,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(2) */
	{0x17b9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(2) */
	{0x17ba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(2) */
	{0x17bb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(2) */
	{0x17bc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(2) */
	{0x17bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(2) */
	{0x17be,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(2) */
	{0x17bf,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(2) */
	{0x1800,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(3) */
	{0x1801,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(3) */
	{0x1810,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(3) */
	{0x1811,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(3) */
	{0x1812,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(3) */
	{0x1813,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(3) */
	{0x1814,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(3) */
	{0x1815,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(3) */
	{0x1820,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(3) */
	{0x1821,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(3) */
	{0x1822,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(3) */
	{0x1840,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_FRESGEN(2) */
	{0x1850,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_TBUSSEL(2) */
	{0x1851,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_BYPASSEN(2) */
	{0x1899,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG1(2) */
	{0x189a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG0(2) */
	{0x18a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENERAL(2) */
	{0x18a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENCFG2(2) */
	{0x18a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGSTATUS(2) */
	{0x18a3,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSRSCFG(2) */
	{0x18a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSTTSRS(2) */
	{0x1900,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(3) */
	{0x1901,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(3) */
	{0x1902,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(3) */
	{0x1903,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(3) */
	{0x1910,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(3) */
	{0x1912,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(3) */
	{0x1913,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(3) */
	{0x1916,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(3) */
	{0x1917,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(3) */
	{0x1918,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(3) */
	{0x1919,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(3) */
	{0x191a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(3) */
	{0x191b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(3) */
	{0x191c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(3) */
	{0x191d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(3) */
	{0x1920,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(3) */
	{0x1922,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(3) */
	{0x1923,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(3) */
	{0x1924,    0x1C,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(3) */
	{0x1925,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(3) */
	{0x1926,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(3) */
	{0x1927,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(3) */
	{0x1928,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(3) */
	{0x1929,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(3) */
	{0x192a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(3) */
	{0x192b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(3) */
	{0x1930,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(3) */
	{0x1931,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(3) */
	{0x1932,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(3) */
	{0x1933,    0xcf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(3) */
	{0x1934,    0xec,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(3) */
	{0x1935,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(3) */
	{0x1936,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(3) */
	{0x1937,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(3) */
	{0x1938,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(3) */
	{0x1939,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(3) */
	{0x193a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(3) */
	{0x1940,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(3) */
	{0x1941,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(3) */
	{0x1942,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(3) */
	{0x1943,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(3) */
	{0x1944,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(3) */
	{0x1948,    0x5c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(3) */
	{0x1949,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(3) */
	{0x194a,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(3) */
	{0x1950,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(3) */
	{0x1951,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(3) */
	{0x1952,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(3) */
	{0x1953,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(3) */
	{0x1954,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(3) */
	{0x1955,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(3) */
	{0x1956,    0x86,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(3) */
	{0x1957,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(3) */
	{0x1958,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(3) */
	{0x1959,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(3) */
	{0x195a,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(3) */
	{0x195b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(3) */
	{0x195c,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(3) */
	{0x195d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(3) */
	{0x195e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(3) */
	{0x1970,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(3) */
	{0x1971,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(3) */
	{0x1972,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(3) */
	{0x1973,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(3) */
	{0x1974,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(3) */
	{0x1975,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(3) */
	{0x1980,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(3) */
	{0x1981,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(3) */
	{0x1982,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(3) */
	{0x1983,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(3) */
	{0x1984,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(3) */
	{0x1985,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(3) */
	{0x1986,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(3) */
	{0x1987,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(3) */
	{0x1988,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(3) */
	{0x1990,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(3) */
	{0x1991,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(3) */
	{0x1992,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(3) */
	{0x1993,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(3) */
	{0x1994,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(3) */
	{0x1995,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(3) */
	{0x1996,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(3) */
	{0x1997,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(3) */
	{0x1998,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(3) */
	{0x1999,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(3) */
	{0x199a,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(3) */
	{0x199b,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(3) */
	{0x199c,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(3) */
	{0x199d,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(3) */
	{0x199e,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(3) */
	{0x199f,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(3) */
	{0x19a0,    0x6c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(3) */
	{0x19a1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(3) */
	{0x19a2,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(3) */
	{0x19a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(3) */
	{0x19a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(3) */
	{0x19a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(3) */
	{0x19a6,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(3) */
	{0x19a7,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(3) */
	{0x19a8,    0x9e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(3) */
	{0x19b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(3) */
	{0x19b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(3) */
	{0x19b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(3) */
	{0x19b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(3) */
	{0x19b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(3) */
	{0x19b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(3) */
	{0x19b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(3) */
	{0x19b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(3) */
	{0x19b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(3) */
	{0x19b9,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(3) */
	{0x19ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(3) */
	{0x19bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(3) */
	{0x19bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(3) */
	{0x19bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(3) */
	{0x19be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(3) */
	{0x19bf,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(3) */
	{0x19c0,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(3) */
	{0x19c1,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(3) */
	{0x19c2,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(3) */
	{0x19c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(3) */
	{0x19c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(3) */
	{0x19c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(3) */
	{0x19c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(3) */
	{0x19c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(3) */
	{0x19c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(3) */
	{0x19c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(3) */
	{0x19ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(3) */
	{0x19cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(3) */
	{0x19cc,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(3) */
	{0x19cd,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(3) */
	{0x19ce,    0x36,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(3) */
	{0x19cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(3) */
	{0x19d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(3) */
	{0x19d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(3) */
	{0x19d2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(3) */
	{0x19d3,    0xef,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(3) */
	{0x19d4,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(3) */
	{0x19d5,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(3) */
	{0x19d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(3) */
	{0x19d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(3) */
	{0x19d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(3) */
	{0x19d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(3) */
	{0x19da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(3) */
	{0x19db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(3) */
	{0x19dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(3) */
	{0x19dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(3) */
	{0x19de,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(3) */
	{0x19e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(3) */
	{0x19e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(3) */
	{0x19e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(3) */
	{0x19e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(3) */
	{0x19e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(3) */
	{0x19e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(3) */
	{0x19e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(3) */
	{0x19e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(3) */
	{0x19e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(3) */
	{0x19e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(3) */
	{0x19ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(3) */
	{0x19eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(3) */
	{0x19ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(3) */
	{0x19ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(3) */
	{0x19f0,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(3) */
	{0x19f1,    0x93,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(3) */
	{0x19f2,    0x65,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(3) */
	{0x19f3,    0x53,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(3) */
	{0x19f4,    0xdd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(3) */
	{0x19f5,    0xbe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(3) */
	{0x19f6,    0x51,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(3) */
	{0x19f7,    0x9b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(3) */
	{0x19f8,    0xb3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(3) */
	{0x19fc,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(3) */
	{0x19fd,    0x93,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(3) */
	{0x19fe,    0x65,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(3) */
	{0x19ff,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(3) */
	{0x1a00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(3) */
	{0x1a01,    0xdc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(3) */
	{0x1a02,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(3) */
	{0x1a03,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(3) */
	{0x1a04,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(3) */
	{0x1a05,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(3) */
	{0x1a06,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(3) */
	{0x1a07,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(3) */
	{0x1a08,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(3) */
	{0x1a10,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(3) */
	{0x1a11,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(3) */
	{0x1a12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(3) */
	{0x1a13,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(3) */
	{0x1a14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(3) */
	{0x1a15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(3) */
	{0x1a16,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(3) */
	{0x1a17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(3) */
	{0x1a18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(3) */
	{0x1a19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(3) */
	{0x1a1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(3) */
	{0x1a1b,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(3) */
	{0x1a1c,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(3) */
	{0x1a20,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(3) */
	{0x1a21,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(3) */
	{0x1a22,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(3) */
	{0x1a23,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(3) */
	{0x1a24,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(3) */
	{0x1a25,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(3) */
	{0x1a26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(3) */
	{0x1a27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(3) */
	{0x1a28,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(3) */
	{0x1a29,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(3) */
	{0x1a2a,    0xe3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(3) */
	{0x1a2b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(3) */
	{0x1a2c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(3) */
	{0x1a2d,    0xe3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(3) */
	{0x1a2e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(3) */
	{0x1a2f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(3) */
	{0x1a30,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(3) */
	{0x1a31,    0xea,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(3) */
	{0x1a32,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(3) */
	{0x1a33,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(3) */
	{0x1a34,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(3) */
	{0x1a35,    0xe3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(3) */
	{0x1a36,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(3) */
	{0x1a37,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(3) */
	{0x1a38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(3) */
	{0x1a39,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(3) */
	{0x1a40,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(3) */
	{0x1a41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(3) */
	{0x1a42,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(3) */
	{0x1a43,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(3) */
	{0x1a44,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(3) */
	{0x1a45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(3) */
	{0x1a46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(3) */
	{0x1a47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(3) */
	{0x1a48,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(3) */
	{0x1a49,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(3) */
	{0x1a4a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(3) */
	{0x1a4b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(3) */
	{0x1a4c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(3) */
	{0x1a4d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(3) */
	{0x1a4e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(3) */
	{0x1a4f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(3) */
	{0x1a50,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(3) */
	{0x1a51,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(3) */
	{0x1a52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(3) */
	{0x1a53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(3) */
	{0x1a54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(3) */
	{0x1a55,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(3) */
	{0x1a56,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(3) */
	{0x1a57,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(3) */
	{0x1a58,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(3) */
	{0x1a59,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(3) */
	{0x1a5a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(3) */
	{0x1a5b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(3) */
	{0x1a5c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(3) */
	{0x1a5d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(3) */
	{0x1a5e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(3) */
	{0x1a5f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(3) */
	{0x1a60,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(3) */
	{0x1a61,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(3) */
	{0x1a62,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(3) */
	{0x1a63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(3) */
	{0x1a64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(3) */
	{0x1a65,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(3) */
	{0x1a68,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(3) */
	{0x1a69,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(3) */
	{0x1a6a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(3) */
	{0x1a6b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(3) */
	{0x1a6c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(3) */
	{0x1a6d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(3) */
	{0x1a6e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(3) */
	{0x1a6f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(3) */
	{0x1a70,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(3) */
	{0x1a71,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(3) */
	{0x1a72,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(3) */
	{0x1a73,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(3) */
	{0x1a74,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(3) */
	{0x1a75,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(3) */
	{0x1a76,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(3) */
	{0x1a77,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(3) */
	{0x1a84,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(3) */
	{0x1a85,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(3) */
	{0x1a86,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(3) */
	{0x1a87,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(3) */
	{0x1a88,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(3) */
	{0x1a89,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(3) */
	{0x1a8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(3) */
	{0x1a8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(3) */
	{0x1a98,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(3) */
	{0x1a99,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(3) */
	{0x1a9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(3) */
	{0x1aa0,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(3) */
	{0x1aa1,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(3) */
	{0x1aa2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(3) */
	{0x1aa3,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(3) */
	{0x1aa4,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(3) */
	{0x1aa5,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(3) */
	{0x1aa6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(3) */
	{0x1aa7,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(3) */
	{0x1aa8,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(3) */
	{0x1aa9,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(3) */
	{0x1aaa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(3) */
	{0x1aab,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(3) */
	{0x1aac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(3) */
	{0x1aad,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(3) */
	{0x1aae,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(3) */
	{0x1aaf,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(3) */
	{0x1ac0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(3) */
	{0x1ac1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(3) */
	{0x1ac2,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(3) */
	{0x1ac3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(3) */
	{0x1ac4,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(3) */
	{0x1ac5,    0xd5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(3) */
	{0x1ac6,    0x53,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(3) */
	{0x1ad0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(3) */
	{0x1ad1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(3) */
	{0x1ad2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(3) */
	{0x1ad3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(3) */
	{0x1ad4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(3) */
	{0x1ad5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(3) */
	{0x1ad6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(3) */
	{0x1ad7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(3) */
	{0x1ad8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(3) */
	{0x1ad9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(3) */
	{0x1ada,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(3) */
	{0x1adb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(3) */
	{0x1adc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(3) */
	{0x1add,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(3) */
	{0x1ade,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(3) */
	{0x1adf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(3) */
	{0x1ae0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(3) */
	{0x1ae1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(3) */
	{0x1ae2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(3) */
	{0x1ae3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(3) */
	{0x1ae4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(3) */
	{0x1ae5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(3) */
	{0x1ae6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(3) */
	{0x1ae7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(3) */
	{0x1aec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(3) */
	{0x1aed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(3) */
	{0x1aee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(3) */
	{0x1b00,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(3) */
	{0x1b01,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(3) */
	{0x1b02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(3) */
	{0x1b03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(3) */
	{0x1b04,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(3) */
	{0x1b05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(3) */
	{0x1b06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(3) */
	{0x1b07,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(3) */
	{0x1b08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(3) */
	{0x1b09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(3) */
	{0x1b0a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(3) */
	{0x1b0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(3) */
	{0x1b0c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(3) */
	{0x1b0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(3) */
	{0x1b0e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(3) */
	{0x1b0f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(3) */
	{0x1b10,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(3) */
	{0x1b11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(3) */
	{0x1b12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(3) */
	{0x1b13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(3) */
	{0x1b14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(3) */
	{0x1b15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(3) */
	{0x1b16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(3) */
	{0x1b17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(3) */
	{0x1b18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(3) */
	{0x1b19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(3) */
	{0x1b1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(3) */
	{0x1b1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(3) */
	{0x1b1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(3) */
	{0x1b1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(3) */
	{0x1b1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(3) */
	{0x1b1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(3) */
	{0x1b20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(3) */
	{0x1b21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(3) */
	{0x1b22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(3) */
	{0x1b23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(3) */
	{0x1b24,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(3) */
	{0x1b25,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(3) */
	{0x1b26,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(3) */
	{0x1b27,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(3) */
	{0x1b28,    0x95,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(3) */
	{0x1b29,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(3) */
	{0x1b2a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(3) */
	{0x1b2b,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(3) */
	{0x1b2c,    0xd8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(3) */
	{0x1b2d,    0x6e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(3) */
	{0x1b2e,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(3) */
	{0x1b2f,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(3) */
	{0x1b30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(3) */
	{0x1b31,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(3) */
	{0x1b60,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(3) */
	{0x1b61,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(3) */
	{0x1b62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(3) */
	{0x1b63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(3) */
	{0x1b64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(3) */
	{0x1b65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(3) */
	{0x1b66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(3) */
	{0x1b67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(3) */
	{0x1b68,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(3) */
	{0x1b69,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(3) */
	{0x1b6a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(3) */
	{0x1b6b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(3) */
	{0x1b6c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(3) */
	{0x1b6d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(3) */
	{0x1b6e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(3) */
	{0x1b6f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(3) */
	{0x1b80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(3) */
	{0x1b81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(3) */
	{0x1b82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(3) */
	{0x1b83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(3) */
	{0x1b84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(3) */
	{0x1b85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(3) */
	{0x1b86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(3) */
	{0x1b87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(3) */
	{0x1b88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(3) */
	{0x1b89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(3) */
	{0x1b8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(3) */
	{0x1b8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(3) */
	{0x1ba0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(3) */
	{0x1ba1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(3) */
	{0x1ba2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(3) */
	{0x1ba3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(3) */
	{0x1ba4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(3) */
	{0x1ba5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(3) */
	{0x1ba6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(3) */
	{0x1bb0,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(3) */
	{0x1bb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(3) */
	{0x1bb2,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(3) */
	{0x1bb3,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(3) */
	{0x1bb4,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(3) */
	{0x1bb5,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(3) */
	{0x1bc0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(3) */
	{0x1bc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(3) */
	{0x1bc2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(3) */
	{0x1bc3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(3) */
	{0x1bc4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(3) */
	{0x1bc5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(3) */
	{0x1bc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(3) */
	{0x1bc7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(3) */
	{0x1bc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(3) */
	{0x1be0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(3) */
	{0x1be1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(3) */
	{0x1be2,    0xd5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(3) */
	{0x1be3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(3) */
	{0x1be4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(3) */
	{0x1be5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(3) */
	{0x1be6,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(3) */
	{0x1be7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(3) */
	{0x1be8,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(3) */
	{0x1be9,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(3) */
	{0x1bea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(3) */
	{0x1beb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(3) */
	{0x1bec,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(3) */
	{0x1bed,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(3) */
	{0x1bee,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(3) */
	{0x1bef,    0xf2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(3) */
	{0x1c00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(3) */
	{0x1c01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(3) */
	{0x1c02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(3) */
	{0x1c03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(3) */
	{0x1c04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(3) */
	{0x1c05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(3) */
	{0x1c06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(3) */
	{0x1c10,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(3) */
	{0x1c11,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(3) */
	{0x1c12,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(3) */
	{0x1c13,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(3) */
	{0x1c14,    0xdc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(3) */
	{0x1c15,    0xf4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(3) */
	{0x1c16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(3) */
	{0x1c17,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(3) */
	{0x1c18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(3) */
	{0x1c19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(3) */
	{0x1c1a,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(3) */
	{0x1c1b,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(3) */
	{0x1c1c,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(3) */
	{0x1c1d,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(3) */
	{0x1c1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(3) */
	{0x1c80,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(3) */
	{0x1c81,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(3) */
	{0x1c82,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(3) */
	{0x1c83,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(3) */
	{0x1c84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(3) */
	{0x1c85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(3) */
	{0x1c86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(3) */
	{0x1c87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(3) */
	{0x1c88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(3) */
	{0x1c89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(3) */
	{0x1c8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(3) */
	{0x1c8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(3) */
	{0x1c8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(3) */
	{0x1c8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(3) */
	{0x1c8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(3) */
	{0x1c8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(3) */
	{0x1c90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(3) */
	{0x1c91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(3) */
	{0x1c92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(3) */
	{0x1c93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(3) */
	{0x1c94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(3) */
	{0x1c95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(3) */
	{0x1c96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(3) */
	{0x1c97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(3) */
	{0x1c98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(3) */
	{0x1c9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(3) */
	{0x1c9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(3) */
	{0x1cac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(3) */
	{0x1cad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(3) */
	{0x1cae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(3) */
	{0x1caf,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(3) */
	{0x1cb0,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(3) */
	{0x1cb1,    0x39,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(3) */
	{0x1cb2,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(3) */
	{0x1cb3,    0x39,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(3) */
	{0x1cb4,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(3) */
	{0x1cb5,    0x39,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(3) */
	{0x1cb6,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(3) */
	{0x1cb7,    0x39,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(3) */
	{0x1cb8,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(3) */
	{0x1cb9,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(3) */
	{0x1cba,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(3) */
	{0x1cbb,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(3) */
	{0x1cbc,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(3) */
	{0x1cbd,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(3) */
	{0x1cbe,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(3) */
	{0x1cbf,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(3) */
	{0x1cc0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(3) */
	{0x1cc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(3) */
	{0x1cc2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(3) */
	{0x1cc3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(3) */
	{0x1cc4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(3) */
	{0x1cc5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(3) */
	{0x1cc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(3) */
	{0x1cc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(3) */
	{0x1cc9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(3) */
	{0x1cca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(3) */
	{0x1cf0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(3) */
	{0x1d00,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(3) */
	{0x1d01,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(3) */
	{0x1d02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(3) */
	{0x1d03,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(3) */
	{0x1d04,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(3) */
	{0x1d05,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(3) */
	{0x1d06,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(3) */
	{0x1d07,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(3) */
	{0x1d08,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(3) */
	{0x1d09,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(3) */
	{0x1d0a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(3) */
	{0x1d0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(3) */
	{0x1d10,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(3) */
	{0x1d11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(3) */
	{0x1d12,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(3) */
	{0x1d13,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(3) */
	{0x1d14,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(3) */
	{0x1d18,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(3) */
	{0x1d19,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(3) */
	{0x1d1a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(3) */
	{0x1d1b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(3) */
	{0x1d1c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(3) */
	{0x1d1d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(3) */
	{0x1d20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(3) */
	{0x1d21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(3) */
	{0x1d22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(3) */
	{0x1d80,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(3) */
	{0x1d81,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(3) */
	{0x1d82,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(3) */
	{0x1d83,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(3) */
	{0x1d84,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(3) */
	{0x1d85,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(3) */
	{0x1d86,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(3) */
	{0x1d87,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(3) */
	{0x1d88,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(3) */
	{0x1d89,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(3) */
	{0x1d8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(3) */
	{0x1d8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(3) */
	{0x1d8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(3) */
	{0x1d8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(3) */
	{0x1e00,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(3) */
	{0x1e01,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(3) */
	{0x1e02,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(3) */
	{0x1e03,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(3) */
	{0x1e04,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(3) */
	{0x1e05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(3) */
	{0x1e06,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(3) */
	{0x1e07,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(3) */
	{0x1e08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(3) */
	{0x1e09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(3) */
	{0x1e0a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(3) */
	{0x1e0b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(3) */
	{0x1e0c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(3) */
	{0x1e0d,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(3) */
	{0x1e0e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(3) */
	{0x1e0f,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(3) */
	{0x1e10,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(3) */
	{0x1e11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(3) */
	{0x1e12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(3) */
	{0x1e13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(3) */
	{0x1e14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(3) */
	{0x1e15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(3) */
	{0x1e16,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(3) */
	{0x1e17,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(3) */
	{0x1e18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(3) */
	{0x1e19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(3) */
	{0x1e1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(3) */
	{0x1e1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(3) */
	{0x1e1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(3) */
	{0x1e1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(3) */
	{0x1e1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(3) */
	{0x1e1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(3) */
	{0x1e20,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(3) */
	{0x1e21,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(3) */
	{0x1e22,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(3) */
	{0x1e24,    0x63,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(3) */
	{0x1e25,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(3) */
	{0x1e26,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(3) */
	{0x1e27,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(3) */
	{0x1e28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(3) */
	{0x1e29,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(3) */
	{0x1e2a,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(3) */
	{0x1e30,    0x2d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(3) */
	{0x1e31,    0x76,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(3) */
	{0x1e32,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(3) */
	{0x1e33,    0xf1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(3) */
	{0x1e34,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(3) */
	{0x1e35,    0x5c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(3) */
	{0x1e36,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(3) */
	{0x1e37,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(3) */
	{0x1e38,    0xb6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(3) */
	{0x1e39,    0x61,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(3) */
	{0x1e3a,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(3) */
	{0x1e3b,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(3) */
	{0x1e3c,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(3) */
	{0x1e3d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(3) */
	{0x1e3e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(3) */
	{0x1e3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(3) */
	{0x1e40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(3) */
	{0x1e41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(3) */
	{0x1e42,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(3) */
	{0x1e43,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(3) */
	{0x1e44,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(3) */
	{0x1e45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(3) */
	{0x1e46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(3) */
	{0x1e47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(3) */
	{0x1e50,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(3) */
	{0x1e51,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(3) */
	{0x1e52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(3) */
	{0x1e53,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(3) */
	{0x1e54,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(3) */
	{0x1e60,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(3) */
	{0x1e61,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(3) */
	{0x1e62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(3) */
	{0x1e63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(3) */
	{0x1e64,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(3) */
	{0x1e65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(3) */
	{0x1e66,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(3) */
	{0x1e67,    0xdc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(3) */
	{0x1e70,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(3) */
	{0x1e71,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(3) */
	{0x1e72,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(3) */
	{0x1e73,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(3) */
	{0x1e74,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(3) */
	{0x1e75,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(3) */
	{0x1e76,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(3) */
	{0x1e77,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(3) */
	{0x1e80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(3) */
	{0x1e81,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(3) */
	{0x1e82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(3) */
	{0x1e83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(3) */
	{0x1e84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(3) */
	{0x1e85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(3) */
	{0x1e86,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(3) */
	{0x1e87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(3) */
	{0x1e88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(3) */
	{0x1e89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(3) */
	{0x1e8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(3) */
	{0x1e8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(3) */
	{0x1e8c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(3) */
	{0x1e8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(3) */
	{0x1e8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(3) */
	{0x1e90,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(3) */
	{0x1e91,    0x36,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(3) */
	{0x1e92,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(3) */
	{0x1e93,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(3) */
	{0x1e94,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(3) */
	{0x1e95,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(3) */
	{0x1ec0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(3) */
	{0x1ec1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(3) */
	{0x1ec2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(3) */
	{0x1ec3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(3) */
	{0x1ec4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(3) */
	{0x1ec5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(3) */
	{0x1ec6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(3) */
	{0x1ec7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(3) */
	{0x1ec8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(3) */
	{0x1ec9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(3) */
	{0x1eca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(3) */
	{0x1ecb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(3) */
	{0x1ecc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(3) */
	{0x1ed0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(3) */
	{0x1ed1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(3) */
	{0x1ed2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(3) */
	{0x1ed3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(3) */
	{0x1ed8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(3) */
	{0x1ed9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(3) */
	{0x1eda,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(3) */
	{0x1f00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(3) */
	{0x1f01,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(3) */
	{0x1f02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(3) */
	{0x1f03,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(3) */
	{0x1f04,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(3) */
	{0x1f05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(3) */
	{0x1f06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(3) */
	{0x1f07,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(3) */
	{0x1f08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(3) */
	{0x1f09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(3) */
	{0x1f0c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(3) */
	{0x1f0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(3) */
	{0x1f10,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(3) */
	{0x1f11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(3) */
	{0x1f12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(3) */
	{0x1f13,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(3) */
	{0x1f14,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(3) */
	{0x1f15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(3) */
	{0x1f16,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(3) */
	{0x1f17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(3) */
	{0x1f18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(3) */
	{0x1f20,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(3) */
	{0x1f21,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(3) */
	{0x1f22,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(3) */
	{0x1f23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(3) */
	{0x1f24,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(3) */
	{0x1f25,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(3) */
	{0x1f26,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(3) */
	{0x1f27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(3) */
	{0x1f28,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(3) */
	{0x1f29,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(3) */
	{0x1f2a,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(3) */
	{0x1f30,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(3) */
	{0x1f31,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(3) */
	{0x1f32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(3) */
	{0x1f34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(3) */
	{0x1f35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(3) */
	{0x1f36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(3) */
	{0x1f37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(3) */
	{0x1f3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(3) */
	{0x1f80,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(3) */
	{0x1f81,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(3) */
	{0x1f82,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(3) */
	{0x1f83,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(3) */
	{0x1f84,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(3) */
	{0x1f85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(3) */
	{0x1f88,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(3) */
	{0x1f89,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(3) */
	{0x1f8a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(3) */
	{0x1f8b,    0xb9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(3) */
	{0x1f8c,    0x89,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(3) */
	{0x1f8d,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(3) */
	{0x1f90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(3) */
	{0x1f91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(3) */
	{0x1f92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(3) */
	{0x1f93,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(3) */
	{0x1f94,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(3) */
	{0x1f95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(3) */
	{0x1f96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(3) */
	{0x1f97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(3) */
	{0x1f98,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(3) */
	{0x1f99,    0x9a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(3) */
	{0x1f9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(3) */
	{0x1f9b,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(3) */
	{0x1f9c,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(3) */
	{0x1f9d,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(3) */
	{0x1fa0,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(3) */
	{0x1fa1,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(3) */
	{0x1fa2,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(3) */
	{0x1fa3,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(3) */
	{0x1fa4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(3) */
	{0x1fa5,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(3) */
	{0x1fa6,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(3) */
	{0x1fa7,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(3) */
	{0x1fae,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(3) */
	{0x1faf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(3) */
	{0x1fb0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(3) */
	{0x1fb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(3) */
	{0x1fb2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(3) */
	{0x1fb3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(3) */
	{0x1fb4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(3) */
	{0x1fb5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(3) */
	{0x1fb6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(3) */
	{0x1fb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(3) */
	{0x1fb8,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(3) */
	{0x1fb9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(3) */
	{0x1fba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(3) */
	{0x1fbb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(3) */
	{0x1fbc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(3) */
	{0x1fbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(3) */
	{0x1fbe,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(3) */
	{0x1fbf,    0x5d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(3) */
	{0x2000,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(4) */
	{0x2001,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(4) */
	{0x2010,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(4) */
	{0x2011,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(4) */
	{0x2012,    0x0b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(4) */
	{0x2013,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(4) */
	{0x2014,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(4) */
	{0x2015,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(4) */
	{0x2020,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(4) */
	{0x2021,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(4) */
	{0x2022,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(4) */
	{0x2100,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(4) */
	{0x2101,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(4) */
	{0x2102,    0x4f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(4) */
	{0x2103,    0xb3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(4) */
	{0x2110,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(4) */
	{0x2112,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(4) */
	{0x2113,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(4) */
	{0x2116,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(4) */
	{0x2117,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(4) */
	{0x2118,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(4) */
	{0x2119,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(4) */
	{0x211a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(4) */
	{0x211b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(4) */
	{0x211c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(4) */
	{0x211d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(4) */
	{0x2120,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(4) */
	{0x2122,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(4) */
	{0x2123,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(4) */
	{0x2124,    0x1C,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(4) */
	{0x2125,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(4) */
	{0x2126,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(4) */
	{0x2127,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(4) */
	{0x2128,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(4) */
	{0x2129,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(4) */
	{0x212a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(4) */
	{0x212b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(4) */
	{0x2130,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(4) */
	{0x2131,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(4) */
	{0x2132,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(4) */
	{0x2133,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(4) */
	{0x2134,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(4) */
	{0x2135,    0xe3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(4) */
	{0x2136,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(4) */
	{0x2137,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(4) */
	{0x2138,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(4) */
	{0x2139,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(4) */
	{0x213a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(4) */
	{0x2140,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(4) */
	{0x2141,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(4) */
	{0x2142,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(4) */
	{0x2143,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(4) */
	{0x2144,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(4) */
	{0x2148,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(4) */
	{0x2149,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(4) */
	{0x214a,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(4) */
	{0x2150,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(4) */
	{0x2151,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(4) */
	{0x2152,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(4) */
	{0x2153,    0xc5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(4) */
	{0x2154,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(4) */
	{0x2155,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(4) */
	{0x2156,    0x7b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(4) */
	{0x2157,    0xfd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(4) */
	{0x2158,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(4) */
	{0x2159,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(4) */
	{0x215a,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(4) */
	{0x215b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(4) */
	{0x215c,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(4) */
	{0x215d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(4) */
	{0x215e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(4) */
	{0x2170,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(4) */
	{0x2171,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(4) */
	{0x2172,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(4) */
	{0x2173,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(4) */
	{0x2174,    0x4a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(4) */
	{0x2175,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(4) */
	{0x2180,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(4) */
	{0x2181,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(4) */
	{0x2182,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(4) */
	{0x2183,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(4) */
	{0x2184,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(4) */
	{0x2185,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(4) */
	{0x2186,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(4) */
	{0x2187,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(4) */
	{0x2188,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(4) */
	{0x2190,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(4) */
	{0x2191,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(4) */
	{0x2192,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(4) */
	{0x2193,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(4) */
	{0x2194,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(4) */
	{0x2195,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(4) */
	{0x2196,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(4) */
	{0x2197,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(4) */
	{0x2198,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(4) */
	{0x2199,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(4) */
	{0x219a,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(4) */
	{0x219b,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(4) */
	{0x219c,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(4) */
	{0x219d,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(4) */
	{0x219e,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(4) */
	{0x219f,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(4) */
	{0x21a0,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(4) */
	{0x21a1,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(4) */
	{0x21a2,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(4) */
	{0x21a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(4) */
	{0x21a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(4) */
	{0x21a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(4) */
	{0x21a6,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(4) */
	{0x21a7,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(4) */
	{0x21a8,    0x9e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(4) */
	{0x21b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(4) */
	{0x21b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(4) */
	{0x21b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(4) */
	{0x21b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(4) */
	{0x21b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(4) */
	{0x21b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(4) */
	{0x21b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(4) */
	{0x21b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(4) */
	{0x21b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(4) */
	{0x21b9,    0xf9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(4) */
	{0x21ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(4) */
	{0x21bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(4) */
	{0x21bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(4) */
	{0x21bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(4) */
	{0x21be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(4) */
	{0x21bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(4) */
	{0x21c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(4) */
	{0x21c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(4) */
	{0x21c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(4) */
	{0x21c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(4) */
	{0x21c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(4) */
	{0x21c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(4) */
	{0x21c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(4) */
	{0x21c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(4) */
	{0x21c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(4) */
	{0x21c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(4) */
	{0x21ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(4) */
	{0x21cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(4) */
	{0x21cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(4) */
	{0x21cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(4) */
	{0x21ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(4) */
	{0x21cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(4) */
	{0x21d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(4) */
	{0x21d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(4) */
	{0x21d2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(4) */
	{0x21d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(4) */
	{0x21d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(4) */
	{0x21d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(4) */
	{0x21d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(4) */
	{0x21d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(4) */
	{0x21d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(4) */
	{0x21d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(4) */
	{0x21da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(4) */
	{0x21db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(4) */
	{0x21dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(4) */
	{0x21dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(4) */
	{0x21de,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(4) */
	{0x21e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(4) */
	{0x21e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(4) */
	{0x21e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(4) */
	{0x21e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(4) */
	{0x21e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(4) */
	{0x21e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(4) */
	{0x21e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(4) */
	{0x21e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(4) */
	{0x21e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(4) */
	{0x21e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(4) */
	{0x21ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(4) */
	{0x21eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(4) */
	{0x21ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(4) */
	{0x21ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(4) */
	{0x21f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(4) */
	{0x21f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(4) */
	{0x21f2,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(4) */
	{0x21f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(4) */
	{0x21f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(4) */
	{0x21f5,    0xe8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(4) */
	{0x21f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(4) */
	{0x21f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(4) */
	{0x21f8,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(4) */
	{0x21fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(4) */
	{0x21fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(4) */
	{0x21fe,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(4) */
	{0x21ff,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(4) */
	{0x2200,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(4) */
	{0x2201,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(4) */
	{0x2202,    0x7a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(4) */
	{0x2203,    0x81,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(4) */
	{0x2204,    0x64,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(4) */
	{0x2205,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(4) */
	{0x2206,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(4) */
	{0x2207,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(4) */
	{0x2208,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(4) */
	{0x2210,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(4) */
	{0x2211,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(4) */
	{0x2212,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(4) */
	{0x2213,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(4) */
	{0x2214,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(4) */
	{0x2215,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(4) */
	{0x2216,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(4) */
	{0x2217,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(4) */
	{0x2218,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(4) */
	{0x2219,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(4) */
	{0x221a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(4) */
	{0x221b,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(4) */
	{0x221c,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(4) */
	{0x2220,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(4) */
	{0x2221,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(4) */
	{0x2222,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(4) */
	{0x2223,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(4) */
	{0x2224,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(4) */
	{0x2225,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(4) */
	{0x2226,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(4) */
	{0x2227,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(4) */
	{0x2228,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(4) */
	{0x2229,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(4) */
	{0x222a,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(4) */
	{0x222b,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(4) */
	{0x222c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(4) */
	{0x222d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(4) */
	{0x222e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(4) */
	{0x222f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(4) */
	{0x2230,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(4) */
	{0x2231,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(4) */
	{0x2232,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(4) */
	{0x2233,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(4) */
	{0x2234,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(4) */
	{0x2235,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(4) */
	{0x2236,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(4) */
	{0x2237,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(4) */
	{0x2238,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(4) */
	{0x2239,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(4) */
	{0x2240,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(4) */
	{0x2241,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(4) */
	{0x2242,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(4) */
	{0x2243,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(4) */
	{0x2244,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(4) */
	{0x2245,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(4) */
	{0x2246,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(4) */
	{0x2247,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(4) */
	{0x2248,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(4) */
	{0x2249,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(4) */
	{0x224a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(4) */
	{0x224b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(4) */
	{0x224c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(4) */
	{0x224d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(4) */
	{0x224e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(4) */
	{0x224f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(4) */
	{0x2250,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(4) */
	{0x2251,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(4) */
	{0x2252,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(4) */
	{0x2253,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(4) */
	{0x2254,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(4) */
	{0x2255,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(4) */
	{0x2256,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(4) */
	{0x2257,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(4) */
	{0x2258,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(4) */
	{0x2259,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(4) */
	{0x225a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(4) */
	{0x225b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(4) */
	{0x225c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(4) */
	{0x225d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(4) */
	{0x225e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(4) */
	{0x225f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(4) */
	{0x2260,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(4) */
	{0x2261,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(4) */
	{0x2262,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(4) */
	{0x2263,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(4) */
	{0x2264,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(4) */
	{0x2265,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(4) */
	{0x2268,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(4) */
	{0x2269,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(4) */
	{0x226a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(4) */
	{0x226b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(4) */
	{0x226c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(4) */
	{0x226d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(4) */
	{0x226e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(4) */
	{0x226f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(4) */
	{0x2270,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(4) */
	{0x2271,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(4) */
	{0x2272,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(4) */
	{0x2273,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(4) */
	{0x2274,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(4) */
	{0x2275,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(4) */
	{0x2276,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(4) */
	{0x2277,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(4) */
	{0x2284,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(4) */
	{0x2285,    0x9c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(4) */
	{0x2286,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(4) */
	{0x2287,    0xf4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(4) */
	{0x2288,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(4) */
	{0x2289,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(4) */
	{0x228a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(4) */
	{0x228b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(4) */
	{0x2298,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(4) */
	{0x2299,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(4) */
	{0x229a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(4) */
	{0x22a0,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(4) */
	{0x22a1,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(4) */
	{0x22a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(4) */
	{0x22a3,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(4) */
	{0x22a4,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(4) */
	{0x22a5,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(4) */
	{0x22a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(4) */
	{0x22a7,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(4) */
	{0x22a8,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(4) */
	{0x22a9,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(4) */
	{0x22aa,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(4) */
	{0x22ab,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(4) */
	{0x22ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(4) */
	{0x22ad,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(4) */
	{0x22ae,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(4) */
	{0x22af,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(4) */
	{0x22c0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(4) */
	{0x22c1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(4) */
	{0x22c2,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(4) */
	{0x22c3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(4) */
	{0x22c4,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(4) */
	{0x22c5,    0xd5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(4) */
	{0x22c6,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(4) */
	{0x22d0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(4) */
	{0x22d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(4) */
	{0x22d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(4) */
	{0x22d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(4) */
	{0x22d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(4) */
	{0x22d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(4) */
	{0x22d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(4) */
	{0x22d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(4) */
	{0x22d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(4) */
	{0x22d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(4) */
	{0x22da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(4) */
	{0x22db,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(4) */
	{0x22dc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(4) */
	{0x22dd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(4) */
	{0x22de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(4) */
	{0x22df,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(4) */
	{0x22e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(4) */
	{0x22e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(4) */
	{0x22e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(4) */
	{0x22e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(4) */
	{0x22e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(4) */
	{0x22e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(4) */
	{0x22e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(4) */
	{0x22e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(4) */
	{0x22ec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(4) */
	{0x22ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(4) */
	{0x22ee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(4) */
	{0x2300,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(4) */
	{0x2301,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(4) */
	{0x2302,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(4) */
	{0x2303,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(4) */
	{0x2304,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(4) */
	{0x2305,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(4) */
	{0x2306,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(4) */
	{0x2307,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(4) */
	{0x2308,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(4) */
	{0x2309,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(4) */
	{0x230a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(4) */
	{0x230b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(4) */
	{0x230c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(4) */
	{0x230d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(4) */
	{0x230e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(4) */
	{0x230f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(4) */
	{0x2310,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(4) */
	{0x2311,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(4) */
	{0x2312,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(4) */
	{0x2313,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(4) */
	{0x2314,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(4) */
	{0x2315,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(4) */
	{0x2316,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(4) */
	{0x2317,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(4) */
	{0x2318,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(4) */
	{0x2319,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(4) */
	{0x231a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(4) */
	{0x231b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(4) */
	{0x231c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(4) */
	{0x231d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(4) */
	{0x231e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(4) */
	{0x231f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(4) */
	{0x2320,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(4) */
	{0x2321,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(4) */
	{0x2322,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(4) */
	{0x2323,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(4) */
	{0x2324,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(4) */
	{0x2325,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(4) */
	{0x2326,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(4) */
	{0x2327,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(4) */
	{0x2328,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(4) */
	{0x2329,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(4) */
	{0x232a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(4) */
	{0x232b,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(4) */
	{0x232c,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(4) */
	{0x232d,    0x66,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(4) */
	{0x232e,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(4) */
	{0x232f,    0xa8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(4) */
	{0x2330,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(4) */
	{0x2331,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(4) */
	{0x2360,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(4) */
	{0x2361,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(4) */
	{0x2362,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(4) */
	{0x2363,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(4) */
	{0x2364,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(4) */
	{0x2365,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(4) */
	{0x2366,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(4) */
	{0x2367,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(4) */
	{0x2368,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(4) */
	{0x2369,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(4) */
	{0x236a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(4) */
	{0x236b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(4) */
	{0x236c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(4) */
	{0x236d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(4) */
	{0x236e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(4) */
	{0x236f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(4) */
	{0x2380,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(4) */
	{0x2381,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(4) */
	{0x2382,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(4) */
	{0x2383,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(4) */
	{0x2384,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(4) */
	{0x2385,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(4) */
	{0x2386,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(4) */
	{0x2387,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(4) */
	{0x2388,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(4) */
	{0x2389,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(4) */
	{0x238a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(4) */
	{0x238b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(4) */
	{0x23a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(4) */
	{0x23a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(4) */
	{0x23a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(4) */
	{0x23a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(4) */
	{0x23a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(4) */
	{0x23a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(4) */
	{0x23a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(4) */
	{0x23b0,    0x5d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(4) */
	{0x23b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(4) */
	{0x23b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(4) */
	{0x23b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(4) */
	{0x23b4,    0x4f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(4) */
	{0x23b5,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(4) */
	{0x23c0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(4) */
	{0x23c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(4) */
	{0x23c2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(4) */
	{0x23c3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(4) */
	{0x23c4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(4) */
	{0x23c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(4) */
	{0x23c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(4) */
	{0x23c7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(4) */
	{0x23c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(4) */
	{0x23e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(4) */
	{0x23e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(4) */
	{0x23e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(4) */
	{0x23e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(4) */
	{0x23e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(4) */
	{0x23e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(4) */
	{0x23e6,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(4) */
	{0x23e7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(4) */
	{0x23e8,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(4) */
	{0x23e9,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(4) */
	{0x23ea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(4) */
	{0x23eb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(4) */
	{0x23ec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(4) */
	{0x23ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(4) */
	{0x23ee,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(4) */
	{0x23ef,    0xdd,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(4) */
	{0x2400,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(4) */
	{0x2401,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(4) */
	{0x2402,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(4) */
	{0x2403,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(4) */
	{0x2404,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(4) */
	{0x2405,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(4) */
	{0x2406,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(4) */
	{0x2410,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(4) */
	{0x2411,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(4) */
	{0x2412,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(4) */
	{0x2413,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(4) */
	{0x2414,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(4) */
	{0x2415,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(4) */
	{0x2416,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(4) */
	{0x2417,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(4) */
	{0x2418,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(4) */
	{0x2419,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(4) */
	{0x241a,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(4) */
	{0x241b,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(4) */
	{0x241c,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(4) */
	{0x241d,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(4) */
	{0x241e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(4) */
	{0x2480,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(4) */
	{0x2481,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(4) */
	{0x2482,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(4) */
	{0x2483,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(4) */
	{0x2484,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(4) */
	{0x2485,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(4) */
	{0x2486,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(4) */
	{0x2487,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(4) */
	{0x2488,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(4) */
	{0x2489,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(4) */
	{0x248a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(4) */
	{0x248b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(4) */
	{0x248c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(4) */
	{0x248d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(4) */
	{0x248e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(4) */
	{0x248f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(4) */
	{0x2490,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(4) */
	{0x2491,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(4) */
	{0x2492,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(4) */
	{0x2493,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(4) */
	{0x2494,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(4) */
	{0x2495,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(4) */
	{0x2496,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(4) */
	{0x2497,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(4) */
	{0x2498,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(4) */
	{0x249a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(4) */
	{0x249b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(4) */
	{0x24ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(4) */
	{0x24ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(4) */
	{0x24ae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(4) */
	{0x24af,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(4) */
	{0x24b0,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(4) */
	{0x24b1,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(4) */
	{0x24b2,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(4) */
	{0x24b3,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(4) */
	{0x24b4,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(4) */
	{0x24b5,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(4) */
	{0x24b6,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(4) */
	{0x24b7,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(4) */
	{0x24b8,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(4) */
	{0x24b9,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(4) */
	{0x24ba,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(4) */
	{0x24bb,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(4) */
	{0x24bc,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(4) */
	{0x24bd,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(4) */
	{0x24be,    0xd1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(4) */
	{0x24bf,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(4) */
	{0x24c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(4) */
	{0x24c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(4) */
	{0x24c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(4) */
	{0x24c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(4) */
	{0x24c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(4) */
	{0x24c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(4) */
	{0x24c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(4) */
	{0x24c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(4) */
	{0x24c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(4) */
	{0x24ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(4) */
	{0x24f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(4) */
	{0x2500,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(4) */
	{0x2501,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(4) */
	{0x2502,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(4) */
	{0x2503,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(4) */
	{0x2504,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(4) */
	{0x2505,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(4) */
	{0x2506,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(4) */
	{0x2507,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(4) */
	{0x2508,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(4) */
	{0x2509,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(4) */
	{0x250a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(4) */
	{0x250b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(4) */
	{0x2510,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(4) */
	{0x2511,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(4) */
	{0x2512,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(4) */
	{0x2513,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(4) */
	{0x2514,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(4) */
	{0x2518,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(4) */
	{0x2519,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(4) */
	{0x251a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(4) */
	{0x251b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(4) */
	{0x251c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(4) */
	{0x251d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(4) */
	{0x2520,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(4) */
	{0x2521,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(4) */
	{0x2522,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(4) */
	{0x2580,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(4) */
	{0x2581,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(4) */
	{0x2582,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(4) */
	{0x2583,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(4) */
	{0x2584,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(4) */
	{0x2585,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(4) */
	{0x2586,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(4) */
	{0x2587,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(4) */
	{0x2588,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(4) */
	{0x2589,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(4) */
	{0x258a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(4) */
	{0x258d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(4) */
	{0x258e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(4) */
	{0x258f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(4) */
	{0x2600,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(4) */
	{0x2601,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(4) */
	{0x2602,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(4) */
	{0x2603,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(4) */
	{0x2604,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(4) */
	{0x2605,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(4) */
	{0x2606,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(4) */
	{0x2607,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(4) */
	{0x2608,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(4) */
	{0x2609,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(4) */
	{0x260a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(4) */
	{0x260b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(4) */
	{0x260c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(4) */
	{0x260d,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(4) */
	{0x260e,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(4) */
	{0x260f,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(4) */
	{0x2610,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(4) */
	{0x2611,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(4) */
	{0x2612,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(4) */
	{0x2613,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(4) */
	{0x2614,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(4) */
	{0x2615,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(4) */
	{0x2616,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(4) */
	{0x2617,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(4) */
	{0x2618,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(4) */
	{0x2619,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(4) */
	{0x261a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(4) */
	{0x261b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(4) */
	{0x261c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(4) */
	{0x261d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(4) */
	{0x261e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(4) */
	{0x261f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(4) */
	{0x2620,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(4) */
	{0x2621,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(4) */
	{0x2622,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(4) */
	{0x2624,    0x64,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(4) */
	{0x2625,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(4) */
	{0x2626,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(4) */
	{0x2627,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(4) */
	{0x2628,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(4) */
	{0x2629,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(4) */
	{0x262a,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(4) */
	{0x2630,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(4) */
	{0x2631,    0x64,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(4) */
	{0x2632,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(4) */
	{0x2633,    0xf1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(4) */
	{0x2634,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(4) */
	{0x2635,    0x5c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(4) */
	{0x2636,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(4) */
	{0x2637,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(4) */
	{0x2638,    0xb4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(4) */
	{0x2639,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(4) */
	{0x263a,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(4) */
	{0x263b,    0xc2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(4) */
	{0x263c,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(4) */
	{0x263d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(4) */
	{0x263e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(4) */
	{0x263f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(4) */
	{0x2640,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(4) */
	{0x2641,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(4) */
	{0x2642,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(4) */
	{0x2643,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(4) */
	{0x2644,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(4) */
	{0x2645,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(4) */
	{0x2646,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(4) */
	{0x2647,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(4) */
	{0x2650,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(4) */
	{0x2651,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(4) */
	{0x2652,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(4) */
	{0x2653,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(4) */
	{0x2654,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(4) */
	{0x2660,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(4) */
	{0x2661,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(4) */
	{0x2662,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(4) */
	{0x2663,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(4) */
	{0x2664,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(4) */
	{0x2665,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(4) */
	{0x2666,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(4) */
	{0x2667,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(4) */
	{0x2670,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(4) */
	{0x2671,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(4) */
	{0x2672,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(4) */
	{0x2673,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(4) */
	{0x2674,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(4) */
	{0x2675,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(4) */
	{0x2676,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(4) */
	{0x2677,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(4) */
	{0x2680,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(4) */
	{0x2681,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(4) */
	{0x2682,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(4) */
	{0x2683,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(4) */
	{0x2684,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(4) */
	{0x2685,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(4) */
	{0x2686,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(4) */
	{0x2687,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(4) */
	{0x2688,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(4) */
	{0x2689,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(4) */
	{0x268a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(4) */
	{0x268b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(4) */
	{0x268c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(4) */
	{0x268d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(4) */
	{0x268f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(4) */
	{0x2690,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(4) */
	{0x2691,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(4) */
	{0x2692,    0xb7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(4) */
	{0x2693,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(4) */
	{0x2694,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(4) */
	{0x2695,    0xa5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(4) */
	{0x26c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(4) */
	{0x26c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(4) */
	{0x26c2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(4) */
	{0x26c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(4) */
	{0x26c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(4) */
	{0x26c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(4) */
	{0x26c6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(4) */
	{0x26c7,    0x6b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(4) */
	{0x26c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(4) */
	{0x26c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(4) */
	{0x26ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(4) */
	{0x26cb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(4) */
	{0x26cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(4) */
	{0x26d0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(4) */
	{0x26d1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(4) */
	{0x26d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(4) */
	{0x26d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(4) */
	{0x26d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(4) */
	{0x26d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(4) */
	{0x26da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(4) */
	{0x2700,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(4) */
	{0x2701,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(4) */
	{0x2702,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(4) */
	{0x2703,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(4) */
	{0x2704,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(4) */
	{0x2705,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(4) */
	{0x2706,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(4) */
	{0x2707,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(4) */
	{0x2708,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(4) */
	{0x2709,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(4) */
	{0x270c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(4) */
	{0x270d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(4) */
	{0x2710,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(4) */
	{0x2711,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(4) */
	{0x2712,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(4) */
	{0x2713,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(4) */
	{0x2714,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(4) */
	{0x2715,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(4) */
	{0x2716,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(4) */
	{0x2717,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(4) */
	{0x2718,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(4) */
	{0x2720,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(4) */
	{0x2721,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(4) */
	{0x2722,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(4) */
	{0x2723,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(4) */
	{0x2724,    0xd2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(4) */
	{0x2725,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(4) */
	{0x2726,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(4) */
	{0x2727,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(4) */
	{0x2728,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(4) */
	{0x2729,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(4) */
	{0x272a,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(4) */
	{0x2730,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(4) */
	{0x2731,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(4) */
	{0x2732,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(4) */
	{0x2734,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(4) */
	{0x2735,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(4) */
	{0x2736,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(4) */
	{0x2737,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(4) */
	{0x273f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(4) */
	{0x2780,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(4) */
	{0x2781,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(4) */
	{0x2782,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(4) */
	{0x2783,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(4) */
	{0x2784,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(4) */
	{0x2785,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(4) */
	{0x2788,    0x6f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(4) */
	{0x2789,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(4) */
	{0x278a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(4) */
	{0x278b,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(4) */
	{0x278c,    0x89,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(4) */
	{0x278d,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(4) */
	{0x2790,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(4) */
	{0x2791,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(4) */
	{0x2792,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(4) */
	{0x2793,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(4) */
	{0x2794,    0xd9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(4) */
	{0x2795,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(4) */
	{0x2796,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(4) */
	{0x2797,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(4) */
	{0x2798,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(4) */
	{0x2799,    0x84,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(4) */
	{0x279a,    0x19,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(4) */
	{0x279b,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(4) */
	{0x279c,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(4) */
	{0x279d,    0x8f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(4) */
	{0x27a0,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(4) */
	{0x27a1,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(4) */
	{0x27a2,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(4) */
	{0x27a3,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(4) */
	{0x27a4,    0xb1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(4) */
	{0x27a5,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(4) */
	{0x27a6,    0xc3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(4) */
	{0x27a7,    0x5c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(4) */
	{0x27ae,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(4) */
	{0x27af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(4) */
	{0x27b0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(4) */
	{0x27b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(4) */
	{0x27b2,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(4) */
	{0x27b3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(4) */
	{0x27b4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(4) */
	{0x27b5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(4) */
	{0x27b6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(4) */
	{0x27b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(4) */
	{0x27b8,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(4) */
	{0x27b9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(4) */
	{0x27ba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(4) */
	{0x27bb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(4) */
	{0x27bc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(4) */
	{0x27bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(4) */
	{0x27be,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(4) */
	{0x27bf,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(4) */
	{0x2800,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(5) */
	{0x2801,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(5) */
	{0x2810,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(5) */
	{0x2811,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(5) */
	{0x2812,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(5) */
	{0x2813,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(5) */
	{0x2814,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(5) */
	{0x2815,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(5) */
	{0x2820,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(5) */
	{0x2821,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(5) */
	{0x2822,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(5) */
	{0x2840,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_FRESGEN(3) */
	{0x2850,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_TBUSSEL(3) */
	{0x2851,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_BYPASSEN(3) */
	{0x2899,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG1(3) */
	{0x289a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG0(3) */
	{0x28a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENERAL(3) */
	{0x28a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENCFG2(3) */
	{0x28a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGSTATUS(3) */
	{0x28a3,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSRSCFG(3) */
	{0x28a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSTTSRS(3) */
	{0x2900,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(5) */
	{0x2901,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(5) */
	{0x2902,    0xe1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(5) */
	{0x2903,    0xf6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(5) */
	{0x2910,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(5) */
	{0x2912,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(5) */
	{0x2913,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(5) */
	{0x2916,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(5) */
	{0x2917,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(5) */
	{0x2918,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(5) */
	{0x2919,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(5) */
	{0x291a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(5) */
	{0x291b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(5) */
	{0x291c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(5) */
	{0x291d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(5) */
	{0x2920,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(5) */
	{0x2922,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(5) */
	{0x2923,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(5) */
	{0x2924,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(5) */
	{0x2925,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(5) */
	{0x2926,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(5) */
	{0x2927,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(5) */
	{0x2928,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(5) */
	{0x2929,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(5) */
	{0x292a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(5) */
	{0x292b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(5) */
	{0x2930,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(5) */
	{0x2931,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(5) */
	{0x2932,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(5) */
	{0x2933,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(5) */
	{0x2934,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(5) */
	{0x2935,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(5) */
	{0x2936,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(5) */
	{0x2937,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(5) */
	{0x2938,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(5) */
	{0x2939,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(5) */
	{0x293a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(5) */
	{0x2940,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(5) */
	{0x2941,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(5) */
	{0x2942,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(5) */
	{0x2943,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(5) */
	{0x2944,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(5) */
	{0x2948,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(5) */
	{0x2949,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(5) */
	{0x294a,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(5) */
	{0x2950,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(5) */
	{0x2951,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(5) */
	{0x2952,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(5) */
	{0x2953,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(5) */
	{0x2954,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(5) */
	{0x2955,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(5) */
	{0x2956,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(5) */
	{0x2957,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(5) */
	{0x2958,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(5) */
	{0x2959,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(5) */
	{0x295a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(5) */
	{0x295b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(5) */
	{0x295c,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(5) */
	{0x295d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(5) */
	{0x295e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(5) */
	{0x2970,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(5) */
	{0x2971,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(5) */
	{0x2972,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(5) */
	{0x2973,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(5) */
	{0x2974,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(5) */
	{0x2975,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(5) */
	{0x2980,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(5) */
	{0x2981,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(5) */
	{0x2982,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(5) */
	{0x2983,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(5) */
	{0x2984,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(5) */
	{0x2985,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(5) */
	{0x2986,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(5) */
	{0x2987,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(5) */
	{0x2988,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(5) */
	{0x2990,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(5) */
	{0x2991,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(5) */
	{0x2992,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(5) */
	{0x2993,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(5) */
	{0x2994,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(5) */
	{0x2995,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(5) */
	{0x2996,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(5) */
	{0x2997,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(5) */
	{0x2998,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(5) */
	{0x2999,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(5) */
	{0x299a,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(5) */
	{0x299b,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(5) */
	{0x299c,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(5) */
	{0x299d,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(5) */
	{0x299e,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(5) */
	{0x299f,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(5) */
	{0x29a0,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(5) */
	{0x29a1,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(5) */
	{0x29a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(5) */
	{0x29a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(5) */
	{0x29a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(5) */
	{0x29a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(5) */
	{0x29a6,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(5) */
	{0x29a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(5) */
	{0x29a8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(5) */
	{0x29b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(5) */
	{0x29b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(5) */
	{0x29b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(5) */
	{0x29b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(5) */
	{0x29b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(5) */
	{0x29b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(5) */
	{0x29b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(5) */
	{0x29b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(5) */
	{0x29b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(5) */
	{0x29b9,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(5) */
	{0x29ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(5) */
	{0x29bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(5) */
	{0x29bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(5) */
	{0x29bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(5) */
	{0x29be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(5) */
	{0x29bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(5) */
	{0x29c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(5) */
	{0x29c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(5) */
	{0x29c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(5) */
	{0x29c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(5) */
	{0x29c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(5) */
	{0x29c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(5) */
	{0x29c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(5) */
	{0x29c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(5) */
	{0x29c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(5) */
	{0x29c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(5) */
	{0x29ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(5) */
	{0x29cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(5) */
	{0x29cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(5) */
	{0x29cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(5) */
	{0x29ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(5) */
	{0x29cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(5) */
	{0x29d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(5) */
	{0x29d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(5) */
	{0x29d2,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(5) */
	{0x29d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(5) */
	{0x29d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(5) */
	{0x29d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(5) */
	{0x29d6,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(5) */
	{0x29d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(5) */
	{0x29d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(5) */
	{0x29d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(5) */
	{0x29da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(5) */
	{0x29db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(5) */
	{0x29dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(5) */
	{0x29dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(5) */
	{0x29de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(5) */
	{0x29e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(5) */
	{0x29e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(5) */
	{0x29e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(5) */
	{0x29e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(5) */
	{0x29e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(5) */
	{0x29e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(5) */
	{0x29e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(5) */
	{0x29e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(5) */
	{0x29e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(5) */
	{0x29e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(5) */
	{0x29ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(5) */
	{0x29eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(5) */
	{0x29ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(5) */
	{0x29ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(5) */
	{0x29f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(5) */
	{0x29f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(5) */
	{0x29f2,    0xa6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(5) */
	{0x29f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(5) */
	{0x29f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(5) */
	{0x29f5,    0xe6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(5) */
	{0x29f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(5) */
	{0x29f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(5) */
	{0x29f8,    0xc4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(5) */
	{0x29fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(5) */
	{0x29fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(5) */
	{0x29fe,    0xa6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(5) */
	{0x29ff,    0x68,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(5) */
	{0x2a00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(5) */
	{0x2a01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(5) */
	{0x2a02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(5) */
	{0x2a03,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(5) */
	{0x2a04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(5) */
	{0x2a05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(5) */
	{0x2a06,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(5) */
	{0x2a07,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(5) */
	{0x2a08,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(5) */
	{0x2a10,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(5) */
	{0x2a11,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(5) */
	{0x2a12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(5) */
	{0x2a13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(5) */
	{0x2a14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(5) */
	{0x2a15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(5) */
	{0x2a16,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(5) */
	{0x2a17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(5) */
	{0x2a18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(5) */
	{0x2a19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(5) */
	{0x2a1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(5) */
	{0x2a1b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(5) */
	{0x2a1c,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(5) */
	{0x2a20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(5) */
	{0x2a21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(5) */
	{0x2a22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(5) */
	{0x2a23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(5) */
	{0x2a24,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(5) */
	{0x2a25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(5) */
	{0x2a26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(5) */
	{0x2a27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(5) */
	{0x2a28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(5) */
	{0x2a29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(5) */
	{0x2a2a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(5) */
	{0x2a2b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(5) */
	{0x2a2c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(5) */
	{0x2a2d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(5) */
	{0x2a2e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(5) */
	{0x2a2f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(5) */
	{0x2a30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(5) */
	{0x2a31,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(5) */
	{0x2a32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(5) */
	{0x2a33,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(5) */
	{0x2a34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(5) */
	{0x2a35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(5) */
	{0x2a36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(5) */
	{0x2a37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(5) */
	{0x2a38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(5) */
	{0x2a39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(5) */
	{0x2a40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(5) */
	{0x2a41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(5) */
	{0x2a42,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(5) */
	{0x2a43,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(5) */
	{0x2a44,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(5) */
	{0x2a45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(5) */
	{0x2a46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(5) */
	{0x2a47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(5) */
	{0x2a48,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(5) */
	{0x2a49,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(5) */
	{0x2a4a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(5) */
	{0x2a4b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(5) */
	{0x2a4c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(5) */
	{0x2a4d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(5) */
	{0x2a4e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(5) */
	{0x2a4f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(5) */
	{0x2a50,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(5) */
	{0x2a51,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(5) */
	{0x2a52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(5) */
	{0x2a53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(5) */
	{0x2a54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(5) */
	{0x2a55,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(5) */
	{0x2a56,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(5) */
	{0x2a57,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(5) */
	{0x2a58,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(5) */
	{0x2a59,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(5) */
	{0x2a5a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(5) */
	{0x2a5b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(5) */
	{0x2a5c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(5) */
	{0x2a5d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(5) */
	{0x2a5e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(5) */
	{0x2a5f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(5) */
	{0x2a60,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(5) */
	{0x2a61,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(5) */
	{0x2a62,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(5) */
	{0x2a63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(5) */
	{0x2a64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(5) */
	{0x2a65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(5) */
	{0x2a68,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(5) */
	{0x2a69,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(5) */
	{0x2a6a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(5) */
	{0x2a6b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(5) */
	{0x2a6c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(5) */
	{0x2a6d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(5) */
	{0x2a6e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(5) */
	{0x2a6f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(5) */
	{0x2a70,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(5) */
	{0x2a71,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(5) */
	{0x2a72,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(5) */
	{0x2a73,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(5) */
	{0x2a74,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(5) */
	{0x2a75,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(5) */
	{0x2a76,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(5) */
	{0x2a77,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(5) */
	{0x2a84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(5) */
	{0x2a85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(5) */
	{0x2a86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(5) */
	{0x2a87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(5) */
	{0x2a88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(5) */
	{0x2a89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(5) */
	{0x2a8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(5) */
	{0x2a8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(5) */
	{0x2a98,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(5) */
	{0x2a99,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(5) */
	{0x2a9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(5) */
	{0x2aa0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(5) */
	{0x2aa1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(5) */
	{0x2aa2,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(5) */
	{0x2aa3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(5) */
	{0x2aa4,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(5) */
	{0x2aa5,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(5) */
	{0x2aa6,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(5) */
	{0x2aa7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(5) */
	{0x2aa8,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(5) */
	{0x2aa9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(5) */
	{0x2aaa,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(5) */
	{0x2aab,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(5) */
	{0x2aac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(5) */
	{0x2aad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(5) */
	{0x2aae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(5) */
	{0x2aaf,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(5) */
	{0x2ac0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(5) */
	{0x2ac1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(5) */
	{0x2ac2,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(5) */
	{0x2ac3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(5) */
	{0x2ac4,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(5) */
	{0x2ac5,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(5) */
	{0x2ac6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(5) */
	{0x2ad0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(5) */
	{0x2ad1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(5) */
	{0x2ad2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(5) */
	{0x2ad3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(5) */
	{0x2ad4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(5) */
	{0x2ad5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(5) */
	{0x2ad6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(5) */
	{0x2ad7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(5) */
	{0x2ad8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(5) */
	{0x2ad9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(5) */
	{0x2ada,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(5) */
	{0x2adb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(5) */
	{0x2adc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(5) */
	{0x2add,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(5) */
	{0x2ade,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(5) */
	{0x2adf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(5) */
	{0x2ae0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(5) */
	{0x2ae1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(5) */
	{0x2ae2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(5) */
	{0x2ae3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(5) */
	{0x2ae4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(5) */
	{0x2ae5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(5) */
	{0x2ae6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(5) */
	{0x2ae7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(5) */
	{0x2aec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(5) */
	{0x2aed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(5) */
	{0x2aee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(5) */
	{0x2b00,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(5) */
	{0x2b01,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(5) */
	{0x2b02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(5) */
	{0x2b03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(5) */
	{0x2b04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(5) */
	{0x2b05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(5) */
	{0x2b06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(5) */
	{0x2b07,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(5) */
	{0x2b08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(5) */
	{0x2b09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(5) */
	{0x2b0a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(5) */
	{0x2b0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(5) */
	{0x2b0c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(5) */
	{0x2b0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(5) */
	{0x2b0e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(5) */
	{0x2b0f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(5) */
	{0x2b10,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(5) */
	{0x2b11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(5) */
	{0x2b12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(5) */
	{0x2b13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(5) */
	{0x2b14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(5) */
	{0x2b15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(5) */
	{0x2b16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(5) */
	{0x2b17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(5) */
	{0x2b18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(5) */
	{0x2b19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(5) */
	{0x2b1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(5) */
	{0x2b1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(5) */
	{0x2b1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(5) */
	{0x2b1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(5) */
	{0x2b1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(5) */
	{0x2b1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(5) */
	{0x2b20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(5) */
	{0x2b21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(5) */
	{0x2b22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(5) */
	{0x2b23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(5) */
	{0x2b24,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(5) */
	{0x2b25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(5) */
	{0x2b26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(5) */
	{0x2b27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(5) */
	{0x2b28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(5) */
	{0x2b29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(5) */
	{0x2b2a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(5) */
	{0x2b2b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(5) */
	{0x2b2c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(5) */
	{0x2b2d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(5) */
	{0x2b2e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(5) */
	{0x2b2f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(5) */
	{0x2b30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(5) */
	{0x2b31,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(5) */
	{0x2b60,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(5) */
	{0x2b61,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(5) */
	{0x2b62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(5) */
	{0x2b63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(5) */
	{0x2b64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(5) */
	{0x2b65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(5) */
	{0x2b66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(5) */
	{0x2b67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(5) */
	{0x2b68,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(5) */
	{0x2b69,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(5) */
	{0x2b6a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(5) */
	{0x2b6b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(5) */
	{0x2b6c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(5) */
	{0x2b6d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(5) */
	{0x2b6e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(5) */
	{0x2b6f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(5) */
	{0x2b80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(5) */
	{0x2b81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(5) */
	{0x2b82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(5) */
	{0x2b83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(5) */
	{0x2b84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(5) */
	{0x2b85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(5) */
	{0x2b86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(5) */
	{0x2b87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(5) */
	{0x2b88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(5) */
	{0x2b89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(5) */
	{0x2b8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(5) */
	{0x2b8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(5) */
	{0x2ba0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(5) */
	{0x2ba1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(5) */
	{0x2ba2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(5) */
	{0x2ba3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(5) */
	{0x2ba4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(5) */
	{0x2ba5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(5) */
	{0x2ba6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(5) */
	{0x2bb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(5) */
	{0x2bb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(5) */
	{0x2bb2,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(5) */
	{0x2bb3,    0x95,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(5) */
	{0x2bb4,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(5) */
	{0x2bb5,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(5) */
	{0x2bc0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(5) */
	{0x2bc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(5) */
	{0x2bc2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(5) */
	{0x2bc3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(5) */
	{0x2bc4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(5) */
	{0x2bc5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(5) */
	{0x2bc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(5) */
	{0x2bc7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(5) */
	{0x2bc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(5) */
	{0x2be0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(5) */
	{0x2be1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(5) */
	{0x2be2,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(5) */
	{0x2be3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(5) */
	{0x2be4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(5) */
	{0x2be5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(5) */
	{0x2be6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(5) */
	{0x2be7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(5) */
	{0x2be8,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(5) */
	{0x2be9,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(5) */
	{0x2bea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(5) */
	{0x2beb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(5) */
	{0x2bec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(5) */
	{0x2bed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(5) */
	{0x2bee,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(5) */
	{0x2bef,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(5) */
	{0x2c00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(5) */
	{0x2c01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(5) */
	{0x2c02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(5) */
	{0x2c03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(5) */
	{0x2c04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(5) */
	{0x2c05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(5) */
	{0x2c06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(5) */
	{0x2c10,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(5) */
	{0x2c11,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(5) */
	{0x2c12,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(5) */
	{0x2c13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(5) */
	{0x2c14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(5) */
	{0x2c15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(5) */
	{0x2c16,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(5) */
	{0x2c17,    0x86,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(5) */
	{0x2c18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(5) */
	{0x2c19,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(5) */
	{0x2c1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(5) */
	{0x2c1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(5) */
	{0x2c1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(5) */
	{0x2c1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(5) */
	{0x2c1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(5) */
	{0x2c80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(5) */
	{0x2c81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(5) */
	{0x2c82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(5) */
	{0x2c83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(5) */
	{0x2c84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(5) */
	{0x2c85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(5) */
	{0x2c86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(5) */
	{0x2c87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(5) */
	{0x2c88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(5) */
	{0x2c89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(5) */
	{0x2c8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(5) */
	{0x2c8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(5) */
	{0x2c8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(5) */
	{0x2c8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(5) */
	{0x2c8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(5) */
	{0x2c8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(5) */
	{0x2c90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(5) */
	{0x2c91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(5) */
	{0x2c92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(5) */
	{0x2c93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(5) */
	{0x2c94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(5) */
	{0x2c95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(5) */
	{0x2c96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(5) */
	{0x2c97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(5) */
	{0x2c98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(5) */
	{0x2c9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(5) */
	{0x2c9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(5) */
	{0x2cac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(5) */
	{0x2cad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(5) */
	{0x2cae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(5) */
	{0x2caf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(5) */
	{0x2cb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(5) */
	{0x2cb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(5) */
	{0x2cb2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(5) */
	{0x2cb3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(5) */
	{0x2cb4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(5) */
	{0x2cb5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(5) */
	{0x2cb6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(5) */
	{0x2cb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(5) */
	{0x2cb8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(5) */
	{0x2cb9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(5) */
	{0x2cba,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(5) */
	{0x2cbb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(5) */
	{0x2cbc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(5) */
	{0x2cbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(5) */
	{0x2cbe,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(5) */
	{0x2cbf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(5) */
	{0x2cc0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(5) */
	{0x2cc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(5) */
	{0x2cc2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(5) */
	{0x2cc3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(5) */
	{0x2cc4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(5) */
	{0x2cc5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(5) */
	{0x2cc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(5) */
	{0x2cc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(5) */
	{0x2cc9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(5) */
	{0x2cca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(5) */
	{0x2cf0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(5) */
	{0x2d00,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(5) */
	{0x2d01,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(5) */
	{0x2d02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(5) */
	{0x2d03,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(5) */
	{0x2d04,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(5) */
	{0x2d05,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(5) */
	{0x2d06,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(5) */
	{0x2d07,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(5) */
	{0x2d08,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(5) */
	{0x2d09,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(5) */
	{0x2d0a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(5) */
	{0x2d0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(5) */
	{0x2d10,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(5) */
	{0x2d11,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(5) */
	{0x2d12,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(5) */
	{0x2d13,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(5) */
	{0x2d14,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(5) */
	{0x2d18,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(5) */
	{0x2d19,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(5) */
	{0x2d1a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(5) */
	{0x2d1b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(5) */
	{0x2d1c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(5) */
	{0x2d1d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(5) */
	{0x2d20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(5) */
	{0x2d21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(5) */
	{0x2d22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(5) */
	{0x2d80,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(5) */
	{0x2d81,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(5) */
	{0x2d82,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(5) */
	{0x2d83,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(5) */
	{0x2d84,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(5) */
	{0x2d85,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(5) */
	{0x2d86,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(5) */
	{0x2d87,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(5) */
	{0x2d88,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(5) */
	{0x2d89,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(5) */
	{0x2d8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(5) */
	{0x2d8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(5) */
	{0x2d8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(5) */
	{0x2d8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(5) */
	{0x2e00,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(5) */
	{0x2e01,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(5) */
	{0x2e02,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(5) */
	{0x2e03,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(5) */
	{0x2e04,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(5) */
	{0x2e05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(5) */
	{0x2e06,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(5) */
	{0x2e07,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(5) */
	{0x2e08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(5) */
	{0x2e09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(5) */
	{0x2e0a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(5) */
	{0x2e0b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(5) */
	{0x2e0c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(5) */
	{0x2e0d,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(5) */
	{0x2e0e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(5) */
	{0x2e0f,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(5) */
	{0x2e10,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(5) */
	{0x2e11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(5) */
	{0x2e12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(5) */
	{0x2e13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(5) */
	{0x2e14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(5) */
	{0x2e15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(5) */
	{0x2e16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(5) */
	{0x2e17,    0x78,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(5) */
	{0x2e18,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(5) */
	{0x2e19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(5) */
	{0x2e1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(5) */
	{0x2e1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(5) */
	{0x2e1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(5) */
	{0x2e1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(5) */
	{0x2e1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(5) */
	{0x2e1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(5) */
	{0x2e20,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(5) */
	{0x2e21,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(5) */
	{0x2e22,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(5) */
	{0x2e24,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(5) */
	{0x2e25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(5) */
	{0x2e26,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(5) */
	{0x2e27,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(5) */
	{0x2e28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(5) */
	{0x2e29,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(5) */
	{0x2e2a,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(5) */
	{0x2e30,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(5) */
	{0x2e31,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(5) */
	{0x2e32,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(5) */
	{0x2e33,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(5) */
	{0x2e34,    0x7e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(5) */
	{0x2e35,    0xea,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(5) */
	{0x2e36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(5) */
	{0x2e37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(5) */
	{0x2e38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(5) */
	{0x2e39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(5) */
	{0x2e3a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(5) */
	{0x2e3b,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(5) */
	{0x2e3c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(5) */
	{0x2e3d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(5) */
	{0x2e3e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(5) */
	{0x2e3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(5) */
	{0x2e40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(5) */
	{0x2e41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(5) */
	{0x2e42,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(5) */
	{0x2e43,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(5) */
	{0x2e44,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(5) */
	{0x2e45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(5) */
	{0x2e46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(5) */
	{0x2e47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(5) */
	{0x2e50,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(5) */
	{0x2e51,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(5) */
	{0x2e52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(5) */
	{0x2e53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(5) */
	{0x2e54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(5) */
	{0x2e60,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(5) */
	{0x2e61,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(5) */
	{0x2e62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(5) */
	{0x2e63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(5) */
	{0x2e64,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(5) */
	{0x2e65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(5) */
	{0x2e66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(5) */
	{0x2e67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(5) */
	{0x2e70,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(5) */
	{0x2e71,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(5) */
	{0x2e72,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(5) */
	{0x2e73,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(5) */
	{0x2e74,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(5) */
	{0x2e75,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(5) */
	{0x2e76,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(5) */
	{0x2e77,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(5) */
	{0x2e80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(5) */
	{0x2e81,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(5) */
	{0x2e82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(5) */
	{0x2e83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(5) */
	{0x2e84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(5) */
	{0x2e85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(5) */
	{0x2e86,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(5) */
	{0x2e87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(5) */
	{0x2e88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(5) */
	{0x2e89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(5) */
	{0x2e8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(5) */
	{0x2e8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(5) */
	{0x2e8c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(5) */
	{0x2e8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(5) */
	{0x2e8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(5) */
	{0x2e90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(5) */
	{0x2e91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(5) */
	{0x2e92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(5) */
	{0x2e93,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(5) */
	{0x2e94,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(5) */
	{0x2e95,    0x3d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(5) */
	{0x2ec0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(5) */
	{0x2ec1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(5) */
	{0x2ec2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(5) */
	{0x2ec3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(5) */
	{0x2ec4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(5) */
	{0x2ec5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(5) */
	{0x2ec6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(5) */
	{0x2ec7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(5) */
	{0x2ec8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(5) */
	{0x2ec9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(5) */
	{0x2eca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(5) */
	{0x2ecb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(5) */
	{0x2ecc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(5) */
	{0x2ed0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(5) */
	{0x2ed1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(5) */
	{0x2ed2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(5) */
	{0x2ed3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(5) */
	{0x2ed8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(5) */
	{0x2ed9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(5) */
	{0x2eda,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(5) */
	{0x2f00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(5) */
	{0x2f01,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(5) */
	{0x2f02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(5) */
	{0x2f03,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(5) */
	{0x2f04,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(5) */
	{0x2f05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(5) */
	{0x2f06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(5) */
	{0x2f07,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(5) */
	{0x2f08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(5) */
	{0x2f09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(5) */
	{0x2f0c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(5) */
	{0x2f0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(5) */
	{0x2f10,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(5) */
	{0x2f11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(5) */
	{0x2f12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(5) */
	{0x2f13,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(5) */
	{0x2f14,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(5) */
	{0x2f15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(5) */
	{0x2f16,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(5) */
	{0x2f17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(5) */
	{0x2f18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(5) */
	{0x2f20,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(5) */
	{0x2f21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(5) */
	{0x2f22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(5) */
	{0x2f23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(5) */
	{0x2f24,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(5) */
	{0x2f25,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(5) */
	{0x2f26,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(5) */
	{0x2f27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(5) */
	{0x2f28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(5) */
	{0x2f29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(5) */
	{0x2f2a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(5) */
	{0x2f30,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(5) */
	{0x2f31,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(5) */
	{0x2f32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(5) */
	{0x2f34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(5) */
	{0x2f35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(5) */
	{0x2f36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(5) */
	{0x2f37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(5) */
	{0x2f3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(5) */
	{0x2f80,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(5) */
	{0x2f81,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(5) */
	{0x2f82,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(5) */
	{0x2f83,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(5) */
	{0x2f84,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(5) */
	{0x2f85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(5) */
	{0x2f88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(5) */
	{0x2f89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(5) */
	{0x2f8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(5) */
	{0x2f8b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(5) */
	{0x2f8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(5) */
	{0x2f8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(5) */
	{0x2f90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(5) */
	{0x2f91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(5) */
	{0x2f92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(5) */
	{0x2f93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(5) */
	{0x2f94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(5) */
	{0x2f95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(5) */
	{0x2f96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(5) */
	{0x2f97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(5) */
	{0x2f98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(5) */
	{0x2f99,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(5) */
	{0x2f9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(5) */
	{0x2f9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(5) */
	{0x2f9c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(5) */
	{0x2f9d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(5) */
	{0x2fa0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(5) */
	{0x2fa1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(5) */
	{0x2fa2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(5) */
	{0x2fa3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(5) */
	{0x2fa4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(5) */
	{0x2fa5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(5) */
	{0x2fa6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(5) */
	{0x2fa7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(5) */
	{0x2fae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(5) */
	{0x2faf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(5) */
	{0x2fb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(5) */
	{0x2fb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(5) */
	{0x2fb2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(5) */
	{0x2fb3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(5) */
	{0x2fb4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(5) */
	{0x2fb5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(5) */
	{0x2fb6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(5) */
	{0x2fb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(5) */
	{0x2fb8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(5) */
	{0x2fb9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(5) */
	{0x2fba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(5) */
	{0x2fbb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(5) */
	{0x2fbc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(5) */
	{0x2fbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(5) */
	{0x2fbe,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(5) */
	{0x2fbf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(5) */
	{0x3000,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(6) */
	{0x3001,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(6) */
	{0x3010,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(6) */
	{0x3011,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(6) */
	{0x3012,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(6) */
	{0x3013,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(6) */
	{0x3014,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(6) */
	{0x3015,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(6) */
	{0x3020,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(6) */
	{0x3021,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(6) */
	{0x3022,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(6) */
	{0x3100,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(6) */
	{0x3101,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(6) */
	{0x3102,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(6) */
	{0x3103,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(6) */
	{0x3110,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(6) */
	{0x3112,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(6) */
	{0x3113,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(6) */
	{0x3116,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(6) */
	{0x3117,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(6) */
	{0x3118,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(6) */
	{0x3119,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(6) */
	{0x311a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(6) */
	{0x311b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(6) */
	{0x311c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(6) */
	{0x311d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(6) */
	{0x3120,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(6) */
	{0x3122,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(6) */
	{0x3123,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(6) */
	{0x3124,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(6) */
	{0x3125,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(6) */
	{0x3126,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(6) */
	{0x3127,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(6) */
	{0x3128,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(6) */
	{0x3129,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(6) */
	{0x312a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(6) */
	{0x312b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(6) */
	{0x3130,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(6) */
	{0x3131,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(6) */
	{0x3132,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(6) */
	{0x3133,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(6) */
	{0x3134,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(6) */
	{0x3135,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(6) */
	{0x3136,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(6) */
	{0x3137,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(6) */
	{0x3138,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(6) */
	{0x3139,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(6) */
	{0x313a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(6) */
	{0x3140,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(6) */
	{0x3141,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(6) */
	{0x3142,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(6) */
	{0x3143,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(6) */
	{0x3144,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(6) */
	{0x3148,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(6) */
	{0x3149,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(6) */
	{0x314a,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(6) */
	{0x3150,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(6) */
	{0x3151,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(6) */
	{0x3152,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(6) */
	{0x3153,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(6) */
	{0x3154,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(6) */
	{0x3155,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(6) */
	{0x3156,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(6) */
	{0x3157,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(6) */
	{0x3158,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(6) */
	{0x3159,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(6) */
	{0x315a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(6) */
	{0x315b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(6) */
	{0x315c,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(6) */
	{0x315d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(6) */
	{0x315e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(6) */
	{0x3170,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(6) */
	{0x3171,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(6) */
	{0x3172,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(6) */
	{0x3173,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(6) */
	{0x3174,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(6) */
	{0x3175,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(6) */
	{0x3180,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(6) */
	{0x3181,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(6) */
	{0x3182,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(6) */
	{0x3183,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(6) */
	{0x3184,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(6) */
	{0x3185,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(6) */
	{0x3186,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(6) */
	{0x3187,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(6) */
	{0x3188,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(6) */
	{0x3190,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(6) */
	{0x3191,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(6) */
	{0x3192,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(6) */
	{0x3193,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(6) */
	{0x3194,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(6) */
	{0x3195,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(6) */
	{0x3196,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(6) */
	{0x3197,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(6) */
	{0x3198,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(6) */
	{0x3199,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(6) */
	{0x319a,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(6) */
	{0x319b,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(6) */
	{0x319c,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(6) */
	{0x319d,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(6) */
	{0x319e,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(6) */
	{0x319f,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(6) */
	{0x31a0,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(6) */
	{0x31a1,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(6) */
	{0x31a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(6) */
	{0x31a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(6) */
	{0x31a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(6) */
	{0x31a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(6) */
	{0x31a6,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(6) */
	{0x31a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(6) */
	{0x31a8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(6) */
	{0x31b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(6) */
	{0x31b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(6) */
	{0x31b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(6) */
	{0x31b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(6) */
	{0x31b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(6) */
	{0x31b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(6) */
	{0x31b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(6) */
	{0x31b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(6) */
	{0x31b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(6) */
	{0x31b9,    0xf9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(6) */
	{0x31ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(6) */
	{0x31bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(6) */
	{0x31bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(6) */
	{0x31bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(6) */
	{0x31be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(6) */
	{0x31bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(6) */
	{0x31c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(6) */
	{0x31c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(6) */
	{0x31c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(6) */
	{0x31c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(6) */
	{0x31c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(6) */
	{0x31c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(6) */
	{0x31c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(6) */
	{0x31c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(6) */
	{0x31c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(6) */
	{0x31c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(6) */
	{0x31ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(6) */
	{0x31cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(6) */
	{0x31cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(6) */
	{0x31cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(6) */
	{0x31ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(6) */
	{0x31cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(6) */
	{0x31d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(6) */
	{0x31d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(6) */
	{0x31d2,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(6) */
	{0x31d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(6) */
	{0x31d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(6) */
	{0x31d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(6) */
	{0x31d6,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(6) */
	{0x31d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(6) */
	{0x31d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(6) */
	{0x31d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(6) */
	{0x31da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(6) */
	{0x31db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(6) */
	{0x31dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(6) */
	{0x31dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(6) */
	{0x31de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(6) */
	{0x31e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(6) */
	{0x31e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(6) */
	{0x31e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(6) */
	{0x31e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(6) */
	{0x31e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(6) */
	{0x31e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(6) */
	{0x31e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(6) */
	{0x31e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(6) */
	{0x31e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(6) */
	{0x31e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(6) */
	{0x31ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(6) */
	{0x31eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(6) */
	{0x31ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(6) */
	{0x31ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(6) */
	{0x31f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(6) */
	{0x31f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(6) */
	{0x31f2,    0xa7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(6) */
	{0x31f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(6) */
	{0x31f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(6) */
	{0x31f5,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(6) */
	{0x31f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(6) */
	{0x31f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(6) */
	{0x31f8,    0xc5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(6) */
	{0x31fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(6) */
	{0x31fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(6) */
	{0x31fe,    0xa7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(6) */
	{0x31ff,    0xbb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(6) */
	{0x3200,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(6) */
	{0x3201,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(6) */
	{0x3202,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(6) */
	{0x3203,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(6) */
	{0x3204,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(6) */
	{0x3205,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(6) */
	{0x3206,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(6) */
	{0x3207,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(6) */
	{0x3208,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(6) */
	{0x3210,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(6) */
	{0x3211,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(6) */
	{0x3212,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(6) */
	{0x3213,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(6) */
	{0x3214,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(6) */
	{0x3215,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(6) */
	{0x3216,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(6) */
	{0x3217,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(6) */
	{0x3218,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(6) */
	{0x3219,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(6) */
	{0x321a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(6) */
	{0x321b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(6) */
	{0x321c,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(6) */
	{0x3220,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(6) */
	{0x3221,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(6) */
	{0x3222,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(6) */
	{0x3223,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(6) */
	{0x3224,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(6) */
	{0x3225,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(6) */
	{0x3226,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(6) */
	{0x3227,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(6) */
	{0x3228,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(6) */
	{0x3229,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(6) */
	{0x322a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(6) */
	{0x322b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(6) */
	{0x322c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(6) */
	{0x322d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(6) */
	{0x322e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(6) */
	{0x322f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(6) */
	{0x3230,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(6) */
	{0x3231,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(6) */
	{0x3232,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(6) */
	{0x3233,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(6) */
	{0x3234,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(6) */
	{0x3235,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(6) */
	{0x3236,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(6) */
	{0x3237,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(6) */
	{0x3238,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(6) */
	{0x3239,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(6) */
	{0x3240,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(6) */
	{0x3241,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(6) */
	{0x3242,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(6) */
	{0x3243,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(6) */
	{0x3244,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(6) */
	{0x3245,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(6) */
	{0x3246,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(6) */
	{0x3247,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(6) */
	{0x3248,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(6) */
	{0x3249,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(6) */
	{0x324a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(6) */
	{0x324b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(6) */
	{0x324c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(6) */
	{0x324d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(6) */
	{0x324e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(6) */
	{0x324f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(6) */
	{0x3250,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(6) */
	{0x3251,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(6) */
	{0x3252,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(6) */
	{0x3253,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(6) */
	{0x3254,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(6) */
	{0x3255,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(6) */
	{0x3256,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(6) */
	{0x3257,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(6) */
	{0x3258,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(6) */
	{0x3259,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(6) */
	{0x325a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(6) */
	{0x325b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(6) */
	{0x325c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(6) */
	{0x325d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(6) */
	{0x325e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(6) */
	{0x325f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(6) */
	{0x3260,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(6) */
	{0x3261,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(6) */
	{0x3262,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(6) */
	{0x3263,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(6) */
	{0x3264,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(6) */
	{0x3265,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(6) */
	{0x3268,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(6) */
	{0x3269,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(6) */
	{0x326a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(6) */
	{0x326b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(6) */
	{0x326c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(6) */
	{0x326d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(6) */
	{0x326e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(6) */
	{0x326f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(6) */
	{0x3270,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(6) */
	{0x3271,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(6) */
	{0x3272,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(6) */
	{0x3273,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(6) */
	{0x3274,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(6) */
	{0x3275,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(6) */
	{0x3276,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(6) */
	{0x3277,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(6) */
	{0x3284,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(6) */
	{0x3285,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(6) */
	{0x3286,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(6) */
	{0x3287,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(6) */
	{0x3288,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(6) */
	{0x3289,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(6) */
	{0x328a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(6) */
	{0x328b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(6) */
	{0x3298,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(6) */
	{0x3299,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(6) */
	{0x329a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(6) */
	{0x32a0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(6) */
	{0x32a1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(6) */
	{0x32a2,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(6) */
	{0x32a3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(6) */
	{0x32a4,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(6) */
	{0x32a5,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(6) */
	{0x32a6,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(6) */
	{0x32a7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(6) */
	{0x32a8,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(6) */
	{0x32a9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(6) */
	{0x32aa,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(6) */
	{0x32ab,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(6) */
	{0x32ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(6) */
	{0x32ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(6) */
	{0x32ae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(6) */
	{0x32af,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(6) */
	{0x32c0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(6) */
	{0x32c1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(6) */
	{0x32c2,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(6) */
	{0x32c3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(6) */
	{0x32c4,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(6) */
	{0x32c5,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(6) */
	{0x32c6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(6) */
	{0x32d0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(6) */
	{0x32d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(6) */
	{0x32d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(6) */
	{0x32d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(6) */
	{0x32d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(6) */
	{0x32d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(6) */
	{0x32d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(6) */
	{0x32d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(6) */
	{0x32d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(6) */
	{0x32d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(6) */
	{0x32da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(6) */
	{0x32db,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(6) */
	{0x32dc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(6) */
	{0x32dd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(6) */
	{0x32de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(6) */
	{0x32df,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(6) */
	{0x32e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(6) */
	{0x32e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(6) */
	{0x32e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(6) */
	{0x32e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(6) */
	{0x32e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(6) */
	{0x32e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(6) */
	{0x32e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(6) */
	{0x32e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(6) */
	{0x32ec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(6) */
	{0x32ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(6) */
	{0x32ee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(6) */
	{0x3300,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(6) */
	{0x3301,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(6) */
	{0x3302,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(6) */
	{0x3303,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(6) */
	{0x3304,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(6) */
	{0x3305,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(6) */
	{0x3306,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(6) */
	{0x3307,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(6) */
	{0x3308,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(6) */
	{0x3309,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(6) */
	{0x330a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(6) */
	{0x330b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(6) */
	{0x330c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(6) */
	{0x330d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(6) */
	{0x330e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(6) */
	{0x330f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(6) */
	{0x3310,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(6) */
	{0x3311,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(6) */
	{0x3312,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(6) */
	{0x3313,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(6) */
	{0x3314,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(6) */
	{0x3315,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(6) */
	{0x3316,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(6) */
	{0x3317,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(6) */
	{0x3318,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(6) */
	{0x3319,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(6) */
	{0x331a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(6) */
	{0x331b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(6) */
	{0x331c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(6) */
	{0x331d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(6) */
	{0x331e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(6) */
	{0x331f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(6) */
	{0x3320,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(6) */
	{0x3321,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(6) */
	{0x3322,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(6) */
	{0x3323,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(6) */
	{0x3324,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(6) */
	{0x3325,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(6) */
	{0x3326,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(6) */
	{0x3327,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(6) */
	{0x3328,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(6) */
	{0x3329,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(6) */
	{0x332a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(6) */
	{0x332b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(6) */
	{0x332c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(6) */
	{0x332d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(6) */
	{0x332e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(6) */
	{0x332f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(6) */
	{0x3330,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(6) */
	{0x3331,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(6) */
	{0x3360,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(6) */
	{0x3361,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(6) */
	{0x3362,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(6) */
	{0x3363,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(6) */
	{0x3364,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(6) */
	{0x3365,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(6) */
	{0x3366,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(6) */
	{0x3367,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(6) */
	{0x3368,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(6) */
	{0x3369,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(6) */
	{0x336a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(6) */
	{0x336b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(6) */
	{0x336c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(6) */
	{0x336d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(6) */
	{0x336e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(6) */
	{0x336f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(6) */
	{0x3380,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(6) */
	{0x3381,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(6) */
	{0x3382,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(6) */
	{0x3383,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(6) */
	{0x3384,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(6) */
	{0x3385,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(6) */
	{0x3386,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(6) */
	{0x3387,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(6) */
	{0x3388,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(6) */
	{0x3389,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(6) */
	{0x338a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(6) */
	{0x338b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(6) */
	{0x33a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(6) */
	{0x33a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(6) */
	{0x33a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(6) */
	{0x33a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(6) */
	{0x33a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(6) */
	{0x33a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(6) */
	{0x33a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(6) */
	{0x33b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(6) */
	{0x33b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(6) */
	{0x33b2,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(6) */
	{0x33b3,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(6) */
	{0x33b4,    0xf7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(6) */
	{0x33b5,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(6) */
	{0x33c0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(6) */
	{0x33c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(6) */
	{0x33c2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(6) */
	{0x33c3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(6) */
	{0x33c4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(6) */
	{0x33c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(6) */
	{0x33c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(6) */
	{0x33c7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(6) */
	{0x33c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(6) */
	{0x33e0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(6) */
	{0x33e1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(6) */
	{0x33e2,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(6) */
	{0x33e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(6) */
	{0x33e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(6) */
	{0x33e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(6) */
	{0x33e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(6) */
	{0x33e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(6) */
	{0x33e8,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(6) */
	{0x33e9,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(6) */
	{0x33ea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(6) */
	{0x33eb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(6) */
	{0x33ec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(6) */
	{0x33ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(6) */
	{0x33ee,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(6) */
	{0x33ef,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(6) */
	{0x3400,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(6) */
	{0x3401,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(6) */
	{0x3402,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(6) */
	{0x3403,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(6) */
	{0x3404,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(6) */
	{0x3405,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(6) */
	{0x3406,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(6) */
	{0x3410,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(6) */
	{0x3411,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(6) */
	{0x3412,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(6) */
	{0x3413,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(6) */
	{0x3414,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(6) */
	{0x3415,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(6) */
	{0x3416,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(6) */
	{0x3417,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(6) */
	{0x3418,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(6) */
	{0x3419,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(6) */
	{0x341a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(6) */
	{0x341b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(6) */
	{0x341c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(6) */
	{0x341d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(6) */
	{0x341e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(6) */
	{0x3480,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(6) */
	{0x3481,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(6) */
	{0x3482,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(6) */
	{0x3483,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(6) */
	{0x3484,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(6) */
	{0x3485,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(6) */
	{0x3486,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(6) */
	{0x3487,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(6) */
	{0x3488,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(6) */
	{0x3489,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(6) */
	{0x348a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(6) */
	{0x348b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(6) */
	{0x348c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(6) */
	{0x348d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(6) */
	{0x348e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(6) */
	{0x348f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(6) */
	{0x3490,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(6) */
	{0x3491,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(6) */
	{0x3492,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(6) */
	{0x3493,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(6) */
	{0x3494,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(6) */
	{0x3495,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(6) */
	{0x3496,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(6) */
	{0x3497,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(6) */
	{0x3498,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(6) */
	{0x349a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(6) */
	{0x349b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(6) */
	{0x34ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(6) */
	{0x34ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(6) */
	{0x34ae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(6) */
	{0x34af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(6) */
	{0x34b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(6) */
	{0x34b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(6) */
	{0x34b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(6) */
	{0x34b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(6) */
	{0x34b4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(6) */
	{0x34b5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(6) */
	{0x34b6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(6) */
	{0x34b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(6) */
	{0x34b8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(6) */
	{0x34b9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(6) */
	{0x34ba,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(6) */
	{0x34bb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(6) */
	{0x34bc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(6) */
	{0x34bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(6) */
	{0x34be,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(6) */
	{0x34bf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(6) */
	{0x34c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(6) */
	{0x34c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(6) */
	{0x34c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(6) */
	{0x34c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(6) */
	{0x34c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(6) */
	{0x34c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(6) */
	{0x34c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(6) */
	{0x34c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(6) */
	{0x34c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(6) */
	{0x34ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(6) */
	{0x34f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(6) */
	{0x3500,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(6) */
	{0x3501,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(6) */
	{0x3502,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(6) */
	{0x3503,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(6) */
	{0x3504,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(6) */
	{0x3505,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(6) */
	{0x3506,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(6) */
	{0x3507,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(6) */
	{0x3508,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(6) */
	{0x3509,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(6) */
	{0x350a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(6) */
	{0x350b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(6) */
	{0x3510,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(6) */
	{0x3511,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(6) */
	{0x3512,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(6) */
	{0x3513,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(6) */
	{0x3514,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(6) */
	{0x3518,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(6) */
	{0x3519,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(6) */
	{0x351a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(6) */
	{0x351b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(6) */
	{0x351c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(6) */
	{0x351d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(6) */
	{0x3520,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(6) */
	{0x3521,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(6) */
	{0x3522,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(6) */
	{0x3580,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(6) */
	{0x3581,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(6) */
	{0x3582,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(6) */
	{0x3583,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(6) */
	{0x3584,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(6) */
	{0x3585,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(6) */
	{0x3586,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(6) */
	{0x3587,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(6) */
	{0x3588,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(6) */
	{0x3589,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(6) */
	{0x358a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(6) */
	{0x358d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(6) */
	{0x358e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(6) */
	{0x358f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(6) */
	{0x3600,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(6) */
	{0x3601,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(6) */
	{0x3602,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(6) */
	{0x3603,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(6) */
	{0x3604,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(6) */
	{0x3605,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(6) */
	{0x3606,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(6) */
	{0x3607,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(6) */
	{0x3608,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(6) */
	{0x3609,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(6) */
	{0x360a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(6) */
	{0x360b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(6) */
	{0x360c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(6) */
	{0x360d,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(6) */
	{0x360e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(6) */
	{0x360f,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(6) */
	{0x3610,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(6) */
	{0x3611,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(6) */
	{0x3612,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(6) */
	{0x3613,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(6) */
	{0x3614,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(6) */
	{0x3615,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(6) */
	{0x3616,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(6) */
	{0x3617,    0x78,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(6) */
	{0x3618,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(6) */
	{0x3619,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(6) */
	{0x361a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(6) */
	{0x361b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(6) */
	{0x361c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(6) */
	{0x361d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(6) */
	{0x361e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(6) */
	{0x361f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(6) */
	{0x3620,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(6) */
	{0x3621,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(6) */
	{0x3622,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(6) */
	{0x3624,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(6) */
	{0x3625,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(6) */
	{0x3626,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(6) */
	{0x3627,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(6) */
	{0x3628,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(6) */
	{0x3629,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(6) */
	{0x362a,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(6) */
	{0x3630,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(6) */
	{0x3631,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(6) */
	{0x3632,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(6) */
	{0x3633,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(6) */
	{0x3634,    0x7e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(6) */
	{0x3635,    0xea,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(6) */
	{0x3636,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(6) */
	{0x3637,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(6) */
	{0x3638,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(6) */
	{0x3639,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(6) */
	{0x363a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(6) */
	{0x363b,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(6) */
	{0x363c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(6) */
	{0x363d,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(6) */
	{0x363e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(6) */
	{0x363f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(6) */
	{0x3640,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(6) */
	{0x3641,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(6) */
	{0x3642,    0x73,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(6) */
	{0x3643,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(6) */
	{0x3644,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(6) */
	{0x3645,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(6) */
	{0x3646,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(6) */
	{0x3647,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(6) */
	{0x3650,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(6) */
	{0x3651,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(6) */
	{0x3652,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(6) */
	{0x3653,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(6) */
	{0x3654,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(6) */
	{0x3660,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(6) */
	{0x3661,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(6) */
	{0x3662,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(6) */
	{0x3663,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(6) */
	{0x3664,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(6) */
	{0x3665,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(6) */
	{0x3666,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(6) */
	{0x3667,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(6) */
	{0x3670,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(6) */
	{0x3671,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(6) */
	{0x3672,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(6) */
	{0x3673,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(6) */
	{0x3674,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(6) */
	{0x3675,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(6) */
	{0x3676,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(6) */
	{0x3677,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(6) */
	{0x3680,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(6) */
	{0x3681,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(6) */
	{0x3682,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(6) */
	{0x3683,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(6) */
	{0x3684,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(6) */
	{0x3685,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(6) */
	{0x3686,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(6) */
	{0x3687,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(6) */
	{0x3688,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(6) */
	{0x3689,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(6) */
	{0x368a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(6) */
	{0x368b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(6) */
	{0x368c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(6) */
	{0x368d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(6) */
	{0x368f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(6) */
	{0x3690,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(6) */
	{0x3691,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(6) */
	{0x3692,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(6) */
	{0x3693,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(6) */
	{0x3694,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(6) */
	{0x3695,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(6) */
	{0x36c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(6) */
	{0x36c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(6) */
	{0x36c2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(6) */
	{0x36c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(6) */
	{0x36c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(6) */
	{0x36c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(6) */
	{0x36c6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(6) */
	{0x36c7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(6) */
	{0x36c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(6) */
	{0x36c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(6) */
	{0x36ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(6) */
	{0x36cb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(6) */
	{0x36cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(6) */
	{0x36d0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(6) */
	{0x36d1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(6) */
	{0x36d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(6) */
	{0x36d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(6) */
	{0x36d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(6) */
	{0x36d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(6) */
	{0x36da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(6) */
	{0x3700,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(6) */
	{0x3701,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(6) */
	{0x3702,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(6) */
	{0x3703,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(6) */
	{0x3704,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(6) */
	{0x3705,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(6) */
	{0x3706,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(6) */
	{0x3707,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(6) */
	{0x3708,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(6) */
	{0x3709,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(6) */
	{0x370c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(6) */
	{0x370d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(6) */
	{0x3710,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(6) */
	{0x3711,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(6) */
	{0x3712,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(6) */
	{0x3713,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(6) */
	{0x3714,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(6) */
	{0x3715,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(6) */
	{0x3716,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(6) */
	{0x3717,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(6) */
	{0x3718,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(6) */
	{0x3720,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(6) */
	{0x3721,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(6) */
	{0x3722,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(6) */
	{0x3723,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(6) */
	{0x3724,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(6) */
	{0x3725,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(6) */
	{0x3726,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(6) */
	{0x3727,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(6) */
	{0x3728,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(6) */
	{0x3729,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(6) */
	{0x372a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(6) */
	{0x3730,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(6) */
	{0x3731,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(6) */
	{0x3732,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(6) */
	{0x3734,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(6) */
	{0x3735,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(6) */
	{0x3736,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(6) */
	{0x3737,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(6) */
	{0x373f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(6) */
	{0x3780,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(6) */
	{0x3781,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(6) */
	{0x3782,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(6) */
	{0x3783,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(6) */
	{0x3784,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(6) */
	{0x3785,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(6) */
	{0x3788,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(6) */
	{0x3789,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(6) */
	{0x378a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(6) */
	{0x378b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(6) */
	{0x378c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(6) */
	{0x378d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(6) */
	{0x3790,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(6) */
	{0x3791,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(6) */
	{0x3792,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(6) */
	{0x3793,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(6) */
	{0x3794,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(6) */
	{0x3795,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(6) */
	{0x3796,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(6) */
	{0x3797,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(6) */
	{0x3798,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(6) */
	{0x3799,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(6) */
	{0x379a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(6) */
	{0x379b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(6) */
	{0x379c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(6) */
	{0x379d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(6) */
	{0x37a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(6) */
	{0x37a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(6) */
	{0x37a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(6) */
	{0x37a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(6) */
	{0x37a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(6) */
	{0x37a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(6) */
	{0x37a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(6) */
	{0x37a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(6) */
	{0x37ae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(6) */
	{0x37af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(6) */
	{0x37b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(6) */
	{0x37b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(6) */
	{0x37b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(6) */
	{0x37b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(6) */
	{0x37b4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(6) */
	{0x37b5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(6) */
	{0x37b6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(6) */
	{0x37b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(6) */
	{0x37b8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(6) */
	{0x37b9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(6) */
	{0x37ba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(6) */
	{0x37bb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(6) */
	{0x37bc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(6) */
	{0x37bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(6) */
	{0x37be,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(6) */
	{0x37bf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(6) */
	{0x3800,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(7) */
	{0x3801,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(7) */
	{0x3810,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(7) */
	{0x3811,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(7) */
	{0x3812,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(7) */
	{0x3813,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(7) */
	{0x3814,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(7) */
	{0x3815,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(7) */
	{0x3820,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(7) */
	{0x3821,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(7) */
	{0x3822,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(7) */
	{0x3840,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_FRESGEN(4) */
	{0x3850,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_TBUSSEL(4) */
	{0x3851,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_GEN_BYPASSEN(4) */
	{0x3899,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG1(4) */
	{0x389a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_RCDEBUG0(4) */
	{0x38a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENERAL(4) */
	{0x38a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGENCFG2(4) */
	{0x38a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSGSTATUS(4) */
	{0x38a3,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSRSCFG(4) */
	{0x38a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_GEN_TSTTSRS(4) */
	{0x3900,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(7) */
	{0x3901,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(7) */
	{0x3902,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(7) */
	{0x3903,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(7) */
	{0x3910,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(7) */
	{0x3912,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(7) */
	{0x3913,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(7) */
	{0x3916,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(7) */
	{0x3917,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(7) */
	{0x3918,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(7) */
	{0x3919,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(7) */
	{0x391a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(7) */
	{0x391b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(7) */
	{0x391c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(7) */
	{0x391d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(7) */
	{0x3920,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(7) */
	{0x3922,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(7) */
	{0x3923,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(7) */
	{0x3924,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(7) */
	{0x3925,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(7) */
	{0x3926,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(7) */
	{0x3927,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(7) */
	{0x3928,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(7) */
	{0x3929,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(7) */
	{0x392a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(7) */
	{0x392b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(7) */
	{0x3930,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(7) */
	{0x3931,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(7) */
	{0x3932,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(7) */
	{0x3933,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(7) */
	{0x3934,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(7) */
	{0x3935,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(7) */
	{0x3936,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(7) */
	{0x3937,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(7) */
	{0x3938,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(7) */
	{0x3939,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(7) */
	{0x393a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(7) */
	{0x3940,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(7) */
	{0x3941,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(7) */
	{0x3942,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(7) */
	{0x3943,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(7) */
	{0x3944,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(7) */
	{0x3948,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(7) */
	{0x3949,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(7) */
	{0x394a,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(7) */
	{0x3950,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(7) */
	{0x3951,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(7) */
	{0x3952,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(7) */
	{0x3953,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(7) */
	{0x3954,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(7) */
	{0x3955,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(7) */
	{0x3956,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(7) */
	{0x3957,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(7) */
	{0x3958,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(7) */
	{0x3959,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(7) */
	{0x395a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(7) */
	{0x395b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(7) */
	{0x395c,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(7) */
	{0x395d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(7) */
	{0x395e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(7) */
	{0x3970,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(7) */
	{0x3971,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(7) */
	{0x3972,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(7) */
	{0x3973,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(7) */
	{0x3974,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(7) */
	{0x3975,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(7) */
	{0x3980,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(7) */
	{0x3981,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(7) */
	{0x3982,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(7) */
	{0x3983,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(7) */
	{0x3984,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(7) */
	{0x3985,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(7) */
	{0x3986,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(7) */
	{0x3987,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(7) */
	{0x3988,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(7) */
	{0x3990,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(7) */
	{0x3991,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(7) */
	{0x3992,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(7) */
	{0x3993,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(7) */
	{0x3994,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(7) */
	{0x3995,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(7) */
	{0x3996,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(7) */
	{0x3997,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(7) */
	{0x3998,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(7) */
	{0x3999,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(7) */
	{0x399a,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(7) */
	{0x399b,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(7) */
	{0x399c,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(7) */
	{0x399d,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(7) */
	{0x399e,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(7) */
	{0x399f,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(7) */
	{0x39a0,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(7) */
	{0x39a1,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(7) */
	{0x39a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(7) */
	{0x39a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(7) */
	{0x39a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(7) */
	{0x39a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(7) */
	{0x39a6,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(7) */
	{0x39a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(7) */
	{0x39a8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(7) */
	{0x39b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(7) */
	{0x39b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(7) */
	{0x39b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(7) */
	{0x39b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(7) */
	{0x39b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(7) */
	{0x39b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(7) */
	{0x39b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(7) */
	{0x39b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(7) */
	{0x39b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(7) */
	{0x39b9,    0xf8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(7) */
	{0x39ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(7) */
	{0x39bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(7) */
	{0x39bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(7) */
	{0x39bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(7) */
	{0x39be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(7) */
	{0x39bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(7) */
	{0x39c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(7) */
	{0x39c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(7) */
	{0x39c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(7) */
	{0x39c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(7) */
	{0x39c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(7) */
	{0x39c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(7) */
	{0x39c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(7) */
	{0x39c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(7) */
	{0x39c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(7) */
	{0x39c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(7) */
	{0x39ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(7) */
	{0x39cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(7) */
	{0x39cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(7) */
	{0x39cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(7) */
	{0x39ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(7) */
	{0x39cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(7) */
	{0x39d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(7) */
	{0x39d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(7) */
	{0x39d2,    0xb9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(7) */
	{0x39d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(7) */
	{0x39d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(7) */
	{0x39d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(7) */
	{0x39d6,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(7) */
	{0x39d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(7) */
	{0x39d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(7) */
	{0x39d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(7) */
	{0x39da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(7) */
	{0x39db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(7) */
	{0x39dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(7) */
	{0x39dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(7) */
	{0x39de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(7) */
	{0x39e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(7) */
	{0x39e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(7) */
	{0x39e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(7) */
	{0x39e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(7) */
	{0x39e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(7) */
	{0x39e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(7) */
	{0x39e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(7) */
	{0x39e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(7) */
	{0x39e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(7) */
	{0x39e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(7) */
	{0x39ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(7) */
	{0x39eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(7) */
	{0x39ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(7) */
	{0x39ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(7) */
	{0x39f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(7) */
	{0x39f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(7) */
	{0x39f2,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(7) */
	{0x39f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(7) */
	{0x39f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(7) */
	{0x39f5,    0xea,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(7) */
	{0x39f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(7) */
	{0x39f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(7) */
	{0x39f8,    0xc7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(7) */
	{0x39fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(7) */
	{0x39fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(7) */
	{0x39fe,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(7) */
	{0x39ff,    0xa1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(7) */
	{0x3a00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(7) */
	{0x3a01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(7) */
	{0x3a02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(7) */
	{0x3a03,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(7) */
	{0x3a04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(7) */
	{0x3a05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(7) */
	{0x3a06,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(7) */
	{0x3a07,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(7) */
	{0x3a08,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(7) */
	{0x3a10,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(7) */
	{0x3a11,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(7) */
	{0x3a12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(7) */
	{0x3a13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(7) */
	{0x3a14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(7) */
	{0x3a15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(7) */
	{0x3a16,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(7) */
	{0x3a17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(7) */
	{0x3a18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(7) */
	{0x3a19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(7) */
	{0x3a1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(7) */
	{0x3a1b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(7) */
	{0x3a1c,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(7) */
	{0x3a20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(7) */
	{0x3a21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(7) */
	{0x3a22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(7) */
	{0x3a23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(7) */
	{0x3a24,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(7) */
	{0x3a25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(7) */
	{0x3a26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(7) */
	{0x3a27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(7) */
	{0x3a28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(7) */
	{0x3a29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(7) */
	{0x3a2a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(7) */
	{0x3a2b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(7) */
	{0x3a2c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(7) */
	{0x3a2d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(7) */
	{0x3a2e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(7) */
	{0x3a2f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(7) */
	{0x3a30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(7) */
	{0x3a31,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(7) */
	{0x3a32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(7) */
	{0x3a33,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(7) */
	{0x3a34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(7) */
	{0x3a35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(7) */
	{0x3a36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(7) */
	{0x3a37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(7) */
	{0x3a38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(7) */
	{0x3a39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(7) */
	{0x3a40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(7) */
	{0x3a41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(7) */
	{0x3a42,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(7) */
	{0x3a43,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(7) */
	{0x3a44,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(7) */
	{0x3a45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(7) */
	{0x3a46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(7) */
	{0x3a47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(7) */
	{0x3a48,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(7) */
	{0x3a49,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(7) */
	{0x3a4a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(7) */
	{0x3a4b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(7) */
	{0x3a4c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(7) */
	{0x3a4d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(7) */
	{0x3a4e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(7) */
	{0x3a4f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(7) */
	{0x3a50,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(7) */
	{0x3a51,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(7) */
	{0x3a52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(7) */
	{0x3a53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(7) */
	{0x3a54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(7) */
	{0x3a55,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(7) */
	{0x3a56,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(7) */
	{0x3a57,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(7) */
	{0x3a58,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(7) */
	{0x3a59,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(7) */
	{0x3a5a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(7) */
	{0x3a5b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(7) */
	{0x3a5c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(7) */
	{0x3a5d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(7) */
	{0x3a5e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(7) */
	{0x3a5f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(7) */
	{0x3a60,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(7) */
	{0x3a61,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(7) */
	{0x3a62,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(7) */
	{0x3a63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(7) */
	{0x3a64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(7) */
	{0x3a65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(7) */
	{0x3a68,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(7) */
	{0x3a69,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(7) */
	{0x3a6a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(7) */
	{0x3a6b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(7) */
	{0x3a6c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(7) */
	{0x3a6d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(7) */
	{0x3a6e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(7) */
	{0x3a6f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(7) */
	{0x3a70,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(7) */
	{0x3a71,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(7) */
	{0x3a72,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(7) */
	{0x3a73,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(7) */
	{0x3a74,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(7) */
	{0x3a75,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(7) */
	{0x3a76,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(7) */
	{0x3a77,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(7) */
	{0x3a84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(7) */
	{0x3a85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(7) */
	{0x3a86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(7) */
	{0x3a87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(7) */
	{0x3a88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(7) */
	{0x3a89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(7) */
	{0x3a8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(7) */
	{0x3a8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(7) */
	{0x3a98,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(7) */
	{0x3a99,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(7) */
	{0x3a9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(7) */
	{0x3aa0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(7) */
	{0x3aa1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(7) */
	{0x3aa2,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(7) */
	{0x3aa3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(7) */
	{0x3aa4,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(7) */
	{0x3aa5,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(7) */
	{0x3aa6,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(7) */
	{0x3aa7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(7) */
	{0x3aa8,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(7) */
	{0x3aa9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(7) */
	{0x3aaa,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(7) */
	{0x3aab,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(7) */
	{0x3aac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(7) */
	{0x3aad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(7) */
	{0x3aae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(7) */
	{0x3aaf,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(7) */
	{0x3ac0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(7) */
	{0x3ac1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(7) */
	{0x3ac2,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(7) */
	{0x3ac3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(7) */
	{0x3ac4,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(7) */
	{0x3ac5,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(7) */
	{0x3ac6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(7) */
	{0x3ad0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(7) */
	{0x3ad1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(7) */
	{0x3ad2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(7) */
	{0x3ad3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(7) */
	{0x3ad4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(7) */
	{0x3ad5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(7) */
	{0x3ad6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(7) */
	{0x3ad7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(7) */
	{0x3ad8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(7) */
	{0x3ad9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(7) */
	{0x3ada,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(7) */
	{0x3adb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(7) */
	{0x3adc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(7) */
	{0x3add,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(7) */
	{0x3ade,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(7) */
	{0x3adf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(7) */
	{0x3ae0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(7) */
	{0x3ae1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(7) */
	{0x3ae2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(7) */
	{0x3ae3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(7) */
	{0x3ae4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(7) */
	{0x3ae5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(7) */
	{0x3ae6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(7) */
	{0x3ae7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(7) */
	{0x3aec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(7) */
	{0x3aed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(7) */
	{0x3aee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(7) */
	{0x3b00,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(7) */
	{0x3b01,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(7) */
	{0x3b02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(7) */
	{0x3b03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(7) */
	{0x3b04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(7) */
	{0x3b05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(7) */
	{0x3b06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(7) */
	{0x3b07,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(7) */
	{0x3b08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(7) */
	{0x3b09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(7) */
	{0x3b0a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(7) */
	{0x3b0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(7) */
	{0x3b0c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(7) */
	{0x3b0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(7) */
	{0x3b0e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(7) */
	{0x3b0f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(7) */
	{0x3b10,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(7) */
	{0x3b11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(7) */
	{0x3b12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(7) */
	{0x3b13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(7) */
	{0x3b14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(7) */
	{0x3b15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(7) */
	{0x3b16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(7) */
	{0x3b17,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(7) */
	{0x3b18,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(7) */
	{0x3b19,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(7) */
	{0x3b1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(7) */
	{0x3b1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(7) */
	{0x3b1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(7) */
	{0x3b1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(7) */
	{0x3b1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(7) */
	{0x3b1f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(7) */
	{0x3b20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(7) */
	{0x3b21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(7) */
	{0x3b22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(7) */
	{0x3b23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(7) */
	{0x3b24,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(7) */
	{0x3b25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(7) */
	{0x3b26,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(7) */
	{0x3b27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(7) */
	{0x3b28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(7) */
	{0x3b29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(7) */
	{0x3b2a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(7) */
	{0x3b2b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(7) */
	{0x3b2c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(7) */
	{0x3b2d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(7) */
	{0x3b2e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(7) */
	{0x3b2f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(7) */
	{0x3b30,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(7) */
	{0x3b31,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(7) */
	{0x3b60,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(7) */
	{0x3b61,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(7) */
	{0x3b62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(7) */
	{0x3b63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(7) */
	{0x3b64,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(7) */
	{0x3b65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(7) */
	{0x3b66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(7) */
	{0x3b67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(7) */
	{0x3b68,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(7) */
	{0x3b69,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(7) */
	{0x3b6a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(7) */
	{0x3b6b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(7) */
	{0x3b6c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(7) */
	{0x3b6d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(7) */
	{0x3b6e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(7) */
	{0x3b6f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(7) */
	{0x3b80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(7) */
	{0x3b81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(7) */
	{0x3b82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(7) */
	{0x3b83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(7) */
	{0x3b84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(7) */
	{0x3b85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(7) */
	{0x3b86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(7) */
	{0x3b87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(7) */
	{0x3b88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(7) */
	{0x3b89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(7) */
	{0x3b8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(7) */
	{0x3b8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(7) */
	{0x3ba0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(7) */
	{0x3ba1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(7) */
	{0x3ba2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(7) */
	{0x3ba3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(7) */
	{0x3ba4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(7) */
	{0x3ba5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(7) */
	{0x3ba6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(7) */
	{0x3bb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(7) */
	{0x3bb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(7) */
	{0x3bb2,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(7) */
	{0x3bb3,    0x97,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(7) */
	{0x3bb4,    0xf3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(7) */
	{0x3bb5,    0xf6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(7) */
	{0x3bc0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(7) */
	{0x3bc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(7) */
	{0x3bc2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(7) */
	{0x3bc3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(7) */
	{0x3bc4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(7) */
	{0x3bc5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(7) */
	{0x3bc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(7) */
	{0x3bc7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(7) */
	{0x3bc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(7) */
	{0x3be0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(7) */
	{0x3be1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(7) */
	{0x3be2,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(7) */
	{0x3be3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(7) */
	{0x3be4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(7) */
	{0x3be5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(7) */
	{0x3be6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(7) */
	{0x3be7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(7) */
	{0x3be8,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(7) */
	{0x3be9,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(7) */
	{0x3bea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(7) */
	{0x3beb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(7) */
	{0x3bec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(7) */
	{0x3bed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(7) */
	{0x3bee,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(7) */
	{0x3bef,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(7) */
	{0x3c00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(7) */
	{0x3c01,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(7) */
	{0x3c02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(7) */
	{0x3c03,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(7) */
	{0x3c04,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(7) */
	{0x3c05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(7) */
	{0x3c06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(7) */
	{0x3c10,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(7) */
	{0x3c11,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(7) */
	{0x3c12,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(7) */
	{0x3c13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(7) */
	{0x3c14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(7) */
	{0x3c15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(7) */
	{0x3c16,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(7) */
	{0x3c17,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(7) */
	{0x3c18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(7) */
	{0x3c19,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(7) */
	{0x3c1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(7) */
	{0x3c1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(7) */
	{0x3c1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(7) */
	{0x3c1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(7) */
	{0x3c1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(7) */
	{0x3c80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(7) */
	{0x3c81,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(7) */
	{0x3c82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(7) */
	{0x3c83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(7) */
	{0x3c84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(7) */
	{0x3c85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(7) */
	{0x3c86,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(7) */
	{0x3c87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(7) */
	{0x3c88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(7) */
	{0x3c89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(7) */
	{0x3c8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(7) */
	{0x3c8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(7) */
	{0x3c8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(7) */
	{0x3c8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(7) */
	{0x3c8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(7) */
	{0x3c8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(7) */
	{0x3c90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(7) */
	{0x3c91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(7) */
	{0x3c92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(7) */
	{0x3c93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(7) */
	{0x3c94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(7) */
	{0x3c95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(7) */
	{0x3c96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(7) */
	{0x3c97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(7) */
	{0x3c98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(7) */
	{0x3c9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(7) */
	{0x3c9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(7) */
	{0x3cac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(7) */
	{0x3cad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(7) */
	{0x3cae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(7) */
	{0x3caf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(7) */
	{0x3cb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(7) */
	{0x3cb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(7) */
	{0x3cb2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(7) */
	{0x3cb3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(7) */
	{0x3cb4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(7) */
	{0x3cb5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(7) */
	{0x3cb6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(7) */
	{0x3cb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(7) */
	{0x3cb8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(7) */
	{0x3cb9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(7) */
	{0x3cba,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(7) */
	{0x3cbb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(7) */
	{0x3cbc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(7) */
	{0x3cbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(7) */
	{0x3cbe,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(7) */
	{0x3cbf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(7) */
	{0x3cc0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(7) */
	{0x3cc1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(7) */
	{0x3cc2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(7) */
	{0x3cc3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(7) */
	{0x3cc4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(7) */
	{0x3cc5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(7) */
	{0x3cc6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(7) */
	{0x3cc8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(7) */
	{0x3cc9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(7) */
	{0x3cca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(7) */
	{0x3cf0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(7) */
	{0x3d00,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(7) */
	{0x3d01,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(7) */
	{0x3d02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(7) */
	{0x3d03,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(7) */
	{0x3d04,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(7) */
	{0x3d05,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(7) */
	{0x3d06,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(7) */
	{0x3d07,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(7) */
	{0x3d08,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(7) */
	{0x3d09,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(7) */
	{0x3d0a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(7) */
	{0x3d0b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(7) */
	{0x3d10,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(7) */
	{0x3d11,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(7) */
	{0x3d12,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(7) */
	{0x3d13,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(7) */
	{0x3d14,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(7) */
	{0x3d18,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(7) */
	{0x3d19,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(7) */
	{0x3d1a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(7) */
	{0x3d1b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(7) */
	{0x3d1c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(7) */
	{0x3d1d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(7) */
	{0x3d20,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(7) */
	{0x3d21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(7) */
	{0x3d22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(7) */
	{0x3d80,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(7) */
	{0x3d81,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(7) */
	{0x3d82,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(7) */
	{0x3d83,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(7) */
	{0x3d84,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(7) */
	{0x3d85,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(7) */
	{0x3d86,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(7) */
	{0x3d87,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(7) */
	{0x3d88,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(7) */
	{0x3d89,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(7) */
	{0x3d8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(7) */
	{0x3d8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(7) */
	{0x3d8e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(7) */
	{0x3d8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(7) */
	{0x3e00,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(7) */
	{0x3e01,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(7) */
	{0x3e02,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(7) */
	{0x3e03,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(7) */
	{0x3e04,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(7) */
	{0x3e05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(7) */
	{0x3e06,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(7) */
	{0x3e07,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(7) */
	{0x3e08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(7) */
	{0x3e09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(7) */
	{0x3e0a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(7) */
	{0x3e0b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(7) */
	{0x3e0c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(7) */
	{0x3e0d,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(7) */
	{0x3e0e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(7) */
	{0x3e0f,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(7) */
	{0x3e10,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(7) */
	{0x3e11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(7) */
	{0x3e12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(7) */
	{0x3e13,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(7) */
	{0x3e14,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(7) */
	{0x3e15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(7) */
	{0x3e16,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(7) */
	{0x3e17,    0x78,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(7) */
	{0x3e18,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(7) */
	{0x3e19,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(7) */
	{0x3e1a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(7) */
	{0x3e1b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(7) */
	{0x3e1c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(7) */
	{0x3e1d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(7) */
	{0x3e1e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(7) */
	{0x3e1f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(7) */
	{0x3e20,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(7) */
	{0x3e21,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(7) */
	{0x3e22,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(7) */
	{0x3e24,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(7) */
	{0x3e25,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(7) */
	{0x3e26,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(7) */
	{0x3e27,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(7) */
	{0x3e28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(7) */
	{0x3e29,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(7) */
	{0x3e2a,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(7) */
	{0x3e30,    0x3d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(7) */
	{0x3e31,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(7) */
	{0x3e32,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(7) */
	{0x3e33,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(7) */
	{0x3e34,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(7) */
	{0x3e35,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(7) */
	{0x3e36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(7) */
	{0x3e37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(7) */
	{0x3e38,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(7) */
	{0x3e39,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(7) */
	{0x3e3a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(7) */
	{0x3e3b,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(7) */
	{0x3e3c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(7) */
	{0x3e3d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(7) */
	{0x3e3e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(7) */
	{0x3e3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(7) */
	{0x3e40,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(7) */
	{0x3e41,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(7) */
	{0x3e42,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(7) */
	{0x3e43,    0xd9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(7) */
	{0x3e44,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(7) */
	{0x3e45,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(7) */
	{0x3e46,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(7) */
	{0x3e47,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(7) */
	{0x3e50,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(7) */
	{0x3e51,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(7) */
	{0x3e52,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(7) */
	{0x3e53,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(7) */
	{0x3e54,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(7) */
	{0x3e60,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(7) */
	{0x3e61,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(7) */
	{0x3e62,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(7) */
	{0x3e63,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(7) */
	{0x3e64,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(7) */
	{0x3e65,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(7) */
	{0x3e66,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(7) */
	{0x3e67,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(7) */
	{0x3e70,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(7) */
	{0x3e71,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(7) */
	{0x3e72,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(7) */
	{0x3e73,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(7) */
	{0x3e74,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(7) */
	{0x3e75,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(7) */
	{0x3e76,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(7) */
	{0x3e77,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(7) */
	{0x3e80,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(7) */
	{0x3e81,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(7) */
	{0x3e82,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(7) */
	{0x3e83,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(7) */
	{0x3e84,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(7) */
	{0x3e85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(7) */
	{0x3e86,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(7) */
	{0x3e87,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(7) */
	{0x3e88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(7) */
	{0x3e89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(7) */
	{0x3e8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(7) */
	{0x3e8b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(7) */
	{0x3e8c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(7) */
	{0x3e8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(7) */
	{0x3e8f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(7) */
	{0x3e90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(7) */
	{0x3e91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(7) */
	{0x3e92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(7) */
	{0x3e93,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(7) */
	{0x3e94,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(7) */
	{0x3e95,    0x63,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(7) */
	{0x3ec0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(7) */
	{0x3ec1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(7) */
	{0x3ec2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(7) */
	{0x3ec3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(7) */
	{0x3ec4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(7) */
	{0x3ec5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(7) */
	{0x3ec6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(7) */
	{0x3ec7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(7) */
	{0x3ec8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(7) */
	{0x3ec9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(7) */
	{0x3eca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(7) */
	{0x3ecb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(7) */
	{0x3ecc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(7) */
	{0x3ed0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(7) */
	{0x3ed1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(7) */
	{0x3ed2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(7) */
	{0x3ed3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(7) */
	{0x3ed8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(7) */
	{0x3ed9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(7) */
	{0x3eda,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(7) */
	{0x3f00,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(7) */
	{0x3f01,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(7) */
	{0x3f02,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(7) */
	{0x3f03,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(7) */
	{0x3f04,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(7) */
	{0x3f05,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(7) */
	{0x3f06,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(7) */
	{0x3f07,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(7) */
	{0x3f08,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(7) */
	{0x3f09,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(7) */
	{0x3f0c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(7) */
	{0x3f0d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(7) */
	{0x3f10,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(7) */
	{0x3f11,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(7) */
	{0x3f12,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(7) */
	{0x3f13,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(7) */
	{0x3f14,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(7) */
	{0x3f15,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(7) */
	{0x3f16,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(7) */
	{0x3f17,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(7) */
	{0x3f18,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(7) */
	{0x3f20,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(7) */
	{0x3f21,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(7) */
	{0x3f22,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(7) */
	{0x3f23,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(7) */
	{0x3f24,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(7) */
	{0x3f25,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(7) */
	{0x3f26,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(7) */
	{0x3f27,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(7) */
	{0x3f28,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(7) */
	{0x3f29,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(7) */
	{0x3f2a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(7) */
	{0x3f30,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(7) */
	{0x3f31,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(7) */
	{0x3f32,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(7) */
	{0x3f34,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(7) */
	{0x3f35,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(7) */
	{0x3f36,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(7) */
	{0x3f37,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(7) */
	{0x3f3f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(7) */
	{0x3f80,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(7) */
	{0x3f81,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(7) */
	{0x3f82,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(7) */
	{0x3f83,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(7) */
	{0x3f84,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(7) */
	{0x3f85,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(7) */
	{0x3f88,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(7) */
	{0x3f89,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(7) */
	{0x3f8a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(7) */
	{0x3f8b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(7) */
	{0x3f8c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(7) */
	{0x3f8d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(7) */
	{0x3f90,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(7) */
	{0x3f91,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(7) */
	{0x3f92,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(7) */
	{0x3f93,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(7) */
	{0x3f94,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(7) */
	{0x3f95,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(7) */
	{0x3f96,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(7) */
	{0x3f97,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(7) */
	{0x3f98,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(7) */
	{0x3f99,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(7) */
	{0x3f9a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(7) */
	{0x3f9b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(7) */
	{0x3f9c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(7) */
	{0x3f9d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(7) */
	{0x3fa0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(7) */
	{0x3fa1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(7) */
	{0x3fa2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(7) */
	{0x3fa3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(7) */
	{0x3fa4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(7) */
	{0x3fa5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(7) */
	{0x3fa6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(7) */
	{0x3fa7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(7) */
	{0x3fae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(7) */
	{0x3faf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(7) */
	{0x3fb0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(7) */
	{0x3fb1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(7) */
	{0x3fb2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(7) */
	{0x3fb3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(7) */
	{0x3fb4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(7) */
	{0x3fb5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(7) */
	{0x3fb6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(7) */
	{0x3fb7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(7) */
	{0x3fb8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(7) */
	{0x3fb9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(7) */
	{0x3fba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(7) */
	{0x3fbb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(7) */
	{0x3fbc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(7) */
	{0x3fbd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(7) */
	{0x3fbe,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(7) */
	{0x3fbf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(7) */
	{0x4000,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STOPCLK(8) */
	{0x4001,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_FRES(8) */
	{0x4010,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK1(8) */
	{0x4011,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQMSK0(8) */
	{0x4012,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS1(8) */
	{0x4013,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQSTATUS0(8) */
	{0x4014,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE1(8) */
	{0x4015,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_IRQFORCE0(8) */
	{0x4020,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS0(8) */
	{0x4021,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS1(8) */
	{0x4022,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_PATH_CTRL_STRSTATUS2(8) */
	{0x4100,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQCONST(8) */
	{0x4101,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQOPTION(8) */
	{0x4102,    0xde,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ISYMB(8) */
	{0x4103,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_QSYMB(8) */
	{0x4110,    0x54,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CFG(8) */
	{0x4112,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1CN(8) */
	{0x4113,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1REF(8) */
	{0x4116,    0x5e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERI(8) */
	{0x4117,    0x5f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1POWERQ(8) */
	{0x4118,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1AMM(8) */
	{0x4119,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1QUAD(8) */
	{0x411a,    0xfa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN1(8) */
	{0x411b,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1IQIN0(8) */
	{0x411c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1SHDB(8) */
	{0x411d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1OPT(8) */
	{0x4120,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMOD(8) */
	{0x4122,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFGMD(8) */
	{0x4123,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG2(8) */
	{0x4124,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDISTATE(8) */
	{0x4125,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0M(8) */
	{0x4126,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT0L(8) */
	{0x4127,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1M(8) */
	{0x4128,    0xee,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDT1L(8) */
	{0x4129,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG3(8) */
	{0x412a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG4(8) */
	{0x412b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCFG5(8) */
	{0x4130,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDMODCOD(8) */
	{0x4131,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLFNUM(8) */
	{0x4132,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSTATE(8) */
	{0x4133,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDFLYW(8) */
	{0x4134,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS(8) */
	{0x4135,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS2(8) */
	{0x4136,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS3(8) */
	{0x4137,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS4(8) */
	{0x4138,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS5(8) */
	{0x4139,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSTATUS6(8) */
	{0x413a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDERRORS(8) */
	{0x4140,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG2(8) */
	{0x4141,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG1(8) */
	{0x4142,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG0(8) */
	{0x4143,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSAMPDLY(8) */
	{0x4144,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DSYMBDLY(8) */
	{0x4148,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO21(8) */
	{0x4149,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBFIFO20(8) */
	{0x414a,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SHDBPARAL(8) */
	{0x4150,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEADR(8) */
	{0x4151,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEDATA(8) */
	{0x4152,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICECFG(8) */
	{0x4153,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICENBR(8) */
	{0x4154,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB2(8) */
	{0x4155,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB1(8) */
	{0x4156,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESYMB0(8) */
	{0x4157,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICERATIO(8) */
	{0x4158,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESTAT(8) */
	{0x4159,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMAX(8) */
	{0x415a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEMIN(8) */
	{0x415b,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICESEL(8) */
	{0x415c,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SLICEANC(8) */
	{0x415d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODAUX(8) */
	{0x415e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_HDEBITCFG4(8) */
	{0x4170,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGM(8) */
	{0x4171,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FILTCFGL(8) */
	{0x4172,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT0(8) */
	{0x4173,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT1(8) */
	{0x4174,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT2(8) */
	{0x4175,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_IQFILT3(8) */
	{0x4180,    0x6a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELMANT(8) */
	{0x4181,    0x8c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABS(8) */
	{0x4182,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELABSM(8) */
	{0x4183,    0xaa,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELEXP(8) */
	{0x4184,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCOEF(8) */
	{0x4185,    0x83,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELCFG(8) */
	{0x4186,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CORRELFREQ(8) */
	{0x4187,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHMODCOD(8) */
	{0x4188,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDREG(8) */
	{0x4190,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2O(8) */
	{0x4191,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2REF(8) */
	{0x4192,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCNADJ(8) */
	{0x4193,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCKS(8) */
	{0x4194,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRSADJ(8) */
	{0x4195,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCRQ8ADJ(8) */
	{0x4196,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1ADJ(8) */
	{0x4197,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR2ADJ(8) */
	{0x4198,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR3ADJ(8) */
	{0x4199,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR4ADJ(8) */
	{0x419a,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR5ADJ(8) */
	{0x419b,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR6ADJ(8) */
	{0x419c,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR7ADJ(8) */
	{0x419d,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR8ADJ(8) */
	{0x419e,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGCR1BADJ(8) */
	{0x419f,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2ADJ(8) */
	{0x41a0,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I1(8) */
	{0x41a1,    0x82,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2I0(8) */
	{0x41a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2IMP(8) */
	{0x41a3,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC1ADJ(8) */
	{0x41a4,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R10DB(8) */
	{0x41a5,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2R20DB(8) */
	{0x41a6,    0xe2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2AMPL(8) */
	{0x41a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2VAR(8) */
	{0x41a8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AGC2RATIO(8) */
	{0x41b0,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARCFG(8) */
	{0x41b1,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCNLK(8) */
	{0x41b2,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCNLK(8) */
	{0x41b3,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLCLK(8) */
	{0x41b4,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLCLK(8) */
	{0x41b5,    0x79,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARFREQ(8) */
	{0x41b6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CARHDR(8) */
	{0x41b7,    0xd0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT(8) */
	{0x41b8,    0xb8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDT2(8) */
	{0x41b9,    0xf9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRICFG(8) */
	{0x41ba,    0x67,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1BCFG(8) */
	{0x41bb,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB1(8) */
	{0x41bc,    0xd4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRULB0(8) */
	{0x41bd,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR2(8) */
	{0x41be,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR1(8) */
	{0x41bf,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRCNTR0(8) */
	{0x41c0,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE2(8) */
	{0x41c1,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE1(8) */
	{0x41c2,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRIBASE0(8) */
	{0x41c3,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT2(8) */
	{0x41c4,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT1(8) */
	{0x41c5,    0x8e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINIT0(8) */
	{0x41c6,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP2(8) */
	{0x41c7,    0xc9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP1(8) */
	{0x41c8,    0xcb,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRUP0(8) */
	{0x41c9,    0xce,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW2(8) */
	{0x41ca,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW1(8) */
	{0x41cb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRLOW0(8) */
	{0x41cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC2(8) */
	{0x41cd,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC1(8) */
	{0x41ce,    0xda,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFRINC0(8) */
	{0x41cf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR12(8) */
	{0x41d0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR11(8) */
	{0x41d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR10(8) */
	{0x41d2,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LDI(8) */
	{0x41d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F2(8) */
	{0x41d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F1(8) */
	{0x41d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1F0(8) */
	{0x41d6,    0x0a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1G(8) */
	{0x41d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B2(8) */
	{0x41d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B1(8) */
	{0x41d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR1B0(8) */
	{0x41da,    0x98,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAUSSR0(8) */
	{0x41db,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIR0(8) */
	{0x41dc,    0xac,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIQUANT(8) */
	{0x41dd,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCITHRES(8) */
	{0x41de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CCIACC(8) */
	{0x41e0,    0xd3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG(8) */
	{0x41e1,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCNLK(8) */
	{0x41e2,    0x56,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RTCLK(8) */
	{0x41e3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHRISE(8) */
	{0x41e4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGTHFALL(8) */
	{0x41e5,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUPRATIO(8) */
	{0x41e6,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOWRATIO(8) */
	{0x41e7,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KTTMG(8) */
	{0x41e8,    0xf5,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG(8) */
	{0x41e9,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRSTEP(8) */
	{0x41ea,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG2(8) */
	{0x41eb,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_KREFTMG2(8) */
	{0x41ec,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGCFG3(8) */
	{0x41ed,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGMTHRES(8) */
	{0x41f0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT2(8) */
	{0x41f1,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT1(8) */
	{0x41f2,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRINIT0(8) */
	{0x41f3,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP2(8) */
	{0x41f4,    0x5a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP1(8) */
	{0x41f5,    0xe9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRUP0(8) */
	{0x41f6,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW2(8) */
	{0x41f7,    0x43,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW1(8) */
	{0x41f8,    0xc7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFRLOW0(8) */
	{0x41fc,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR3(8) */
	{0x41fd,    0x4d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR2(8) */
	{0x41fe,    0xa9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR1(8) */
	{0x41ff,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SFR0(8) */
	{0x4200,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG2(8) */
	{0x4201,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG1(8) */
	{0x4202,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGREG0(8) */
	{0x4203,    0xe4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK1(8) */
	{0x4204,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGLOCK0(8) */
	{0x4205,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TMGOBS(8) */
	{0x4206,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR2(8) */
	{0x4207,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR1(8) */
	{0x4208,    0x55,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDCODSFR0(8) */
	{0x4210,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFECFG(8) */
	{0x4211,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFECFG(8) */
	{0x4212,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG(8) */
	{0x4213,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_XFECFG2(8) */
	{0x4214,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PEGALCFG(8) */
	{0x4215,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFECFG(8) */
	{0x4216,    0x91,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERCFG(8) */
	{0x4217,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMPOS(8) */
	{0x4218,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMI(8) */
	{0x4219,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFERAMQ(8) */
	{0x421a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEROBS(8) */
	{0x421b,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DFESTNBR(8) */
	{0x421c,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFESTNBR(8) */
	{0x4220,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI1(8) */
	{0x4221,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ1(8) */
	{0x4222,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI2(8) */
	{0x4223,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ2(8) */
	{0x4224,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI3(8) */
	{0x4225,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ3(8) */
	{0x4226,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI4(8) */
	{0x4227,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ4(8) */
	{0x4228,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI5(8) */
	{0x4229,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ5(8) */
	{0x422a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI6(8) */
	{0x422b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ6(8) */
	{0x422c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI7(8) */
	{0x422d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ7(8) */
	{0x422e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAI8(8) */
	{0x422f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EQUAQ8(8) */
	{0x4230,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI1(8) */
	{0x4231,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ1(8) */
	{0x4232,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI2(8) */
	{0x4233,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ2(8) */
	{0x4234,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI3(8) */
	{0x4235,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ3(8) */
	{0x4236,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI4(8) */
	{0x4237,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ4(8) */
	{0x4238,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEI5(8) */
	{0x4239,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFEQ5(8) */
	{0x4240,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN1(8) */
	{0x4241,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI1(8) */
	{0x4242,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ1(8) */
	{0x4243,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN2(8) */
	{0x4244,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI2(8) */
	{0x4245,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ2(8) */
	{0x4246,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN3(8) */
	{0x4247,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI3(8) */
	{0x4248,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ3(8) */
	{0x4249,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN4(8) */
	{0x424a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI4(8) */
	{0x424b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ4(8) */
	{0x424c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN5(8) */
	{0x424d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI5(8) */
	{0x424e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ5(8) */
	{0x424f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN6(8) */
	{0x4250,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI6(8) */
	{0x4251,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ6(8) */
	{0x4252,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN7(8) */
	{0x4253,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI7(8) */
	{0x4254,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ7(8) */
	{0x4255,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN8(8) */
	{0x4256,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI8(8) */
	{0x4257,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ8(8) */
	{0x4258,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN9(8) */
	{0x4259,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI9(8) */
	{0x425a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ9(8) */
	{0x425b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN10(8) */
	{0x425c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI10(8) */
	{0x425d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ10(8) */
	{0x425e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN11(8) */
	{0x425f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI11(8) */
	{0x4260,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR2CFG(8) */
	{0x4261,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2CFR1(8) */
	{0x4262,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CAR3CFG(8) */
	{0x4263,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR22(8) */
	{0x4264,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR21(8) */
	{0x4265,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR20(8) */
	{0x4268,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S1(8) */
	{0x4269,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2Q(8) */
	{0x426a,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S28(8) */
	{0x426b,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S216A(8) */
	{0x426c,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S232A(8) */
	{0x426d,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S264A(8) */
	{0x426e,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2128A(8) */
	{0x426f,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ACLC2S2256A(8) */
	{0x4270,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S1(8) */
	{0x4271,    0xc6,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2Q(8) */
	{0x4272,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S28(8) */
	{0x4273,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S216A(8) */
	{0x4274,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S232A(8) */
	{0x4275,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S264A(8) */
	{0x4276,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2128A(8) */
	{0x4277,    0xc8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BCLC2S2256A(8) */
	{0x4284,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX1(8) */
	{0x4285,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2MAX0(8) */
	{0x4286,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR1(8) */
	{0x4287,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NCO2FR0(8) */
	{0x4288,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE1(8) */
	{0x4289,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFR2AVRGE0(8) */
	{0x428a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX1(8) */
	{0x428b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DPILOTMAX0(8) */
	{0x4298,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFG(8) */
	{0x4299,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF1(8) */
	{0x429a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSCFGF2(8) */
	{0x42a0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT1(8) */
	{0x42a1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATAT0(8) */
	{0x42a2,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA1(8) */
	{0x42a3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSDATA0(8) */
	{0x42a4,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT1(8) */
	{0x42a5,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLHT0(8) */
	{0x42a6,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH1(8) */
	{0x42a7,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSPLH0(8) */
	{0x42a8,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT1(8) */
	{0x42a9,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDATAT0(8) */
	{0x42aa,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME1(8) */
	{0x42ab,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSFRAME0(8) */
	{0x42ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD1(8) */
	{0x42ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NNOSRAD0(8) */
	{0x42ae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR1(8) */
	{0x42af,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCNR0(8) */
	{0x42c0,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES1(8) */
	{0x42c1,    0x69,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSTHRES2(8) */
	{0x42c2,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSDIFF1(8) */
	{0x42c3,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_RAINFADE(8) */
	{0x42c4,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMCFG(8) */
	{0x42c5,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMPOS(8) */
	{0x42c6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_NOSRAMVAL(8) */
	{0x42d0,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE3(8) */
	{0x42d1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE2(8) */
	{0x42d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE1(8) */
	{0x42d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SOFCODE0(8) */
	{0x42d4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB7(8) */
	{0x42d5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB6(8) */
	{0x42d6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB5(8) */
	{0x42d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB4(8) */
	{0x42d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB3(8) */
	{0x42d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB2(8) */
	{0x42da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB1(8) */
	{0x42db,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSSCRAMB0(8) */
	{0x42dc,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBB(8) */
	{0x42dd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMBA(8) */
	{0x42de,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB9(8) */
	{0x42df,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB8(8) */
	{0x42e0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB7(8) */
	{0x42e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB6(8) */
	{0x42e2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB5(8) */
	{0x42e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB4(8) */
	{0x42e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB3(8) */
	{0x42e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB2(8) */
	{0x42e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB1(8) */
	{0x42e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLSMSCRAMB0(8) */
	{0x42ec,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT2(8) */
	{0x42ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT1(8) */
	{0x42ee,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLROOT0(8) */
	{0x4300,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST0(8) */
	{0x4301,    0xcc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST1(8) */
	{0x4302,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST2(8) */
	{0x4303,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST3(8) */
	{0x4304,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST4(8) */
	{0x4305,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST5(8) */
	{0x4306,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST6(8) */
	{0x4307,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST7(8) */
	{0x4308,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST8(8) */
	{0x4309,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLST9(8) */
	{0x430a,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTA(8) */
	{0x430b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTB(8) */
	{0x430c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTC(8) */
	{0x430d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTD(8) */
	{0x430e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTE(8) */
	{0x430f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLSTF(8) */
	{0x4310,    0xfc,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS10(8) */
	{0x4311,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS11(8) */
	{0x4312,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS12(8) */
	{0x4313,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS13(8) */
	{0x4314,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS14(8) */
	{0x4315,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS15(8) */
	{0x4316,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS16(8) */
	{0x4317,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS17(8) */
	{0x4318,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS18(8) */
	{0x4319,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS19(8) */
	{0x431a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1A(8) */
	{0x431b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1B(8) */
	{0x431c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1C(8) */
	{0x431d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1D(8) */
	{0x431e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1E(8) */
	{0x431f,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODLS1F(8) */
	{0x4320,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH3(8) */
	{0x4321,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH2(8) */
	{0x4322,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCH1(8) */
	{0x4323,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MODCODCHM(8) */
	{0x4324,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESCFG(8) */
	{0x4325,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESADR(8) */
	{0x4326,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA7(8) */
	{0x4327,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA6(8) */
	{0x4328,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA5(8) */
	{0x4329,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA4(8) */
	{0x432a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA3(8) */
	{0x432b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA2(8) */
	{0x432c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA1(8) */
	{0x432d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA0(8) */
	{0x432e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA8(8) */
	{0x432f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDRESDATA9(8) */
	{0x4330,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG(8) */
	{0x4331,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TNRCFG2(8) */
	{0x4360,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ11(8) */
	{0x4361,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN12(8) */
	{0x4362,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI12(8) */
	{0x4363,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ12(8) */
	{0x4364,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN13(8) */
	{0x4365,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI13(8) */
	{0x4366,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ13(8) */
	{0x4367,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN14(8) */
	{0x4368,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI14(8) */
	{0x4369,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ14(8) */
	{0x436a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN15(8) */
	{0x436b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI15(8) */
	{0x436c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ15(8) */
	{0x436d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEN16(8) */
	{0x436e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEI16(8) */
	{0x436f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_WDFEQ16(8) */
	{0x4380,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF7(8) */
	{0x4381,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF6(8) */
	{0x4382,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF5(8) */
	{0x4383,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF4(8) */
	{0x4384,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF3(8) */
	{0x4385,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF2(8) */
	{0x4386,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF1(8) */
	{0x4387,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEF0(8) */
	{0x4388,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SDEMAP(8) */
	{0x4389,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM2(8) */
	{0x438a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM1(8) */
	{0x438b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_SMAPCOEFM0(8) */
	{0x43a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS5(8) */
	{0x43a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS4(8) */
	{0x43a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS3(8) */
	{0x43a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS2(8) */
	{0x43a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS1(8) */
	{0x43a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBS0(8) */
	{0x43a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LLROBSCFG(8) */
	{0x43b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDPLHSTAT(8) */
	{0x43b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDSELOBS(8) */
	{0x43b2,    0x06,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME3(8) */
	{0x43b3,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME2(8) */
	{0x43b4,    0xb3,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME1(8) */
	{0x43b5,    0xdf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_LOCKTIME0(8) */
	{0x43c0,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALCFG(8) */
	{0x43c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALADDR(8) */
	{0x43c2,    0x09,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTART(8) */
	{0x43c3,    0x3f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALMASK(8) */
	{0x43c4,    0x0e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALSTOP(8) */
	{0x43c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALOBS(8) */
	{0x43c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESINC(8) */
	{0x43c7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRESDEC(8) */
	{0x43c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CALRLIST(8) */
	{0x43e0,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP1(8) */
	{0x43e1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHCCMP0(8) */
	{0x43e2,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDTIMER(8) */
	{0x43e3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DMDATTEMPT(8) */
	{0x43e4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER1(8) */
	{0x43e5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLFHEADER0(8) */
	{0x43e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF1(8) */
	{0x43e7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHSFRDIFF0(8) */
	{0x43e8,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP1(8) */
	{0x43e9,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRCMP0(8) */
	{0x43ea,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD1(8) */
	{0x43eb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECORD0(8) */
	{0x43ec,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO1(8) */
	{0x43ed,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHRECNCO0(8) */
	{0x43ee,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF1(8) */
	{0x43ef,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDELTAF0(8) */
	{0x4400,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP5(8) */
	{0x4401,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP4(8) */
	{0x4402,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP3(8) */
	{0x4403,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP2(8) */
	{0x4404,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP1(8) */
	{0x4405,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PHERRCMP0(8) */
	{0x4406,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_PLHDEBUG(8) */
	{0x4410,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGM(8) */
	{0x4411,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFGL(8) */
	{0x4412,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC1(8) */
	{0x4413,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMAGC0(8) */
	{0x4414,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSI(8) */
	{0x4415,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMOBSQ(8) */
	{0x4416,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMSTATUS(8) */
	{0x4417,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMWSAR(8) */
	{0x4418,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGM(8) */
	{0x4419,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AFILTCFGL(8) */
	{0x441a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT0(8) */
	{0x441b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT1(8) */
	{0x441c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT2(8) */
	{0x441d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_AIQFILT3(8) */
	{0x441e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_ASYMCFG3(8) */
	{0x4480,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GCTRL(8) */
	{0x4481,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTCTRL(8) */
	{0x4482,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_FFTACC(8) */
	{0x4483,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_THRESHOLD(8) */
	{0x4484,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GAINCONT(8) */
	{0x4485,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_UPDCONT(8) */
	{0x4486,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_GSTAT(8) */
	{0x4487,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_EXPMAX(8) */
	{0x4488,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX1(8) */
	{0x4489,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX0(8) */
	{0x448a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX2(8) */
	{0x448b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX1(8) */
	{0x448c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX0(8) */
	{0x448d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX21(8) */
	{0x448e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX20(8) */
	{0x448f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX22(8) */
	{0x4490,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX21(8) */
	{0x4491,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX20(8) */
	{0x4492,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX31(8) */
	{0x4493,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_BINMAX30(8) */
	{0x4494,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX32(8) */
	{0x4495,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX31(8) */
	{0x4496,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_VALMAX30(8) */
	{0x4497,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CPTACC(8) */
	{0x4498,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CTESTAT(8) */
	{0x449a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST1(8) */
	{0x449b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_CFOEST0(8) */
	{0x44ac,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEBUG1(8) */
	{0x44ad,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR1(8) */
	{0x44ae,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMADDR0(8) */
	{0x44af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMSTAT(8) */
	{0x44b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA01(8) */
	{0x44b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA00(8) */
	{0x44b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA11(8) */
	{0x44b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA10(8) */
	{0x44b4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA21(8) */
	{0x44b5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA20(8) */
	{0x44b6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA31(8) */
	{0x44b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA30(8) */
	{0x44b8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA41(8) */
	{0x44b9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA40(8) */
	{0x44ba,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA51(8) */
	{0x44bb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA50(8) */
	{0x44bc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA61(8) */
	{0x44bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA60(8) */
	{0x44be,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA71(8) */
	{0x44bf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_MEMVA70(8) */
	{0x44c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTDMD(8) */
	{0x44c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TPOLY(8) */
	{0x44c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTR(8) */
	{0x44c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TAGC2(8) */
	{0x44c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL1(8) */
	{0x44c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL2(8) */
	{0x44c6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL3(8) */
	{0x44c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TCTL4(8) */
	{0x44c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTCAR3(8) */
	{0x44ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_TSTHDEBIT(8) */
	{0x44f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_DEMOD_DEMODEND(8) */
	{0x4500,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SIGPOWER(8) */
	{0x4501,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_DEMAPVIT(8) */
	{0x4502,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITSCALE(8) */
	{0x4503,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_FECM(8) */
	{0x4504,    0xd7,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH12(8) */
	{0x4505,    0x85,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH23(8) */
	{0x4506,    0x58,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH34(8) */
	{0x4507,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH56(8) */
	{0x4508,    0x34,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH67(8) */
	{0x4509,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTH78(8) */
	{0x450a,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_PRVIT(8) */
	{0x450b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VAVSRVIT(8) */
	{0x4510,    0x0d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCURPUN(8) */
	{0x4511,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VERROR(8) */
	{0x4512,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VITCNR(8) */
	{0x4513,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VTHINUSE(8) */
	{0x4514,    0xa4,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_VSTATUSVIT(8) */
	{0x4518,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV12(8) */
	{0x4519,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV23(8) */
	{0x451a,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV34(8) */
	{0x451b,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV56(8) */
	{0x451c,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV67(8) */
	{0x451d,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_KDIV78(8) */
	{0x4520,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_SELOUT(8) */
	{0x4521,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSYNC(8) */
	{0x4522,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_VITERBI_TSTERR(8) */
	{0x4580,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFAVSR(8) */
	{0x4581,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFDEMAP(8) */
	{0x4582,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFERROR(8) */
	{0x4583,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECCNR(8) */
	{0x4584,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV12(8) */
	{0x4585,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV23(8) */
	{0x4586,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV34(8) */
	{0x4587,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV56(8) */
	{0x4588,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV67(8) */
	{0x4589,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFKDIV78(8) */
	{0x458a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_SFECSTATUS(8) */
	{0x458d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFMET(8) */
	{0x458e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSFSYNC(8) */
	{0x458f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_SUPERFEC_TSTSFERR(8) */
	{0x4600,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE1(8) */
	{0x4601,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATE0(8) */
	{0x4602,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG2(8) */
	{0x4603,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG1(8) */
	{0x4604,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG0(8) */
	{0x4605,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSYNC(8) */
	{0x4606,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDIVN(8) */
	{0x4607,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG4(8) */
	{0x4608,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSHEMCFG(8) */
	{0x4609,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCPLPCFG(8) */
	{0x460a,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRCFG(8) */
	{0x460b,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID1(8) */
	{0x460c,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRPID0(8) */
	{0x460d,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRCFG(8) */
	{0x460e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID1(8) */
	{0x460f,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRPID0(8) */
	{0x4610,    0xe0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ2(8) */
	{0x4611,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ1(8) */
	{0x4612,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNCRADJ0(8) */
	{0x4613,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTM(8) */
	{0x4614,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTL(8) */
	{0x4615,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTC(8) */
	{0x4616,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET2(8) */
	{0x4617,    0x78,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET1(8) */
	{0x4618,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLYSET0(8) */
	{0x4619,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELH(8) */
	{0x461a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELM(8) */
	{0x461b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSINSDELL(8) */
	{0x461c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG5(8) */
	{0x461d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSCFG6(8) */
	{0x461e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPIDFLTD(8) */
	{0x461f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSAMPDLY(8) */
	{0x4620,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMINSPEED(8) */
	{0x4621,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMAXSPEED(8) */
	{0x4622,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSPEED(8) */
	{0x4624,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK1(8) */
	{0x4625,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDILSTK0(8) */
	{0x4626,    0x52,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS(8) */
	{0x4627,    0x28,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS2(8) */
	{0x4628,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSSTATUS3(8) */
	{0x4629,    0x2f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD1(8) */
	{0x462a,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSMODCOD0(8) */
	{0x4630,    0x3d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE1(8) */
	{0x4631,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBITRATE0(8) */
	{0x4632,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN1(8) */
	{0x4633,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPACKLEN0(8) */
	{0x4634,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN1(8) */
	{0x4635,    0x44,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBLOCLEN0(8) */
	{0x4636,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY2(8) */
	{0x4637,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY1(8) */
	{0x4638,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDLY0(8) */
	{0x4639,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT2(8) */
	{0x463a,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT1(8) */
	{0x463b,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ISCRUNIT0(8) */
	{0x463c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSNPDAV(8) */
	{0x463d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT2(8) */
	{0x463e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT1(8) */
	{0x463f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSBUFSTAT0(8) */
	{0x4640,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS1(8) */
	{0x4641,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSXCROBS0(8) */
	{0x4642,    0xbf,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR272(8) */
	{0x4643,    0xd9,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR271(8) */
	{0x4644,    0x99,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCR270(8) */
	{0x4645,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ2(8) */
	{0x4646,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ1(8) */
	{0x4647,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSPCRADJ0(8) */
	{0x4650,    0x48,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG1(8) */
	{0x4651,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSDEBUG0(8) */
	{0x4652,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBSCFG(8) */
	{0x4653,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS1(8) */
	{0x4654,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSOBS0(8) */
	{0x4660,    0x35,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL1(8) */
	{0x4661,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT12(8) */
	{0x4662,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT11(8) */
	{0x4663,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT10(8) */
	{0x4664,    0xc1,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCTRL2(8) */
	{0x4665,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT22(8) */
	{0x4666,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT21(8) */
	{0x4667,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_ERRCNT20(8) */
	{0x4670,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS1(8) */
	{0x4671,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS2(8) */
	{0x4672,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS3(8) */
	{0x4673,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS4(8) */
	{0x4674,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS5(8) */
	{0x4675,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS6(8) */
	{0x4676,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTS7(8) */
	{0x4677,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTCPLP(8) */
	{0x4680,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSCFG(8) */
	{0x4681,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTAT(8) */
	{0x4682,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART5(8) */
	{0x4683,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART4(8) */
	{0x4684,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART3(8) */
	{0x4685,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART2(8) */
	{0x4686,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART1(8) */
	{0x4687,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSSTART0(8) */
	{0x4688,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND5(8) */
	{0x4689,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND4(8) */
	{0x468a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND3(8) */
	{0x468b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND2(8) */
	{0x468c,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND1(8) */
	{0x468d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSEND0(8) */
	{0x468f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSPRE(8) */
	{0x4690,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME5(8) */
	{0x4691,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME4(8) */
	{0x4692,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME3(8) */
	{0x4693,    0xb2,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME2(8) */
	{0x4694,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME1(8) */
	{0x4695,    0x75,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSRCSTIME0(8) */
	{0x46c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK1(8) */
	{0x46c1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDILSTK0(8) */
	{0x46c2,    0x46,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFSTATUS(8) */
	{0x46c3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY2(8) */
	{0x46c4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY1(8) */
	{0x46c5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLY0(8) */
	{0x46c6,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET2(8) */
	{0x46c7,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET1(8) */
	{0x46c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFDLYSET0(8) */
	{0x46c9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBSCFG(8) */
	{0x46ca,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS1(8) */
	{0x46cb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFOBS0(8) */
	{0x46cc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFECINFO(8) */
	{0x46d0,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCTRL(8) */
	{0x46d1,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT2(8) */
	{0x46d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT1(8) */
	{0x46d3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_SFERRCNT0(8) */
	{0x46d8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF1(8) */
	{0x46d9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF2(8) */
	{0x46da,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_HWARE_TSTTSSF3(8) */
	{0x4700,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL0(8) */
	{0x4701,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL1(8) */
	{0x4702,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL2(8) */
	{0x4703,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL3(8) */
	{0x4704,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELCTRL4(8) */
	{0x4705,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL1(8) */
	{0x4706,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBHCTRL2(8) */
	{0x4707,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_HYSTTHRESH(8) */
	{0x4708,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIENTRY(8) */
	{0x4709,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIBITENA(8) */
	{0x470c,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGM(8) */
	{0x470d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELDBGL(8) */
	{0x4710,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST1(8) */
	{0x4711,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATCST0(8) */
	{0x4712,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST1(8) */
	{0x4713,    0x77,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLCST0(8) */
	{0x4714,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST1(8) */
	{0x4715,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLCST0(8) */
	{0x4716,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCCST(8) */
	{0x4717,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST1(8) */
	{0x4718,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDCST0(8) */
	{0x4720,    0xf0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR1(8) */
	{0x4721,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_MATSTR0(8) */
	{0x4722,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR1(8) */
	{0x4723,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPLSTR0(8) */
	{0x4724,    0x7d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR1(8) */
	{0x4725,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_DFLSTR0(8) */
	{0x4726,    0x47,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCSTR(8) */
	{0x4727,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR1(8) */
	{0x4728,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_SYNCDSTR0(8) */
	{0x4729,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMAXSTR(8) */
	{0x472a,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_ISIMINSTR(8) */
	{0x4730,    0x94,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS1(8) */
	{0x4731,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS2(8) */
	{0x4732,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_PDELSTATUS3(8) */
	{0x4734,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO1(8) */
	{0x4735,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_BBFCRCKO0(8) */
	{0x4736,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO1(8) */
	{0x4737,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_UPCRCKO0(8) */
	{0x473f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_PKTDELIN_TPKTDELIN(8) */
	{0x4780,    0x88,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FECSPY(8) */
	{0x4781,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYCFG(8) */
	{0x4782,    0xba,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDATA(8) */
	{0x4783,    0x42,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOUT(8) */
	{0x4784,    0x11,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYBER(8) */
	{0x4785,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOPT(8) */
	{0x4788,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATUS(8) */
	{0x4789,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FGOODPACK(8) */
	{0x478a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FPACKCNT(8) */
	{0x478b,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYMISC(8) */
	{0x478c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES1(8) */
	{0x478d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSTATES0(8) */
	{0x4790,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT4(8) */
	{0x4791,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT3(8) */
	{0x4792,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT2(8) */
	{0x4793,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT1(8) */
	{0x4794,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERCPT0(8) */
	{0x4795,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR2(8) */
	{0x4796,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR1(8) */
	{0x4797,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FBERERR0(8) */
	{0x4798,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST1(8) */
	{0x4799,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYDIST0(8) */
	{0x479a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR1(8) */
	{0x479b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYPCR0(8) */
	{0x479c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR1(8) */
	{0x479d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYNCR0(8) */
	{0x47a0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS7(8) */
	{0x47a1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS6(8) */
	{0x47a2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS5(8) */
	{0x47a3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS4(8) */
	{0x47a4,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS3(8) */
	{0x47a5,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS2(8) */
	{0x47a6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS1(8) */
	{0x47a7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_FSPYOBS0(8) */
	{0x47ae,    0x10,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCM(8) */
	{0x47af,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVDESCL(8) */
	{0x47b0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS3(8) */
	{0x47b1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS2(8) */
	{0x47b2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS1(8) */
	{0x47b3,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVOBS0(8) */
	{0x47b4,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG(8) */
	{0x47b5,    0x01,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID1(8) */
	{0x47b6,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVPID0(8) */
	{0x47b7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCFG2(8) */
	{0x47b8,    0x80,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX1(8) */
	{0x47b9,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMAX0(8) */
	{0x47ba,    0x7f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN1(8) */
	{0x47bb,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVMIN0(8) */
	{0x47bc,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS1(8) */
	{0x47bd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVABS0(8) */
	{0x47be,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT1(8) */
	{0x47bf,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_DVBSX_FECSPY_NCRVCPT0(8) */
	{0x5000,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF1 */
	{0x5001,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF2 */
	{0x5002,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF3 */
	{0x5003,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF4 */
	{0x5004,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF5 */
	{0x5005,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF6 */
	{0x5006,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF7 */
	{0x5007,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF8 */
	{0x5008,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF9 */
	{0x5009,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF10 */
	{0x500a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF11 */
	{0x500b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF12 */
	{0x500c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF13 */
	{0x500d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF14 */
	{0x500e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF15 */
	{0x500f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF16 */
	{0x5010,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF17 */
	{0x5011,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF18 */
	{0x5012,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF19 */
	{0x5013,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF20 */
	{0x5014,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF21 */
	{0x5015,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF22 */
	{0x5016,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF23 */
	{0x5017,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF24 */
	{0x5018,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF25 */
	{0x5019,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF26 */
	{0x501a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF27 */
	{0x501b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF28 */
	{0x501c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF1 */
	{0x501d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF2 */
	{0x501e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF3 */
	{0x501f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF4 */
	{0x5020,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF5 */
	{0x5021,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF6 */
	{0x5022,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF7 */
	{0x5023,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF8 */
	{0x5024,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF9 */
	{0x5025,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF10 */
	{0x5026,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF12 */
	{0x5027,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF13 */
	{0x5028,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF14 */
	{0x5029,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF15 */
	{0x502a,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF16 */
	{0x502b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF18 */
	{0x502c,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF19 */
	{0x502d,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF20 */
	{0x502e,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF21 */
	{0x502f,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF22 */
	{0x5030,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF24 */
	{0x5031,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF25 */
	{0x5032,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF26 */
	{0x5033,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF27 */
	{0x5034,    0x05,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR6 */
	{0x5035,    0x5b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR5 */
	{0x5036,    0x96,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR4 */
	{0x5037,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR3 */
	{0x5038,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR2 */
	{0x5039,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR1 */
	{0x503a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR0 */
	{0x503d,    0x0c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_DIFFDIV */
	{0x503e,    0x33,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITERDIV */
	{0x503f,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITERNOERR */
	{0x5040,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF1 */
	{0x5041,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF2 */
	{0x5042,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF3 */
	{0x5043,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF4 */
	{0x5044,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF5 */
	{0x5045,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF6 */
	{0x5046,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF7 */
	{0x5047,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF8 */
	{0x5048,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF9 */
	{0x5049,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF10 */
	{0x504a,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF11 */
	{0x504b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF12 */
	{0x504c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF13 */
	{0x504d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF14 */
	{0x504e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF15 */
	{0x504f,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF16 */
	{0x5050,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF17 */
	{0x5051,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF18 */
	{0x5052,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF19 */
	{0x5053,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF20 */
	{0x5054,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF21 */
	{0x5055,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF22 */
	{0x5056,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF23 */
	{0x5057,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF24 */
	{0x5058,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF25 */
	{0x5059,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF26 */
	{0x505a,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF27 */
	{0x505b,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF28 */
	{0x505c,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF1 */
	{0x505d,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF2 */
	{0x505e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF3 */
	{0x505f,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF4 */
	{0x5060,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF5 */
	{0x5061,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF6 */
	{0x5062,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF7 */
	{0x5063,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF8 */
	{0x5064,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF9 */
	{0x5065,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF10 */
	{0x5066,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF12 */
	{0x5067,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF13 */
	{0x5068,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF14 */
	{0x5069,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF15 */
	{0x506a,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF16 */
	{0x506b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF18 */
	{0x506c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF19 */
	{0x506d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF20 */
	{0x506e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF21 */
	{0x506f,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF22 */
	{0x5070,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF24 */
	{0x5071,    0x50,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF25 */
	{0x5072,    0x60,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF26 */
	{0x5073,    0x70,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF27 */
	{0x507c,    0xa0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBCYCLETRANSFER1 */
	{0x507d,    0x0f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBCYCLETRANSFER2 */
	{0x507e,    0xe8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBCYCLETRANSFER3 */
	{0x507f,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBCYCLETRANSFER4 */
	{0x5080,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_CFGEXT */
	{0x5081,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_ADDCYCLES */
	{0x5085,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_MODCOD */
	{0x5086,    0x04,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GENCFG */
	{0x5087,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER6 */
	{0x5088,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER5 */
	{0x5089,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER4 */
	{0x508a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER3 */
	{0x508b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER2 */
	{0x508c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER1 */
	{0x508d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER0 */
	{0x508e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NOSTREAM */
	{0x508f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NOSHFR */
	{0x5090,    0xe8,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_TEMPOLF1 */
	{0x5091,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_TEMPOLF2 */
	{0x5092,    0x3a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_TEMPOSF1 */
	{0x5093,    0x07,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_TEMPOSF2 */
	{0x5094,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELPATH */
	{0x5096,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_LDPCERR1 */
	{0x5097,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_LDPCERR0 */
	{0x5098,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_BCHERR */
	{0x5099,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBBUFFERFULL */
	{0x509a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_NBBUFFERUSED */
	{0x509f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INITMAXITER */
	{0x50a0,    0x03,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_STATUSITER */
	{0x50a1,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_STATUSMAXITER */
	{0x50b0,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBFROVERFLOW */
	{0x50b1,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBFROVERFLOW */
	{0x50b2,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBFROVERFLOW */
	{0x50b3,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBFROVERFLOW */
	{0x50b4,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBFROVERFLOW */
	{0x50b5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBFROVERFLOW */
	{0x50b6,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBFROVERFLOW */
	{0x50b7,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBFROVERFLOW */
	{0x50b8,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBFR_CHECK */
	{0x50b9,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBFR_CHECK */
	{0x50ba,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBFR_CHECK */
	{0x50bb,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBFR_CHECK */
	{0x50bc,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBFR_CHECK */
	{0x50bd,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBFR_CHECK */
	{0x50be,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBFR_CHECK */
	{0x50bf,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBFR_CHECK */
	{0x50c0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_CONTROLLDPC */
	{0x50c1,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_MODEEXTRAITER */
	{0x50c2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_MODEFRACT */
	{0x50c3,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELLAYER */
	{0x50c4,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_MAXEXTRAITER */
	{0x50c5,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_LGTHSTOPITER */
	{0x50c6,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBLAYERSTOP */
	{0x50c7,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_THSTOP */
	{0x50c8,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_FRACTSET */
	{0x50c9,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_MAXEXTRAITER */
	{0x50ca,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_LGTHSTOPITER */
	{0x50cb,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBLAYERSTOP */
	{0x50cc,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_THSTOP */
	{0x50cd,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_FRACTSET */
	{0x50ce,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_MAXEXTRAITER */
	{0x50cf,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_LGTHSTOPITER */
	{0x50d0,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBLAYERSTOP */
	{0x50d1,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_THSTOP */
	{0x50d2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_FRACTSET */
	{0x50d3,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_MAXEXTRAITER */
	{0x50d4,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_LGTHSTOPITER */
	{0x50d5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBLAYERSTOP */
	{0x50d6,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_THSTOP */
	{0x50d7,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_FRACTSET */
	{0x50d8,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_MAXEXTRAITER */
	{0x50d9,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_LGTHSTOPITER */
	{0x50da,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBLAYERSTOP */
	{0x50db,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_THSTOP */
	{0x50dc,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_FRACTSET */
	{0x50dd,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_MAXEXTRAITER */
	{0x50de,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_LGTHSTOPITER */
	{0x50df,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBLAYERSTOP */
	{0x50e0,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_THSTOP */
	{0x50e1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_FRACTSET */
	{0x50e2,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_MAXEXTRAITER */
	{0x50e3,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_LGTHSTOPITER */
	{0x50e4,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBLAYERSTOP */
	{0x50e5,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_THSTOP */
	{0x50e6,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_FRACTSET */
	{0x50e7,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_MAXEXTRAITER */
	{0x50e8,    0x08,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_LGTHSTOPITER */
	{0x50e9,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBLAYERSTOP */
	{0x50ea,    0x02,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_THSTOP */
	{0x50eb,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_FRACTSET */
	{0x5100,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF1 */
	{0x5101,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF2 */
	{0x5102,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF3 */
	{0x5103,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF4 */
	{0x5104,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF5 */
	{0x5105,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF6 */
	{0x5106,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF7 */
	{0x5107,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF8 */
	{0x5108,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF9 */
	{0x5109,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF10 */
	{0x510a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF11 */
	{0x510b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF12 */
	{0x510c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF13 */
	{0x510d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF14 */
	{0x510e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF15 */
	{0x510f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF16 */
	{0x5110,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF17 */
	{0x5111,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF18 */
	{0x5112,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF19 */
	{0x5113,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF20 */
	{0x5114,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF21 */
	{0x5115,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF22 */
	{0x5116,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF23 */
	{0x5117,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF24 */
	{0x5118,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF25 */
	{0x5119,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF26 */
	{0x511a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF27 */
	{0x511b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF28 */
	{0x511c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF1 */
	{0x511d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF2 */
	{0x511e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF3 */
	{0x511f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF4 */
	{0x5120,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF5 */
	{0x5121,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF6 */
	{0x5122,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF7 */
	{0x5123,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF8 */
	{0x5124,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF9 */
	{0x5125,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF10 */
	{0x5126,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF12 */
	{0x5127,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF13 */
	{0x5128,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF14 */
	{0x5129,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF15 */
	{0x512a,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF16 */
	{0x512b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF18 */
	{0x512c,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF19 */
	{0x512d,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF20 */
	{0x512e,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF21 */
	{0x512f,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF22 */
	{0x5130,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF24 */
	{0x5131,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF25 */
	{0x5132,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF26 */
	{0x5133,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF27 */
	{0x5140,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF1 */
	{0x5141,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF2 */
	{0x5142,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF3 */
	{0x5143,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF4 */
	{0x5144,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF5 */
	{0x5145,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF6 */
	{0x5146,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF7 */
	{0x5147,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF8 */
	{0x5148,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF9 */
	{0x5149,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF10 */
	{0x514a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF11 */
	{0x514b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF12 */
	{0x514c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF13 */
	{0x514d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF14 */
	{0x514e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF15 */
	{0x514f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF16 */
	{0x5150,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF17 */
	{0x5151,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF18 */
	{0x5152,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF19 */
	{0x5153,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF20 */
	{0x5154,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF21 */
	{0x5155,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF22 */
	{0x5156,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF23 */
	{0x5157,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF24 */
	{0x5158,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF25 */
	{0x5159,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF26 */
	{0x515a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF27 */
	{0x515b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF28 */
	{0x515c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF1 */
	{0x515d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF2 */
	{0x515e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF3 */
	{0x515f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF4 */
	{0x5160,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF5 */
	{0x5161,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF6 */
	{0x5162,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF7 */
	{0x5163,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF8 */
	{0x5164,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF9 */
	{0x5165,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF10 */
	{0x5166,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF12 */
	{0x5167,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF13 */
	{0x5168,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF14 */
	{0x5169,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF15 */
	{0x516a,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF16 */
	{0x516b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF18 */
	{0x516c,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF19 */
	{0x516d,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF20 */
	{0x516e,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF21 */
	{0x516f,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF22 */
	{0x5170,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF24 */
	{0x5171,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF25 */
	{0x5172,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF26 */
	{0x5173,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF27 */
	{0x5180,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF1 */
	{0x5181,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF2 */
	{0x5182,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF3 */
	{0x5183,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF4 */
	{0x5184,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF5 */
	{0x5185,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF6 */
	{0x5186,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF7 */
	{0x5187,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF8 */
	{0x5188,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF9 */
	{0x5189,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF10 */
	{0x518a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF11 */
	{0x518b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF12 */
	{0x518c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF13 */
	{0x518d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF14 */
	{0x518e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF15 */
	{0x518f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF16 */
	{0x5190,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF17 */
	{0x5191,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF18 */
	{0x5192,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF19 */
	{0x5193,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF20 */
	{0x5194,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF21 */
	{0x5195,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF22 */
	{0x5196,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF23 */
	{0x5197,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF24 */
	{0x5198,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF25 */
	{0x5199,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF26 */
	{0x519a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF27 */
	{0x519b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF28 */
	{0x519c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF1 */
	{0x519d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF2 */
	{0x519e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF3 */
	{0x519f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF4 */
	{0x51a0,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF5 */
	{0x51a1,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF6 */
	{0x51a2,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF7 */
	{0x51a3,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF8 */
	{0x51a4,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF9 */
	{0x51a5,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF10 */
	{0x51a6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF12 */
	{0x51a7,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF13 */
	{0x51a8,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF14 */
	{0x51a9,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF15 */
	{0x51aa,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF16 */
	{0x51ab,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF18 */
	{0x51ac,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF19 */
	{0x51ad,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF20 */
	{0x51ae,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF21 */
	{0x51af,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF22 */
	{0x51b0,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF24 */
	{0x51b1,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF25 */
	{0x51b2,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF26 */
	{0x51b3,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF27 */
	{0x51c0,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF1 */
	{0x51c1,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF2 */
	{0x51c2,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF3 */
	{0x51c3,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF4 */
	{0x51c4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF5 */
	{0x51c5,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF6 */
	{0x51c6,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF7 */
	{0x51c7,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF8 */
	{0x51c8,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF9 */
	{0x51c9,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF10 */
	{0x51ca,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF11 */
	{0x51cb,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF12 */
	{0x51cc,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF13 */
	{0x51cd,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF14 */
	{0x51ce,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF15 */
	{0x51cf,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF16 */
	{0x51d0,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF17 */
	{0x51d1,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF18 */
	{0x51d2,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF19 */
	{0x51d3,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF20 */
	{0x51d4,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF21 */
	{0x51d5,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF22 */
	{0x51d6,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF23 */
	{0x51d7,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF24 */
	{0x51d8,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF25 */
	{0x51d9,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF26 */
	{0x51da,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF27 */
	{0x51db,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF28 */
	{0x51dc,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF1 */
	{0x51dd,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF2 */
	{0x51de,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF3 */
	{0x51df,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF4 */
	{0x51e0,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF5 */
	{0x51e1,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF6 */
	{0x51e2,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF7 */
	{0x51e3,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF8 */
	{0x51e4,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF9 */
	{0x51e5,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF10 */
	{0x51e6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF12 */
	{0x51e7,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF13 */
	{0x51e8,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF14 */
	{0x51e9,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF15 */
	{0x51ea,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF16 */
	{0x51eb,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF18 */
	{0x51ec,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF19 */
	{0x51ed,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF20 */
	{0x51ee,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF21 */
	{0x51ef,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF22 */
	{0x51f0,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF24 */
	{0x51f1,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF25 */
	{0x51f2,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF26 */
	{0x51f3,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF27 */
	{0x5200,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF1 */
	{0x5201,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF2 */
	{0x5202,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF3 */
	{0x5203,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF4 */
	{0x5204,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF5 */
	{0x5205,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF6 */
	{0x5206,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF7 */
	{0x5207,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF8 */
	{0x5208,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF9 */
	{0x5209,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF10 */
	{0x520a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF11 */
	{0x520b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF12 */
	{0x520c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF13 */
	{0x520d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF14 */
	{0x520e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF15 */
	{0x520f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF16 */
	{0x5210,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF17 */
	{0x5211,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF18 */
	{0x5212,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF19 */
	{0x5213,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF20 */
	{0x5214,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF21 */
	{0x5215,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF22 */
	{0x5216,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF23 */
	{0x5217,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF24 */
	{0x5218,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF25 */
	{0x5219,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF26 */
	{0x521a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF27 */
	{0x521b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF28 */
	{0x521c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF1 */
	{0x521d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF2 */
	{0x521e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF3 */
	{0x521f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF4 */
	{0x5220,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF5 */
	{0x5221,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF6 */
	{0x5222,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF7 */
	{0x5223,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF8 */
	{0x5224,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF9 */
	{0x5225,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF10 */
	{0x5226,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF12 */
	{0x5227,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF13 */
	{0x5228,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF14 */
	{0x5229,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF15 */
	{0x522a,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF16 */
	{0x522b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF18 */
	{0x522c,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF19 */
	{0x522d,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF20 */
	{0x522e,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF21 */
	{0x522f,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF22 */
	{0x5230,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF24 */
	{0x5231,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF25 */
	{0x5232,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF26 */
	{0x5233,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF27 */
	{0x5240,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF1 */
	{0x5241,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF2 */
	{0x5242,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF3 */
	{0x5243,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF4 */
	{0x5244,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF5 */
	{0x5245,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF6 */
	{0x5246,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF7 */
	{0x5247,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF8 */
	{0x5248,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF9 */
	{0x5249,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF10 */
	{0x524a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF11 */
	{0x524b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF12 */
	{0x524c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF13 */
	{0x524d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF14 */
	{0x524e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF15 */
	{0x524f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF16 */
	{0x5250,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF17 */
	{0x5251,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF18 */
	{0x5252,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF19 */
	{0x5253,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF20 */
	{0x5254,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF21 */
	{0x5255,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF22 */
	{0x5256,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF23 */
	{0x5257,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF24 */
	{0x5258,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF25 */
	{0x5259,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF26 */
	{0x525a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF27 */
	{0x525b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF28 */
	{0x525c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF1 */
	{0x525d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF2 */
	{0x525e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF3 */
	{0x525f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF4 */
	{0x5260,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF5 */
	{0x5261,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF6 */
	{0x5262,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF7 */
	{0x5263,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF8 */
	{0x5264,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF9 */
	{0x5265,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF10 */
	{0x5266,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF12 */
	{0x5267,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF13 */
	{0x5268,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF14 */
	{0x5269,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF15 */
	{0x526a,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF16 */
	{0x526b,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF18 */
	{0x526c,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF19 */
	{0x526d,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF20 */
	{0x526e,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF21 */
	{0x526f,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF22 */
	{0x5270,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF24 */
	{0x5271,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF25 */
	{0x5272,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF26 */
	{0x5273,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF27 */
	{0x5280,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF1 */
	{0x5281,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF2 */
	{0x5282,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF3 */
	{0x5283,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF4 */
	{0x5284,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF5 */
	{0x5285,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF6 */
	{0x5286,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF7 */
	{0x5287,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF8 */
	{0x5288,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF9 */
	{0x5289,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF10 */
	{0x528a,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF11 */
	{0x528b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF12 */
	{0x528c,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF13 */
	{0x528d,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF14 */
	{0x528e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF15 */
	{0x528f,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF16 */
	{0x5290,    0x27,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF17 */
	{0x5291,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF18 */
	{0x5292,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF19 */
	{0x5293,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF20 */
	{0x5294,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF21 */
	{0x5295,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF22 */
	{0x5296,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF23 */
	{0x5297,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF24 */
	{0x5298,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF25 */
	{0x5299,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF26 */
	{0x529a,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF27 */
	{0x529b,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF28 */
	{0x529c,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF1 */
	{0x529d,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF2 */
	{0x529e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF3 */
	{0x529f,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF4 */
	{0x52a0,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF5 */
	{0x52a1,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF6 */
	{0x52a2,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF7 */
	{0x52a3,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF8 */
	{0x52a4,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF9 */
	{0x52a5,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF10 */
	{0x52a6,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF12 */
	{0x52a7,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF13 */
	{0x52a8,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF14 */
	{0x52a9,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF15 */
	{0x52aa,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF16 */
	{0x52ab,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF18 */
	{0x52ac,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF19 */
	{0x52ad,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF20 */
	{0x52ae,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF21 */
	{0x52af,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF22 */
	{0x52b0,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF24 */
	{0x52b1,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF25 */
	{0x52b2,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF26 */
	{0x52b3,    0x23,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF27 */
	{0x5300,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF33_0 */
	{0x5301,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF33_1 */
	{0x5302,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF34_0 */
	{0x5303,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF34_1 */
	{0x5304,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF35_0 */
	{0x5305,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF35_1 */
	{0x5306,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF36_0 */
	{0x5307,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF36_1 */
	{0x5308,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF37_0 */
	{0x5309,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF37_1 */
	{0x530a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF38_0 */
	{0x530b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF38_1 */
	{0x530c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF39_0 */
	{0x530d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF39_1 */
	{0x530e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF40_0 */
	{0x530f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF40_1 */
	{0x5310,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF41_0 */
	{0x5311,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF41_1 */
	{0x5312,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF42_0 */
	{0x5313,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF42_1 */
	{0x5314,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF43_0 */
	{0x5315,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF43_1 */
	{0x5316,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF44_1 */
	{0x5317,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF45_0 */
	{0x5318,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF45_1 */
	{0x5319,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF46_0 */
	{0x531a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF46_1 */
	{0x531b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF47_1 */
	{0x531c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF48_1 */
	{0x531d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF49_1 */
	{0x531e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF50_0 */
	{0x531f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF50_1 */
	{0x5320,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF51_0 */
	{0x5321,    0x2d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF51_1 */
	{0x5322,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF52_0 */
	{0x5323,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF52_1 */
	{0x5324,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF53_0 */
	{0x5325,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_NF53_1 */
	{0x5326,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF54_0 */
	{0x5327,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF54_1 */
	{0x5328,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF55_0 */
	{0x5329,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF55_1 */
	{0x532a,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF56_0 */
	{0x532b,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF56_1 */
	{0x532c,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF57_0 */
	{0x532d,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF57_1 */
	{0x532e,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF58_0 */
	{0x532f,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF58_1 */
	{0x5330,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF59_0 */
	{0x5331,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF59_1 */
	{0x5332,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF60_0 */
	{0x5333,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF60_1 */
	{0x5334,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF61_0 */
	{0x5335,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF61_1 */
	{0x5336,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P1_NBITER_SF62_0 */
	{0x5337,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR13 */
	{0x5338,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR12 */
	{0x5339,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR11 */
	{0x533a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR10 */
	{0x533b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR9 */
	{0x533c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR8 */
	{0x533d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_SELSATUR7 */
	{0x5340,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF33_0 */
	{0x5341,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF33_1 */
	{0x5342,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF34_0 */
	{0x5343,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF34_1 */
	{0x5344,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF35_0 */
	{0x5345,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF35_1 */
	{0x5346,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF36_0 */
	{0x5347,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF36_1 */
	{0x5348,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF37_0 */
	{0x5349,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF37_1 */
	{0x534a,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF38_0 */
	{0x534b,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF38_1 */
	{0x534c,    0x21,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF39_0 */
	{0x534d,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF39_1 */
	{0x534e,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF40_0 */
	{0x534f,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF40_1 */
	{0x5350,    0x2a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF41_0 */
	{0x5351,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF41_1 */
	{0x5352,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF42_0 */
	{0x5353,    0x2B,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF42_1 */
	{0x5354,    0x40,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF43_0 */
	{0x5355,    0x45,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF43_1 */
	{0x5356,    0x53,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF44_1 */
	{0x5357,    0x57,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF45_0 */
	{0x5358,    0x62,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF45_1 */
	{0x5359,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF46_0 */
	{0x535a,    0x76,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF46_1 */
	{0x535b,    0x71,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF47_1 */
	{0x535c,    0xfe,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF48_1 */
	{0x535d,    0xff,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF49_1 */
	{0x535e,    0xc0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF50_0 */
	{0x535f,    0xb0,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF50_1 */
	{0x5360,    0x2c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF51_0 */
	{0x5361,    0x2d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF51_1 */
	{0x5362,    0x30,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF52_0 */
	{0x5363,    0x32,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF52_1 */
	{0x5364,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF53_0 */
	{0x5365,    0x38,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_NF53_1 */
	{0x5366,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF54_0 */
	{0x5367,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF54_1 */
	{0x5368,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF55_0 */
	{0x5369,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF55_1 */
	{0x536a,    0x25,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF56_0 */
	{0x536b,    0x2b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF56_1 */
	{0x536c,    0x12,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF57_0 */
	{0x536d,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF57_1 */
	{0x536e,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF58_0 */
	{0x536f,    0x26,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF58_1 */
	{0x5370,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF59_0 */
	{0x5371,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF59_1 */
	{0x5372,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF60_0 */
	{0x5373,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF60_1 */
	{0x5374,    0x29,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF61_0 */
	{0x5375,    0x3b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF61_1 */
	{0x5376,    0x41,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_GAINLLR_SF62_0 */
	{0x5377,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER13 */
	{0x5378,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER12 */
	{0x5379,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER11 */
	{0x537a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER10 */
	{0x537b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER9 */
	{0x537c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER8 */
	{0x537d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_INVDINTER7 */
	{0x5380,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF33_0 */
	{0x5381,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF33_1 */
	{0x5382,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF34_0 */
	{0x5383,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF34_1 */
	{0x5384,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF35_0 */
	{0x5385,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF35_1 */
	{0x5386,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF36_0 */
	{0x5387,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF36_1 */
	{0x5388,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF37_0 */
	{0x5389,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF37_1 */
	{0x538a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF38_0 */
	{0x538b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF38_1 */
	{0x538c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF39_0 */
	{0x538d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF39_1 */
	{0x538e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF40_0 */
	{0x538f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF40_1 */
	{0x5390,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF41_0 */
	{0x5391,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF41_1 */
	{0x5392,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF42_0 */
	{0x5393,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF42_1 */
	{0x5394,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF43_0 */
	{0x5395,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF43_1 */
	{0x5396,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF44_1 */
	{0x5397,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF45_0 */
	{0x5398,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF45_1 */
	{0x5399,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF46_0 */
	{0x539a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF46_1 */
	{0x539b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF47_1 */
	{0x539c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF48_1 */
	{0x539d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF49_1 */
	{0x539e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF50_0 */
	{0x539f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF50_1 */
	{0x53a0,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF51_0 */
	{0x53a1,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF51_1 */
	{0x53a2,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF52_0 */
	{0x53a3,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF52_1 */
	{0x53a4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF53_0 */
	{0x53a5,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_NF53_1 */
	{0x53a6,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF54_0 */
	{0x53a7,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF54_1 */
	{0x53a8,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF55_0 */
	{0x53a9,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF55_1 */
	{0x53aa,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF56_0 */
	{0x53ab,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF56_1 */
	{0x53ac,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF57_0 */
	{0x53ad,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF57_1 */
	{0x53ae,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF58_0 */
	{0x53af,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF58_1 */
	{0x53b0,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF59_0 */
	{0x53b1,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF59_1 */
	{0x53b2,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF60_0 */
	{0x53b3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF60_1 */
	{0x53b4,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF61_0 */
	{0x53b5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF61_1 */
	{0x53b6,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P2_NBITER_SF62_0 */
	{0x53c0,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF33_0 */
	{0x53c1,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF33_1 */
	{0x53c2,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF34_0 */
	{0x53c3,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF34_1 */
	{0x53c4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF35_0 */
	{0x53c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF35_1 */
	{0x53c6,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF36_0 */
	{0x53c7,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF36_1 */
	{0x53c8,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF37_0 */
	{0x53c9,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF37_1 */
	{0x53ca,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF38_0 */
	{0x53cb,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF38_1 */
	{0x53cc,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF39_0 */
	{0x53cd,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF39_1 */
	{0x53ce,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF40_0 */
	{0x53cf,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF40_1 */
	{0x53d0,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF41_0 */
	{0x53d1,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF41_1 */
	{0x53d2,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF42_0 */
	{0x53d3,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF42_1 */
	{0x53d4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF43_0 */
	{0x53d5,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF43_1 */
	{0x53d6,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF44_1 */
	{0x53d7,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF45_0 */
	{0x53d8,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF45_1 */
	{0x53d9,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF46_0 */
	{0x53da,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF46_1 */
	{0x53db,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF47_1 */
	{0x53dc,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF48_1 */
	{0x53dd,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF49_1 */
	{0x53de,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF50_0 */
	{0x53df,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF50_1 */
	{0x53e0,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF51_0 */
	{0x53e1,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF51_1 */
	{0x53e2,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF52_0 */
	{0x53e3,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF52_1 */
	{0x53e4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF53_0 */
	{0x53e5,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_NF53_1 */
	{0x53e6,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF54_0 */
	{0x53e7,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF54_1 */
	{0x53e8,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF55_0 */
	{0x53e9,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF55_1 */
	{0x53ea,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF56_0 */
	{0x53eb,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF56_1 */
	{0x53ec,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF57_0 */
	{0x53ed,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF57_1 */
	{0x53ee,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF58_0 */
	{0x53ef,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF58_1 */
	{0x53f0,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF59_0 */
	{0x53f1,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF59_1 */
	{0x53f2,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF60_0 */
	{0x53f3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF60_1 */
	{0x53f4,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF61_0 */
	{0x53f5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF61_1 */
	{0x53f6,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P3_NBITER_SF62_0 */
	{0x5400,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF33_0 */
	{0x5401,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF33_1 */
	{0x5402,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF34_0 */
	{0x5403,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF34_1 */
	{0x5404,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF35_0 */
	{0x5405,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF35_1 */
	{0x5406,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF36_0 */
	{0x5407,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF36_1 */
	{0x5408,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF37_0 */
	{0x5409,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF37_1 */
	{0x540a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF38_0 */
	{0x540b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF38_1 */
	{0x540c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF39_0 */
	{0x540d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF39_1 */
	{0x540e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF40_0 */
	{0x540f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF40_1 */
	{0x5410,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF41_0 */
	{0x5411,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF41_1 */
	{0x5412,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF42_0 */
	{0x5413,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF42_1 */
	{0x5414,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF43_0 */
	{0x5415,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF43_1 */
	{0x5416,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF44_1 */
	{0x5417,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF45_0 */
	{0x5418,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF45_1 */
	{0x5419,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF46_0 */
	{0x541a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF46_1 */
	{0x541b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF47_1 */
	{0x541c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF48_1 */
	{0x541d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF49_1 */
	{0x541e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF50_0 */
	{0x541f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF50_1 */
	{0x5420,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF51_0 */
	{0x5421,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF51_1 */
	{0x5422,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF52_0 */
	{0x5423,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF52_1 */
	{0x5424,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF53_0 */
	{0x5425,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_NF53_1 */
	{0x5426,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF54_0 */
	{0x5427,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF54_1 */
	{0x5428,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF55_0 */
	{0x5429,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF55_1 */
	{0x542a,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF56_0 */
	{0x542b,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF56_1 */
	{0x542c,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF57_0 */
	{0x542d,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF57_1 */
	{0x542e,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF58_0 */
	{0x542f,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF58_1 */
	{0x5430,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF59_0 */
	{0x5431,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF59_1 */
	{0x5432,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF60_0 */
	{0x5433,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF60_1 */
	{0x5434,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF61_0 */
	{0x5435,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF61_1 */
	{0x5436,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P4_NBITER_SF62_0 */
	{0x5440,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF33_0 */
	{0x5441,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF33_1 */
	{0x5442,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF34_0 */
	{0x5443,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF34_1 */
	{0x5444,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF35_0 */
	{0x5445,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF35_1 */
	{0x5446,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF36_0 */
	{0x5447,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF36_1 */
	{0x5448,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF37_0 */
	{0x5449,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF37_1 */
	{0x544a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF38_0 */
	{0x544b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF38_1 */
	{0x544c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF39_0 */
	{0x544d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF39_1 */
	{0x544e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF40_0 */
	{0x544f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF40_1 */
	{0x5450,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF41_0 */
	{0x5451,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF41_1 */
	{0x5452,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF42_0 */
	{0x5453,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF42_1 */
	{0x5454,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF43_0 */
	{0x5455,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF43_1 */
	{0x5456,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF44_1 */
	{0x5457,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF45_0 */
	{0x5458,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF45_1 */
	{0x5459,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF46_0 */
	{0x545a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF46_1 */
	{0x545b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF47_1 */
	{0x545c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF48_1 */
	{0x545d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF49_1 */
	{0x545e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF50_0 */
	{0x545f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF50_1 */
	{0x5460,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF51_0 */
	{0x5461,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF51_1 */
	{0x5462,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF52_0 */
	{0x5463,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF52_1 */
	{0x5464,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF53_0 */
	{0x5465,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_NF53_1 */
	{0x5466,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF54_0 */
	{0x5467,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF54_1 */
	{0x5468,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF55_0 */
	{0x5469,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF55_1 */
	{0x546a,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF56_0 */
	{0x546b,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF56_1 */
	{0x546c,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF57_0 */
	{0x546d,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF57_1 */
	{0x546e,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF58_0 */
	{0x546f,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF58_1 */
	{0x5470,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF59_0 */
	{0x5471,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF59_1 */
	{0x5472,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF60_0 */
	{0x5473,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF60_1 */
	{0x5474,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF61_0 */
	{0x5475,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF61_1 */
	{0x5476,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P5_NBITER_SF62_0 */
	{0x5480,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF33_0 */
	{0x5481,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF33_1 */
	{0x5482,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF34_0 */
	{0x5483,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF34_1 */
	{0x5484,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF35_0 */
	{0x5485,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF35_1 */
	{0x5486,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF36_0 */
	{0x5487,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF36_1 */
	{0x5488,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF37_0 */
	{0x5489,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF37_1 */
	{0x548a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF38_0 */
	{0x548b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF38_1 */
	{0x548c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF39_0 */
	{0x548d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF39_1 */
	{0x548e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF40_0 */
	{0x548f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF40_1 */
	{0x5490,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF41_0 */
	{0x5491,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF41_1 */
	{0x5492,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF42_0 */
	{0x5493,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF42_1 */
	{0x5494,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF43_0 */
	{0x5495,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF43_1 */
	{0x5496,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF44_1 */
	{0x5497,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF45_0 */
	{0x5498,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF45_1 */
	{0x5499,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF46_0 */
	{0x549a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF46_1 */
	{0x549b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF47_1 */
	{0x549c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF48_1 */
	{0x549d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF49_1 */
	{0x549e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF50_0 */
	{0x549f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF50_1 */
	{0x54a0,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF51_0 */
	{0x54a1,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF51_1 */
	{0x54a2,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF52_0 */
	{0x54a3,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF52_1 */
	{0x54a4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF53_0 */
	{0x54a5,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_NF53_1 */
	{0x54a6,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF54_0 */
	{0x54a7,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF54_1 */
	{0x54a8,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF55_0 */
	{0x54a9,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF55_1 */
	{0x54aa,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF56_0 */
	{0x54ab,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF56_1 */
	{0x54ac,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF57_0 */
	{0x54ad,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF57_1 */
	{0x54ae,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF58_0 */
	{0x54af,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF58_1 */
	{0x54b0,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF59_0 */
	{0x54b1,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF59_1 */
	{0x54b2,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF60_0 */
	{0x54b3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF60_1 */
	{0x54b4,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF61_0 */
	{0x54b5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF61_1 */
	{0x54b6,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P6_NBITER_SF62_0 */
	{0x54c0,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF33_0 */
	{0x54c1,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF33_1 */
	{0x54c2,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF34_0 */
	{0x54c3,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF34_1 */
	{0x54c4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF35_0 */
	{0x54c5,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF35_1 */
	{0x54c6,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF36_0 */
	{0x54c7,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF36_1 */
	{0x54c8,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF37_0 */
	{0x54c9,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF37_1 */
	{0x54ca,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF38_0 */
	{0x54cb,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF38_1 */
	{0x54cc,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF39_0 */
	{0x54cd,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF39_1 */
	{0x54ce,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF40_0 */
	{0x54cf,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF40_1 */
	{0x54d0,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF41_0 */
	{0x54d1,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF41_1 */
	{0x54d2,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF42_0 */
	{0x54d3,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF42_1 */
	{0x54d4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF43_0 */
	{0x54d5,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF43_1 */
	{0x54d6,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF44_1 */
	{0x54d7,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF45_0 */
	{0x54d8,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF45_1 */
	{0x54d9,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF46_0 */
	{0x54da,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF46_1 */
	{0x54db,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF47_1 */
	{0x54dc,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF48_1 */
	{0x54dd,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF49_1 */
	{0x54de,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF50_0 */
	{0x54df,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF50_1 */
	{0x54e0,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF51_0 */
	{0x54e1,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF51_1 */
	{0x54e2,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF52_0 */
	{0x54e3,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF52_1 */
	{0x54e4,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF53_0 */
	{0x54e5,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_NF53_1 */
	{0x54e6,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF54_0 */
	{0x54e7,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF54_1 */
	{0x54e8,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF55_0 */
	{0x54e9,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF55_1 */
	{0x54ea,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF56_0 */
	{0x54eb,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF56_1 */
	{0x54ec,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF57_0 */
	{0x54ed,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF57_1 */
	{0x54ee,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF58_0 */
	{0x54ef,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF58_1 */
	{0x54f0,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF59_0 */
	{0x54f1,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF59_1 */
	{0x54f2,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF60_0 */
	{0x54f3,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF60_1 */
	{0x54f4,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF61_0 */
	{0x54f5,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF61_1 */
	{0x54f6,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P7_NBITER_SF62_0 */
	{0x5500,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF33_0 */
	{0x5501,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF33_1 */
	{0x5502,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF34_0 */
	{0x5503,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF34_1 */
	{0x5504,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF35_0 */
	{0x5505,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF35_1 */
	{0x5506,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF36_0 */
	{0x5507,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF36_1 */
	{0x5508,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF37_0 */
	{0x5509,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF37_1 */
	{0x550a,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF38_0 */
	{0x550b,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF38_1 */
	{0x550c,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF39_0 */
	{0x550d,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF39_1 */
	{0x550e,    0x1e,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF40_0 */
	{0x550f,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF40_1 */
	{0x5510,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF41_0 */
	{0x5511,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF41_1 */
	{0x5512,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF42_0 */
	{0x5513,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF42_1 */
	{0x5514,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF43_0 */
	{0x5515,    0x22,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF43_1 */
	{0x5516,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF44_1 */
	{0x5517,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF45_0 */
	{0x5518,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF45_1 */
	{0x5519,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF46_0 */
	{0x551a,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF46_1 */
	{0x551b,    0x1d,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF47_1 */
	{0x551c,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF48_1 */
	{0x551d,    0x1f,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF49_1 */
	{0x551e,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF50_0 */
	{0x551f,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF50_1 */
	{0x5520,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF51_0 */
	{0x5521,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF51_1 */
	{0x5522,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF52_0 */
	{0x5523,    0x1b,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF52_1 */
	{0x5524,    0x1a,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF53_0 */
	{0x5525,    0x1c,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_NF53_1 */
	{0x5526,    0x24,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF54_0 */
	{0x5527,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF54_1 */
	{0x5528,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF55_0 */
	{0x5529,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF55_1 */
	{0x552a,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF56_0 */
	{0x552b,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF56_1 */
	{0x552c,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF57_0 */
	{0x552d,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF57_1 */
	{0x552e,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF58_0 */
	{0x552f,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF58_1 */
	{0x5530,    0x14,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF59_0 */
	{0x5531,    0x13,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF59_1 */
	{0x5532,    0x15,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF60_0 */
	{0x5533,    0x18,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF60_1 */
	{0x5534,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF61_0 */
	{0x5535,    0x20,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF61_1 */
	{0x5536,    0x17,    STCHIP_REGSIZE_8},	/* REG_RC8CODEW_C8CODEW_DVBS2FEC_P8_NBITER_SF62_0 */

	{0x9000,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_OSC */
	{0x9001,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_CTRL */
	{0x9002,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_INT */
	{0x9003,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_FRAC1 */
	{0x9004,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_FRAC2 */
	{0x9005,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_TST1 */
	{0x9006,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_PLL_TST2 */
	{0x9007,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_VCO_CAL1 */
	{0x9008,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_VCO_CAL2 */
	{0x9009,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_VCO_CTRL */
	{0x900a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DFECLK_CTRL1 */
	{0x900b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DFECLK_CTRL2 */
	{0x9010,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RX1_CTRL */
	{0x9011,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RX2_CTRL */
	{0x9012,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RX3_CTRL */
	{0x9013,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RX4_CTRL */
	{0x9014,    0xF0,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB_CAL */
	{0x9015,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB1I_CAL */
	{0x9016,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB1Q_CAL */
	{0x9017,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB2I_CAL */
	{0x9018,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB2Q_CAL */
	{0x9019,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB3I_CAL */
	{0x901a,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB3Q_CAL */
	{0x901b,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB4I_CAL */
	{0x901c,    0xFF,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BB4Q_CAL */
	{0x901d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RF_CFG1 */
	{0x901e,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_RF_CFG2 */
	{0x9020,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_ADDR1 */
	{0x9021,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_ADDR2 */
	{0x9022,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_CORR1 */
	{0x9023,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_CORR2 */
	{0x9024,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC1_CTRL1 */
	{0x9025,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC1_CTRL2 */
	{0x9026,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC2_CTRL1 */
	{0x9027,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC2_CTRL2 */
	{0x9028,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC3_CTRL1 */
	{0x9029,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC3_CTRL2 */
	{0x902a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC4_CTRL1 */
	{0x902b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC4_CTRL2 */
	{0x902c,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_CFG */
	{0x902d,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ADC_TST */
	{0x9030,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC1_CTRL */
	{0x9031,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC2_CTRL */
	{0x9032,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC3_CTRL */
	{0x9033,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC4_CTRL */
	{0x9034,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC1_RF_PWM */
	{0x9035,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC2_RF_PWM */
	{0x9036,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC3_RF_PWM */
	{0x9037,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC4_RF_PWM */
	{0x9038,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC1_BB_PWM */
	{0x9039,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC2_BB_PWM */
	{0x903a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC3_BB_PWM */
	{0x903b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_AGC4_BB_PWM */
	{0x9040,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FSK */
	{0x9041,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DISEQC */
	{0x9042,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_LNBCTRL */
	{0x9050,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_BIAS_CTRL */
	{0x9051,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_LDO2V5_CTRL */
	{0x9052,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DCDC1V8_CTRL */
	{0x9053,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DCDC1V8_CAL1 */
	{0x9054,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DCDC1V8_CAL2 */
	{0x9055,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_DCDC1V8_TST */
	{0x9070,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL1 */
	{0x9071,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL2 */
	{0x9072,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL3 */
	{0x9073,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL4 */
	{0x9074,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL5 */
	{0x9075,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_CTRL6 */
	{0x9076,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_RF12 */
	{0x9077,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_RF34 */
	{0x9078,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_BB12 */
	{0x9079,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_BB34 */
	{0x907a,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_SPARE1 */
	{0x907b,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_SPARE2 */
	{0x907f,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_TST_MODE */
	{0x9080,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_ID */
	{0x9081,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_STATUS */
	{0x9082,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE1 */
	{0x9083,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE2 */
	{0x9084,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE3 */
	{0x9085,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE4 */
	{0x9086,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE5 */
	{0x9087,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_FUSE6 */
	{0x9090,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_IRQ_MASK */
	{0x9091,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_IRQ */
	{0x90f0,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_SPARE1 */
	{0x90f1,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_SPARE2 */
	{0x90f2,    0x00,    STCHIP_REGSIZE_8},	/* REG_RSTID135_AFE_AFE_SPARE3 */
};

static STCHIP_Register_t STiD135SocDefVal[]={
	{0x8000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_RESERVED0 */
	{0x8040,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS16 */
	{0x8080,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG32 */
	{0x8084,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG33 */
	{0x8088,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG34 */
	{0x808c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG35 */
	{0x8090,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG36 */
	{0x8094,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG37 */
	{0x8098,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG38 */
	{0x809c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG39 */
	{0x80c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS48 */
	{0x80c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS49 */
	{0x80c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS50 */
	{0x80cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS51 */
	{0x80d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS52 */
	{0x8100,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG64 */
	{0x8140,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS80 */
	{0x8180,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG96 */
	{0x8184,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG97 */
	{0x8188,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG98 */
	{0x818c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG99 */
	{0x81c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS112 */
	{0x8240,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_STATUS144 */
	{0x8280,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG160 */
	{0x8400,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT(1) */
	{0x8404,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_SET(1) */
	{0x8408,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_RESET(1) */
	{0x8410,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PIO_IN(1) */
	{0x8420,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0(1) */
	{0x8424,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_SET(1) */
	{0x8428,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_RST(1) */
	{0x8430,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1(1) */
	{0x8434,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_SET(1) */
	{0x8438,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_RST(1) */
	{0x8440,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2(1) */
	{0x8444,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_SET(1) */
	{0x8448,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_RST(1) */
	{0x8450,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP(1) */
	{0x8454,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_SET(1) */
	{0x8458,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_RST(1) */
	{0x8460,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK(1) */
	{0x8464,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_SET(1) */
	{0x8468,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_RST(1) */
	{0x8480,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT(2) */
	{0x8484,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_SET(2) */
	{0x8488,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_RESET(2) */
	{0x8490,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PIO_IN(2) */
	{0x84a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0(2) */
	{0x84a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_SET(2) */
	{0x84a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_RST(2) */
	{0x84b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1(2) */
	{0x84b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_SET(2) */
	{0x84b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_RST(2) */
	{0x84c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2(2) */
	{0x84c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_SET(2) */
	{0x84c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_RST(2) */
	{0x84d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP(2) */
	{0x84d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_SET(2) */
	{0x84d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_RST(2) */
	{0x84e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK(2) */
	{0x84e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_SET(2) */
	{0x84e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_RST(2) */
	{0x8500,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT(3) */
	{0x8504,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_SET(3) */
	{0x8508,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_POUT_RESET(3) */
	{0x8510,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PIO_IN(3) */
	{0x8520,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0(3) */
	{0x8524,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_SET(3) */
	{0x8528,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC0_RST(3) */
	{0x8530,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1(3) */
	{0x8534,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_SET(3) */
	{0x8538,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC1_RST(3) */
	{0x8540,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2(3) */
	{0x8544,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_SET(3) */
	{0x8548,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PC2_RST(3) */
	{0x8550,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP(3) */
	{0x8554,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_SET(3) */
	{0x8558,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PCOMP_RST(3) */
	{0x8560,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK(3) */
	{0x8564,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_SET(3) */
	{0x8568,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIONORTHPIO_PMASK_RST(3) */
	{0x8580,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_POUT(4) */
	{0x8584,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_POUT_SET(4) */
	{0x8588,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_POUT_RESET(4) */
	{0x8590,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PIO_IN(4) */
	{0x85a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC0(4) */
	{0x85a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC0_SET(4) */
	{0x85a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC0_RST(4) */
	{0x85b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC1(4) */
	{0x85b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC1_SET(4) */
	{0x85b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC1_RST(4) */
	{0x85c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC2(4) */
	{0x85c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC2_SET(4) */
	{0x85c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PC2_RST(4) */
	{0x85d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PCOMP(4) */
	{0x85d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PCOMP_SET(4) */
	{0x85d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PCOMP_RST(4) */
	{0x85e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PMASK(4) */
	{0x85e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PMASK_SET(4) */
	{0x85e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID145_X5BANKPIONORTHPIO_PMASK_RST(4) */
	{0x8600,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_POUT(5) */
	{0x8604,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_POUT_SET(5) */
	{0x8608,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_POUT_RESET(5) */
	{0x8610,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PIO_IN(5) */
	{0x8620,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC0(5) */
	{0x8624,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC0_SET(5) */
	{0x8628,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC0_RST(5) */
	{0x8630,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC1(5) */
	{0x8634,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC1_SET(5) */
	{0x8638,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC1_RST(5) */
	{0x8640,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC2(5) */
	{0x8644,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC2_SET(5) */
	{0x8648,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PC2_RST(5) */
	{0x8650,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PCOMP(5) */
	{0x8654,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PCOMP_SET(5) */
	{0x8658,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PCOMP_RST(5) */
	{0x8660,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PMASK(5) */
	{0x8664,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PMASK_SET(5) */
	{0x8668,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID155_X5BANKPIONORTHPIO_PMASK_RST(5) */
	{0x8800,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1000 */
	{0x8804,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1001 */
	{0x8808,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1002 */
	{0x880c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1003 */
	{0x88a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1040 */
	{0x88c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1050 */
	{0x88dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1055 */
	{0x88f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1060 */
	{0x8990,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1100 */
	{0x8994,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1101 */
	{0x8998,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1102 */
	{0x899c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1103 */
	{0x89a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1104 */
	{0x89a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1105 */
	{0x89a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1106 */
	{0x89ac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1107 */
	{0x89b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1108 */
	{0x89b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1109 */
	{0x89b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1110 */
	{0x89bc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1111 */
	{0x89c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1112 */
	{0x89c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1113 */
	{0x89c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1114 */
	{0x89cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1115 */
	{0x89d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1116 */
	{0x89d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1117 */
	{0x89d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1118 */
	{0x89dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1119 */
	{0x89e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1120 */
	{0x89e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1121 */
	{0x89e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1122 */
	{0x89ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1123 */
	{0x89f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1124 */
	{0x89f4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1125 */
	{0x89f8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1126 */
	{0x89fc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1127 */
	{0x8a00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1128 */
	{0x8a04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1129 */
	{0x8a08,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1130 */
	{0x8a0c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_NORTH_SYSTEM_CONFIG1131 */
	
	{0x9200,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_CONFIG */
	{0x9204,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_STATUS */
	{0x9208,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_INT_THRESH */
	{0x920c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_INT_ENABLE */
	{0x9210,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_INT_EVENT */
	{0x9214,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_INT_STATUS */
	{0x9218,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_LPA_THRESH */
	{0x921c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_LPA_ENABLE */
	{0x9220,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_LPA_EVENT */
	{0x9224,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C9THS_GLUE_TOP_TSENSOR_LPA_STATUS */
	{0x9800,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_VAL0 */
	{0x9804,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_VAL1 */
	{0x9808,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_VAL2 */
	{0x980c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_VAL3 */
	{0x9810,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_VAL0 */
	{0x9814,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_VAL1 */
	{0x9818,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_VAL2 */
	{0x981c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_VAL3 */
	{0x9820,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_VAL0 */
	{0x9824,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_VAL1 */
	{0x9828,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_VAL2 */
	{0x982c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_VAL3 */
	{0x9830,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_EDGE0 */
	{0x9834,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_EDGE1 */
	{0x9838,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_EDGE2 */
	{0x983c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_EDGE3 */
	{0x9840,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_OUT_VAL0 */
	{0x9844,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_OUT_VAL1 */
	{0x9848,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_OUT_VAL2 */
	{0x984c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CMP_OUT_VAL3 */
	{0x9850,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CTRL */
	{0x9854,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_INT_EN */
	{0x9858,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_INT_STA */
	{0x985c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_INT_ACK */
	{0x9860,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CNT */
	{0x9864,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_PWMTIMER_PWM_CPT_CMP_CNT */
	{0x9c00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8IRQ_MERGER_TOP_IRQ_POL */
	{0x9c04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8IRQ_MERGER_TOP_IRQ_VAL */
	{0xa000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG0 */
	{0xa040,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS16 */
	{0xa044,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS17 */
	{0xa080,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG32 */
	{0xa0c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS48 */
	{0xa0c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS49 */
	{0xa100,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG64 */
	{0xa104,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG65 */
	{0xa108,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG66 */
	{0xa10c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG67 */
	{0xa110,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG68 */
	{0xa140,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS80 */
	{0xa180,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG96 */
	{0xa184,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS97 */
	{0xa188,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS98 */
	{0xa18c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS99 */
	{0xa190,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS100 */
	{0xa194,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS101 */
	{0xa198,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS102 */
	{0xa19c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS103 */
	{0xa1c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS112 */
	{0xa1c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS113 */
	{0xa1c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS114 */
	{0xa1cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS115 */
	{0xa1d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS116 */
	{0xa1d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS117 */
	{0xa1d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS118 */
	{0xa1dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS119 */
	{0xa1e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS120 */
	{0xa1e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS121 */
	{0xa1e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS122 */
	{0xa1ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS123 */
	{0xa1f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS124 */
	{0xa1f4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS125 */
	{0xa1f8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS126 */
	{0xa1fc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS127 */
	{0xa200,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG128 */
	{0xa204,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG129 */
	{0xa208,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG130 */
	{0xa20c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG131 */
	{0xa210,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG132 */
	{0xa240,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_RESERVED144 */
	{0xa280,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG160 */
	{0xa2c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS176 */
	{0xa300,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG192 */
	{0xa304,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG193 */
	{0xa308,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG194 */
	{0xa340,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_STATUS208 */
	{0xa400,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT(1) */
	{0xa404,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_SET(1) */
	{0xa408,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_RESET(1) */
	{0xa410,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PIO_IN(1) */
	{0xa420,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0(1) */
	{0xa424,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_SET(1) */
	{0xa428,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_RST(1) */
	{0xa430,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1(1) */
	{0xa434,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_SET(1) */
	{0xa438,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_RST(1) */
	{0xa440,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2(1) */
	{0xa444,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_SET(1) */
	{0xa448,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_RST(1) */
	{0xa450,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP(1) */
	{0xa454,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_SET(1) */
	{0xa458,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_RST(1) */
	{0xa460,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK(1) */
	{0xa464,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_SET(1) */
	{0xa468,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_RST(1) */
	{0xa480,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT(2) */
	{0xa484,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_SET(2) */
	{0xa488,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_RESET(2) */
	{0xa490,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PIO_IN(2) */
	{0xa4a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0(2) */
	{0xa4a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_SET(2) */
	{0xa4a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_RST(2) */
	{0xa4b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1(2) */
	{0xa4b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_SET(2) */
	{0xa4b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_RST(2) */
	{0xa4c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2(2) */
	{0xa4c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_SET(2) */
	{0xa4c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_RST(2) */
	{0xa4d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP(2) */
	{0xa4d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_SET(2) */
	{0xa4d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_RST(2) */
	{0xa4e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK(2) */
	{0xa4e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_SET(2) */
	{0xa4e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_RST(2) */
	{0xa500,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT(3) */
	{0xa504,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_SET(3) */
	{0xa508,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_RESET(3) */
	{0xa510,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PIO_IN(3) */
	{0xa520,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0(3) */
	{0xa524,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_SET(3) */
	{0xa528,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_RST(3) */
	{0xa530,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1(3) */
	{0xa534,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_SET(3) */
	{0xa538,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_RST(3) */
	{0xa540,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2(3) */
	{0xa544,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_SET(3) */
	{0xa548,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_RST(3) */
	{0xa550,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP(3) */
	{0xa554,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_SET(3) */
	{0xa558,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_RST(3) */
	{0xa560,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK(3) */
	{0xa564,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_SET(3) */
	{0xa568,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_RST(3) */
	{0xa580,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT(4) */
	{0xa584,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_SET(4) */
	{0xa588,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_RESET(4) */
	{0xa590,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PIO_IN(4) */
	{0xa5a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0(4) */
	{0xa5a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_SET(4) */
	{0xa5a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_RST(4) */
	{0xa5b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1(4) */
	{0xa5b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_SET(4) */
	{0xa5b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_RST(4) */
	{0xa5c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2(4) */
	{0xa5c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_SET(4) */
	{0xa5c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_RST(4) */
	{0xa5d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP(4) */
	{0xa5d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_SET(4) */
	{0xa5d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_RST(4) */
	{0xa5e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK(4) */
	{0xa5e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_SET(4) */
	{0xa5e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_RST(4) */
	{0xa600,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT(5) */
	{0xa604,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_SET(5) */
	{0xa608,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_POUT_RESET(5) */
	{0xa610,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PIO_IN(5) */
	{0xa620,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0(5) */
	{0xa624,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_SET(5) */
	{0xa628,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC0_RST(5) */
	{0xa630,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1(5) */
	{0xa634,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_SET(5) */
	{0xa638,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC1_RST(5) */
	{0xa640,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2(5) */
	{0xa644,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_SET(5) */
	{0xa648,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PC2_RST(5) */
	{0xa650,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP(5) */
	{0xa654,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_SET(5) */
	{0xa658,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PCOMP_RST(5) */
	{0xa660,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK(5) */
	{0xa664,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_SET(5) */
	{0xa668,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_X5BANKPIOSOUTHPIO_PMASK_RST(5) */
	{0xa800,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1000 */
	{0xa804,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1001 */
	{0xa808,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1002 */
	{0xa80c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1003 */
	{0xa8a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1040 */
	{0xa8c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1050 */
	{0xa8dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1055 */
	{0xa8f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1060 */
	{0xa990,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1100 */
	{0xa994,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1101 */
	{0xa998,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1102 */
	{0xa99c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1103 */
	{0xa9a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1104 */
	{0xa9a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1105 */
	{0xa9a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1106 */
	{0xa9ac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1107 */
	{0xa9b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1108 */
	{0xa9b4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1109 */
	{0xa9b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1110 */
	{0xa9bc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1111 */
	{0xa9c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1112 */
	{0xa9c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1113 */
	{0xa9c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1114 */
	{0xa9cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1115 */
	{0xa9d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1116 */
	{0xa9d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1117 */
	{0xa9d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1118 */
	{0xa9dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1119 */
	{0xa9e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1120 */
	{0xa9e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1121 */
	{0xa9e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1122 */
	{0xa9ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1123 */
	{0xa9f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1124 */
	{0xa9f4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1125 */
	{0xa9f8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1126 */
	{0xa9fc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1127 */
	{0xaa00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1128 */
	{0xaa04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1129 */
	{0xaa08,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1130 */
	{0xaa0c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_SYSCFG_SOUTH_SYSTEM_CONFIG1131 */
	{0xac00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG0 */
	{0xac04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG1 */
	{0xac08,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG2 */
	{0xac0c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG3 */
	{0xac10,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG4 */
	{0xac14,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG5 */
	{0xac18,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG6 */
	{0xac1c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG7 */
	{0xac20,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG8 */
	{0xac24,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG9 */
	{0xac28,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG10 */
	{0xac2c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG11 */
	{0xac30,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG12 */
	{0xac34,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG13 */
	{0xac38,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG14 */
	{0xac3c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG15 */
	{0xac40,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG16 */
	{0xac44,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG17 */
	{0xac48,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG18 */
	{0xac4c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG19 */
	{0xac50,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG20 */
	{0xac54,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG21 */
	{0xac58,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG22 */
	{0xac5c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG23 */
	{0xac60,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG24 */
	{0xac64,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG25 */
	{0xac68,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG26 */
	{0xac6c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG27 */
	{0xac70,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG28 */
	{0xac74,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG29 */
	{0xac78,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG30 */
	{0xac7c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG31 */
	{0xac80,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG32 */
	{0xac84,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG33 */
	{0xac88,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG34 */
	{0xac8c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG35 */
	{0xac90,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG36 */
	{0xac94,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG37 */
	{0xac98,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG38 */
	{0xac9c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG39 */
	{0xaca0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG40 */
	{0xaca4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG41 */
	{0xaca8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG42 */
	{0xacac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG43 */
	{0xacb0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG44 */
	{0xacb4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG45 */
	{0xacb8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG46 */
	{0xacbc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG47 */
	{0xacc0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG48 */
	{0xacc4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG49 */
	{0xacc8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG50 */
	{0xaccc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG51 */
	{0xacd0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG52 */
	{0xacd4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG53 */
	{0xacd8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG54 */
	{0xacdc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG55 */
	{0xace0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG56 */
	{0xace4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG57 */
	{0xace8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG58 */
	{0xacec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG59 */
	{0xacf0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG60 */
	{0xacf4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG61 */
	{0xacf8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG62 */
	{0xacfc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG63 */
	{0xad00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG64 */
	{0xad04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG65 */
	{0xad08,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG66 */
	{0xad0c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG67 */
	{0xad10,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG68 */
	{0xad14,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG69 */
	{0xad18,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG70 */
	{0xad1c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG71 */
	{0xad20,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG72 */
	{0xad24,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG73 */
	{0xad28,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG74 */
	{0xad2c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG75 */
	{0xad30,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG76 */
	{0xad34,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG77 */
	{0xad38,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG78 */
	{0xad3c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG79 */
	{0xad40,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG80 */
	{0xad44,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG81 */
	{0xad48,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG82 */
	{0xad4c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG83 */
	{0xad50,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG84 */
	{0xad54,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG85 */
	{0xad58,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG86 */
	{0xad5c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG87 */
	{0xad60,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG88 */
	{0xad64,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG89 */
	{0xad68,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG90 */
	{0xad6c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG91 */
	{0xad70,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG92 */
	{0xad74,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG93 */
	{0xad78,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG94 */
	{0xad7c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG95 */
	{0xad80,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG96 */
	{0xad84,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG97 */
	{0xad88,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG98 */
	{0xad8c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG99 */
	{0xad90,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG100 */
	{0xad94,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG101 */
	{0xad98,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG102 */
	{0xad9c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG103 */
	{0xada0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG104 */
	{0xada4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG105 */
	{0xada8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG106 */
	{0xadac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG107 */
	{0xadb0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG108 */
	{0xadb4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG109 */
	{0xadb8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG110 */
	{0xadbc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG111 */
	{0xadc0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG112 */
	{0xadc4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG113 */
	{0xadc8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG114 */
	{0xadcc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG115 */
	{0xadd0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG116 */
	{0xadd4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG117 */
	{0xadd8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG118 */
	{0xaddc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG119 */
	{0xade0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG120 */
	{0xade4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG121 */
	{0xade8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG122 */
	{0xadec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG123 */
	{0xadf0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG124 */
	{0xadf4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG125 */
	{0xadf8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG126 */
	{0xadfc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG127 */
	{0xae00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG128 */
	{0xae04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG129 */
	{0xae08,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG130 */
	{0xae0c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG131 */
	{0xae10,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG132 */
	{0xae14,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG133 */
	{0xae18,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG134 */
	{0xae1c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG135 */
	{0xae20,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG136 */
	{0xae24,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG137 */
	{0xae28,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG138 */
	{0xae2c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG139 */
	{0xae30,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG140 */
	{0xae34,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG141 */
	{0xae38,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG142 */
	{0xae3c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG143 */
	{0xae40,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG144 */
	{0xae44,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG145 */
	{0xae48,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG146 */
	{0xae4c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG147 */
	{0xae50,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG148 */
	{0xae54,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG149 */
	{0xae58,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG150 */
	{0xae5c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG151 */
	{0xae60,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG152 */
	{0xae64,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG153 */
	{0xae68,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG154 */
	{0xae6c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG155 */
	{0xae70,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG156 */
	{0xae74,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG157 */
	{0xae78,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG158 */
	{0xae7c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG159 */
	{0xae80,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG160 */
	{0xae84,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG161 */
	{0xae88,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG162 */
	{0xae8c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG163 */
	{0xae90,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG164 */
	{0xae94,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG165 */
	{0xae98,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG166 */
	{0xae9c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_FCG_CONFIG167 */
	{0xaea0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG0 */
	{0xaea4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG1 */
	{0xaea8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG2 */
	{0xaeac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG3 */
	{0xaeb0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG4 */
	{0xaeb4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG5 */
	{0xaeb8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG6 */
	{0xaebc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG7 */
	{0xaec0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG8 */
	{0xaec4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_GFG0_CONFIG9 */
	{0xafe0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG0 */
	{0xafe4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG1 */
	{0xafe8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG2 */
	{0xafec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG3 */
	{0xaff0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG4 */
	{0xaff4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG5 */
	{0xaff8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG6 */
	{0xaffc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_OXFORD_FLEXCLKGEN_A_EXT_CONFIG7 */
	
	{0xc000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_INPUT_ERR_STATUS */
	{0xc008,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_OTHER_ERR_STATUS */
	{0xc010,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_INPUT_ERR_MASK */
	{0xc018,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_OTHER_ERR_MASK */
	{0xc030,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_INPUT_CLKEN */
	{0xc038,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_OTHER_CLKEN */
	{0xc200,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_IB */
	{0xc204,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_MIB */
	{0xc208,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_SWTS */
	{0xc20c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_TSOUT */
	{0xc210,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_CCSC */
	{0xc214,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_RAM */
	{0xc218,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_NUM_TP */
	{0xc400,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB0_INFO */
	{0xc404,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB0_DMA_INFO */
	{0xc410,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB1_INFO */
	{0xc414,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB1_DMA_INFO */
	{0xc420,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB2_INFO */
	{0xc424,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB2_DMA_INFO */
	{0xc430,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB3_INFO */
	{0xc434,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB3_DMA_INFO */
	{0xc440,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB4_INFO */
	{0xc444,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB4_DMA_INFO */
	{0xc450,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB5_INFO */
	{0xc454,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB5_DMA_INFO */
	{0xc460,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB6_INFO */
	{0xc464,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB6_DMA_INFO */
	{0xc470,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB7_INFO */
	{0xc474,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_IB7_DMA_INFO */
	{0xcd00,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_RAM0_BASE */
	{0xcd04,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_SYS_C8SECTPFE_SYS_CFG_RAM0_SIZE */
	{0xd000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(1) */
	{0xd004,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(1) */
	{0xd008,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(1) */
	{0xd00c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(1) */
	{0xd010,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(1) */
	{0xd014,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(1) */
	{0xd018,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(1) */
	{0xd01c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(1) */
	{0xd020,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(1) */
	{0xd024,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(1) */
	{0xd028,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(1) */
	{0xd02c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(1) */
	{0xd030,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(1) */
	{0xd040,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(2) */
	{0xd044,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(2) */
	{0xd048,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(2) */
	{0xd04c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(2) */
	{0xd050,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(2) */
	{0xd054,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(2) */
	{0xd058,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(2) */
	{0xd05c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(2) */
	{0xd060,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(2) */
	{0xd064,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(2) */
	{0xd068,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(2) */
	{0xd06c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(2) */
	{0xd070,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(2) */
	{0xd080,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(3) */
	{0xd084,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(3) */
	{0xd088,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(3) */
	{0xd08c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(3) */
	{0xd090,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(3) */
	{0xd094,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(3) */
	{0xd098,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(3) */
	{0xd09c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(3) */
	{0xd0a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(3) */
	{0xd0a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(3) */
	{0xd0a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(3) */
	{0xd0ac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(3) */
	{0xd0b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(3) */
	{0xd0c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(4) */
	{0xd0c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(4) */
	{0xd0c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(4) */
	{0xd0cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(4) */
	{0xd0d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(4) */
	{0xd0d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(4) */
	{0xd0d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(4) */
	{0xd0dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(4) */
	{0xd0e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(4) */
	{0xd0e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(4) */
	{0xd0e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(4) */
	{0xd0ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(4) */
	{0xd0f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(4) */
	{0xd100,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(5) */
	{0xd104,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(5) */
	{0xd108,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(5) */
	{0xd10c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(5) */
	{0xd110,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(5) */
	{0xd114,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(5) */
	{0xd118,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(5) */
	{0xd11c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(5) */
	{0xd120,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(5) */
	{0xd124,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(5) */
	{0xd128,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(5) */
	{0xd12c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(5) */
	{0xd130,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(5) */
	{0xd140,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(6) */
	{0xd144,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(6) */
	{0xd148,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(6) */
	{0xd14c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(6) */
	{0xd150,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(6) */
	{0xd154,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(6) */
	{0xd158,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(6) */
	{0xd15c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(6) */
	{0xd160,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(6) */
	{0xd164,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(6) */
	{0xd168,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(6) */
	{0xd16c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(6) */
	{0xd170,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(6) */
	{0xd180,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(7) */
	{0xd184,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(7) */
	{0xd188,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(7) */
	{0xd18c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(7) */
	{0xd190,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(7) */
	{0xd194,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(7) */
	{0xd198,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(7) */
	{0xd19c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(7) */
	{0xd1a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(7) */
	{0xd1a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(7) */
	{0xd1a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(7) */
	{0xd1ac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(7) */
	{0xd1b0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(7) */
	{0xd1c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_INPUT_FORMAT_CONFIG(8) */
	{0xd1c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SLD_CONFIG(8) */
	{0xd1c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_TAG_BYTES(8) */
	{0xd1cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PID_FILTER(8) */
	{0xd1d0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PKT_LENGTH(8) */
	{0xd1d4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_START(8) */
	{0xd1d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_BUFFER_END(8) */
	{0xd1dc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_READ_POINTER(8) */
	{0xd1e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_WRITE_POINTER(8) */
	{0xd1e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_PRIORITY_THRESHOLD(8) */
	{0xd1e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_STATUS(8) */
	{0xd1ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_MASK(8) */
	{0xd1f0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_IB_C8SECTPFE_IB_SYSTEM(8) */
	{0xe000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TC_C8SECTPFE_TC_COUNTER_LSW(1) */
	{0xe004,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TC_C8SECTPFE_TC_COUNTER_MSW(1) */
	{0xe040,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TC_C8SECTPFE_TC_COUNTER_LSW(2) */
	{0xe044,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TC_C8SECTPFE_TC_COUNTER_MSW(2) */
	{0xf000,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM0_BASE */
	{0xf004,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM0_TOP */
	{0xf008,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM0_PKTSIZE */
	{0xf00c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM0_FORMAT */
	{0xf018,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM0_STATUS */
	{0xf020,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM1_BASE */
	{0xf024,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM1_TOP */
	{0xf028,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM1_PKTSIZE */
	{0xf02c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM1_FORMAT */
	{0xf038,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM1_STATUS */
	{0xf040,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM2_BASE */
	{0xf044,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM2_TOP */
	{0xf048,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM2_PKTSIZE */
	{0xf04c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM2_FORMAT */
	{0xf058,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM2_STATUS */
	{0xf060,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM3_BASE */
	{0xf064,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM3_TOP */
	{0xf068,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM3_PKTSIZE */
	{0xf06c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM3_FORMAT */
	{0xf078,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM3_STATUS */
	{0xf080,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM4_BASE */
	{0xf084,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM4_TOP */
	{0xf088,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM4_PKTSIZE */
	{0xf08c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM4_FORMAT */
	{0xf098,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM4_STATUS */
	{0xf0a0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM5_BASE */
	{0xf0a4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM5_TOP */
	{0xf0a8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM5_PKTSIZE */
	{0xf0ac,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM5_FORMAT */
	{0xf0b8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM5_STATUS */
	{0xf0c0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM6_BASE */
	{0xf0c4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM6_TOP */
	{0xf0c8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM6_PKTSIZE */
	{0xf0cc,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM6_FORMAT */
	{0xf0d8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM6_STATUS */
	{0xf0e0,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM7_BASE */
	{0xf0e4,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM7_TOP */
	{0xf0e8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM7_PKTSIZE */
	{0xf0ec,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM7_FORMAT */
	{0xf0f8,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_STRM7_STATUS */
	{0xf800,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_ROUTE */
	{0xf808,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_FIFOTRIG */
	{0xf80c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_BYPASS */
	{0xf810,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_CLKDIV */
	{0xf814,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_FORMAT */
	{0xf818,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST0_STATUS */
	{0xf820,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_ROUTE */
	{0xf828,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_FIFOTRIG */
	{0xf82c,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_BYPASS */
	{0xf830,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_CLKDIV */
	{0xf834,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_FORMAT */
	{0xf838,    0x00,    STCHIP_REGSIZE_32},	/* REG_RSTID135_C8SECTPFE_TSDMA_C8SECTPFE_TSDMA_DEST1_STATUS */
};

STCHIP_Error_t STiD135_Init(Demod_InitParams_t *InitParams,
				STCHIP_Handle_t *hChipHandle)
{
	STCHIP_Handle_t hChip = NULL;
	STCHIP_Error_t error = CHIPERR_NO_ERROR;
	u32 reg_value;
	int i,j;
	u32 real_STiD135_NBREGS;
	s32 regIndex;
    
	/* NTC: Some important sanity checks */
	real_STiD135_NBREGS = sizeof(STiD135DefVal) / sizeof(STCHIP_Register_t);
	if (real_STiD135_NBREGS != STiD135_NBREGS) {
		return(CHIPERR_CONFIG_ERR);
	}

	
	
	/* fill elements of external chip data structure */
	InitParams->Chip->NbInsts  = DEMOD_NBINSTANCES;
	InitParams->Chip->NbRegs   = STiD135_NBREGS;
	InitParams->Chip->NbFields = STiD135_NBFIELDS;										  
	InitParams->Chip->ChipMode = STCHIP_MODE_I2C2STBUS;
	InitParams->Chip->pData = NULL;
	
	InitParams->Chip->WrStart  = STCHIP_MODE_STBUS_A2D1S0;  // Default mode for STBus interface A2D1S1 : many issues such as: bad accuracy of SR and freq, not possible to lock demods#5 to #8 if blind search and SR>20MS/s
	ChipSetMapRegisterSize(STCHIP_REGSIZE_8);
	
	ChipSetHierarchyMap (TRUE); 
	
	(*hChipHandle) = ChipOpen(InitParams->Chip);

	ChipSetHierarchyMap (FALSE);
	
	hChip=(*hChipHandle);

	if(hChip != NULL) {
			
		/*******************************
		**   CHIP REGISTER MAP IMAGE INITIALIZATION
		**     ----------------------
		********************************/
		ChipUpdateDefaultValues(hChip,STiD135DefVal);
		
		/*Read the ID*/
		regIndex = ChipGetRegisterIndex(hChip, (u16)REG_RSTID135_AFE_AFE_ID);
		hChip->pRegMapImage[regIndex].Size = STCHIP_REGSIZE_8;
		ChipGetOneRegister(hChip,(u16)REG_RSTID135_AFE_AFE_ID, &reg_value);
		hChip->ChipID = (u8)reg_value;
		if((hChip->ChipID & FSTID135_AFE_AFE_ID_CUT_ID__MASK) != 0x08) {
			return(CHIPERR_INVALID_HANDLE);
		}
		
		if(hChip->Error == CHIPERR_NO_ERROR) {
			/*******************************
			**   REGISTER CONFIGURATION
			**     ----------------------
			********************************/
	
			for(i=0;i<DEMOD_NBREGS;i++)
				hChip->pRegMapImage[i].Size = STCHIP_REGSIZE_8;

			for(i=0;i<DEMOD_NBREGS;i++) {
        			for(j=i+1;j<=DEMOD_NBREGS;j++) {
            				if((STiD135DefVal[j].Addr != STiD135DefVal[j-1].Addr+1) || (j == DEMOD_NBREGS)) {
						error |= ChipSetRegisters(hChip,STiD135DefVal[i].Addr, (s32)(j-i));
                				i=j-1;
                				break;
            				}
        			}
    			}

			for(i=DEMOD_NBREGS;i<DEMOD_NBREGS+AFE_NBREGS;i++) /* AFE registers */
				hChip->pRegMapImage[i].Size = STCHIP_REGSIZE_8;
		}
		error=hChip->Error;
	} else
		error=CHIPERR_INVALID_HANDLE;
		
	return error;
}
			
STCHIP_Error_t STiD135_SOC_Init(Demod_InitParams_t *InitParams, STCHIP_Handle_t *hChipHandle) 
{
	STCHIP_Handle_t hChip; 
	STCHIP_Error_t error = 0;  
	int i;
	u32 real_STiD135_NBSOCREGS;

	/* NTC: Some important sanity checks */
	real_STiD135_NBSOCREGS = sizeof(STiD135SocDefVal) / sizeof(STCHIP_Register_t);
	if (real_STiD135_NBSOCREGS != STiD135_NBSOCREGS) {
		return(CHIPERR_CONFIG_ERR);
	}
	
	InitParams->Chip->ChipMode  = STCHIP_MODE_I2C2STBUS;
	ChipSetMapRegisterSize(STCHIP_REGSIZE_32);	         // pass regsizes in this mode
	InitParams->Chip->WrStart   = STCHIP_MODE_STBUS_A2D4S1;  // Default mode for STBus interface
	
	InitParams->Chip->NbInsts  = 1;
	InitParams->Chip->NbRegs   = STiD135_NBSOCREGS;
	InitParams->Chip->NbFields = 1764;
	InitParams->Chip->pData    = NULL;
	
	(*hChipHandle) = ChipOpen(InitParams->Chip);
	hChip=(*hChipHandle);
	
	if(hChip != NULL) {
		ChipUpdateDefaultValues(hChip,STiD135SocDefVal);
		
		for(i=0;i<STiD135_NBSOCREGS;i++) { /* 735 SOC regs, excluding AFE regs */
			hChip->pRegMapImage[i].Size = STCHIP_REGSIZE_32;
			/* FIXME: new for 32-bit access */
			//ChipSetOneRegister(hChip,STiD135SocDefVal[i].Addr,
			/*ChipSetOneSocRegister(hChip,STiD135SocDefVal[i].Addr,
						STiD135SocDefVal[i].Value);*/
			/* FIXME: using old inits, it is not possible to read/write SOC registers
			on blocks which have several instances.
			We have to deal with hChip->pRegMapImage[i].Base = Instance[j].Instance;
			if we want to make it work */
		}
		error=hChip->Error;
			
	}  else
		error=CHIPERR_INVALID_HANDLE;

	return error; 
}
